"""
load points in site database

USAGE

    python -m thyrsis.database.load_points site srid point.csv groupe

    :param: site : site name str
    :param: srid : EPSG id

    try to load points into the site database
"""
from builtins import str

from ..log import logger


def load_points(conn, siteName, srid, fileName, groupe="calcul"):
    """load interest points into the current database for a site

    :param conn: connection on a sqlite database
    :type cur: sqlite3.Connection
    :param siteName: name of the site
    :type siteName: string
    :param srid: epsg code
    :type srid: string
    :param fileName: path to a csv file of interests points
    :type fileName: string
    :param groupe: group name of the loaded points
    :type groupe: string

    :return: None
    """
    logger.debug("load_points")

    srid = str(srid)
    cur = conn.cursor()

    sid = cur.execute("SELECT id FROM sites WHERE nom='%s'" % (siteName)).fetchone()
    if not sid:
        logger.error("site", siteName, " introuvable dans ", sitesdb)
        for (nom,) in cur.execute("SELECT nom FROM sites").fetchall():
            logger.debug("    ", nom)
        exit(1)
    sid = sid[0]

    points = []
    with open(fileName, "r") as file_points:
        next(file_points)
        for line in file_points:
            spl = line.split()
            points.append(
                {
                    "x": float(spl[0]),
                    "y": float(spl[1]),
                    "nom": spl[2],
                    "titre": spl[2] if len(spl) == 3 else spl[3],
                    "position": spl[-1] if len(spl) == 5 else "gauche",
                }
            )

    logger.debug(len(points), " points lus")
    for pca in points:
        if not cur.execute(
            "SELECT COUNT(1) FROM points_interet \
                            WHERE nom='%s' AND sid=%d"
            % (pca["nom"], sid)
        ).fetchone()[0]:
            logger.debug("Ajout du point " + pca["nom"])
            cur.execute(
                (
                    "\
                INSERT INTO points_interet \
                (GEOMETRY, nom, titre, position, groupe, sid) \
                VALUES \
                (ST_TRANSFORM(MakePoint(%(x)f, %(y)f, "
                    + srid
                    + "),4326), '%(nom)s', '%(titre)s', '%(position)s', '"
                    + groupe
                    + "', "
                    + str(sid)
                    + ")"
                )
                % pca
            )
        else:
            # check that the point is at the same place
            dist = cur.execute(
                (
                    "SELECT Distance(GEOMETRY, ST_TRANSFORM(MakePoint(%(x)f, %(y)f, "
                    + srid
                    + "), 4326) < 1 ) \
                    FROM points_interet WHERE nom='%(nom)s' AND sid="
                    + str(sid)
                )
                % pca
            ).fetchone()[0]
            if dist > 1:
                ref, pt = cur.execute(
                    (
                        "\
                    SELECT AsText(GEOMETRY), \
                        AsText(ST_TRANSFORM(MakePoint(%(x)f, %(y)f, "
                        + srid
                        + "),4326))\
                    FROM points_interet WHERE nom='%(nom)s' AND sid="
                        + str(sid)
                    )
                    % pca
                ).fetchone()
                raise Exception(
                    "point %s %s with the same name exists at position %s (distance %f > 1)"
                    % (pca["nom"], pt, ref, dist)
                )
            else:
                logger.warning("Le point " + pca["nom"] + " est deja dans la base")


if __name__ == "__main__":
    import sys

    from PyQt5.QtCore import *
    from PyQt5.QtGui import *

    from ..database import sqlite
    from ..settings import Settings

    logger.enable_console(True)

    if len(sys.argv) == 2 and sys.argv[1] in ["-h", "--help"]:
        help(sys.modules[__name__])
        exit(0)

    if len(sys.argv) != 5:
        logger.error(
            "wrong number of arguments (try python -m thyrsis.database.load_points --help)"
        )
        exit(1)

    QCoreApplication.setOrganizationName("QGIS")
    QCoreApplication.setOrganizationDomain("qgis.org")
    QCoreApplication.setApplicationName("QGIS2")

    if not Settings().contains("General", "defaultSite"):
        logger.error("defaultSite undefined, use preferences_dialog.py")
        exit(1)

    sitesdb = str(Settings().value("General", "defaultSite"))

    conn = sqlite.connect(sitesdb)

    load_points(conn, sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])

    conn.commit()
