# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ThermalMetricsDialog
                                 A QGIS plugin
 This plugin helps to calculate basic metrics and indices from thermal images. 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-10-02
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Florian Ellsäßer
        email                : info@ecothermographylab.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'thermalmetrics_dialog_base.ui'))


class ThermalMetricsDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(ThermalMetricsDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        # if the patch Richness And Density checkBoxis checked, call the enter_automatic_input function
        self.patchRichnessAndDensity_checkBox.toggled.connect(self.automatic_input)
        
        # if one of the indices is selected, run the select patch function
        self.shannonDiversityIndex_checkBox.toggled.connect(self.select_patch)
        self.shannonEquitabilityIndex_checkBox.toggled.connect(self.select_patch)
        self.simpsonDiversityIndex_checkBox.toggled.connect(self.select_patch)
        self.giniSimpsonDiversityIndex_checkBox.toggled.connect(self.select_patch)
        self.simpsonReciprocalIndex_checkBox.toggled.connect(self.select_patch)
        
    def automatic_input(self):
        #This function reads the defined output .csv file and adds the .tif version automatically
        # get the new name and change to .tif
        new_out_name = str(self.output_name.text().split('.')[0] + '_patch_raster.tif')
            
        # remove the numbers from the manual bin number input and replace by 'auto'
        self.patch_output_name.setText(new_out_name)
                
                
    def select_patch(self):
        # check the calculate patches checkbox
        self.patchRichnessAndDensity_checkBox.setChecked(True)
   

        
        
        
        
