# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Ch2L2
                                 A QGIS plugin
 This plugin generates reflectance from Radiance data of  Imaging Infrared Radio Specrometer sensor of Chandrayaan 2
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-04-24
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Prabhakar Alok Verma, Mamta Chauhan, Prakash Chauhan
        email                : prabhakar.9219@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License.        *
 *                                                                         *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QThread
from qgis.PyQt.QtWidgets import QAction, QFileDialog, QMessageBox, QInputDialog, QLabel
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
import time
from PyQt5 import QtCore
from qgis.core import QgsTask, QgsTaskManager, QgsApplication 

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Thermal_dialog import Ch2L2Dialog
from .Corrector import Corrector as cc
from .Incidence import Incidence as II
from .ThermalInci import Corrector as TI
import os.path


class Ch2L2:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Ch2L2_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Chandrayaan-2 IIRS')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None



    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Ch2L2', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Thermal/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'IIRS'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True




    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Chandrayaan-2 IIRS'),
                action)
            self.iface.removeToolBarIcon(action)


    def toolButton(self):
        file_path = QFileDialog.getOpenFileName(
            self.dlg, self.tr('Select solar flux file:'))
        if file_path:           
            self.dlg.lineEdit.setText(file_path[0])

    def toolButton_3(self):
        file_path = QFileDialog.getOpenFileName(
            self.dlg, self.tr('Select radiance image:'))
        if file_path:           
            self.dlg.lineEdit_3.setText(file_path[0])

    def toolButton_4(self):
        directory_path = QFileDialog.getExistingDirectory(
            self.dlg, self.tr('Select a folder:'),
            os.path.expanduser('~'), QFileDialog.ShowDirsOnly)

        if directory_path:
            self.selected_folder = directory_path[:]
            self.selected_folder = './' + os.path.basename(os.path.normpath(self.selected_folder)) + '/'
            self.dlg.lineEdit_4.setText(directory_path)




    def CheckIncidence(self,task):
        II(self.inSolar, self.path, self.outPath)


    def CheckThermal(self,task):
        cc(self.inSolar, self.path, self.outPath)

    def ThermalIncidence(self,task):
        II(self.inSolar, self.path, self.outPath)
        TI(self.inSolar, self.path, self.outPath)
          
    def comp(self, exception, result=None):
        if exception is None:
            self.dlg.textEdit.append('Process completed in' +str(time.time()-sTime)+' seconds')
            self.dlg.progressBar.setValue(100)
        else:
            self.dlg.textEdit.append('Exception in task')
            self.dlg.textEdit.append(str(exception))
            self.dlg.progressBar.setValue(100)

    def runTask(self):
        self.dlg.textEdit.clear()
        self.dlg.progressBar.setValue(0)

        global sTime
        sTime=time.time()
        self.inSolar = self.dlg.lineEdit.text()
        if not os.path.isfile(self.inSolar):
            self.inSolar=r'Solar flux.txt'
            self.inSolar=os.path.join(os.path.dirname(os.path.abspath(__file__)),self.inSolar)
        self.path= self.dlg.lineEdit_3.text()
        self.outPath= self.dlg.lineEdit_4.text()

        if self.dlg.radioButton.isChecked():
            self.task1 = QgsTask.fromFunction('Processing',self.CheckIncidence, on_finished=self.comp)

        if self.dlg.radioButton_2.isChecked():
            self.task1 = QgsTask.fromFunction('Processing',self.CheckThermal, on_finished=self.comp)

        if self.dlg.radioButton_3.isChecked():
            self.task1 = QgsTask.fromFunction('Processing',self.ThermalIncidence, on_finished=self.comp)




        self.dlg.textEdit.append('Task created')      
        QgsApplication.taskManager().addTask(self.task1)
        self.dlg.textEdit.append('Task running........')
        self.dlg.textEdit.append('It will take some time depending on image size.....')

               
    
    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started

        if self.first_start == True:
            self.first_start = False
            self.dlg = Ch2L2Dialog()
            self.dlg.Close.clicked.connect(self.dlg.close)
            self.dlg.toolButton.clicked.connect(self.toolButton)
            self.dlg.toolButton_3.clicked.connect(self.toolButton_3)
            self.dlg.toolButton_4.clicked.connect(self.toolButton_4)
            self.dlg.Run.clicked.connect(self.runTask)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()

        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass