# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ThemeManagerDialog
                                 A QGIS plugin
 This plugin stands to be a theme manager. It allows you to select the layers you want to set up in the different themes in your projet as a checklist, showing up all themes at once.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-05-22
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Antoine BOYER
        email                : theme.manager.qgis.plugin@gmail.com
 ***************************************************************************/
"""

import os
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets, QtCore
from qgis.core import QgsProject, QgsMapThemeCollection
from qgis.PyQt.QtGui import QColor

# Charge le formulaire .ui généré dans QtDesigner (fichier d'interface graphique)
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'theme_manager_dialog_base.ui'))

class ThemeManagerDialog(QtWidgets.QDialog, FORM_CLASS):
            # Initialisation de l'interface utilisateur 
    def __init__(self, iface, parent=None):
        # Initialisation des boutons et connexion de ces derniers avec les méthodes utilisées, remplissage des tableaux
        super().__init__(parent)
        self.iface = iface
        self.setupUi(self)
        self.last_modified_theme = None  # Vidange de la variable qui stocke le dernier thème utilisé

        # Connexion des boutons et tableaux aux méthodes
        if hasattr(self, "btnCreateNewTheme"):
            self.btnCreateNewTheme.clicked.connect(self.create_new_theme)
        if hasattr(self, "btnApplyTheme"):
            self.btnApplyTheme.clicked.connect(self.apply_selected_theme)
        if hasattr(self, "table_FilterAndSuppressThemes"):
            self.table_FilterAndSuppressThemes.itemChanged.connect(self.on_filter_changed)

        # Remplissage des tableaux
        self.fill_theme_table()
        self.fill_theme_filter_table()
        self.check_for_themes()

    def check_for_themes(self):
        theme_collection = QgsProject.instance().mapThemeCollection()
        themes = list(theme_collection.mapThemes())
        if not themes:
            QtWidgets.QMessageBox.information(
                self,
                self.tr("Absence de thème dans le projet"),
                self.tr("Votre projet ne contient pas de thème. Créez-en un depuis le menu QGIS ou dans le premier volet du plugin.")
            )

    def fill_theme_table(self):
        # Pour le tableau principal, les lignes sont associées aux groupes et aux couches du projet, les colonnes sont associées aux thèmes activés par l'utilisateur (tous si aucun décochage)
        # Dans le même temps, ajout des boutons d'actions : Inversion/Sélection pour les lignes et les colonnes
        theme_collection = QgsProject.instance().mapThemeCollection()
        all_themes = list(theme_collection.mapThemes())

        # Ajuste la largeur des colonnes en fonction du contenu (nom du thème, non de la couche ou du groupe)
        self.tableThemes.resizeColumnsToContents()

        # Récupère la liste des thèmes à afficher selon le filtre appliqué par l'utilisateur
        if hasattr(self, "table_FilterAndSuppressThemes"):
            selected_themes = []
            for row in range(self.table_FilterAndSuppressThemes.rowCount()):
                if self.table_FilterAndSuppressThemes.item(row, 0).checkState() == QtCore.Qt.Checked:
                    selected_themes.append(self.table_FilterAndSuppressThemes.item(row, 1).text())
            themes = selected_themes if selected_themes else all_themes
        else:
            themes = all_themes

        # Liste tous les groupes et couches de l'arbre des couches QGIS
        items = []
        def add_items_rec(node, parent_id=None):
            for child in node.children():
                if child.nodeType() == child.NodeGroup:
                    group_id = child.name()
                    items.append((True, group_id, child.name(), parent_id))
                    add_items_rec(child, group_id)
                elif child.nodeType() == child.NodeLayer:
                    items.append((False, child.layerId(), child.name(), parent_id))
        root = QgsProject.instance().layerTreeRoot()
        add_items_rec(root)

        # Prépare le tableau (en-têtes, lignes, colonnes)
        self.tableThemes.clear()
        self.tableThemes.setRowCount(len(items) + 1)
        self.tableThemes.setColumnCount(len(themes) + 2)
        self.tableThemes.setHorizontalHeaderLabels(["", self.tr("Groupe/Couche")] + themes)
        for col in [0, 1]:
            item = QtWidgets.QTableWidgetItem()
            item.setFlags(QtCore.Qt.ItemIsEnabled)
            item.setBackground(QtCore.Qt.gray)
            self.tableThemes.setItem(0, col, item)

        # Ajoute les boutons d'actions pour les colonnes (thème)
        from functools import partial
        for col, theme in enumerate(themes, start=2):
            header_widget = QtWidgets.QWidget()
            header_layout = QtWidgets.QVBoxLayout(header_widget)
            header_layout.setContentsMargins(0, 0, 0, 0)
            header_layout.setSpacing(2)

            btn_select_all = QtWidgets.QPushButton(self.tr("Tout sélectionner"))
            btn_select_all.setToolTip(self.tr("Tout cocher pour le thème « {theme} »").format(theme=theme))
            btn_select_all.clicked.connect(partial(self.select_all_column, col))
            header_layout.addWidget(btn_select_all)

            btn_invert = QtWidgets.QPushButton(self.tr("Inverser la sélection"))
            btn_invert.setToolTip(self.tr("Inverser la sélection pour le thème « {theme} »").format(theme=theme))
            btn_invert.clicked.connect(partial(self.invert_column, col))
            header_layout.addWidget(btn_invert)

            self.tableThemes.setCellWidget(0, col, header_widget)

        # ComboBox pour sélectionner un thème à appliquer
        if hasattr(self, "comboThemes"):
            self.comboThemes.clear()
            self.comboThemes.addItems(themes)

        # Remplit chaque ligne de la table (groupes/couches)
        for row, (is_group, item_id, name, parent_id) in enumerate(items):
            if is_group:
                group_item = QtWidgets.QTableWidgetItem()
                group_item.setFlags(QtCore.Qt.NoItemFlags)
                group_item.setBackground(QColor("#f0f0f0"))
                self.tableThemes.setItem(row + 1, 0, group_item)
            else:
                btn_widget = QtWidgets.QWidget()
                btn_layout = QtWidgets.QVBoxLayout(btn_widget)
                btn_layout.setContentsMargins(0, 0, 0, 0)
                btn_layout.setSpacing(2)

                btn_select_all_row = QtWidgets.QPushButton(self.tr("Tout sélectionner"))
                btn_select_all_row.setToolTip(self.tr("Tout cocher pour « {name} »").format(name=name))
                btn_select_all_row.clicked.connect(partial(self.select_all_row, row + 1))
                btn_layout.addWidget(btn_select_all_row)

                btn_invert_row = QtWidgets.QPushButton(self.tr("Inverser la sélection"))
                btn_invert_row.setToolTip(self.tr("Inverser la sélection pour « {name} »").format(name=name))
                btn_invert_row.clicked.connect(partial(self.invert_row, row + 1))
                btn_layout.addWidget(btn_invert_row)

                self.tableThemes.setCellWidget(row + 1, 0, btn_widget)

            # Si c'est un groupe le nom est en gras
            label = QtWidgets.QLabel(name)
            if is_group:
                font = label.font()
                font.setBold(True)
                label.setFont(font)
            self.tableThemes.setCellWidget(row + 1, 1, label)

            # Ajoute une case à cocher pour chaque thème (couche/thème ou groupe/thème)

            for col, theme in enumerate(themes, start=2):
                if is_group:
                    group_item = QtWidgets.QTableWidgetItem()
                    group_item.setFlags(QtCore.Qt.NoItemFlags)
                    group_item.setBackground(QColor("#f0f0f0"))
                    self.tableThemes.setItem(row + 1, col, group_item)
                else: # Collecte les ID des couches contenues dans un thème
                    layers_in_theme = theme_collection.mapThemeVisibleLayerIds(theme)
                    checked = item_id in layers_in_theme
                    chk = QtWidgets.QCheckBox()
                    chk.setChecked(checked)
                    chk.stateChanged.connect(partial(self.on_box_changed, item_id, theme))
                    widget = QtWidgets.QWidget()
                    layout = QtWidgets.QHBoxLayout(widget)
                    layout.addWidget(chk)
                    layout.setAlignment(chk, QtCore.Qt.AlignCenter) # Checkbox au centre de la cellule
                    layout.setContentsMargins(0, 0, 0, 0)
                    widget.setLayout(layout)
                    self.tableThemes.setCellWidget(row + 1, col, widget)

                    # Ajuste la taille des cellules en fonction du contenu
                    self.tableThemes.resizeColumnsToContents()
                    self.tableThemes.resizeRowsToContents()
                    self.tableThemes.resizeColumnsToContents()
                    self.tableThemes.resizeRowsToContents()
                    self.tableThemes.resizeColumnsToContents()
        
    def on_box_changed(self, item_id, theme, state): # Lors d'une coche de case, la fonction met à jour l'état du thème, applique le thème courant pour afficher les modifications
        theme_collection = QgsProject.instance().mapThemeCollection()
        record = theme_collection.mapThemeState(theme)
        root = QgsProject.instance().layerTreeRoot()
        layer = QgsProject.instance().mapLayer(item_id)
        if layer:
            if state == QtCore.Qt.Checked: # Ajoute la couche comme étant visible dans le thème
                record.removeLayerRecord(layer)
                lr = QgsMapThemeCollection.MapThemeLayerRecord(layer)
                lr.isVisible = True
                record.addLayerRecord(lr)
            else: # Sinon, retire la couche du thème
                record.removeLayerRecord(layer)
            theme_collection.update(theme, record)
            self.last_modified_theme = theme

        self.check_group_if_layers_in_check() # Après chaque clic sur une checkbox : Tenter de forcer l'affichage des groupes parents si sa couche enfant est visible (À revoir)
        if hasattr(self, "comboThemes"): # Réappliques le thème courant pour que les changements soient visibles instantanéments
            current_theme = self.comboThemes.currentText()
            if current_theme:
                theme_collection.applyTheme(current_theme, root, self.iface.layerTreeView().layerTreeModel())

    def apply_selected_theme(self):
        # Applique le thème sélectionné via la comboBox à l'arbre des couches QGIS, met à jour la visibilité des groupes selon les couches enregistrées dans le thème sélectionné
        if hasattr(self, "comboThemes"):
            selected_theme = self.comboThemes.currentText()
        else:
            selected_theme = None
        if selected_theme:
            theme_collection = QgsProject.instance().mapThemeCollection()
            root = QgsProject.instance().layerTreeRoot()
            layerTreeModel = self.iface.layerTreeView().layerTreeModel()
            theme_collection.applyTheme(selected_theme, root, layerTreeModel)
            self.check_group_if_layers_in_check()

    def fill_theme_filter_table(self):
        # Remplit la table de gestion des thèmes (affichage dans la table de gestion des couches, suppression, renommage), une ligne = un thème
        theme_collection = QgsProject.instance().mapThemeCollection()
        themes = list(theme_collection.mapThemes())
        self.table_FilterAndSuppressThemes.blockSignals(True)
        self.table_FilterAndSuppressThemes.setRowCount(len(themes))
        self.table_FilterAndSuppressThemes.setColumnCount(4)  # 4 colonnes : afficher, nom, supprimer, renommer
        self.table_FilterAndSuppressThemes.setHorizontalHeaderLabels([self.tr("Afficher"), self.tr("Thème"), self.tr("Supprimer"), self.tr("Modifier le nom")])

        for row, theme in enumerate(themes):
            # Colonne 0 : Base à cocher pour afficher/masquer le thème dans la table de gestion des couches par thème
            chk_item = QtWidgets.QTableWidgetItem()
            chk_item.setFlags(QtCore.Qt.ItemIsUserCheckable | QtCore.Qt.ItemIsEnabled)
            chk_item.setCheckState(QtCore.Qt.Checked)
            self.table_FilterAndSuppressThemes.setItem(row, 0, chk_item)
            # Colonne 1 : Nom du thème (Ce n'est pas ici que l'utilisateur est invité à modifier son nom)
            name_item = QtWidgets.QTableWidgetItem(theme)
            name_item.setFlags(QtCore.Qt.ItemIsEnabled)
            self.table_FilterAndSuppressThemes.setItem(row, 1, name_item)
            # Colonne 2 : Bouton de suppression du thème
            btn = QtWidgets.QPushButton(self.tr("Supprimer"))
            btn.clicked.connect(lambda checked, t=theme: self.delete_theme(t))
            self.table_FilterAndSuppressThemes.setCellWidget(row, 2, btn)
            # Colonne 3 : Bouton pour renommer le thème
            btn_rename = QtWidgets.QPushButton(self.tr("Modifier le nom du thème"))
            btn_rename.setToolTip(self.tr("Renommer ce thème"))
            btn_rename.clicked.connect(lambda checked, t=theme, r=row: self.rename_theme_from_table(t, r))
            self.table_FilterAndSuppressThemes.setCellWidget(row, 3, btn_rename)

        self.table_FilterAndSuppressThemes.resizeColumnsToContents()
        self.table_FilterAndSuppressThemes.blockSignals(False)

    def rename_theme_from_table(self, old_name, row):
        # Renomme un thème déjà existant (procédure de vérification de doublons) et met à jour les tableaux pour y afficher le thème créé puis maffiche un message de confirmation
        theme_collection = QgsProject.instance().mapThemeCollection()
        # Demande un nouveau nom à l'utilisateur via une boîte de dialogue
        new_name, ok = QtWidgets.QInputDialog.getText(self, self.tr("Renommer le thème"), self.tr("Entrer un nouveau nom pour le thème « {old_name} » :").format(old_name=old_name), QtWidgets.QLineEdit.Normal, old_name)
        if not ok or not new_name:
            return 
        new_name = new_name.strip()
        # Vérification du nom (vide, identique, doublon)
        if not new_name:
            QtWidgets.QMessageBox.warning(self, self.tr("Nom manquant"), self.tr("Veuillez saisir un nom de thème non vide."))
            return
        if new_name == old_name:
            QtWidgets.QMessageBox.information(self, self.tr("Renommer le thème"), self.tr("Le nom n'a pas changé."))
            return
        if new_name in theme_collection.mapThemes():
            QtWidgets.QMessageBox.warning(self, self.tr("Thème existant"), self.tr("Ce nom de thème existe déjà."))
            return
        # Applique la modification
        theme_collection.renameMapTheme(old_name, new_name)
        self.fill_theme_filter_table()
        self.fill_theme_table()
        QtWidgets.QMessageBox.information(self, self.tr("Renommé"), self.tr("Le thème « {old_name} » a été renommé en « {new_name} ».").format(old_name=old_name, new_name=new_name))

    def create_new_theme(self):
        # Ce nouveau thème se compose du canvas actuel de la carte
        if not hasattr(self, "textEditNameNewTheme"):
            return
        name = self.textEditNameNewTheme.toPlainText().strip()
        if not name:
            QtWidgets.QMessageBox.warning(self, self.tr("Nom manquant"), self.tr("Veuillez saisir un nom de thème non vide."))
            return
        theme_collection = QgsProject.instance().mapThemeCollection()
        if name in theme_collection.mapThemes():
            QtWidgets.QMessageBox.warning(self, self.tr("Thème existant"), self.tr("Ce nom de thème existe déjà."))
            return
        root = QgsProject.instance().layerTreeRoot()
        layerTreeModel = self.iface.layerTreeView().layerTreeModel()
        # Capture l'état actuel de visibilité de l'arbre pour créer le thème
        theme_state = QgsMapThemeCollection.createThemeFromCurrentState(root, layerTreeModel)
        theme_collection.insert(name, theme_state)
        self.fill_theme_filter_table()
        self.fill_theme_table()
        self.textEditNameNewTheme.clear()

    def delete_theme(self, theme_name):
        # Supprime un thème du projet après avoir demandé confirmation et rafraîchit les tableaux
        theme_collection = QgsProject.instance().mapThemeCollection()
        if theme_name not in theme_collection.mapThemes():
            return
        reply = QtWidgets.QMessageBox.question(
            self, self.tr("Suppression de thème"),
            self.tr("Êtes-vous sûr de vouloir supprimer le thème : « {theme_name} » ?").format(theme_name=theme_name),
            QtWidgets.QMessageBox.Yes | QtWidgets.QMessageBox.No)
        if reply == QtWidgets.QMessageBox.Yes:
            theme_collection.removeMapTheme(theme_name)
            self.fill_theme_filter_table()
            self.fill_theme_table()

    def on_filter_changed(self, item):
        # Si le thème est décoché, il est masqué du second tableau, gère la modification d'un nom de thème
        if item.column() == 0:
            self.fill_theme_table()
        elif item.column() == 1:
            row = item.row()
            old_name = self._get_theme_name_by_row(row)
            new_name = item.text().strip()
            if not new_name or new_name == old_name:
                return
            theme_collection = QgsProject.instance().mapThemeCollection()
            if new_name in theme_collection.mapThemes():
                QtWidgets.QMessageBox.warning(self, self.tr("Thème existant"), self.tr("Ce nom de thème existe déjà."))
                item.setText(old_name)
                return
            theme_collection.renameMapTheme(old_name, new_name)
            self.fill_theme_filter_table()
            self.fill_theme_table()

    def _get_theme_name_by_row(self, row):
        # Récupères le nom d'un thème en fonction de son placement sur la ligne de la table de gestion des thèmes
        item = self.table_FilterAndSuppressThemes.item(row, 1)
        return item.text() if item else ""

    def select_all_row(self, row):
        # Fonctionnement du bouton de sélection de toutes les lignes
        for col in range(2, self.tableThemes.columnCount()):
            cell_widget = self.tableThemes.cellWidget(row, col)
            if cell_widget:
                chk = cell_widget.findChild(QtWidgets.QCheckBox)
                if chk and not chk.isChecked():
                    chk.setChecked(True)

    def invert_row(self, row):
        # Fonctionnement du bouton d'inversion de la sélection pour une ligne
        for col in range(2, self.tableThemes.columnCount()):
            cell_widget = self.tableThemes.cellWidget(row, col)
            if cell_widget:
                chk = cell_widget.findChild(QtWidgets.QCheckBox)
                if chk:
                    chk.setChecked(not chk.isChecked())

    def select_all_column(self, col):
        # Fonctionnement du bouton de sélection de toutes les colonnes
        for row in range(1, self.tableThemes.rowCount()):
            cell_widget = self.tableThemes.cellWidget(row, col)
            if cell_widget:
                chk = cell_widget.findChild(QtWidgets.QCheckBox)
                if chk and not chk.isChecked():
                    chk.setChecked(True)

    def invert_column(self, col):
        # Fonctionnement du bouton d'inversion de la sélection pour une colonne
        for row in range(1, self.tableThemes.rowCount()):
            cell_widget = self.tableThemes.cellWidget(row, col)
            if cell_widget:
                chk = cell_widget.findChild(QtWidgets.QCheckBox)
                if chk:
                    chk.setChecked(not chk.isChecked())

    def check_group_if_layers_in_check(self):
        # Si un groupe a au moins une case de cocher, il doit être visible, explore récursivement les éventuels sous groupes pour les afficher aussi (NE FONCTIONNE PAS COMME ATTENDUE)
        root = QgsProject.instance().layerTreeRoot()
        def update_group(node):
            if node.nodeType() == node.NodeGroup:
                any_child_visible = False
                for child in node.children():
                    if child.nodeType() == child.NodeLayer and child.isVisible():
                        any_child_visible = True
                    elif child.nodeType() == child.NodeGroup and update_group(child):
                        any_child_visible = True
                node.setItemVisibilityChecked(any_child_visible)
                return any_child_visible
            elif node.nodeType() == node.NodeLayer:
                return node.isVisible()
            return False
        update_group(root)