# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ThemeManager
                                 A QGIS plugin
 This plugin stands to be a theme manager. It allows you to select the layers you want to set up in the different themes in your projet as a checklist, showing up all themes at once.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-05-22
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Antoine BOYER
        email                : theme.manager.qgis.plugin@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from .resources import *
from .theme_manager_dialog import ThemeManagerDialog
import os.path

class ThemeManager:
    def __init__(self, iface):
        from qgis.PyQt.QtCore import QTranslator, QCoreApplication, QSettings
        import os

        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)

        locale_full = QSettings().value('locale/userLocale')
        if locale_full:
            lang = locale_full.split('_')[0]
        else:
            lang = 'fr'

        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'theme_manager_{}.qm'.format(lang)
        )

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        self.actions = []
        self.menu = self.tr(u'&Theme Manager')
        self.first_start = None

    def tr(self, message):
        return QCoreApplication.translate('ThemeManager', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)
        if whats_this is not None:
            action.setWhatsThis(whats_this)
        if add_to_toolbar:
            self.iface.addToolBarIcon(action)
        if add_to_menu:
            self.iface.addPluginToMenu(self.menu, action)

        self.actions.append(action)
        return action

    def initGui(self):
        icon_path = ':/plugins/theme_manager/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u''),
            callback=self.run,
            parent=self.iface.mainWindow())
        self.first_start = True

    def unload(self):
        for action in self.actions:
            self.iface.removePluginMenu(self.tr(u'&Theme Manager'), action)
            self.iface.removeToolBarIcon(action)

    def run(self):
        self.dlg = ThemeManagerDialog(self.iface)
        self.dlg.show()
        result = self.dlg.exec_()
        if result:
            pass
