# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ThematicDialog
                                 A QGIS plugin
 Plugin for the evaluation of thematic accuracy on vector cartography
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-08-09
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Harold Mercado LLanos
        email                : hmercado78@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis import processing
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import (QgsProject, QgsVectorLayer, QgsFeatureRequest, QgsSimpleFillSymbolLayer, QgsSymbolLayer, QgsProperty, QgsFillSymbol, 
    QgsSingleSymbolRenderer, QgsField, QgsGeometry, QgsPointXY, QgsFeature, Qgis)
from processing.tools import dataobjects
from PyQt5.QtWidgets import QMessageBox, QDialog, QFileDialog
from PyQt5.QtCore import Qt
from qgis.PyQt.QtCore import QVariant
import numpy as np
from datetime import datetime
from qgis.utils import iface
import webbrowser
from PyQt5.QtGui import QPixmap

# Se instancia el proyecto
project = QgsProject.instance()
root = QgsProject.instance().layerTreeRoot()

# Se configura el contexto para utilziarlo en los geoprocesos que requieran trabajar con geometrias invalidas
context = dataobjects.createContext()
context.setInvalidGeometryCheck(QgsFeatureRequest.GeometrySkipInvalid)
# ------

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'Thematic_accuracy_dialog_base.ui'))
FORM_CLASS2, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'Thematic_accuracy_dialog_result.ui'))


class Thematic_result(QtWidgets.QDialog, FORM_CLASS2):
    def __init__(self, parent=None):
        """Constructor."""
        QDialog.__init__(self)
        self.setupUi(self)

class ThematicDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(ThematicDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.ventana = Thematic_result()

        # Se asigan el comportamiento de los botones y demas Widgets
        self.tabWidget.setTabEnabled(1,False)
        self.tabWidget.setTabEnabled(2,False)
        self.tabWidget.setTabEnabled(3,False)
        self.data_next.clicked.connect(self.campos)
        self.add.clicked.connect(self.add_attr)
        self.field_next.clicked.connect(self.muestreo)
        self.sample_next1.clicked.connect(self.eval_sis)
        self.sample_next2.clicked.connect(self.eval_sim)
        self.sample_next3.clicked.connect(self.eval_est)
        self.field_auto.clicked.connect(self.auto)
        self.bt_result.clicked.connect(self.v_result)
        self.refresh.clicked.connect(self.reload_c)
        self.save_fic.clicked.connect(self.save_html)
        self.help_w.clicked.connect(self.help_win)
        self.bt_clear.clicked.connect(self.clear_win)
        self.siste.clear()
        ruta_img1 = os.path.join(os.path.dirname(__file__), r'imagen\sistematico.jpg')
        imagen1 = QPixmap(ruta_img1)
        self.siste.setPixmap(imagen1)
        self.siste.setScaledContents(True)
        self.randon.clear()
        ruta_img2 = os.path.join(os.path.dirname(__file__), r'imagen\simple.jpg')
        imagen2 = QPixmap(ruta_img2)
        self.randon.setPixmap(imagen2)
        self.randon.setScaledContents(True)
        self.stra.clear()
        ruta_img3 = os.path.join(os.path.dirname(__file__), r'imagen\estratificado.jpg')
        imagen3 = QPixmap(ruta_img3)
        self.stra.setPixmap(imagen3)
        self.stra.setScaledContents(True)

        global option_s
        option_s=""
        self.reload_c()
        self.data_eva.currentIndexChanged.connect(self.selection_ref)

    def help_win(self):
        page_help="http://thematicaccuracy.hol.es/"
        webbrowser.open(page_help, new=0, autoraise=True)

    def clear_win(self):
        if 'list_rel' in globals():
            global list_rel
            del list_rel
            global list_text
            del list_text
            global list_a
            del list_a
            global list_b
            del list_b
            global list_text_e
            del list_text_e
            global list_text_r
            del list_text_r
            self.campos()
            self.tab_rel.clear()
            self.field_eva.setEnabled(True)
            self.field_ref.setEnabled(True)
            self.field_next.setEnabled(False)
            self.tabWidget.setTabEnabled(2,False)
            self.tabWidget.setTabEnabled(3,False)
        else:
            pass

    def reload_c(self):
        global layer
        layer = project.mapLayers()
        global capas
        capas = dict()
        global nom_capas
        self.data_eva.clear()
        self.data_ref.clear()
        nom_capas = []
        nom_capas.append("")
        cont=0
        for n in layer.values():
            if isinstance(n, QgsVectorLayer):
                if n.storageType ()!='Memory storage':
                    if n.geometryType() == 2:
                        capas[cont]=n
                        nom_capas.append(n.name())
                        cont+=1
        self.data_eva.addItems(nom_capas)

        if 'list_rel' in globals():
            global list_rel
            del list_rel
            global list_text
            del list_text
            global list_a
            del list_a
            global list_b
            del list_b
            global list_text_e
            del list_text_e
            global list_text_r
            del list_text_r
        else:
            pass

    def selection_ref(self):
        self.data_ref.setEnabled(True)
        sel_eva= (self.data_eva.currentIndex())
        list_ref = nom_capas.copy()
        list_ref.pop(sel_eva)
        if sel_eva>0:
            self.data_ref.clear()
            self.data_ref.addItems(list_ref)
            self.data_ref.currentIndexChanged.connect(self.verific)
        else:
            self.data_ref.clear()
        
    def verific(self):
        self.mens_data.setEnabled(True)
        self.data_next.setEnabled(False)
        self.tabWidget.setTabEnabled(1,False)
        self.tabWidget.setTabEnabled(2,False)
        self.tabWidget.setTabEnabled(3,False)
        self.tab_rel.clear()
        sel_eva= (self.data_eva.currentIndex())
        sel_ref= (self.data_ref.currentText())
        pos_ref= (nom_capas.index(sel_ref)-1)

        if sel_eva>0 and pos_ref>=0:
            self.field_eva.setEnabled(True)
            self.field_ref.setEnabled(True)
            global capa_eva
            capa_eva = capas[sel_eva-1]
            global capa_ref
            capa_ref = capas[pos_ref]
            global int_ext

            # Verificar que los conjuntos de datos esten en el mismo sistema de coordenadas
            crs_eva = capa_eva.crs().description()
            crs_ref = capa_ref.crs().description()

            mensaje=""
            if crs_eva==crs_ref:
                mensaje+="The Reference Coordinate System of the data is the same<br>"

                exten_eva = processing.run("native:polygonfromlayerextent", {'INPUT': capa_eva,'ROUND_TO':0,'OUTPUT':'TEMPORARY_OUTPUT'}, context=context)
                project.addMapLayer(exten_eva["OUTPUT"], False)

                exten_ref = processing.run("native:polygonfromlayerextent", {'INPUT': capa_ref,'ROUND_TO':0,'OUTPUT':'TEMPORARY_OUTPUT'}, context=context)
                project.addMapLayer(exten_ref["OUTPUT"], False)

                int_ext = processing.run("native:intersection", {'INPUT':exten_eva["OUTPUT"],'OVERLAY':exten_ref["OUTPUT"],'INPUT_FIELDS':[],'OVERLAY_FIELDS':[],'OVERLAY_FIELDS_PREFIX':'','OUTPUT':'TEMPORARY_OUTPUT'}, context=context)
                project.addMapLayer(int_ext["OUTPUT"], False)

                if len(int_ext["OUTPUT"])<1:
                    mensaje+="Data sets do not have shared coverage<br>"
                else:
                    mensaje+="Data sets have shared coverage<br>"
                    self.data_next.setEnabled(True)
                    int_ext["OUTPUT"].selectAll()
                    iface.mapCanvas().zoomToSelected(int_ext["OUTPUT"])
                    int_ext["OUTPUT"].removeSelection()

            else:
                mensaje+="The data Reference Coordinate System is not the same, please change selection<br>"

            doc = """<style type='text/css'>
                table {border-collapse:collapse; border:1px; border-style:solid; border-color:darkblue; padding:3px; vertical-align:middle;} 
                td {padding: 3px;text-align: center;}</style>"""

            self.mens_data.setHtml(doc+mensaje)
            
        else:
            self.mens_data.clear()

    def campos(self):
        self.tabWidget.setTabEnabled(1,True)
        self.tabWidget.setCurrentIndex(1)

        self.label_eva.setText(capa_eva.name())
        self.label_ref.setText(capa_ref.name())

        global campos_eva
        global campos_ref

        campos = list(capa_eva.fields())
        campos_eva=[""]

        for n in campos:
            campos_eva.append(n.name())
        campos = list(capa_ref.fields())
        campos_ref=[""]
        for n in campos:
            campos_ref.append(n.name())

        self.field_eva.clear()
        self.field_eva.addItems(campos_eva)
        self.field_ref.clear()
        self.field_ref.addItems(campos_ref)

        self.field_eva.currentIndexChanged.connect(self.campos_e)
        self.field_ref.currentIndexChanged.connect(self.campos_r)

    def campos_e(self):
        if self.field_eva.currentIndex()>0:
            self.add.setCheckable(False)
            index_eva = (self.field_eva.currentIndex()-1)
            global text_cam_eva
            text_cam_eva = self.field_eva.currentText()
            global atrib_eva
            atrib_eva = ["Select..."]
            for n in capa_eva.getFeatures():
                if not str(n.attributes()[index_eva]) in atrib_eva:
                    atrib_eva.append(str(n.attributes()[index_eva]))
            self.attr_eva.clear()
            self.attr_eva.addItems(atrib_eva)
            self.attr_eva.setEnabled(True)
            self.attr_eva.currentIndexChanged.connect(self.add_rel)
        else:
            self.attr_eva.clear()
            self.attr_eva.setEnabled(False)
        
        if self.field_eva.currentIndex()>0 and self.field_ref.currentIndex()>0:
            self.field_auto.setEnabled(True)
        else:
            self.field_auto.setEnabled(False)

    def campos_r(self):
        if self.field_ref.currentIndex()>0:
            self.add.setCheckable(False)
            index_ref = (self.field_ref.currentIndex()-1)
            global text_cam_ref
            text_cam_ref = self.field_ref.currentText()
            global atrib_ref
            atrib_ref = ["Select..."]
            for n in capa_ref.getFeatures():
                if not str(n.attributes()[index_ref]) in atrib_ref:
                    atrib_ref.append(str(n.attributes()[index_ref]))
            self.attr_ref.clear()
            self.attr_ref.addItems(atrib_ref)
            self.attr_ref.setEnabled(True)
            self.attr_ref.currentIndexChanged.connect(self.add_rel)
        else:
            self.attr_ref.clear()
            self.attr_ref.setEnabled(False)

        if self.field_eva.currentIndex()>0 and self.field_ref.currentIndex()>0:
            self.field_auto.setEnabled(True)
        else:
            self.field_auto.setEnabled(False)

    def add_rel(self):
        if self.attr_eva.currentIndex()>0 and self.attr_ref.currentIndex()>0:
            self.add.setEnabled(True)
            self.add.setCheckable(True)
        else:
            self.add.setEnabled(False)

    def auto(self):
        self.field_eva.setEnabled(False)
        self.field_ref.setEnabled(False)
        texto=""
        global list_rel
        global list_text
        global list_a
        global list_b
        global list_text_e
        global list_text_r
        list_rel= list()
        list_text= list()
        list_a = list()
        list_b = list()
        list_text_e= list()
        list_text_r= list()
        atrib_eva_a = atrib_eva.copy()
        atrib_eva_a.remove("Select...")
        atrib_ref_a = atrib_ref.copy()
        atrib_ref_a.remove("Select...")
                
        for n in atrib_eva_a:
            if n in atrib_ref_a:
                text_rel = [atrib_eva_a.index(n),atrib_ref_a.index(n)]
                text_tex = [n,n]
                list_rel.append(text_rel)
                list_text.append(text_tex)
                list_a.append(atrib_eva_a.index(n))
                list_b.append(atrib_ref_a.index(n))
                list_text_e.append(n)
                list_text_r.append(n)
                    
        if len(list_rel)>1:
            self.field_next.setEnabled(True)
        else:
            texto+="<font color=#FF0000><b>Error: There are no common attributes to establish a relation</b></font><br>"
            self.field_eva.setEnabled(True)
            self.field_ref.setEnabled(True)
        
        doc = """<style type='text/css'>
            table {border-collapse:collapse; border:1px; border-style:solid; border-color:darkblue; padding:3px; vertical-align:middle;} 
            td {padding: 3px;text-align: center;}</style>"""
        
        texto+="<center>"
        texto+="<table border=1><tr><td><b><center>Evaluate</center></b></td><td><b><center>Reference</center></b></td></tr>"
        for n in list_text:
            texto+=f"<tr><td><center>{n[0]}</center></td><td><center>{n[1]}</center></td></tr>"
        texto+="</table></center>"

        self.tab_rel.setHtml(doc+texto)    

    def add_attr(self):
        self.field_eva.setEnabled(False)
        self.field_ref.setEnabled(False)
        cam_eva = self.attr_eva.currentIndex()-1
        cam_ref = self.attr_ref.currentIndex()-1
        text_eva = self.attr_eva.currentText()
        text_ref = self.attr_ref.currentText()

        text_rel = [cam_eva,cam_ref]
        text_tex = [text_eva,text_ref] 
        global list_rel
        global list_text
        global list_text_e
        global list_text_r
        global list_a
        global list_b
        texto=""

        try:
            if not text_rel in list_rel:
                if not cam_eva in list_a:
                    if not cam_ref in list_b:
                        list_rel.append(text_rel)
                        list_text.append(text_tex)
                        list_a.append(cam_eva)
                        list_b.append(cam_ref)
                        list_text_e.append(text_eva)
                        list_text_r.append(text_ref)
                    else:
                        texto+="<font color=#FF0000><b>Error: the relation cannot be established</b></font><br>"
                else:
                    texto+="<font color=#FF0000><b>Error: the relation cannot be established</b></font><br>"
        except NameError:
            list_rel= list()
            list_text= list()
            list_text_e= list()
            list_text_r= list()
            list_a = list()
            list_b = list()
            list_rel.append(text_rel)
            list_text.append(text_tex)
            list_a.append(cam_eva)
            list_b.append(cam_ref)
            list_text_e.append(text_eva)
            list_text_r.append(text_ref)

        if len(list_rel)>1:
            self.field_next.setEnabled(True)
            

        doc = """<style type='text/css'>
            table {border-collapse:collapse; border:1px; border-style:solid; border-color:darkblue; padding:3px; vertical-align:middle;} 
            td {padding: 3px;text-align: center;}</style>"""
        
        texto+="<center>"
        texto+="<table border=1><tr><td><b><center>Evaluate</center></b></td><td><b><center>Reference</center></b></td></tr>"
        for n in list_text:
            texto+=f"<tr><td><center>{n[0]}</center></td><td><center>{n[1]}</center></td></tr>"
        texto+="</table></center>"

        self.tab_rel.setHtml(doc+texto)

    def muestreo(self):
        self.tabWidget.setTabEnabled(2,True)
        self.tabWidget.setCurrentIndex(2)

        self.s_row.valueChanged[unicode].connect(self.eval)
        self.s_col.valueChanged[unicode].connect(self.eval)
        self.s_simple.valueChanged[unicode].connect(self.eval)
        self.s_estra.valueChanged[unicode].connect(self.eval)
        
    def eval(self):
        for feature in int_ext["OUTPUT"].getFeatures():
            attrs = feature.attributes()
            self.min_e.setText(str(round(attrs[0],2)))
            self.min_n.setText(str(round(attrs[1],2)))
            self.max_e.setText(str(round(attrs[2],2)))
            self.max_n.setText(str(round(attrs[3],2)))

        min_este = attrs[0]
        min_norte = attrs[1]
        max_este = attrs[2]
        max_norte = attrs[3]

        if self.s_row.value()>0 and self.s_col.value()>0:
            self.sample_next1.setEnabled(True)
        else:
            self.sample_next1.setEnabled(False)

        if self.s_simple.value()>0:
            self.sample_next2.setEnabled(True)
        else:
            self.sample_next2.setEnabled(False)

        if self.s_estra.value()>0:
            self.sample_next3.setEnabled(True)
        else:
            self.sample_next3.setEnabled(False)

    def mens_push(self):
        iface.messageBar().pushMessage("Thematic accuracy",'Running sampling, please wait...', level=Qgis.Info, duration=10)

    def eval_sis(self):
        self.mens_push()   
        self.tabWidget.setTabEnabled(3,True)
        self.tabWidget.setCurrentIndex(3)
        self.label_15.setText("Selected sampling: Systematic Sampling")
        option_s="Selected sampling: Systematic Sampling"

        for feature in int_ext["OUTPUT"].getFeatures():
            attrs = feature.attributes()
            self.min_e.setText(str(round(attrs[0],2)))
            self.min_n.setText(str(round(attrs[1],2)))
            self.max_e.setText(str(round(attrs[2],2)))
            self.max_n.setText(str(round(attrs[3],2)))

        min_este = attrs[0]
        min_norte = attrs[1]
        max_este = attrs[2]
        max_norte = attrs[3]

        filas = self.s_row.value()
        columnas = self.s_col.value()
        ancho = (max_este-min_este)/(columnas+1)
        alto = (max_norte-min_norte)/(filas+1)
        global num_pts
        num_pts = filas*columnas

        epsg=capa_eva.crs().toWkt()
        pts_sample = QgsVectorLayer("Point?crs="+ epsg, "temp", "Memory")
        pts_sample.dataProvider().addAttributes([QgsField("id", QVariant.Int)])
        pts_sample.updateFields()

        cont=1
        for r in range(1,filas+1):
            for c in range(1,columnas+1):
                feat = QgsFeature(pts_sample.fields())
                feat.setAttribute(0,cont)
                x = min_este+(c*ancho)
                y = max_norte-(r*alto)
                feat.setGeometry(QgsGeometry.fromPointXY(QgsPointXY(x, y)))
                pts_sample.dataProvider().addFeatures([feat])
                cont+=1

        global pts_sample_r
        pts_sample_e = processing.run("native:intersection", {'INPUT':pts_sample,'OVERLAY':capa_eva,'INPUT_FIELDS':[],'OVERLAY_FIELDS':[text_cam_eva],'OVERLAY_FIELDS_PREFIX':'Eva_','OUTPUT':'TEMPORARY_OUTPUT'}, context=context)
        pts_sample_r = processing.run("native:intersection", {'INPUT':pts_sample_e["OUTPUT"],'OVERLAY':capa_ref,'INPUT_FIELDS':[],'OVERLAY_FIELDS':[text_cam_ref],'OVERLAY_FIELDS_PREFIX':'Ref_','OUTPUT':'TEMPORARY_OUTPUT'}, context=context)

        processing.run("native:renamelayer", {'INPUT': pts_sample_r["OUTPUT"],'NAME': 'Sample_Systematic'}, context=context)
        project.addMapLayer(pts_sample_r["OUTPUT"],True)

        self.matriz()

    def eval_sim(self):
        self.mens_push()
        self.tabWidget.setTabEnabled(3,True)
        self.tabWidget.setCurrentIndex(3)
        self.label_15.setText("Selected sampling: Simple Random Sampling")
        option_s="Selected sampling: Simple Random Sampling"

        for feature in int_ext["OUTPUT"].getFeatures():
            attrs = feature.attributes()
            self.min_e.setText(str(round(attrs[0],2)))
            self.min_n.setText(str(round(attrs[1],2)))
            self.max_e.setText(str(round(attrs[2],2)))
            self.max_n.setText(str(round(attrs[3],2)))

        global num_pts
        num_pts = self.s_simple.value()
        dist_pt = self.distance_pt.value()

        pts_sample = processing.run("qgis:randompointsinlayerbounds", {'INPUT': int_ext["OUTPUT"],'POINTS_NUMBER':num_pts,'MIN_DISTANCE':dist_pt,'OUTPUT':'TEMPORARY_OUTPUT'}, context=context)
        global pts_sample_r
        pts_sample_e = processing.run("native:intersection", {'INPUT':pts_sample["OUTPUT"],'OVERLAY':capa_eva,'INPUT_FIELDS':[],'OVERLAY_FIELDS':[text_cam_eva],'OVERLAY_FIELDS_PREFIX':'Eva_','OUTPUT':'TEMPORARY_OUTPUT'}, context=context)
        pts_sample_r = processing.run("native:intersection", {'INPUT':pts_sample_e["OUTPUT"],'OVERLAY':capa_ref,'INPUT_FIELDS':[],'OVERLAY_FIELDS':[text_cam_ref],'OVERLAY_FIELDS_PREFIX':'Ref_','OUTPUT':'TEMPORARY_OUTPUT'}, context=context)

        processing.run("native:renamelayer", {'INPUT': pts_sample_r["OUTPUT"],'NAME': 'Sample_Simple_Random'}, context=context)
        project.addMapLayer(pts_sample_r["OUTPUT"],True)

        self.matriz()

    def eval_est(self):
        self.mens_push()
        self.tabWidget.setTabEnabled(3,True)
        self.tabWidget.setCurrentIndex(3)
        self.label_15.setText("Selected sampling: Stratified Random Sampling")
        option_s="Selected sampling: Stratified Random Sampling"

        for feature in int_ext["OUTPUT"].getFeatures():
            attrs = feature.attributes()
            self.min_e.setText(str(round(attrs[0],2)))
            self.min_n.setText(str(round(attrs[1],2)))
            self.max_e.setText(str(round(attrs[2],2)))
            self.max_n.setText(str(round(attrs[3],2)))

        strategy = self.strategy.currentText()
        global num_pts
        num_pts = self.s_estra.value()
        dist_pt = self.distance_pt.value()

        corte = processing.run("native:clip", {'INPUT':capa_eva,'OVERLAY':int_ext["OUTPUT"],'OUTPUT':'TEMPORARY_OUTPUT'}, context=context)

        if strategy=="Sample by feature":
            pts_sample = processing.run("qgis:randompointsinsidepolygons", {'INPUT':corte["OUTPUT"],'STRATEGY':0,'VALUE':num_pts,'MIN_DISTANCE':dist_pt,'OUTPUT':'TEMPORARY_OUTPUT'}, context=context)
            pts_sample_e = processing.run("native:intersection", {'INPUT':pts_sample["OUTPUT"],'OVERLAY':capa_eva,'INPUT_FIELDS':[],'OVERLAY_FIELDS':[text_cam_eva],'OVERLAY_FIELDS_PREFIX':'Eva_','OUTPUT':'TEMPORARY_OUTPUT'}, context=context)
        
        if strategy=="Sample by category":
            epsg=capa_eva.crs().toWkt()
            pts_sample = QgsVectorLayer("Point?crs="+ epsg, "temp", "Memory")
            pts_sample.dataProvider().addAttributes([QgsField("id", QVariant.Int)])
            pts_sample.updateFields()

            disol= processing.run("native:dissolve", {'INPUT':corte["OUTPUT"],'FIELD':text_cam_eva,'OUTPUT':'TEMPORARY_OUTPUT'})
            cont=1
            for n in disol["OUTPUT"].getFeatures():
                capa_temp = QgsVectorLayer("Polygon?crs="+ epsg, "temp", "Memory")
                capa_temp.dataProvider().addFeatures([n])
                pts_temp = processing.run("qgis:randompointsinsidepolygons", {'INPUT':capa_temp,'STRATEGY':0,'VALUE':num_pts,'MIN_DISTANCE':dist_pt,'OUTPUT':'TEMPORARY_OUTPUT'}, context=context)
                for m in pts_temp["OUTPUT"].getFeatures():
                    m.setAttribute(0,cont)
                    pts_sample.dataProvider().addFeatures([m])
                    cont+=1
                project.removeMapLayer(pts_temp["OUTPUT"].id())
            pts_sample_e = processing.run("native:intersection", {'INPUT':pts_sample,'OVERLAY':capa_eva,'INPUT_FIELDS':[],'OVERLAY_FIELDS':[text_cam_eva],'OVERLAY_FIELDS_PREFIX':'Eva_','OUTPUT':'TEMPORARY_OUTPUT'}, context=context)

        global pts_sample_r
        pts_sample_r = processing.run("native:intersection", {'INPUT':pts_sample_e["OUTPUT"],'OVERLAY':capa_ref,'INPUT_FIELDS':[],'OVERLAY_FIELDS':[text_cam_ref],'OVERLAY_FIELDS_PREFIX':'Ref_','OUTPUT':'TEMPORARY_OUTPUT'}, context=context)

        processing.run("native:renamelayer", {'INPUT': pts_sample_r["OUTPUT"],'NAME': 'Sample_Stratified_Random'}, context=context)
        project.addMapLayer(pts_sample_r["OUTPUT"],True)

        self.matriz()

    def matriz(self):
        global mat_conf
        mat_conf=np.zeros((len(list_a)+1,len(list_b)+1))
        otro_cam="NO"
        campos_sam = list(pts_sample_r["OUTPUT"].fields())
        for n in pts_sample_r["OUTPUT"].getFeatures():
            val_e = n.attributes()[1]
            if val_e in list_text_e:
                ind_e = list_text_e.index(val_e)
            else:
                ind_e=len(list_a)
                otro_cam ="SI"
            
            val_r = n.attributes()[2]
            if val_r in list_text_r:
                ind_r = list_text_r.index(val_r)
            else:
                ind_r=len(list_b)
                otro_cam="SI"

            mat_conf[ind_e][ind_r]+=1

        if otro_cam=="SI":
            titulo="Thematic Accuracy Vector"
            mens_b="There are relations not indicated in the classification. Do you want to evaluate them as 'other'?"
            msgBox = QMessageBox().question(self,titulo, mens_b, QMessageBox.Yes | QMessageBox.No, QMessageBox.Yes)
        else:
            msgBox = QMessageBox.No

        global list_text_e_c
        global list_text_r_c
        global list_a_c
        global list_b_c
        list_text_e_c = list_text_e.copy()
        list_text_r_c = list_text_r.copy()
        list_a_c = list_a.copy()
        list_b_c = list_b.copy()

        long_mat=len(mat_conf)-1
        if msgBox == QMessageBox.Yes:
            list_text_e_c.append("other")
            list_text_r_c.append("other")
            list_a_c.append("other")            
            list_b_c.append("other")
        else:
            mat_conf=np.delete(mat_conf, long_mat, axis=0)
            mat_conf=np.delete(mat_conf, long_mat, axis=1)

        # Total de elementos
        total = np.sum(mat_conf)

        # Verdaderos positivos
        b = np.asarray(mat_conf)
        t_pos = np.trace(b)
        accu = round((t_pos/total)*100,2)

        #Texto para el archivo THML
        sum_c=np.zeros((1,len(list_a_c)))

        texto2='<!DOCTYPE html>\n<html>\n<head>\n<meta charset="utf-8">\n<title>Resultado de Evaluación Calidad - Exactitud Posiocional</title>\n'
        texto2+='<style type="text/css">\nbody {font-family: arial; margin: 5%;}\ntable {border: 2px solid blue; border-collapse: collapse; font-family: arial;}\n'
        texto2+='td {padding: 5px;text-align: center;}</style></head>\n<body>\n'
        texto2+="<center><h3><b>Vector Thematic Accuracy</b></h3></center><br>\n"
        texto2+=f"Data set to evaluate: <b>{capa_eva.name()}</b><br>\n"
        texto2+=f"Reference Dataset: <b>{capa_ref.name()}</b><br>\n"
        now = datetime.now()
        hoy = now.strftime('%Y/%m/%d %H:%M')
        texto2+=f"Date: <b>{hoy}</b><br>\n"
        texto2+=f"<b>{option_s}</b><br>\n"
        texto2+="<b>ISO19157 MEASURES</b><br>"
        texto2+="<b>Measure 62:</b> Misclassification matrix<br>"        
        texto2+=f"<center><table><tr><td></td><td>Reference Dataset</td><tr>\n"
        texto2+=f"<tr><td>Data set to evaluate</td><td>\n"
        texto2+="<table border=1><tr><td></td>\n"
        for n in list_text_r_c:
            texto2+=f"<td style='background-color:#BCF5FF;'><b>{n}</b></td>\n"
        cont=0
        list_sum_f=list()
        list_dia=list()
        texto2+="<td style='background-color:#BCF5FF;'><b>T.E.</b></td></tr>\n"
        for n in list_text_e_c:
            texto2+=f"<tr><td style='background-color:#BCF5FF;'><b>{n}</b></td>\n"
            sum_f=0
            for c in range(len(list_text_r_c)):
                if cont==c:
                    color="#BCF5FF"
                    list_dia.append(mat_conf[cont][c])
                else:
                    color="#FFFFFF"
                if mat_conf[cont][c]==0 and cont!=c:     
                    texto2+=f"<td style='background-color:{color};color:white'>{int(mat_conf[cont][c])}</td>\n"
                else:
                    texto2+=f"<td style='background-color:{color};'>{int(mat_conf[cont][c])}</td>\n"
                sum_f+=mat_conf[cont][c]
                sum_c[0][c]+=mat_conf[cont][c]
            texto2+=f"<td><b>{int(sum_f)}</b></td></tr>\n"
            list_sum_f.append(sum_f)
            cont+=1
        texto2+="<tr><td style='background-color:#BCF5FF;'><b>T.R.</b></td>\n"
        for c in range(len(list_text_r_c)):
            texto2+=f"<td><b>{int(sum_c[0][c])}</b></td>\n"
        texto2+=f"<td><b>{int(total)}</b></td></tr></table></td></tr></table></center><br>\n"
        texto2+="<b>T.E</b> = Total Evaluated <b>T.R.</b> = Total Reference<br><br>\n"

        texto2+="<b>Measure 63</b>: Relative misclassification matrix (%)<br>\n"
        texto2+=f"<center><table><tr><td></td><td>Reference Dataset</td><tr>\n"
        texto2+=f"<tr><td>Data set to evaluate</td><td>\n"
        texto2+="<table border=1><tr><td></td>\n"
        for n in list_text_r_c:
            texto2+=f"<td style='background-color:#BCF5FF;'><b>{n}</b></td>"
        cont=0
        list_sum_f2=list()
        texto2+="</tr>\n"
        for n in list_text_e_c:
            texto2+=f"<tr><td style='background-color:#BCF5FF;'><b>{n}</b></td>\n"
            sum_f=0
            for c in range(len(list_text_r_c)):
                sum_f+=mat_conf[cont][c]
            
            list_sum_f2.append(sum_f)
            for c in range(len(list_text_r_c)):    
                if cont==c:
                    color="#BCF5FF"
                else:
                    color="#FFFFFF"
                rel = round((mat_conf[cont][c]/list_sum_f2[cont])*100,2)
                if mat_conf[cont][c]==0 and cont!=c:
                    if list_sum_f2[cont]==0:      
                        texto2+=f"<td style='background-color:{color};color:white;'></td>\n"
                    else:
                        texto2+=f"<td style='background-color:{color};color:white;'>{rel}</td>\n"
                else:
                    if list_sum_f2[cont]==0:      
                        texto2+=f"<td style='background-color:{color};color:white;'></td>\n"
                    else:
                        texto2+=f"<td style='background-color:{color};'>{rel}</td>\n"
            texto2+="</tr>"
            cont+=1
        texto2+="</table></td></tr></table></center><br>"

        size_sample=len(pts_sample_r["OUTPUT"])
        if num_pts>size_sample:
            texto2+=f"There are <b>{int(num_pts-size_sample)}</b> invalid geometries that cannot be sampled<br>\n"
        texto2+=f"<b>Measure 60:</b> misclassified objects = <b>{int(total-t_pos)}</b><br>\n"
        texto2+=f"<b>Measure 61:</b> index of misclassified objects = <b>{round((total-t_pos)/total,2)}</b><br>\n"
        sum_tot=0
        for x in range(len(list_sum_f)):
            sum_tot +=list_sum_f[x]*sum_c[0][x]

        kappa = round(((total*t_pos)-sum_tot)/((total**2)-sum_tot),2)
        texto2+=f"<b>Measure 64:</b> Total Kappa Statistic= <b>{kappa}</b><br>\n"
        texto2+="<center><table><tr><td><b>Kappa Statistic</b></td><td><b>Strength of agreement</b></td></tr>\n"
        texto2+="<tr><td><b><0.00</b></td><td>Poor</td></tr>\n"
        texto2+="<tr><td><b>0.00 - 0.20</b></td><td>Slight</td></tr>\n"
        texto2+="<tr><td><b>0.21 - 0.40</b></td><td>Fair</td></tr>\n"
        texto2+="<tr><td><b>0.41 - 0.60</b></td><td>Moderate</td></tr>\n"
        texto2+="<tr><td><b>0.61 - 0.80</b></td><td>Substantial</td></tr>\n"
        texto2+="<tr><td><b>0.81 - 1.00</b></td><td>Almost perfect</td></tr><tr><td colspan=2><h6>Landis JR, Koch GG 1977</h6></td><tr></table></center><br>\n"

        texto2+="<b>OTHER MEASURES</b><br>\n"
        texto2+=f"Sample = <b>{size_sample}</b><br>\n"        
        texto2+=f"Classified sample = <b>{int(total)}</b><br>\n"
        texto2+=f"True positives = <b>{int(t_pos)}</b><br>\n"
        texto2+=f"Accuracy = <b>{accu}%</b><br>\n"
        
        cont=0
        texto2+="<center><table border=1><tr><td></td><td><b>user accuracy</b></td><td><b>producer accuracy</b></td></tr>\n"
        for n in list_text_e_c:
            exac_user=round(((list_dia[cont]/list_sum_f[cont])*100),2)
            exac_prod=round(((list_dia[cont]/sum_c[0][cont])*100),2)
            if exac_user>=0 and exac_prod>=0:
                texto2+=f"<tr><td><b>{n}</b></td><td>{exac_user} %</td><td>{exac_prod} %</td></tr>\n"
            else:
                texto2+=f"<tr><td><b>{n}</b></td><td"
                if exac_user>=0:
                    texto2+=">"
                else:
                    texto2+=" style='color:white'>"
                texto2+=f"{exac_user} %</td><td"
                if exac_prod>=0:
                    texto2+=">"
                else:
                    texto2+=" style='color:white'>"
                texto2+=f"{exac_prod} %</td></tr>\n"
            cont+=1
        texto2+="</table><br>\n"
        texto2+="</body></html>"

        global text_comp
        text_comp=texto2

        #----------------------        


        #Exactitud
        accu = round((t_pos/total)*100,2)
        texto=""
        size_sample=len(pts_sample_r["OUTPUT"])
        if num_pts>size_sample:
            texto+=f"There are <b>{int(num_pts-size_sample)}</b> invalid geometries that cannot be sampled<br>"
        size_sample=len(pts_sample_r["OUTPUT"])
        texto+=f"Sample = {size_sample}<br>"
        texto+=f"Classified sample = {total}<br>"
        texto+=f"True positives = {t_pos}<br>"
        texto+=f"Accuracy = {accu}%<br>"
        texto+=f"Total Kappa Statistic= {kappa}<br>"

        doc = """<style type='text/css'>
            table {border-collapse:collapse; border:1px; border-style:solid; border-color:darkblue; padding:3px; vertical-align:middle;} 
            td {padding: 3px;text-align: center;}</style>"""
                
        self.result.setHtml(doc+texto)  

    def v_result(self):
        ventana = Thematic_result()

        sum_c=np.zeros((1,len(list_a_c)))

        # Total de elementos
        total = np.sum(mat_conf)

        # Verdaderos positivos
        b = np.asarray(mat_conf)
        t_pos = np.trace(b)

        #Exactitud
        accu = round((t_pos/total)*100,2)

        texto="<center><h3><b>Vector Thematic Accuracy</b></h3></center><br>"
        texto+=f"Data set to evaluate: <b>{capa_eva.name()}</b><br>"
        texto+=f"Reference Dataset: <b>{capa_ref.name()}</b><br>"

        now = datetime.now()
        hoy = now.strftime('%Y/%m/%d %H:%M')

        texto+=f"Date: <b>{hoy}</b><br>"
        texto+=f"<b>{option_s}</b><br>"        

        texto+="<b>ISO19157 MEASURES</b><br>"
        texto+="<b>Measure 62:</b> Misclassification matrix<br>"
        texto+=f"<center><table><tr><td></td><td>Reference Dataset</td><tr>"
        texto+=f"<tr><td>Data set to evaluate</td><td>"
        texto+="<table border=1><tr><td></td>"
        for n in list_text_r_c:
            texto+=f"<td style='background-color:#BCF5FF;'><b>{n}</b></td>"
        cont=0
        list_sum_f=list()
        list_dia=list()
        texto+="<td style='background-color:#BCF5FF;'><b>TC</b></td></tr>"
        for n in list_text_e_c:
            texto+=f"<tr><td style='background-color:#BCF5FF;'><b>{n}</b></td>"
            sum_f=0
            for c in range(len(list_text_r_c)):
                if cont==c:
                    color="#BCF5FF"
                    list_dia.append(mat_conf[cont][c])
                else:
                    color="#FFFFFF"
                if mat_conf[cont][c]==0 and cont!=c:     
                    texto+=f"<td style='background-color:{color};color:white'>{int(mat_conf[cont][c])}</td>\n"
                else:
                    texto+=f"<td style='background-color:{color};'>{int(mat_conf[cont][c])}</td>"
                sum_f+=mat_conf[cont][c]
                sum_c[0][c]+=mat_conf[cont][c]
            texto+=f"<td><b>{int(sum_f)}</b></td></tr>"
            list_sum_f.append(sum_f)
            cont+=1
        texto+="<tr><td style='background-color:#BCF5FF;'><b>TO</b></td>"
        for c in range(len(list_text_r_c)):
            texto+=f"<td><b>{int(sum_c[0][c])}</b></td>"
        texto+=f"<td><b>{int(total)}</b></td></tr></table></td></tr></table></center><br>"
        texto+="<b>T.E</b> = Total Evaluated <b>T.R.</b> = Total Reference<br><br>"

        texto+="<b>Measure 63:</b> Relative misclassification matrix (%)<br>"
        texto+=f"<center><table><tr><td></td><td>Reference Dataset</td><tr>"
        texto+=f"<tr><td>Data set to evaluate</td><td>"
        texto+="<table border=1><tr><td></td>"
        for n in list_text_r_c:
            texto+=f"<td style='background-color:#BCF5FF;'><b>{n}</b></td>"
        cont=0
        list_sum_f2=list()
        texto+="</tr>"
        for n in list_text_e_c:
            texto+=f"<tr><td style='background-color:#BCF5FF;'><b>{n}</b></td>"
            sum_f=0
            for c in range(len(list_text_r_c)):
                sum_f+=mat_conf[cont][c]

            list_sum_f2.append(sum_f)
            for c in range(len(list_text_r_c)):    
                if cont==c:
                    color="#BCF5FF"
                else:
                    color="#FFFFFF"
                rel = round((mat_conf[cont][c]/list_sum_f2[cont])*100,2)
                if mat_conf[cont][c]==0 and cont!=c:
                    if list_sum_f2[cont]==0:      
                        texto+=f"<td style='background-color:{color};color:white;'></td>"
                    else:
                        texto+=f"<td style='background-color:{color};color:white;'>{rel}</td>"
                else:
                    if list_sum_f2[cont]==0:      
                        texto+=f"<td style='background-color:{color};color:white;'></td>"
                    else:
                        texto+=f"<td style='background-color:{color};'>{rel}</td>"
            texto+="</tr>"
            cont+=1
        texto+="</table></td></tr></table></center><br>"

        size_sample=len(pts_sample_r["OUTPUT"])
        if num_pts>size_sample:
            texto+=f"There are <b>{int(num_pts-size_sample)}</b> invalid geometries that cannot be sampled<br>"
        texto+=f"<b>Measure 60:</b> misclassified objects = <b>{int(total-t_pos)}</b><br>"
        texto+=f"<b>Measure 61:</b> index of misclassified objects = <b>{round((total-t_pos)/total,2)}</b><br>"

        sum_tot=0
        for x in range(len(list_sum_f)):
            sum_tot +=list_sum_f[x]*sum_c[0][x]
        kappa = round(((total*t_pos)-sum_tot)/((total**2)-sum_tot),2)
        texto+=f"<b>Measure 64:</b> Total Kappa Statistic= <b>{kappa}</b><br>"
        texto+="<center><table><tr><td><b>Kappa Statistic</b></td><td><b>Strength of agreement</b></td></tr>"
        texto+="<tr><td><b>less 0.00</b></td><td>Poor</td></tr>"
        texto+="<tr><td><b>0.00 - 0.20</b></td><td>Slight</td></tr>"
        texto+="<tr><td><b>0.21 - 0.40</b></td><td>Fair</td></tr>"
        texto+="<tr><td><b>0.41 - 0.60</b></td><td>Moderate</td></tr>"
        texto+="<tr><td><b>0.61 - 0.80</b></td><td>Substantial</td></tr>"
        texto+="<tr><td><b>0.81 - 1.00</b></td><td>Almost perfect</td></tr><tr><td colspan=2><h6>Landis JR, Koch GG 1977</h6></td><tr></table></center><br>"

        texto+="<b>OTHER MEASURES</b><br>"
        texto+=f"Sample = <b>{size_sample}</b><br>"        
        texto+=f"Classified sample = <b>{int(total)}</b><br>"
        texto+=f"True positives = <b>{int(t_pos)}</b><br>"
        texto+=f"Accuracy = <b>{accu}%</b><br>"

        cont=0
        texto+="<center><table border=1><tr><td></td><td><b>user accuracy</b></td><td><b>producer accuracy</b></td></tr>"
        for n in list_text_e_c:
            exac_user=round(((list_dia[cont]/list_sum_f[cont])*100),2)
            exac_prod=round(((list_dia[cont]/sum_c[0][cont])*100),2)
            if exac_user>=0 and exac_prod>=0:
                texto+=f"<tr><td><b>{n}</b></td><td>{exac_user} %</td><td>{exac_prod} %</td></tr>\n"
            else:
                texto+=f"<tr><td><b>{n}</b></td><td"
                if exac_user>=0:
                    texto+=">"
                else:
                    texto+=" style='color:white'>"
                texto+=f"{exac_user} %</td><td"
                if exac_prod>=0:
                    texto+=">"
                else:
                    texto+=" style='color:white'>"
                texto+=f"{exac_prod} %</td></tr>\n"
            cont+=1
        texto+="</table><br>"

        doc = """<style type='text/css'>
            table {border-collapse:collapse; border:1px; border-style:solid; border-color:darkblue; padding:3px; vertical-align:middle;} 
            td {padding: 3px;text-align: center;}</style>"""
                
        ventana.res_result.setHtml(doc+texto)
        ventana.res_result.move(0, 0) 
        ventana.exec_() 

    def save_html(self):
        dialogo = QFileDialog(self)
        fileName_f, filetype = dialogo.getSaveFileName(self, "Guardar archivo HTML",'' ,"HTML (*.html)")
        f = open (fileName_f, 'w')
        f.write(text_comp)
        f.close()  
        webbrowser.open(fileName_f, new=0, autoraise=True)