# -*- coding: utf-8 -*-

"""
/***************************************************************************
 TfCTools
                                 A QGIS plugin
 A suite of Transport for Cairo tools: RouteLab to SDI migration, GIS2GTFS, and Vehicle & Passenger Flow.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-08-28
        copyright            : (C) 2025 by Transport for Cairo
        email                : info@transportforcairo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Transport for Cairo'
__date__ = '2025-08-28'
__copyright__ = '(C) 2025 by Transport for Cairo'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingProvider
from .tfc_tools_algorithm import TfCToolsAlgorithm

# for icons
from qgis.PyQt.QtGui import QIcon
import os

from qgis.PyQt.QtCore import QCoreApplication

from .rl2sdi.rl2sdi_algorithm import RL2SDIAlgorithm
from .gis2gtfs.gis2gtfs_algorithm import GIS2GTFSAlgorithm
from .vehicle_passenger_flow.vehicle_passenger_flow_algorithm import VehiclePassengerFlowAlgorithm


class TfCToolsProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(TfCToolsAlgorithm())
        # add additional algorithms here
        # self.addAlgorithm(MyOtherAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        # stable, lowercase, no spaces/hyphens
        return 'tfc_tools'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        # The label shown as top-level in the Processing Toolbox
        return self.tr('TfC Tools')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        icon_path = os.path.join(os.path.dirname(__file__), "icons", "TfC-tools-icon.svg")
        return QIcon(icon_path)
        # return QgsProcessingProvider.icon(self)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
    
    def loadAlgorithms(self):
        # Register algorithms here. Grouping will be controlled by each Algorithm's group()/groupId()
        self.addAlgorithm(RL2SDIAlgorithm())
        self.addAlgorithm(GIS2GTFSAlgorithm())
        self.addAlgorithm(VehiclePassengerFlowAlgorithm())

    def tr(self, string):
        return QCoreApplication.translate("TfCToolsProvider", string)
