# -*- coding: utf-8 -*-

"""
/***************************************************************************
 RL2SDI
                                 A QGIS plugin
 This plugin migrates RouteLab data to SDI schema
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-06-29
        copyright            : (C) 2025 by Transport for Cairo
        email                : info@transportforcairo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Transport for Cairo'
__date__ = '2025-06-29'
__copyright__ = '(C) 2025 by Transport for Cairo'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterString,  #newly added from this line
                       QgsProcessingParameterProviderConnection,
                       QgsApplication,
                       QgsProviderRegistry,
                       QgsDataSourceUri) #this is for conn_mgr
from .script4plugin import run_migration
import urllib.parse 

# for icon
from qgis.PyQt.QtGui import QIcon
import os

def _icon_path(*parts):
    # __file__ is inside tfc_tools/rl2sdi/
    here = os.path.dirname(__file__)
    root = os.path.abspath(os.path.join(here, ".."))     # tfc_tools/
    return os.path.join(root, *parts)

class RL2SDIAlgorithm(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OBSERVER_CONN = 'observer_connection'
    SDI_CONN = 'sdi_connection'
    PROJECT_ID = 'project_id'

    # OUTPUT = 'OUTPUT'
    # INPUT = 'INPUT'

    def initAlgorithm(self, config=None):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        # 1. Observer DB connection (provider: PostgreSQL)
        self.addParameter(
            QgsProcessingParameterProviderConnection(
                self.OBSERVER_CONN,
                "RouteLab's Observer DB connection",
                provider='postgres'
            )
        )


        # 2. SDI DB connection (target DB)
        self.addParameter(
            QgsProcessingParameterProviderConnection(
                self.SDI_CONN,
                "Target SDI DB connection",
                provider='postgres'
            )
        )

        # 3. Project ID
        self.addParameter(
            QgsProcessingParameterString(
                self.PROJECT_ID,
                "RouteLab Project ID"
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.

        # Get connection name from parameters
        observer_conn_name = self.parameterAsConnectionName(parameters, self.OBSERVER_CONN, context)
        sdi_conn_name = self.parameterAsConnectionName(parameters, self.SDI_CONN, context)

        project_id = self.parameterAsString(parameters, self.PROJECT_ID, context)

        feedback.pushInfo(f"Using Observer connection: {observer_conn_name}")
        feedback.pushInfo(f"Using SDI connection: {sdi_conn_name}")
        feedback.pushInfo(f"RouteLab Project ID: {project_id}")
        
        # Access connection URI strings via provider metadata
        postgres_metadata = QgsProviderRegistry.instance().providerMetadata('postgres') #this variable stores the object 'postgres' from the class providerMetadata

        observer_conn = postgres_metadata.findConnection(observer_conn_name)
        sdi_conn = postgres_metadata.findConnection(sdi_conn_name)
        
        observer_uri_str = observer_conn.uri() #returns string of DB connection
        sdi_uri_str = sdi_conn.uri()

        # Parse URI string into connection details
        observer_uri = QgsDataSourceUri(observer_uri_str) #ChatGPT suggested the naming observer_uri
        sdi_uri = QgsDataSourceUri(sdi_uri_str)  #ChatGPT suggested the naming sdi_uri

        observer_db_params = {
            "dbname": observer_uri.database(),
            "user": observer_uri.username(),
            "password": observer_uri.password(),
            "host": observer_uri.host(),
            "port": str(observer_uri.port())
        }

        sdi_db_params = {
            "dbname": sdi_uri.database(),
            "user": sdi_uri.username(),
            "password": sdi_uri.password(),
            "host": sdi_uri.host(),
            "port": str(sdi_uri.port())
        }
        

        # You can now pass observer_db_params and sdi_db_params to your migration logic
        # run_migration(observer_db_params, sdi_db_params, project_id, feedback)

        # Return the results of the algorithm. In this case our only result is
        # the feature sink which contains the processed features, but some
        # algorithms may return multiple feature sinks, calculated numeric
        # statistics, etc. These should all be included in the returned
        # dictionary, with keys matching the feature corresponding parameter
        # or output names.

        # Call the core logic function run_migration(), with the cleaned-up inputs
        run_migration(observer_db_params, sdi_db_params, project_id, feedback)
        return {'RESULT': 'Migration completed successfully'}


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'RouteLab to SDI Migration'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr(self.name())

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        # return self.tr(self.groupId())
        return self.tr('01 RouteLab Tools')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        # return 'Migration tools'
        return 'rl_tools'
    
    def shortHelpString(self):
        return self.tr("This algorithm migrates field surveys data from Transport for Cairo TfC's RouteLab database to an SDI.")  # later revise this text here    

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return RL2SDIAlgorithm()
    
    def icon(self):
        return QIcon(_icon_path("icons", "RL-icon.svg"))
    # Optional: some QGIS builds prefer this for SVG
    def svgIconPath(self):
        return _icon_path("icons", "RL-icon.svg")
