# -*- coding: utf-8 -*-

"""
/***************************************************************************
 GIS2GTFS
                                 A QGIS plugin
 This plugin turns GIS files to GTFS feed
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-07-02
        copyright            : (C) 2025 by Transport for Cairo
        email                : info@transportforcairo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Transport for Cairo'
__date__ = '2025-07-02'
__copyright__ = '(C) 2025 by Transport for Cairo'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.core import QgsProcessingAlgorithm, QgsApplication
from .gis2gtfs_provider import GIS2GTFSProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class GIS2GTFSPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface # WE ADDED THIS + MODIFIED __init__.py TO FIX THE ERROR OF "Couldn't load plugin 'gis2gtfs' due to an error when calling its classFactory()"

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = GIS2GTFSProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
