# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TerritorialControl
                                 A QGIS plugin
 This plugin is an upgraded version of Territorial Control in QGIS2
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-09-19
        git sha              : $Format:%H$
        github page          : https://github.com/bobyellow/TerrCtrl
        copyright            : (C) 2019 by Ran Tao
        email                : rtao@usf.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
#from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, qVersion
from qgis.PyQt.QtCore import *
#from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import QAction, QFileDialog

from qgis.core import *

# Initialize Qt resources from file resources.py 
from .resources import *
# Import the code for the dialog
from .Territorial_Control_dialog import TerritorialControlDialog
import os.path
import processing
from processing.tools import dataobjects
from qgis.utils import *
import csv
import os, shutil


class TerritorialControl:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'TerritorialControl_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        # Create the dialog (after translation) and keep reference
        self.dlg = TerritorialControlDialog()

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&TerrCtrl')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.addToolBar(u'TerritorialControl')
        self.toolbar.setObjectName(u'TerritorialControl')
        self.dlg.lineEdit.clear()
        #output feature
        self.dlg.lineEdit_2.clear()
        self.dlg.pushButton.clicked.connect(self.select_output_file)
        self.dlg.lineEdit_4.clear()
        self.dlg.pushButton_3.clicked.connect(self.select_extent_file)
        self.dlg.lineEdit_5.clear()
        self.dlg.pushButton_4.clicked.connect(self.select_road_file)
        self.dlg.lineEdit_6.clear()
        self.dlg.pushButton_5.clicked.connect(self.select_artroad_file)
        self.dlg.lineEdit_7.clear()
        self.dlg.pushButton_6.clicked.connect(self.select_railroad_file)
        self.dlg.lineEdit_8.clear()
        self.dlg.pushButton_7.clicked.connect(self.select_enddates_file)
        self.dlg.lineEdit_9.clear()
        self.dlg.pushButton_8.clicked.connect(self.select_hexagon_file)
        self.dlg.lineEdit_10.clear()
        self.dlg.pushButton_9.clicked.connect(self.select_event_file)

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('TerrCtrl', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Territorial_Control/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'TerrCtrl'),
            callback=self.run,
            parent=self.iface.mainWindow())


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&TerrCtrl'),
                action)
            self.iface.removeToolBarIcon(action)
        # remove the toolbar
        del self.toolbar

    def select_output_file(self):
        outputfilename = QFileDialog.getSaveFileName(self.dlg, "Select output file ","", '*.shp')
        self.dlg.lineEdit_2.setText(outputfilename[0])

    def select_extent_file(self):
        extentfilename = QFileDialog.getOpenFileName(self.dlg, "Select extent file ", "", '*.shp')
        self.dlg.lineEdit_4.setText(extentfilename[0])

    def select_road_file(self):
        roadfilename = QFileDialog.getOpenFileName(self.dlg, "Select road file ", "", '*.shp')
        self.dlg.lineEdit_5.setText(roadfilename[0])

    def select_artroad_file(self):
        artroadfilename = QFileDialog.getOpenFileName(self.dlg, "Select artificial road file ", "", '*.shp')
        self.dlg.lineEdit_6.setText(artroadfilename[0])

    def select_railroad_file(self):
        railroadfilename = QFileDialog.getOpenFileName(self.dlg, "Select artificial road file ", "", '*.shp')
        self.dlg.lineEdit_7.setText(railroadfilename[0])

    def select_enddates_file(self):
        enddatesfilename = QFileDialog.getOpenFileName(self.dlg, "Select end dates file", "", '*.csv')
        self.dlg.lineEdit_8.setText(enddatesfilename[0])

    def select_hexagon_file(self):
        hexagonfilename = QFileDialog.getOpenFileName(self.dlg, "Select hexagonal grid cells ", "", '*.shp')
        self.dlg.lineEdit_9.setText(hexagonfilename[0])

    def select_event_file(self):
        eventfilename = QFileDialog.getOpenFileName(self.dlg, "Select event data file ", "", '*.shp')
        self.dlg.lineEdit_10.setText(eventfilename[0])

    def run(self):
        """Run method that performs all the real work"""
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        #traveltime = "1"
        traveltime = self.dlg.lineEdit.text()
        traveltimelist = traveltime.split(',')
        CountTraveltime = len(traveltimelist)
        outputfilename = self.dlg.lineEdit_2.text()
        extentfilename = self.dlg.lineEdit_4.text()
        roadfilename = self.dlg.lineEdit_5.text()
        artroadfilename = self.dlg.lineEdit_6.text()
        railroadfilename = self.dlg.lineEdit_7.text()
        enddatesfilename = self.dlg.lineEdit_8.text()
        hexagonfilename = self.dlg.lineEdit_9.text()
        eventfilename = self.dlg.lineEdit_10.text()
       
        #Option: pre-set all input parameters here so no need to manually input with the GUI
##        traveltime = '1'
##        traveltimelist = traveltime.split(',')
##        CountTraveltime = len(traveltimelist)

##        outputfilename = "C:/Users/bobye/Data For QGIS Plugin/African Countries/Liberia/LiberiaGov_MODEL_Territories_1h.shp"
        outputdir = outputfilename[:-4]
        if(os.path.exists(outputdir)== 0):
            os.mkdir(outputdir)
        
##        extentfilename = "C:/Users/bobye/Data For QGIS Plugin/African Countries/Liberia/country_polygon.shp"
##        roadfilename = "C:/Users/bobye/Data For QGIS Plugin/African Countries/Liberia/road.shp"
##        artroadfilename = "C:/Users/bobye/Data For QGIS Plugin/African Countries/Liberia/artificial_roads.shp"
##        railroadfilename = "C:/Users/bobye/Data For QGIS Plugin/African Countries/Liberia/rail.shp"
##        enddatesfilename = "C:/Users/bobye/Data For QGIS Plugin/African Countries/Liberia/Liberia_MODEL.csv"
##        hexagonfilename = "C:/Users/bobye/Data For QGIS Plugin/African Countries/Liberia/hexagon_grid_5km.shp"
##        eventfilename = "C:/Users/bobye/Data For QGIS Plugin/African Countries/Liberia/LiberiaGov_MODEL_ConflictEvents.shp"

        
        #Get EndData From UI
        #EndDate = self.dlg.lineEdit_3.text()
        ##self.dlg.radioButton.isChecked() = True
        ##self.dlg.radioButton_2.isChecked() = True
        
        
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.

            iface.messageBar().pushMessage("Start running", "this may take a while, please be patient...",level=0,duration = 10)
            paths = []
            #Clip & Merge First
            ArtRoadLayer = QgsVectorLayer(artroadfilename, 'Artifical Road Layer', 'ogr')
            RoadLayer = QgsVectorLayer(roadfilename,'Road Layer','ogr')
            #RailLayer = QgsVectorLayer(railroadfilename, 'Railway Layer', 'ogr')

            
            if (self.dlg.radioButton.isChecked()):
                RailLayer = QgsVectorLayer(railroadfilename, 'Railway Layer', 'ogr')
            
            
            Extentlayer = QgsVectorLayer(extentfilename,'Extentlayer','ogr')
            mycrs = Extentlayer.crs()
            #print("Projection: {}".format(mycrs.description()))
##            QSettings().setValue('/Projections/defaultBehavior', 'useGlobal')  # Use default crs
            QSettings().setValue('/Projections/defaultBehavior', mycrs)  # Use default crs
            QSettings().setValue('Projections/layerDefaultCrs', mycrs)
            #get the rectangular extent of the geographic extent
            extent = Extentlayer.extent()
            xmin = extent.xMinimum()
            xmax = extent.xMaximum()
            ymin = extent.yMinimum()
            ymax = extent.yMaximum()

            extent_str = str(xmin)+','+str(xmax)+','+str(ymin)+','+str(ymax)
            #print extent_str

            Hexagonlayer = QgsVectorLayer(hexagonfilename,'Hexagonlayer','ogr')

            
            eventLayer = QgsVectorLayer(eventfilename, "Event Layer", "ogr")
            ####eventLayerCRS = processing.run('native:assignprojection', {'CRS': 'ProjectCrs','INPUT':eventLayer,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
            ####clipLayer = eventLayerCRS['OUTPUT']
            clipLayer = eventLayer
            QgsProject.instance().addMapLayer(clipLayer, False)



            Clip_ArtRoad=processing.run('native:clip', {'INPUT':artroadfilename,'OVERLAY':extentfilename,'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT})
            Clip_Road=processing.run('native:clip', {'INPUT':roadfilename,'OVERLAY':extentfilename,'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT})
            Clip_Hexagon=processing.run('native:clip', {'INPUT':hexagonfilename,'OVERLAY':extentfilename,'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT})

 
            Clip_ArtRoad_Vec = Clip_ArtRoad['OUTPUT']
            Clip_Road_Vec = Clip_Road['OUTPUT']
            Clip_Hexagon_Vec = Clip_Hexagon['OUTPUT']


            #check if IsoLine temporal result exists or not
            outputfilename_IsoLines = outputfilename[:-4]+ "_IsoLines"+".shp"
            if (os.path.exists(outputfilename_IsoLines)==0):                
                #check if hybrid road temporal result exists or not
                roadFile_indent = 6+len(traveltime) #e.g. xxx_2p5hr.shp -> 9; xxx_2hr.shp ->7
                HybridRdOutputfilename = outputfilename[:-roadFile_indent]+'HybridRoads.shp'
                if (os.path.exists(HybridRdOutputfilename)==0):
                    #Merge clipped networks as a single one
                    # optional: with railway or not
                   
                    if (self.dlg.radioButton.isChecked()): # merge road, railways, and artificial roads
                        Clip_Rail=processing.run('native:clip', {'INPUT':railroadfilename,'OVERLAY':extentfilename,'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT})
                        Clip_Rail_Vec = Clip_Rail['OUTPUT']
                        #Merge_ArtRR=processing.run('saga:mergelayers', [Clip_ArtRoad_Vec,Clip_Road_Vec,Clip_Rail_Vec],True,True,None)
                        Merge_ArtRR=processing.run('saga:mergevectorlayers', {'INPUT':[Clip_ArtRoad_Vec,Clip_Road_Vec,Clip_Rail_Vec],'MATCH':True, 'SRCINFO':True, 'MERGED': QgsProcessing.TEMPORARY_OUTPUT})                    
       
                    else: #only merge road and artificial roads
                        #Merge_ArtRR=processing.run('saga:mergelayers', [Clip_ArtRoad_Vec,Clip_Road_Vec],True,True,None)
                         Merge_ArtRR=processing.run('saga:mergevectorlayers', {'INPUT':[Clip_ArtRoad_Vec,Clip_Road_Vec],'MATCH':True, 'SRCINFO':True, 'MERGED': QgsProcessing.TEMPORARY_OUTPUT})                    
       
                        
                    Merge_ArtRR_Vec = Merge_ArtRR['MERGED']

                    Mergelayer = QgsVectorLayer(Merge_ArtRR_Vec, "Mergelayer", "ogr")
                    #QgsProject.instance().addMapLayer(Mergelayer, False)

                       
                    ### select only speed above zero roads
                    SpeedAboveZero = Mergelayer.getFeatures( QgsFeatureRequest().setFilterExpression (' "Speed" >  0'  ) )
                    Mergelayer.select([ fea.id() for fea in SpeedAboveZero ])
                    MergelayerSel = processing.run('native:saveselectedfeatures', {'INPUT':Mergelayer,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                    MergelayerSelVec = MergelayerSel['OUTPUT']
                    ###

                
                    BreakOutputfilename = outputdir+'/'+'BreakRd.shp'
                    Break_ArtRR = processing.run('grass7:v.clean', {'-b':False,'-c':False,'input':MergelayerSelVec,'GRASS_MIN_AREA_PARAMETER':0.0001,'tool': 0,'GRASS_OUTPUT_TYPE_PARAMETER':2,'GRASS_SNAP_TOLERANCE_PARAMETER':-1,
                                                                                  'type':1,'GRASS_REGION_PARAMETER':MergelayerSelVec,'GRASS_VECTOR_EXPORT_NOCAT':False,'output': BreakOutputfilename,'error':QgsProcessing.TEMPORARY_OUTPUT})



                    #Break_ArtRR_Vec = Break_ArtRR['output']
                    Breaklayer = QgsVectorLayer(BreakOutputfilename, "Breaklayer", "ogr")
                 
                    QgsProject.instance().addMapLayer(Breaklayer, False)

                    #Add field TimeCost and calculate it
                    #This is the very important field as the movement cost: the time (hour) it takes to move 1km on each road segment
                    ##added = processing.run('qgis:addfieldtoattributestable', {'INPUT':BreakOutputfilename,'FIELD_NAME':'TimeCost','FIELD_PRECISION':0,'FIELD_TYPE': 1,'FIELD_LENGTH': 10,'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT})
                    ##added_Vec = added['OUTPUT']

                    calc = processing.run('qgis:fieldcalculator', {'INPUT':Breaklayer,'FIELD_NAME':'TimeCost','FIELD_PRECISION':3,'FIELD_TYPE': 0,'FIELD_LENGTH': 10,
                                                                   'OUTPUT':HybridRdOutputfilename,'FORMULA':'if(Speed = 0, 9999, $length /(1000*Speed))','NEW_FIELD':True})
                    QgsProject.instance().removeMapLayer(Breaklayer)

                # if HybridRdlayer temporal result already exists, jump here use it for later calculations  
                HybridRdlayer = QgsVectorLayer(HybridRdOutputfilename, "HybridRdlayer", "ogr")

                #for Event in GEDselectDateQgs.getFeatures():
                #SelectedFeatures = clipLayer.getFeatures(request)
                TimeID_from0 = 0
                basis = 0
                #Events = processing.features(Layer)
                for Event in clipLayer.getFeatures():
                    ##clipLayer.setSelectedFeatures([TimeID_from0])
                    clipLayer.select(TimeID_from0)
                    clipLayerSel = processing.run('native:saveselectedfeatures', {'INPUT':clipLayer,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                    clipFea = clipLayerSel['OUTPUT']
                    IsoOutputfilename = outputdir+'/'+str(TimeID_from0)+'_Iso.shp'

                    IsoLayer = processing.run("grass7:v.net.iso", {'input':HybridRdlayer, 'points':clipFea, 'threshold': 5000, 'GRASS_OUTPUT_TYPE_PARAMETER': 2, 'center_cats':"1-100000",
                                                 'costs':traveltime, 'arc_column':'TimeCost', 'arc_backward_column':None, 'node_column':None, 'GRASS_VECTOR_EXPORT_NOCAT': False,'GRASS_REGION_PARAMETER':HybridRdlayer,
                                                                   'GRASS_SNAP_TOLERANCE_PARAMETER':-1, 'GRASS_MIN_AREA_PARAMETER': 0.0001, 'output': IsoOutputfilename})
    
                    IsoFeature = IsoLayer['output']  #get features from the SA layer in memory
                    
                    IsoFeaLayer = QgsVectorLayer(IsoOutputfilename, "IsoFeaLayer", "ogr")

                    QgsProject.instance().addMapLayer(IsoFeaLayer, False)
                   
                    ##IsoFeatureDis=processing.run('saga:linedissolve', IsoFeature,'cat','cat','cat',0,None)
                    IsoFeatureDis=processing.run('saga:linedissolve', {'LINES':IsoOutputfilename,'FIELD_1': 'cat','FIELD_2': 'cat','FIELD_3': 'cat','ALL': 0,'DISSOLVED': QgsProcessing.TEMPORARY_OUTPUT})
                    #IsoFeatureDis
                    #IsoFeatureDissolved
                    IsoFeatureDisFea = IsoFeatureDis['DISSOLVED']  #return a shapefile in temp file
                    
                    #convert Dissolved feature as QgsVectorLayer
                    IsoQgsDis = QgsVectorLayer(IsoFeatureDisFea,'IsoQgsDis','ogr')


                    #extract only the cat=1, and discard cat = null or above 1
                    IsoDisExtract = processing.run('native:extractbyattribute', {'FIELD': 'cat','INPUT':IsoQgsDis,'OPERATOR': 5,'VALUE': '1','OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                    IsoDisExtractQgs = IsoDisExtract['OUTPUT'] #return a QgsVectorLayer
                    #IsoQgsDisExtractLayer = QgsVectorLayer(IsoDisExtractFea,'IsoDisExtractLayer','ogr')


                    ##IsoDP = IsoQgsDis.dataProvider()
                    IsoDP = IsoDisExtractQgs.dataProvider()

                    ##Delete the largest cat
                    ##IsoDP.deleteFeatures([CountTraveltime])

                    #Delete the two redundant cat fields as result of dissolve lines
                    IsoDP.deleteAttributes([1,2])
                    IsoQgsDis.updateFields()

                    #Add field of travel time
                    #IsoDP.addAttributes([QgsField("TravelTime", QVariant.String)])
                    #IsoQgsDis.updateFields()
                    #Add field of current GED TimeID
                    IsoDP.addAttributes([QgsField("TimeID", QVariant.Int)])
                    IsoQgsDis.updateFields()

                    #Write attributes of travel time and TimeID
                    IsoFe = IsoDisExtractQgs.getFeatures()
                    IsoDisExtractQgs.startEditing()
                    TimeID = Event['TimeID']
                    #TimeID123 = TimeID_from0 
                    #TimeID123 = Event.id() + 1
                    for feature in IsoFe:
                        #IsoQgsDis.changeAttributeValue(feature.id(), 1, traveltimelist[feature.id()])
                        IsoDisExtractQgs.changeAttributeValue(feature.id(), 1, TimeID)
                    IsoDisExtractQgs.commitChanges()
                    #IsoQgsDis.updateFields()
                    
                    #if TimeID_from0 == 0: #the first (earliest) one as the basis
                    if TimeID_from0 == 0 and basis == 0: #the first (earliest) one as the basis
                        IsoQgsDisAll = IsoDisExtractQgs
                        #IsoQgsDisAll = QgsVectorLayer(IsoQgsDis.source(), IsoQgsDis.name(), IsoQgsDis.providerType())
                        IsoDPAll = IsoQgsDisAll.dataProvider()
                        basis = basis + 1
                        #print 'create Iso for TimeID = 0'
                    #IsoQgsDisAll.startEditing()
                    #Add features
                    IsoFe = IsoDisExtractQgs.getFeatures()
                    IsoQgsDisAll.startEditing()

                    if TimeID_from0 > 0:
                        for feature2 in IsoFe:
                            IsoDPAll.addFeatures([feature2])
                            #print 'add feature2'
                            IsoQgsDisAll.updateExtents()
                    TimeID_from0 = TimeID_from0 +1

                    clipLayer.removeSelection()

                    #delete temporary result
                    #QgsProject.instance().removeMapLayer(IsoFeaLayer.id())
                    QgsProject.instance().removeMapLayer(IsoFeaLayer)
                    
                #GEDselectDateQgs.removeSelection()
                clipLayer.removeSelection()

                # a great way to debug is to print out the intermediate result layers
                outputfilename_IsoLines = outputfilename[:-4]+ "_IsoLines"+".shp"
                writer = QgsVectorFileWriter.writeAsVectorFormat(IsoQgsDisAll,outputfilename_IsoLines,"utf-8",mycrs,"ESRI Shapefile")            
                del writer

               
               
                paths.append(outputdir)

                ### #delete temporal files in the folder that are no more useful
                for folder in paths:
                    for the_file in os.listdir(folder):
                        file_path = os.path.join(folder, the_file)
                        try:
                            if os.path.isfile(file_path):
                                os.unlink(file_path)
                        except Exception as e:
                            print(e)
                            iface.messageBar().pushMessage("warning", "some temporal files in the subdirectory of output cannot be deleted. You can mannually delete them later.",level=1,duration = 10)

                            

            # if IsoLine temporal result already exists, jump here use it for later calculations
            IsoDisAllLayer = QgsVectorLayer(outputfilename_IsoLines, "Iso_Network", "ogr")
          
            #assign CRS to the project CRS
            IsoDisAllLayer_crs = processing.run('native:assignprojection', {'CRS': mycrs,'INPUT':IsoDisAllLayer,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
            IsoDisAllLayer_crs_VEC = IsoDisAllLayer_crs['OUTPUT']
            ##IsoDisAllLayer_crsQgs = QgsVectorLayer(IsoDisAllLayer_crs_VEC, "Iso_Network_CRS", "ogr")

            
            #Join the GED information with TimeID
            ##IsoQgsDisAll_GED = processing.run('qgis:joinattributestable', IsoQgsDisAll, clipLayer,'TimeID','TimeID',None)
            ##IsoQgsDisAll_GED_Vec = IsoQgsDisAll_GED['OUTPUT_LAYER']

            IsoQgsDisAll_GED = processing.run('native:joinattributestable', {'INPUT': IsoDisAllLayer_crs_VEC, 'INPUT_2':clipLayer,'FIELD':'TimeID','FIELD_2': 'TimeID', 'FIELDS_TO_COPY': '',
                                                                             'DISCARD_NONMATCHING': True,'METHOD': 1,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
            SAlayer =  IsoQgsDisAll_GED['OUTPUT'] #return a QgsVectorLayer

            QgsProject.instance().addMapLayer(SAlayer,False)
            
            #print('-4')
            
            if (self.dlg.radioButton_2.isChecked()):
                enddate_list = []
                with open(enddatesfilename, 'r') as datefile:
                    reader = csv.reader(datefile)
                    ##enddate_list = list(reader)
                    for row in reader:
                        enddate = row[0]
                        enddate_list.append(enddate)

                for i in  range(0,len(enddate_list)):
                    #paths = []
                    paths.append(outputdir)
                    ##enddate = int(enddate_list[i][0])
                    enddate = int(enddate_list[i])
                    outputfilename_enddate = outputdir + "_" + enddate_list[i]+".shp"
                    Hex_SA_Qgs_containGED_Outputfilename = outputdir+'/'+'Hex_SA_Qgs_containGED.'+ "_" + enddate_list[i]+".shp"
                    #Raterozatoion to solve overlap
                    #Rasterize SA lines with TimeID, use the maximal TimeID as raster value means to use the latest events to update the previous
                    #SAlayer = QgsVectorLayer(Url,'SAlayer','ogr')

                    #SAlayer = iface.addVectorLayer(reachablenetworkfilename, "SAlayer", "ogr")
                    it = SAlayer.getFeatures( QgsFeatureRequest().setFilterExpression (' "Date_int" <= \'%s\'  ' %enddate ) )
                    #it = SAlayer.getFeatures( QgsFeatureRequest().setFilterExpression (' "TimeID" <= \'%s\'  ' %enddate ) )

                    #print("enddate")
                    print(enddate)

                    # Set the selection
                    ##SAlayer.setSelectedFeatures( [ fea.id() for fea in it ] )

                    SAlayer.select([ fea.id() for fea in it ])
                    SAlayerSel = processing.run('native:saveselectedfeatures', {'INPUT':SAlayer,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                    SAFea = SAlayerSel['OUTPUT']

 
                   
                    SAtoRas=processing.run('gdal:rasterize', {'INPUT': SAFea,'BURN': 0,'FIELD': 'TimeID','HEIGHT':100,'WIDTH': 100,
                                                             'EXTENT':SAFea,'INVERT':False,'DATA_TYPE': 5,'NODATA': 0,'UNITS': 1,'INIT': None,'OPTIONS': '','OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                   
                                       
                    ########### from this line below is almost the same as the "else" section  ###################
                    ##############################################################################################

                    SAtoRas_raster = SAtoRas['OUTPUT']

                    #Polygonize (vectorize) and keep TimeID
                    #SA_RastoPoly = processing.runAndLoadResults('gdalogr:polygonize', SAtoRas_raster,'TimeID',None)
                    ##SA_RastoPoly = processing.run('gdalogr:polygonize', SAtoRas_raster,'TimeID',None)
##                    SA_RastoPoly = processing.run('gdal:polygonize', {'INPUT':SAtoRas_raster,'BAND': 1,'EIGHT_CONNECTEDNESS': False,'FIELD': 'TimeID','OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})

                    try:
                        SA_RastoPoly = processing.run('gdal:polygonize', {'INPUT':SAtoRas_raster,'BAND': 1,'EIGHT_CONNECTEDNESS': False,'FIELD': 'TimeID','OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                    except:
                        print("error: no proper intermediate results to polygonize regarding the selected events")
                        continue

                      
                    #print SA_RastoPoly
                    ##SA_RastoPoly = processing.run('gdalogr:polygonize', SAtoRas_raster,'TimeID',path+'/SA_RastoPoly.shp')
                    #SA_RastoPoly_Dis_Vec = SA_RastoPoly_Dis['OUTPUT_LAYER']
                    SA_RastoPoly_Dis_Vec = SA_RastoPoly['OUTPUT']
                    layer2 = QgsVectorLayer(SA_RastoPoly_Dis_Vec, "lyr2", "ogr")

                    ##QgsMapLayerRegistry.instance().addMapLayer(layer2)
                    layer2_crs = processing.run('native:assignprojection', {'CRS': mycrs,'INPUT':layer2,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                    layer2_crs_VEC = layer2_crs['OUTPUT']

                    #QgsProject.instance().addMapLayer(layer2_crs_VEC)
                          
                    #Spatial Join with hexagons
                    #Hexagon_1km = QgsVectorLayer('Z:\\projects\\Minerva\\Africa\\FinalBuffer\\QGIS\\Angola_testHex1km.shp','SAlayer','ogr')
                    #Hex_SJ_SA = processing.runAndLoadResults('qgis:joinattributesbylocation', Hexagon_1km, SA_RastoPoly_Dis_Vec,['intersects'],0.0,0,'sum,mean,min,max,median',0,None)
                    context = dataobjects.createContext()
                    context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
                    Hex_SJ_SA = processing.run('qgis:joinattributesbylocation', {'DISCARD_NONMATCHING': True,'INPUT':Clip_Hexagon_Vec, 'JOIN':layer2_crs_VEC,'JOIN_FIELDS': '','METHOD': 1,'PREDICATE': [0],'PREFIX':'','OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},context=context)
                    Hex_SJ_SA_Vec = Hex_SJ_SA['OUTPUT']
                    
                    ##Hex_SJ_SA_path = Hex_SJ_SA_Vec[:-11]
                    ##paths.append(Hex_SJ_SA_path)
                    ##layer3 = QgsVectorLayer(Hex_SJ_SA_path + '/OUTPUT.shp', "lyr3", "ogr")
                    ##QgsMapLayerRegistry.instance().addMapLayer(layer3)
                    

                    Hex_TimeID = processing.run('native:dissolve',{'FIELD': 'TimeID','INPUT':Hex_SJ_SA_Vec, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})                
                    ##Hex_TimeID = processing.run('gdalogr:dissolvepolygons', Hex_SJ_SA_Vec,'geometry','TimeID',False,False,False,False,False,None,None,None)
                    ##Hex_TimeID = processing.run('gdalogr:dissolvepolygons', Hex_SJ_SA_Vec,'geometry','TimeID',False,False,False,False,False,None,None,path+'/Hex_TimeID.shp')
                    ##Hex_Smooth_Vec = Hex_TimeID['OUTPUT_LAYER']
                    Hex_Smooth_Vec = Hex_TimeID['OUTPUT']
                    ##Hex_TimeID_path = Hex_Smooth_Vec[:-16]
                    ##paths.append(Hex_TimeID_path)
                    ##layer4 = QgsVectorLayer(Hex_TimeID_path + '/OUTPUTLAYER.shp', "lyr4", "ogr")
                    ##QgsMapLayerRegistry.instance().addMapLayer(layer4)
                    layer4 = Hex_Smooth_Vec

                    
                    ##QgsProject.instance().addMapLayer(layer4_crs_VEC)
                   
                    #Join the GED information with TimeID
                    ##Hex_SA = processing.run('qgis:joinattributestable', Hex_Smooth_Vec, clipLayer,'TimeID','TimeID',None)
                    ##Hex_SA_Vec = Hex_SA['OUTPUT_LAYER']
                    ##Hex_SA_Qgs = QgsVectorLayer(Hex_SA_Vec,'Hex_SA_Qgs','ogr')
                    ###Hex_SA_Qgs = QgsVectorLayer(Hex_Smooth_Vec,'Hex_SA_Qgs','ogr')

                    # to solve error small territories or territories whose starting point (event location) has been occupied by later territories
                    # use contain_event_or_not to determine to keep or not
                    ##Hex_SA_Qgs_containGED = processing.run('grass7:v.select',layer4,0,clipLayer,2,7,False,extent_str,-1.0,0.0001,0,None)

                    #####Hex_SA_Qgs_containGED_Outputfilename = outputdir+'/'+'Hex_SA_Qgs_containGED.shp'
                    Hex_SA_Qgs_containGED = processing.run('grass7:v.select',{'-c': False,'-r': False,'-t': False,'GRASS_MIN_AREA_PARAMETER': 0.0001,'GRASS_OUTPUT_TYPE_PARAMETER': 3,
                                                           'GRASS_REGION_PARAMETER': layer4,'GRASS_SNAP_TOLERANCE_PARAMETER': -1,'GRASS_VECTOR_DSCO': '','GRASS_VECTOR_EXPORT_NOCAT': False,
                                                           'GRASS_VECTOR_LCO': '','ainput':layer4,'atype': [4],'binput':clipLayer,'btype': [0],'operator': 7,'output': Hex_SA_Qgs_containGED_Outputfilename})
                    ##Hex_SA_Qgs_containGED =    processing.run('grass7:v.select',Hex_SA_Qgs,0,clipLayer,2,7,False,extent_str,-1.0,0.0001,0,path+'/Hex_SA_Qgs_containGED.shp')
                    Hex_SA_Qgs_containGED_Vec = Hex_SA_Qgs_containGED['output']
                    ##Hex_SA_Qgs_containGED_path = Hex_SA_Qgs_containGED_Vec[:-11]
                    ##paths.append(Hex_SA_Qgs_containGED_path)
                    #layer5 = QgsVectorLayer(Hex_SA_Qgs_containGED_path + '/output.shp', "lyr5", "ogr")
                    layer5 = QgsVectorLayer(Hex_SA_Qgs_containGED_Outputfilename, "lyr5", "ogr")
                    ##QgsProject.instance().addMapLayer(layer5)
                    QgsProject.instance().addMapLayer(layer5, False)

                    ##QgsProject.instance().addMapLayer(layer5_crs_VEC)
                    

                    #Dissolve joined hexagon by TimeID to form multipart polygons

##                    Hex_SA_Qgs_containGED_Dis = processing.run('native:dissolve',{'FIELD': 'TimeID','INPUT':layer5, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                    try:
                        Hex_SA_Qgs_containGED_Dis = processing.run('native:dissolve',{'FIELD': 'TimeID','INPUT':layer5, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                    except:
                        print("error: no proper intermediate results to dissolve regarding the selected events")
                        continue
                    
                    ##Hex_SA_Qgs_containGED_Dis = processing.run('gdalogr:dissolvepolygons', Hex_SA_Qgs_containGED_Vec,'geometry','TimeID',True,False,False,False,False,None,None,path+'/Hex_SA_Qgs_containGED_Dis.shp')
                    Hex_SA_Qgs_containGED_Dis_Vec = Hex_SA_Qgs_containGED_Dis['OUTPUT']
                    layer6 = Hex_SA_Qgs_containGED_Dis_Vec
                    ##QgsProject.instance().addMapLayer(layer6)
                    ##Hex_SA_Qgs_containGED_Dis_path = Hex_SA_Qgs_containGED_Dis_Vec[:-16]
                    ##paths.append(Hex_SA_Qgs_containGED_Dis_path)
                    ##layer6 = QgsVectorLayer(Hex_SA_Qgs_containGED_Dis_path + '/OUTPUTLAYER.shp', "lyr6", "ogr")
                    ##QgsMapLayerRegistry.instance().addMapLayer(layer6)

                   ##QgsProject.instance().addMapLayer(layer6_crs_VEC)

                    
                    #A much easier way to add field of travel time
                    #processing.load(calc['OUTPUT_LAYER'])

                    calc_traveltime = processing.run('qgis:fieldcalculator', {'INPUT':layer6,'FIELD_NAME':'TravelTime','FIELD_PRECISION':2,'FIELD_TYPE': 0,'FIELD_LENGTH': 10,
                                                                   'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT,'FORMULA':traveltime,'NEW_FIELD': True})
                    calc_traveltime_vec = calc_traveltime['OUTPUT']

                    calc_Area = processing.run('qgis:fieldcalculator', {'INPUT':calc_traveltime_vec,'FIELD_NAME':'Area','FIELD_PRECISION':2,'FIELD_TYPE': 0,'FIELD_LENGTH': 10,
                                                                  'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT,'FORMULA':'$area','NEW_FIELD': True})
                    calc_Area_Vec = calc_Area['OUTPUT']

                    Final_Join = processing.run('native:joinattributestable', {'INPUT': calc_Area_Vec, 'INPUT_2':clipLayer,'FIELD':'TimeID','FIELD_2': 'TimeID', 'FIELDS_TO_COPY': '',
                                                                                 'DISCARD_NONMATCHING': True,'METHOD': 1,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                    
                    ##Final_Join = processing.run('qgis:joinattributestable', calc_Area_Vec, clipLayer,'TimeID','TimeID',path+'/Final_Join.shp')
                    Final_Vec = Final_Join['OUTPUT']
                    ##Final_path = Final_Vec[:-16]
                    ##paths.append(Final_path)
                    
                    #Convert Dissolved feature as QgsVectorLayer
                    ##Final_Qgs = QgsVectorLayer(Final_Vec,'Final_Qgs','ogr')

##                    QgsProject.instance().addMapLayer(Final_Vec)

                 
                    Final_Vec_crs = processing.run('native:assignprojection', {'CRS': mycrs,'INPUT':Final_Vec,'OUTPUT': outputfilename_enddate}) #save to outputfile name so no need to use writer later

                    ####Final_Vec_crs = processing.run('native:assignprojection', {'CRS': 'ProjectCrs','INPUT':Final_Vec,'OUTPUT': outputfilename_enddate})

                    QgsProject.instance().removeMapLayer(layer5)
                                                                    
                    SAlayer.removeSelection()
                    #print('-3')


            else:
                #paths = []
                paths.append(outputdir)
                ##SAtoRas = processing.run('saga:shapestogrid', SAlayer, 'TimeID', 2, 3, 1, 0, 3, extent_str, 100.0, 0, None)
                ##SAtoRas=processing.run('saga:shapestogrid', SAlayer,'TimeID',3,1,3,extent_str,100.0,None)
                ##path = 'D:/Dropbox/Territorial Control/tmp2'
                ##SAtoRas=processing.run('saga:shapestogrid', SAlayer,'TimeID',3,1,3,extent_str,100.0,path+'/SA_to_Ras.sdat')
                ##SAtoRas_raster = SAtoRas['GRID']
                ##SAtoRas_raster = SAtoRas['USER_GRID']
                ##SAtoRas=processing.run('gdalogr:rasterize', SAlayer,'TimeID',1,100.0,100.0,extent_str,False,5,'0',4,75.0,6.0,1.0,False,0,None,None)
##                SAtoRas=processing.runAndLoadResults('gdal:rasterize', {'INPUT': SAlayer,'BURN': 0,'FIELD': 'TimeID','HEIGHT':100,'WIDTH': 100,
##                                                             'EXTENT':SAlayer,'INVERT':False,'DATA_TYPE': 5,'NODATA': 0,'UNITS': 1,'INIT': None,'OPTIONS': '','OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})

                SAtoRas=processing.run('gdal:rasterize', {'INPUT': SAlayer,'BURN': 0,'FIELD': 'TimeID','HEIGHT':100,'WIDTH': 100,
                                                             'EXTENT': SAlayer,'INVERT':False,'DATA_TYPE': 5,'NODATA': 0,'UNITS': 1,'INIT': None,'OPTIONS': '','OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})


               
                SAtoRas_raster = SAtoRas['OUTPUT']

                #Polygonize (vectorize) and keep TimeID
                #SA_RastoPoly = processing.runAndLoadResults('gdalogr:polygonize', SAtoRas_raster,'TimeID',None)
                ##SA_RastoPoly = processing.run('gdalogr:polygonize', SAtoRas_raster,'TimeID',None)
                SA_RastoPoly = processing.run('gdal:polygonize', {'INPUT':SAtoRas_raster,'BAND': 1,'EIGHT_CONNECTEDNESS': False,'FIELD': 'TimeID','OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                #print SA_RastoPoly
                ##SA_RastoPoly = processing.run('gdalogr:polygonize', SAtoRas_raster,'TimeID',path+'/SA_RastoPoly.shp')
                #SA_RastoPoly_Dis_Vec = SA_RastoPoly_Dis['OUTPUT_LAYER']
                SA_RastoPoly_Dis_Vec = SA_RastoPoly['OUTPUT']
                layer2 = QgsVectorLayer(SA_RastoPoly_Dis_Vec, "lyr2", "ogr")

                ##QgsMapLayerRegistry.instance().addMapLayer(layer2)


                layer2_crs = processing.run('native:assignprojection', {'CRS': mycrs,'INPUT':layer2,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                layer2_crs_VEC = layer2_crs['OUTPUT']


                #QgsProject.instance().addMapLayer(layer2_crs_VEC)
                      
                #Spatial Join with hexagons
                #Hexagon_1km = QgsVectorLayer('Z:\\projects\\Minerva\\Africa\\FinalBuffer\\QGIS\\Angola_testHex1km.shp','SAlayer','ogr')
                #Hex_SJ_SA = processing.runAndLoadResults('qgis:joinattributesbylocation', Hexagon_1km, SA_RastoPoly_Dis_Vec,['intersects'],0.0,0,'sum,mean,min,max,median',0,None)
                context = dataobjects.createContext()
                context.setInvalidGeometryCheck(QgsFeatureRequest.GeometryNoCheck)
                Hex_SJ_SA = processing.run('qgis:joinattributesbylocation', {'DISCARD_NONMATCHING': True,'INPUT':Clip_Hexagon_Vec, 'JOIN':layer2_crs_VEC,'JOIN_FIELDS': '','METHOD': 1,'PREDICATE': [0],'PREFIX':'','OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},context=context)
                Hex_SJ_SA_Vec = Hex_SJ_SA['OUTPUT']
                
                ##Hex_SJ_SA_path = Hex_SJ_SA_Vec[:-11]
                ##paths.append(Hex_SJ_SA_path)
                ##layer3 = QgsVectorLayer(Hex_SJ_SA_path + '/OUTPUT.shp', "lyr3", "ogr")
                ##QgsMapLayerRegistry.instance().addMapLayer(layer3)
                

                #Dissolve joined hexagon by TimeID
                #Hex_TimeID = processing.runAndLoadResults('gdalogr:dissolvepolygons', Hex_SJ_SA_Vec,'geometry','TimeID',False,False,False,False,False,None,None,None)
##                Hex_TimeID = processing.runAndLoadResults('gdal:dissolve', {'INPUT': Hex_SJ_SA_Vec,'COMPUTE_AREA': False,'COMPUTE_STATISTICS': False,'COUNT_FEATURES': False,'EXPLODE_COLLECTIONS': False,'FIELD': 'TimeID',
##                                                                      'GEOMETRY': 'geometry','KEEP_ATTRIBUTES': False,'OPTIONS': '','STATISTICS_ATTRIBUTE': None,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})

                Hex_TimeID = processing.run('native:dissolve',{'FIELD': 'TimeID','INPUT':Hex_SJ_SA_Vec, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})                
                ##Hex_TimeID = processing.run('gdalogr:dissolvepolygons', Hex_SJ_SA_Vec,'geometry','TimeID',False,False,False,False,False,None,None,None)
                ##Hex_TimeID = processing.run('gdalogr:dissolvepolygons', Hex_SJ_SA_Vec,'geometry','TimeID',False,False,False,False,False,None,None,path+'/Hex_TimeID.shp')
                ##Hex_Smooth_Vec = Hex_TimeID['OUTPUT_LAYER']
                Hex_Smooth_Vec = Hex_TimeID['OUTPUT']
                ##Hex_TimeID_path = Hex_Smooth_Vec[:-16]
                ##paths.append(Hex_TimeID_path)
                ##layer4 = QgsVectorLayer(Hex_TimeID_path + '/OUTPUTLAYER.shp', "lyr4", "ogr")
                ##QgsMapLayerRegistry.instance().addMapLayer(layer4)
##                layer4 = QgsVectorLayer(Hex_Smooth_Vec, "lyr4", "ogr")
                layer4 = Hex_Smooth_Vec

##                layer4_crs = processing.run('native:assignprojection', {'CRS': 'ProjectCrs','INPUT':layer4,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
##                layer4_crs_VEC = layer4_crs['OUTPUT']
                
                ##QgsProject.instance().addMapLayer(layer4_crs_VEC)
               
                #Join the GED information with TimeID
                ##Hex_SA = processing.run('qgis:joinattributestable', Hex_Smooth_Vec, clipLayer,'TimeID','TimeID',None)
                ##Hex_SA_Vec = Hex_SA['OUTPUT_LAYER']
                ##Hex_SA_Qgs = QgsVectorLayer(Hex_SA_Vec,'Hex_SA_Qgs','ogr')
                ###Hex_SA_Qgs = QgsVectorLayer(Hex_Smooth_Vec,'Hex_SA_Qgs','ogr')

                # to solve error small territories or territories whose starting point (event location) has been occupied by later territories
                # use contain_event_or_not to determine to keep or not
                ##Hex_SA_Qgs_containGED = processing.run('grass7:v.select',layer4,0,clipLayer,2,7,False,extent_str,-1.0,0.0001,0,None)
                Hex_SA_Qgs_containGED_Outputfilename = outputdir+'/'+'Hex_SA_Qgs_containGED.shp'
                Hex_SA_Qgs_containGED = processing.run('grass7:v.select',{'-c': False,'-r': False,'-t': False,'GRASS_MIN_AREA_PARAMETER': 0.0001,'GRASS_OUTPUT_TYPE_PARAMETER': 3,
                                                       'GRASS_REGION_PARAMETER': layer4,'GRASS_SNAP_TOLERANCE_PARAMETER': -1,'GRASS_VECTOR_DSCO': '','GRASS_VECTOR_EXPORT_NOCAT': False,
                                                       'GRASS_VECTOR_LCO': '','ainput':layer4,'atype': [4],'binput':clipLayer,'btype': [0],'operator': 7,'output': Hex_SA_Qgs_containGED_Outputfilename})
                ##Hex_SA_Qgs_containGED =    processing.run('grass7:v.select',Hex_SA_Qgs,0,clipLayer,2,7,False,extent_str,-1.0,0.0001,0,path+'/Hex_SA_Qgs_containGED.shp')
                Hex_SA_Qgs_containGED_Vec = Hex_SA_Qgs_containGED['output']
                ##Hex_SA_Qgs_containGED_path = Hex_SA_Qgs_containGED_Vec[:-11]
                ##paths.append(Hex_SA_Qgs_containGED_path)
                #layer5 = QgsVectorLayer(Hex_SA_Qgs_containGED_path + '/output.shp', "lyr5", "ogr")
                layer5 = QgsVectorLayer(Hex_SA_Qgs_containGED_Outputfilename, "lyr5", "ogr")
                ##QgsProject.instance().addMapLayer(layer5)
                QgsProject.instance().addMapLayer(layer5, False)

##                layer5_crs = processing.run('native:assignprojection', {'CRS': 'ProjectCrs','INPUT':layer5,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
##                layer5_crs_VEC = layer5_crs['OUTPUT']
                
                ##QgsProject.instance().addMapLayer(layer5_crs_VEC)
                

                #Dissolve joined hexagon by TimeID to form multipart polygons
##                Hex_SA_Qgs_containGED_Dis = processing.runAndLoadResults('gdal:dissolve', {'INPUT': layer5,'COMPUTE_AREA': False,'COMPUTE_STATISTICS': False,'COUNT_FEATURES': False,'EXPLODE_COLLECTIONS': False,'FIELD': 'TimeID',
##                                                                      'GEOMETRY': 'geometry','KEEP_ATTRIBUTES': False,'OPTIONS': '','STATISTICS_ATTRIBUTE': None,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})

                Hex_SA_Qgs_containGED_Dis = processing.run('native:dissolve',{'FIELD': 'TimeID','INPUT':layer5, 'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})                
                ##Hex_SA_Qgs_containGED_Dis = processing.run('gdalogr:dissolvepolygons', Hex_SA_Qgs_containGED_Vec,'geometry','TimeID',True,False,False,False,False,None,None,path+'/Hex_SA_Qgs_containGED_Dis.shp')
                Hex_SA_Qgs_containGED_Dis_Vec = Hex_SA_Qgs_containGED_Dis['OUTPUT']
##                layer6 = QgsVectorLayer(Hex_SA_Qgs_containGED_Dis_Vec, "lyr6", "ogr")
                layer6 = Hex_SA_Qgs_containGED_Dis_Vec
                ##QgsProject.instance().addMapLayer(layer6)
                ##Hex_SA_Qgs_containGED_Dis_path = Hex_SA_Qgs_containGED_Dis_Vec[:-16]
                ##paths.append(Hex_SA_Qgs_containGED_Dis_path)
                ##layer6 = QgsVectorLayer(Hex_SA_Qgs_containGED_Dis_path + '/OUTPUTLAYER.shp', "lyr6", "ogr")
                ##QgsMapLayerRegistry.instance().addMapLayer(layer6)

##                layer6_crs = processing.run('native:assignprojection', {'CRS': 'ProjectCrs','INPUT':layer6,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
##                layer6_crs_VEC = layer6_crs['OUTPUT']
                ##QgsProject.instance().addMapLayer(layer6_crs_VEC)
                calc_traveltime = processing.run('qgis:fieldcalculator', {'INPUT':layer6,'FIELD_NAME':'TravelTime','FIELD_PRECISION':2,'FIELD_TYPE': 0,'FIELD_LENGTH': 10,
                                                               'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT,'FORMULA':traveltime,'NEW_FIELD': True})
                calc_traveltime_vec = calc_traveltime['OUTPUT']
               
                ##calc_Area = processing.run('qgis:fieldcalculator', add_Area_vec,'Area',0,10.0,2.0,False,'$area',None)
                calc_Area = processing.run('qgis:fieldcalculator', {'INPUT':calc_traveltime_vec,'FIELD_NAME':'Area','FIELD_PRECISION':2,'FIELD_TYPE': 0,'FIELD_LENGTH': 10,
                                                              'OUTPUT':QgsProcessing.TEMPORARY_OUTPUT,'FORMULA':'$area','NEW_FIELD': True})
                calc_Area_Vec = calc_Area['OUTPUT']

                ##Final_Join = processing.run('qgis:joinattributestable', calc_Area_Vec, clipLayer,'TimeID','TimeID',None)
                Final_Join = processing.run('native:joinattributestable', {'INPUT': calc_Area_Vec, 'INPUT_2':clipLayer,'FIELD':'TimeID','FIELD_2': 'TimeID', 'FIELDS_TO_COPY': '',
                                                                             'DISCARD_NONMATCHING': True,'METHOD': 1,'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT})
                
                ##Final_Join = processing.run('qgis:joinattributestable', calc_Area_Vec, clipLayer,'TimeID','TimeID',path+'/Final_Join.shp')
                Final_Vec = Final_Join['OUTPUT']
                ##Final_path = Final_Vec[:-16]
                ##paths.append(Final_path)
               
                Final_Vec_crs = processing.run('native:assignprojection', {'CRS': mycrs,'INPUT':Final_Vec,'OUTPUT': outputfilename}) #save to outputfile name so no need to use writer later

                QgsProject.instance().removeMapLayer(layer5)


            #delete temporal files in the folder that are no more useful
            for folder in paths:
                    for the_file in os.listdir(folder):
                        file_path = os.path.join(folder, the_file)
                        try:
                            if os.path.isfile(file_path):
                                os.unlink(file_path)
                        except Exception as e:
                            print(e)
                            iface.messageBar().pushMessage("warning", "some temporal files in the subdirectory of output cannot be deleted. Please mannually delete them later.",level=1,duration = 10)
            #print('end')
            iface.messageBar().pushMessage("Finish", "please find the results in the output directory",level=3,duration =0)


