# -*- coding: utf-8 -*-

"""
/***************************************************************************
 TerrainZones
                                 A QGIS plugin
 Used to Determine the Area within the Region of influence of a Selected Sub-Irrigation Zones
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-11-12
        copyright            : (C) 2023 by FALASY Anamelechi
        email                : fvw.services@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'FALASY Anamelechi'
__date__ = '2025-11-12'
__copyright__ = '(C) 2023 by FALASY Anamelechi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import processing
import os, math
import inspect
import time
import qgis.utils
import numpy as np

from qgis.gui import *
from osgeo import gdal
from PyQt5 import QtWidgets
from osgeo import gdalnumeric
from collections import Counter
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QCoreApplication, QVariant, QObject
from processing.algs.qgis.QgisAlgorithm import QgisAlgorithm
from qgis.analysis import QgsRasterCalculator, QgsRasterCalculatorEntry

from qgis.core import QgsCategorizedSymbolRenderer, QgsSymbol, QgsRendererCategory, QgsFillSymbol, QgsLineSymbol
from PyQt5.QtGui import QColor

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFolderDestination
from qgis.core import QgsProcessingParameterFileDestination
from qgis.core import QgsProcessingParameterVectorDestination
from qgis.core import QgsProcessingParameterExtent
from qgis.core import QgsProcessingParameterEnum
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterPoint
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterCrs
from qgis.core import QgsCoordinateReferenceSystem
from qgis.core import QgsFeatureSink
from qgis.core import QgsProcessingOutputVectorLayer
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsFeatureRequest
from qgis.core import QgsVectorLayer
from qgis.core import QgsLineSymbol
from qgis.core import QgsProperty

from qgis.core import QgsProcessingParameterBand

from qgis.core import QgsProcessingFeatureSourceDefinition

from qgis.core import QgsProcessingException
from qgis.core import QgsProcessingOutputNumber
from qgis.core import QgsProcessingParameterDistance
from qgis import processing

from qgis.core import QgsProcessingParameterString
from qgis.core import QgsProcessingLayerPostProcessorInterface
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingParameterExpression

from qgis.core import (edit,QgsField, QgsFeature, QgsPointXY, QgsWkbTypes, QgsGeometry, QgsFields)

class InfluenceRegionAlgorithm(QgsProcessingAlgorithm):
    
    SPACING_KEY = 'SPACING_KEY'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return InfluenceRegionAlgorithm()
        
    def name(self):        
        return '2. Region of Influence'

    def displayName(self):        
        return self.tr(self.name())

    def group(self):        
        return self.tr(self.groupId())

    def groupId(self):        
        return ''
        
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon
        
    def shortHelpString(self):
        return self.tr("""This Tool uses a zone map from Terrain Zone and a tile system to determine the area within the region of influence of the tile system that is within the selected zone elevation interval.
        
        Workflow: 
        1. Select a Terrain Zone Vector Layer
        2. Select a Tile Network Line Layer
        3. Specify Drainpipe Spacing in the Tile Layout          
        4. Save the output files (optional)
        5. Click on \"Run\"
        
        The script will gives out two outputs.         
                
        The help link in the Graphical User Interface (GUI) provides more information about the plugin.             
        """)    
        
    def helpUrl(self):         
        return "https://publish.illinois.edu/illinoisdrainageguide/"
        
    
    def addAdvancedParameter(self, parameter):
        parameter.setFlags(parameter.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(parameter)    
    
    def initAlgorithm(self, config):
        
        #self.addParameter(QgsProcessingParameterRasterLayer('InputRaster', 'Raster Layer: Subirrigation Terrain Zone', defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorLayer('InputLineLayer', 'Line Layer: Drain Tile Network', types=[QgsProcessing.TypeVectorLine], defaultValue=None))
        
        self.addParameter(QgsProcessingParameterVectorLayer('VectorBound', 'Field Boundary', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterBoolean('SELECTED', 'Selected Features Only', optional=True, defaultValue=False))
        
        self.addParameter(QgsProcessingParameterNumber('DrainSpacing', 'Specify Drain Tile Spacing', type=QgsProcessingParameterNumber.Double, maxValue=200.0, defaultValue=50))              
        
        #self.addParameter(QgsProcessingParameterVectorDestination('VectorNew_a', 'Subirrigation Terrain Zones', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorDestination('VectorNew_b', 'Subirrigation Region of Influence', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
                                            
    def processAlgorithm(self, parameters, context, feedback):
        
        '''
        # Convert Raster to Vector Polygon Layer        
        polygonize_params = processing.run('gdal:polygonize',
        {'INPUT': parameters['InputRaster'], 
        'BAND': 1, 
        'FIELD': 'REGION_ID', 
        'EIGHT_CONNECTEDNESS': False, 
        'OUTPUT': parameters['VectorNew_a']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #1
               
        results_a = polygonize_params['OUTPUT']
        '''
        
        # Features Buffer for Tile Layer
        buffer_dist = (parameters['DrainSpacing'] / 2)
        
        buffer_params = processing.run('sagang:featuresbuffer',
        {'SHAPES': parameters['InputLineLayer'], 
        'DIST_FIELD': None, 
        'DIST_FIELD_DEFAULT': buffer_dist, 
        'DIST_SCALE': 2, 
        'DISSOLVE': True, 
        'NZONES': 1,
        'POLY_INNER': False,
        'DARC': 5,        
        'BUFFER': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #2                     
        
        results_b = buffer_params['BUFFER']
        
        # Intersect Buffer and Subirrigation Zones Together 
        only_features = parameters['SELECTED']
        '''
        How do i ensure this feature is activated: selectedFeaturesOnly=True,
        '''
        
        if only_features is True:
            
            input_boundary_layer = parameters['VectorBound']
            layer_def = QgsProcessingFeatureSourceDefinition(input_boundary_layer, selectedFeaturesOnly=True)
        
            intersect_params = processing.run('sagang:intersect', 
            {'A': results_b, 
            'B': layer_def, 
            'SPLIT': False, 
            'RESULT': QgsProcessing.TEMPORARY_OUTPUT}, 
            context=context, feedback=feedback, is_child_algorithm=True) #3              
            results_c = intersect_params['RESULT']
        
        else:
        
            intersect_params = processing.run('sagang:intersect', 
            {'A': results_b, 
            'B': parameters['VectorBound'], 
            'SPLIT': False, 
            'RESULT': QgsProcessing.TEMPORARY_OUTPUT}, 
            context=context, feedback=feedback, is_child_algorithm=True) #3              
            results_c = intersect_params['RESULT']
        
        # Add Geometry Attributes to Intersect Layer        
        attribute_params = processing.run('qgis:exportaddgeometrycolumns', 
        {'INPUT': results_c, 
        'CALC_METHOD': 0, 
        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}, 
        context=context, feedback=feedback, is_child_algorithm=True) #4                
        
        results_d = attribute_params['OUTPUT']
        
        # Field calculator
        calc_params = processing.run('native:fieldcalculator',
        {'FIELD_LENGTH': 10, 
        'FIELD_NAME': 'AREA_acres',
        'FIELD_PRECISION': 2,
        'FIELD_TYPE': 0,
        'FORMULA': '"area" / 43560',
        'INPUT': results_d,
        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
        context=context, feedback=feedback, is_child_algorithm=True) #5
        
        results_e = calc_params['OUTPUT']
        
        # Dissolve Polygon into One       
        dissolve_params = processing.run('native:dissolve', 
        {'INPUT': results_e, 
        'FIELD': ['AREA_acres', 'REGION_ID'], 
        'SEPARATE_DISJOINT': False, 
        'OUTPUT': parameters['VectorNew_b']},
        context=context, feedback=feedback, is_child_algorithm=True) #6

        results_f = dissolve_params['OUTPUT']
                
        
        #global renamer_a       
        #renamer_a = Renamer_1('Subirrigation_Zones')
        #context.layerToLoadOnCompletionDetails(results_a).setPostProcessor(renamer_a)
        
        global renamer_b       
        renamer_b = Renamer_1('Region_of_Influence')
        context.layerToLoadOnCompletionDetails(results_f).setPostProcessor(renamer_b)
                       
                
        return {'VectorNew_b': results_f} 
              
class Renamer_1(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
'''        
class Renamer_2(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
'''