# -*- coding: utf-8 -*-

"""
/***************************************************************************
 TerrainZones
                                 A QGIS plugin
 This Plugin Identifies & Creates Sub-Irrigation Zones
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-10-14
        copyright            : (C) 2023 by FALASY Anamelechi
        email                : fvw.services@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'FALASY Anamelechi'
__date__ = '2023-10-14'
__copyright__ = '(C) 2023 by FALASY Anamelechi'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import processing
import os, math
import inspect
import time
import qgis.utils
import numpy as np

from qgis.gui import *
from osgeo import gdal
from PyQt5 import QtWidgets
from osgeo import gdalnumeric
from collections import Counter
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QCoreApplication, QVariant, QObject
from processing.algs.qgis.QgisAlgorithm import QgisAlgorithm
from qgis.analysis import QgsRasterCalculator, QgsRasterCalculatorEntry

from qgis.core import QgsCategorizedSymbolRenderer, QgsSymbol, QgsRendererCategory, QgsFillSymbol, QgsLineSymbol
from PyQt5.QtGui import QColor

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFolderDestination
from qgis.core import QgsProcessingParameterFileDestination
from qgis.core import QgsProcessingParameterVectorDestination
from qgis.core import QgsProcessingParameterExtent
from qgis.core import QgsProcessingParameterEnum
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterFeatureSource
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterPoint
from qgis.core import QgsProcessingParameterField
from qgis.core import QgsProcessingParameterCrs
from qgis.core import QgsCoordinateReferenceSystem
from qgis.core import QgsFeatureSink
from qgis.core import QgsProcessingOutputVectorLayer
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsFeatureRequest
from qgis.core import QgsVectorLayer
from qgis.core import QgsLineSymbol
from qgis.core import QgsProperty

from qgis.core import QgsProcessingException
from qgis.core import QgsProcessingOutputNumber
from qgis.core import QgsProcessingParameterDistance
from qgis import processing

from qgis.core import QgsProcessingParameterString
from qgis.core import QgsProcessingLayerPostProcessorInterface
from qgis.core import QgsProcessingParameterRasterDestination
from qgis.core import QgsProcessingParameterExpression

from qgis.core import (edit,QgsField, QgsFeature, QgsPointXY, QgsWkbTypes, QgsGeometry, QgsFields)

class TerrainZonesAlgorithm(QgsProcessingAlgorithm):
    
    SPACING_KEY = 'SPACING_KEY'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return TerrainZonesAlgorithm()
        
    def name(self):        
        return '1. Terrain Zones'

    def displayName(self):        
        return self.tr(self.name())

    def group(self):        
        return self.tr(self.groupId())

    def groupId(self):        
        return ''
        
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon
        
    def shortHelpString(self):
        return self.tr("""This Tool is used to create Sub-irrigation zones and highlight terrain features on the Raster DEM.
        
        Workflow: 
        1. Select a Raster Layer
        2. Specify Height Exaggeration        
        3. Specify the Minimum Base Value        
        4. Save the output files (optional)
        5. Click on \"Run\"
        
        The script will gives out 9 outputs.         
                
        The help link in the Graphical User Interface (GUI) provides more information about the plugin.             
        """)    
        
    def helpUrl(self):         
        return "https://publish.illinois.edu/illinoisdrainageguide/"
        
    
    def addAdvancedParameter(self, parameter):
        parameter.setFlags(parameter.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(parameter)    
    
    def initAlgorithm(self, config):
        
        self.addParameter(QgsProcessingParameterRasterLayer('MDT', 'Input Raster Layer', defaultValue=None))
        
        self.addParameter(QgsProcessingParameterNumber('Exagiration', 'DEM Height Exaggeration', type=QgsProcessingParameterNumber.Double, maxValue=100.0, defaultValue=15))
                        
        self.addAdvancedParameter(QgsProcessingParameterEnum(self.SPACING_KEY, self.tr('SPECIFY MINIMUM BASEVALUE'), options=[self.tr("Default Minimum"),self.tr("Specify Minimum")], defaultValue=0))
        
        self.addAdvancedParameter(QgsProcessingParameterNumber('BValue', 'Specify Minimum Value', type=QgsProcessingParameterNumber.Double, defaultValue=0))       
                             
        self.addParameter(QgsProcessingParameterRasterDestination('VectorNew_a', '[0.5Ft] Raster Zones', createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorDestination('VectorNew_1', '[0.5Ft] Vector Zones', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        
        self.addParameter(QgsProcessingParameterRasterDestination('VectorNew_b', '[1.0Ft] Raster Zones', createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorDestination('VectorNew_2', '[1.0Ft] Vector Zones', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        
        self.addParameter(QgsProcessingParameterRasterDestination('VectorNew_c', '[1.5Ft] Raster Zones', createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorDestination('VectorNew_3', '[1.5Ft] Vector Zones', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        
        self.addParameter(QgsProcessingParameterRasterDestination('VectorNew_d', '[2.0Ft] Raster Zones', createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterVectorDestination('VectorNew_4', '[2.0Ft] Vector Zones', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))        
                                      
        self.addParameter(QgsProcessingParameterRasterDestination('Hillslope', 'Terrain Hillshade', createByDefault=True, defaultValue=None))
                                    
    def processAlgorithm(self, parameters, context, feedback):
        
        ras_id = self.parameterAsRasterLayer(parameters, 'MDT', context)
        pixel_x = ras_id.rasterUnitsPerPixelX()
        pixel_y = ras_id.rasterUnitsPerPixelY() 
        
        spacing_id = self.parameterAsEnum(parameters, self.SPACING_KEY, context)
        spacing_s = self.parameterAsDouble(parameters, 'BValue', context)
                
        # Find Field POLYGON A
                     
        pix1_params = processing.run('native:pixelstopoints', 
        {'INPUT_RASTER': parameters['MDT'], 
        'RASTER_BAND': 1, 
        'FIELD_NAME': 'ELEV', 
        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}, 
        context=context, feedback=feedback, is_child_algorithm=True)        
        contour_a = pix1_params['OUTPUT']
        
        if spacing_id == 0:  # use default minimum value from ELEV table 
        
            points1_params = processing.run('native:fieldcalculator',
            {'FIELD_LENGTH': 15,
            'FIELD_NAME': 'DEM_ZONES',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,
            'FORMULA': '(\"ELEV\" -  minimum(\"ELEV\"))/0.5 + 0.5 ', 
            'INPUT': contour_a,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
            context=context, feedback=feedback, is_child_algorithm=True)
            polygon_1 = points1_params['OUTPUT']
            
        else:  
        
            points1_params = processing.run('native:fieldcalculator',
            {'FIELD_LENGTH': 15,
            'FIELD_NAME': 'DEM_ZONES',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,
            'FORMULA': '("ELEV" - ' + str(spacing_s) + ')/0.5 + 0.5',
            'INPUT': contour_a,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
            context=context, feedback=feedback, is_child_algorithm=True)
            polygon_1 = points1_params['OUTPUT'] 
                                              
        zone1_params = processing.run('gdal:rasterize', 
        {'INPUT': polygon_1, 
        'FIELD': 'DEM_ZONES',
        'UNITS': 1,
        'WIDTH': pixel_x,
        'HEIGHT': pixel_y,
        'OUTPUT': parameters['VectorNew_a']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #1     
        polygon_a = zone1_params['OUTPUT']
               
        # Find Field POLYGON B
        
        pix2_params = processing.run('native:pixelstopoints', 
        {'INPUT_RASTER': parameters['MDT'], 
        'RASTER_BAND': 1, 
        'FIELD_NAME': 'ELEV', 
        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}, 
        context=context, feedback=feedback, is_child_algorithm=True)        
        contour_b = pix2_params['OUTPUT']
                
        if spacing_id == 0:  # use default minimum value from ELEV table 
        
            points2_params = processing.run('native:fieldcalculator',
            {'FIELD_LENGTH': 15,
            'FIELD_NAME': 'DEM_ZONES',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,
            'FORMULA': '(\"ELEV\" -  minimum(\"ELEV\"))/1 + 0.5 ', 
            'INPUT': contour_b,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
            context=context, feedback=feedback, is_child_algorithm=True)
            polygon_2 = points2_params['OUTPUT']
            
        else:  
        
            points2_params = processing.run('native:fieldcalculator',
            {'FIELD_LENGTH': 15,
            'FIELD_NAME': 'DEM_ZONES',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,
            'FORMULA': '("ELEV" - ' + str(spacing_s) + ')/1 + 0.5',
            'INPUT': contour_b,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
            context=context, feedback=feedback, is_child_algorithm=True)
            polygon_2 = points2_params['OUTPUT']                 
                        
        zone2_params = processing.run('gdal:rasterize', 
        {'INPUT': polygon_2, 
        'FIELD': 'DEM_ZONES',
        'UNITS': 1,
        'WIDTH': pixel_x,
        'HEIGHT': pixel_y,
        'OUTPUT': parameters['VectorNew_b']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #2     
        polygon_b = zone2_params['OUTPUT']
                        
        # Find Field POLYGON C

        pix3_params = processing.run('native:pixelstopoints', 
        {'INPUT_RASTER': parameters['MDT'], 
        'RASTER_BAND': 1, 
        'FIELD_NAME': 'ELEV', 
        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}, 
        context=context, feedback=feedback, is_child_algorithm=True)        
        contour_c = pix3_params['OUTPUT']
                
        if spacing_id == 0:  # use default minimum value from ELEV table 
        
            points3_params = processing.run('native:fieldcalculator',
            {'FIELD_LENGTH': 15,
            'FIELD_NAME': 'DEM_ZONES',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,
            'FORMULA': '(\"ELEV\" -  minimum(\"ELEV\"))/1.5 + 0.5 ', 
            'INPUT': contour_c,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
            context=context, feedback=feedback, is_child_algorithm=True)
            polygon_3 = points3_params['OUTPUT']
            
        else:  
        
            points3_params = processing.run('native:fieldcalculator',
            {'FIELD_LENGTH': 15,
            'FIELD_NAME': 'DEM_ZONES',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,
            'FORMULA': '("ELEV" - ' + str(spacing_s) + ')/1.5 + 0.5',
            'INPUT': contour_c,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
            context=context, feedback=feedback, is_child_algorithm=True)
            polygon_3 = points3_params['OUTPUT']                
                        
        zone3_params = processing.run('gdal:rasterize', 
        {'INPUT': polygon_3, 
        'FIELD': 'DEM_ZONES',
        'UNITS': 1,
        'WIDTH': pixel_x,
        'HEIGHT': pixel_y,
        'OUTPUT': parameters['VectorNew_c']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #3     
        polygon_c = zone3_params['OUTPUT']
                        
        # Find Field POLYGON D               
        
        pix4_params = processing.run('native:pixelstopoints', 
        {'INPUT_RASTER': parameters['MDT'], 
        'RASTER_BAND': 1, 
        'FIELD_NAME': 'ELEV', 
        'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT}, 
        context=context, feedback=feedback, is_child_algorithm=True)        
        contour_d = pix4_params['OUTPUT']
                
        if spacing_id == 0:  # use default minimum value from ELEV table 
        
            points4_params = processing.run('native:fieldcalculator',
            {'FIELD_LENGTH': 15,
            'FIELD_NAME': 'DEM_ZONES',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,
            'FORMULA': '(\"ELEV\" -  minimum(\"ELEV\"))/2 + 0.5 ', 
            'INPUT': contour_d,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
            context=context, feedback=feedback, is_child_algorithm=True)
            polygon_4 = points4_params['OUTPUT']
            
        else:  
        
            points4_params = processing.run('native:fieldcalculator',
            {'FIELD_LENGTH': 15,
            'FIELD_NAME': 'DEM_ZONES',
            'FIELD_PRECISION': 3,
            'FIELD_TYPE': 1,
            'FORMULA': '("ELEV" - ' + str(spacing_s) + ')/2 + 0.5',
            'INPUT': contour_d,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT},
            context=context, feedback=feedback, is_child_algorithm=True)
            polygon_4 = points4_params['OUTPUT'] 
                                        
        zone4_params = processing.run('gdal:rasterize', 
        {'INPUT': polygon_4, 
        'FIELD': 'DEM_ZONES',
        'UNITS': 1,
        'WIDTH': pixel_x,
        'HEIGHT': pixel_y,
        'OUTPUT': parameters['VectorNew_d']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #4     
        polygon_d = zone4_params['OUTPUT']
               
        # Find DEM Exaggeration              
        hill_params = processing.run('native:hillshade', 
        {'INPUT': parameters['MDT'], 
        'Z_FACTOR': parameters['Exagiration'], 
        'AZIMUTH': 315, 
        'V_ANGLE': 45, 
        'OUTPUT': parameters['Hillslope']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #5
        
        shadey = hill_params['OUTPUT']
        
        # Convert Raster to Vector Polygon Layer        
        polygonize1_params = processing.run('gdal:polygonize',
        {'INPUT': polygon_a, 
        'BAND': 1, 
        'FIELD': 'REGION_ID', 
        'EIGHT_CONNECTEDNESS': False, 
        'OUTPUT': parameters['VectorNew_1']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #1
               
        results_a = polygonize1_params['OUTPUT']
        
        # Convert Raster to Vector Polygon Layer        
        polygonize2_params = processing.run('gdal:polygonize',
        {'INPUT': polygon_b, 
        'BAND': 1, 
        'FIELD': 'REGION_ID', 
        'EIGHT_CONNECTEDNESS': False, 
        'OUTPUT': parameters['VectorNew_2']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #1
               
        results_b = polygonize2_params['OUTPUT']
        
        # Convert Raster to Vector Polygon Layer        
        polygonize3_params = processing.run('gdal:polygonize',
        {'INPUT': polygon_c, 
        'BAND': 1, 
        'FIELD': 'REGION_ID', 
        'EIGHT_CONNECTEDNESS': False, 
        'OUTPUT': parameters['VectorNew_3']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #1
               
        results_c = polygonize3_params['OUTPUT']
        
        # Convert Raster to Vector Polygon Layer        
        polygonize4_params = processing.run('gdal:polygonize',
        {'INPUT': polygon_d, 
        'BAND': 1, 
        'FIELD': 'REGION_ID', 
        'EIGHT_CONNECTEDNESS': False, 
        'OUTPUT': parameters['VectorNew_4']}, 
        context=context, feedback=feedback, is_child_algorithm=True) #1
               
        results_d = polygonize4_params['OUTPUT']
        
        global renamer_a       
        renamer_a = Renamer_1('[0.5Ft] Raster Zones')
        context.layerToLoadOnCompletionDetails(polygon_a).setPostProcessor(renamer_a)
        
        global renamer_b       
        renamer_b = Renamer_2('[1.0Ft] Raster Zones')
        context.layerToLoadOnCompletionDetails(polygon_b).setPostProcessor(renamer_b)
        
        global renamer_c      
        renamer_c = Renamer_3('[1.5Ft] Raster Zones')
        context.layerToLoadOnCompletionDetails(polygon_c).setPostProcessor(renamer_c)
        
        global renamer_d       
        renamer_d = Renamer_4('[2.0Ft] Raster Zones')
        context.layerToLoadOnCompletionDetails(polygon_d).setPostProcessor(renamer_d)

        global renamer_e       
        renamer_e = Renamer_5('Terrain Hillshade')
        context.layerToLoadOnCompletionDetails(shadey).setPostProcessor(renamer_e)

        global renamer_f       
        renamer_f = Renamer_6('[0.5Ft] Vector Zones')
        context.layerToLoadOnCompletionDetails(results_a).setPostProcessor(renamer_f)
        
        global renamer_g       
        renamer_g = Renamer_7('[1.0Ft] Vector Zones')
        context.layerToLoadOnCompletionDetails(results_b).setPostProcessor(renamer_g)
        
        global renamer_h      
        renamer_h = Renamer_8('[1.5Ft] Vector Zones')
        context.layerToLoadOnCompletionDetails(results_c).setPostProcessor(renamer_h)
        
        global renamer_i       
        renamer_i = Renamer_9('[2.0Ft] Vector Zones')
        context.layerToLoadOnCompletionDetails(results_d).setPostProcessor(renamer_i)        
                
        return {
        'VectorNew_a': polygon_a, 
        'VectorNew_b': polygon_b, 
        'VectorNew_c': polygon_c, 
        'VectorNew_d': polygon_d, 
        'VectorNew_1': results_a, 
        'VectorNew_2': results_b, 
        'VectorNew_3': results_c, 
        'VectorNew_4': results_d,
        'Hillslope': shadey} 
              
class Renamer_1(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_2(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_3(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_4(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)

class Renamer_5(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)

class Renamer_6(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_7(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_8(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)
        
class Renamer_9(QgsProcessingLayerPostProcessorInterface):
    def __init__(self, layer_name):
        self.name = layer_name
        super().__init__()
        
    def postProcessLayer(self, layer, context, feedback):
        layer.setName(self.name)