# -*- coding: utf-8 -*-

"""
/***************************************************************************
 TerraHidro
                                 A QGIS plugin
 The TerraHidro plugin provides an interface for the TerraHidro console used in hydrological applications.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-01-24
        copyright            : (C) 2022 by Henrique Rennó de Azeredo Freitas (INPE)
        email                : henrique.renno@inpe.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Henrique Rennó de Azeredo Freitas (INPE)'
__date__ = '2022-01-24'
__copyright__ = '(C) 2022 by Henrique Rennó de Azeredo Freitas (INPE)'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

# path functions
import os

# icon
import inspect
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessingProvider
from .terrahidro_algorithm import TerraHidroAlgorithm


class TerraHidroProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        
        self.algs = []
        folder = os.path.normpath(os.path.join(os.path.dirname(__file__), 'functions'))
        
        for funcFile in os.listdir(folder):
            functionFile = os.path.join(folder, funcFile)
            alg = TerraHidroAlgorithm(functionFile)
            self.algs.append(alg)
            
        for alg in self.algs:
            self.addAlgorithm(alg)
        
    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'terrahidro'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('TerraHidro')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
