# -*- coding: utf-8 -*-

"""
/***************************************************************************
 TerraHidro
                                 A QGIS plugin
 The TerraHidro plugin provides an interface for the TerraHidro console used in hydrological applications.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-01-24
        copyright            : (C) 2022 by Henrique Rennó de Azeredo Freitas (INPE)
        email                : henrique.renno@inpe.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Henrique Rennó de Azeredo Freitas (INPE)'
__date__ = '2022-01-24'
__copyright__ = '(C) 2022 by Henrique Rennó de Azeredo Freitas (INPE)'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

# path functions
import os

# icon
import inspect
from qgis.PyQt.QtGui import QIcon

from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (QgsProcessing,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterRasterLayer,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFile,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterString,
                       QgsProcessingParameterRasterDestination,
                       QgsProcessingParameterVectorDestination,
                       QgsProcessingParameterFileDestination,
                       QgsMessageLog)
from processing.core.parameters import getParameterFromString

from terrahidro import utils


class TerraHidroAlgorithm(QgsProcessingAlgorithm):
    """
    All Processing algorithms should extend the QgsProcessingAlgorithm class.
    """

    def __init__(self, functionFile):
        super().__init__()

        self._name = ''
        self._displayName = ''
        self._group = ''
        self._groupId = ''
        self._help = ''
        self.functionFile = functionFile

        self.params = []
        
        self.functionFromFile()
        
    def functionFromFile(self):
        with open(self.functionFile) as file:
            line = file.readline().strip()
            self._name = line
            
            line = file.readline().strip()
            self._displayName = line
            
            line = file.readline().strip()
            self._group = line
            
            line = file.readline().strip()
            self._groupId = line
            
            line = file.readline().strip()
            self._help = line
            
            line = file.readline().strip()
            while line != '':
                self.params.append(getParameterFromString(line, 'TerraHidroAlgorithm'))
                line = file.readline().strip()
                
    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm.
        """

        for p in self.params:
            self.addParameter(p, True)

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        command = ['"{}"'.format(os.path.join(os.getenv('TERRAHIDRO'), 'th')), self.name()]
        
        # input/output parameters
        for param in self.parameterDefinitions():
            # input raster
            if isinstance(param, QgsProcessingParameterRasterLayer):
                layer = self.parameterAsRasterLayer(parameters, param.name(), context)
                if layer is not None:
                    command.append('"{}"'.format(layer.source()))
            # input vector
            elif isinstance(param, QgsProcessingParameterFeatureSource):
                layer = self.parameterAsLayer(parameters, param.name(), context)
                source = layer.source()
                if layer is not None:
                    if "|" in source:
                        idx = source.index("|")
                        source = source[0:idx]
                    command.append('"{}"'.format(source))
            # input text file
            elif isinstance(param, (QgsProcessingParameterFile)):
                inputFile = self.parameterAsFile(parameters, param.name(), context)
                command.append('"{}"'.format(inputFile))
            # input number
            elif isinstance(param, QgsProcessingParameterNumber):
                if param.dataType() == QgsProcessingParameterNumber.Integer:
                    val = self.parameterAsInt(parameters, param.name(), context)
                    command.append('{}'.format(val))
                else:
                    val = self.parameterAsDouble(parameters, param.name(), context)
                    command.append('{}'.format(val))
            # input string
            elif isinstance(param, QgsProcessingParameterString):
                string = self.parameterAsString(parameters, param.name(), context)
                command.append('"{}"'.format(string))
            # output raster
            elif isinstance(param, QgsProcessingParameterRasterDestination):
                outputFile = self.parameterAsOutputLayer(parameters, param.name(), context)
                command.append('"{}"'.format(outputFile))
            # output vector
            elif isinstance(param, QgsProcessingParameterVectorDestination):
                outputFile = self.parameterAsOutputLayer(parameters, param.name(), context)
                command.append('"{}"'.format(outputFile))
            # output text file
            elif isinstance(param, QgsProcessingParameterFileDestination):
                outputFile = self.parameterAsFileOutput(parameters, param.name(), context)
                command.append('"{}"'.format(outputFile))

        """
        Executes TerraHidro using the utility available in WhiteboxTools developed by Alexander Bruy (2017).
        """
        utils.execute(command, feedback)
        
        # define output results
        results = {}
        for output in self.outputDefinitions():
            outputName = output.name()
            if outputName in parameters:
                results[outputName] = parameters[outputName]

        return results

    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return self._name

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self._displayName

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self._group

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return self._groupId

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)
        
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon

    def createInstance(self):
        return TerraHidroAlgorithm(self.functionFile)
