# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TerraBrasilisDataSource
                                 A QGIS plugin
 The plugin enable to show layers from TerraBrasilis Geoserver
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-11-25
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Adeline Maciel
        email                : adelinemaciel22@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from PyQt5 import QtGui
from PyQt5 import QtCore

from PyQt5.QtCore import QSettings, QTranslator, QCoreApplication, qVersion,QCoreApplication
from PyQt5.QtGui import QIcon, QStandardItemModel, QStandardItem
from PyQt5.QtWidgets import QAction, QFileDialog, QListWidget, QComboBox, QApplication, QWidget, QLabel, QVBoxLayout
from qgis.core import QgsProject, Qgis, QgsRasterLayer, QgsProject, QgsApplication

import requests
import json
from qgis.utils import iface

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .terrabrasilis_datasource_dialog import TerraBrasilisDataSourceDialog
import os.path


class TerraBrasilisDataSource:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:5] # ajust here from [0:2] pt to [0:5] pt_BR
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'TerraBrasilisDataSource_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # print('Localization loaded: ', locale_path)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&TerraBrasilis Data Source')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        self.dlg = TerraBrasilisDataSourceDialog()
        self.model = QStandardItemModel()

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('TerraBrasilisDataSource', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/terrabrasilis_datasource/terrabrasilis.png'
        self.add_action(
            icon_path,
            text=self.tr(u'TerraBrasilis Data Source'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&TerraBrasilis Data Source'),
                action)
            self.iface.removeToolBarIcon(action)

        #print("------- FINISHED -------")
           
    # update combo box when change workspace
    def update_combo_box(self, index):
        indx = self.model.index(index, 0, self.dlg.comboBox.rootModelIndex())
        self.dlg.comboBox_2.setRootModelIndex(indx)
        self.dlg.comboBox_2.setCurrentIndex(0)

    # # update label with values from combobox
    # def show_values_combobox_label(self):
    #     workspace = self.dlg.comboBox.currentText()
    #     layer = self.dlg.comboBox_2.currentText()
    #     self.dlg.label_3.setText("Project name: {}\nLayer name: {}".format(workspace, layer))

    # update label with metadata link
    def show_values_metadata_layer(self, data_layer):
        info_layer = self.layer_combo_box_info(data_layer)
        text = self.tr(u'Metadata Link')
        metadata = "<a href={}>{}</a>".format(info_layer[6], text)
        self.dlg.label_3.setText(metadata)
        self.dlg.label_3.setOpenExternalLinks(True)
        
    # return elements that are used in other methods
    def layer_combo_box_info(self, data):
        biome_name = self.dlg.comboBox.currentText()
        workspace = None
        layer = self.dlg.comboBox_2.currentText()
        #print("---", workspace, "---", layer, "---")
        crs_layer = None
        title = None
        url = None
        has_time = None
        times = None
        metadata = None
        #host = "http://localhost:10190/geoserver/"
        host = "https://terrabrasilis.dpi.inpe.br/geoserver/"

        for i in data:
            for j in i["workspace"]:
                if j['biome_name'] == biome_name:
                    workspace = j["name"]
                    #print("Is the data", j['name'])
                    for k in j['layer']:
                        if k['name'] == layer:
                            title = k["title"]
                            #print("Title: ", title)
                            crs_layer = k["crs"]
                            #print("CRS: ", crs)
                            has_time = k["hasTime"]
                            #print("Has Time: ", has_time)
                            times = k["times"]
                            metadata = k["metadata"]
                            break

        crs = str(crs_layer)

        if (has_time is True):
            url = []
            for i in times:
                # https://issues.qgis.org/issues/13085
                url.append(str("IgnoreGetFeatureInfoUrl=1&IgnoreGetMapUrl=1&contextualWMSLegend=0&crs=EPSG:" + crs + "&format=image/png&layers=" + layer + "&styles=&url=" + host + "" + workspace + "/wms?TIME%3D" + i + "%26LAYERS%3D" + layer + ""))
        else:
            url = str("url=" + host + "" + workspace + "/wms&layers=" + layer + "&styles=&crs=EPSG:" + crs + "&format=image/png")

        # print("--------")
        # print("= layer_combo_box_info", url)
        # print("--------")
        return workspace, layer, title, crs, url, times, metadata

    # update combo box when change workspace
    def update_textEdit(self, data_layer):
        info_layer = self.layer_combo_box_info(data_layer)
        url = info_layer[4]
        #print("--------")
        #print("- update_textEdit", url)
        #print("--------")
        self.dlg.textEdit.setText(str(url))

    # open a layer in QGIS when button is pressed
    def open_layer_wms(self, data_layer):
        info_layer = self.layer_combo_box_info(data_layer)
        title = info_layer[2]
        url = info_layer[4]
        times = info_layer[5]
        # print("--------")
        # print("+ open_layer_wms", url)
        # print("--------")

        if (type(url) == type([])):
            group_name=title
            root = QgsProject.instance().layerTreeRoot()
            group = root.addGroup(group_name)
            for i in times:
                # print(i)
                # print(times.index(i))
                # print(url[times.index(i)])
                if i == times[-1]:
                    rlayer = QgsRasterLayer(url[times.index(i)], i, 'wms')
                    #print("last layer ", url[times.index(i)]) ####
                    rlayer.isValid()
                    QgsProject.instance().addMapLayer(rlayer, False)
                    group.addLayer(rlayer)
                else:
                    rlayer = QgsRasterLayer(url[times.index(i)], i, 'wms')
                    #print("other layers ",url[times.index(i)]) ####
                    rlayer.isValid()
                    QgsProject.instance().addMapLayer(rlayer, False)
                    group.addLayer(rlayer)
                    root.findLayer(rlayer).setItemVisibilityChecked(False) # set layer as visible or not 
        else:
            rlayer = QgsRasterLayer(url, title, 'wms')
            rlayer.isValid() 
            QgsProject.instance().addMapLayer(rlayer)
            self.iface.zoomToActiveLayer()
            
                
    def run(self):
        """Run method that performs all the real work"""
        
        if self.first_start == True:
            self.first_start = True # change False to True to stop layer/variable duplication after qgis plugin restart
            self.dlg = TerraBrasilisDataSourceDialog()
            self.model = QStandardItemModel() 
            #print("------- START -------")

        # Clear the QComboBox before loading layers    
        self.dlg.comboBox.clear()
        self.dlg.comboBox_2.clear()
        self.dlg.textEdit.clear()
        
        # read file from githut
        url_json = 'https://raw.githubusercontent.com/terrabrasilis/terrabrasilis_datasource/main/data/geoserver_terrabrasilis_info.json'
        #file_folder = os.path.join(os.path.expanduser("~"), "geoserver_terrabrasilis_info.json")
        resp = requests.get(url_json)
        
        template = QgsApplication.qgisSettingsDirPath() + "python/plugins/terrabrasilis_datasource/data"
        file_folder = os.path.join(template, "geoserver_terrabrasilis_info.json")
        print(file_folder)
        #data = json.load(open(file_folder)) # case test json from localhost

        if resp.status_code == requests.codes['ok']:
            data = json.loads(resp.text)
            with open(file_folder, 'w') as json_file:
                json.dump(data, json_file)
            #print(data)
        else:
            iface.messageBar().pushMessage("Error", "json from github terrabrasilis_datasource was not found.", level=1)
            data = json.load(open(file_folder))
            #print("From folder")

        # workspace
        self.dlg.comboBox.setModel(self.model)
        # layers
        self.dlg.comboBox_2.setModel(self.model)

        for i in data:
            #print(i["workspace"])
            for j in i["workspace"]:
                biome_name = QStandardItem(j["biome_name"])
                #workspace_name = j["name"]
                self.model.appendRow(biome_name)
                for k in j["layer"]:
                    layer_name = QStandardItem(k["name"])
                    biome_name.appendRow(layer_name)

        # update both QComboBox
        self.dlg.comboBox.currentIndexChanged.connect(self.update_combo_box)
        self.update_combo_box(0)

        # # update both QLabel - label3 with workspace and layer name
        # self.dlg.comboBox_2.currentIndexChanged.connect(self.show_values_combobox_label)

        # update both QLabel - label3 with metadata link
        self.dlg.comboBox_2.currentIndexChanged.connect(lambda: self.show_values_metadata_layer(data))

        # update both QLabel - label4 with url to wms service
        self.dlg.comboBox_2.currentIndexChanged.connect(lambda: self.update_textEdit(data))
        
        self.dlg.pushButton.clicked.connect(lambda: self.open_layer_wms(data))
        
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
    
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
