# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Terminus
                                 A QGIS plugin
 This plugin performs Image Segmentation
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-10-13
        copyright            : (C) 2020 by Ioannis Kotaridis
        email                : ikotarid@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Ioannis Kotaridis'
__date__ = '2020-10-13'
__copyright__ = '(C) 2020 by Ioannis Kotaridis'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect

from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtGui import QIcon

from qgis.core import QgsProcessingAlgorithm, QgsApplication
import processing
from .terminus_processing_provider import TerminusProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class TerminusPlugin(object):

    def __init__(self, iface):
        self.provider = None
        self.iface = iface

    	# noinspection PyMethodMayBeStatic

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = TerminusProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    """Create the menu entries and toolbar icons inside the QGIS GUI."""
    def initGui(self):
        #code to initialize the processing provider
        self.initProcessing()

        #code to add toolbar buttons and a menu item for more than one algorithms
        actionSegF = QAction(
            QIcon(os.path.join(os.path.join(cmd_folder, 'icons\F.png'))),
            u"Felzenszwalb algorithm", self.iface.mainWindow())
        actionSegF.triggered.connect(self.runSegF)


        actionSegQ = QAction(
            QIcon(os.path.join(os.path.join(cmd_folder, 'icons\Q.png'))),
            u"Quickshift algorithm", self.iface.mainWindow())
        actionSegQ.triggered.connect(self.runSegQ)

        actionSegS = QAction(
            QIcon(os.path.join(os.path.join(cmd_folder, 'icons\S.png'))),
            u"Slic algorithm", self.iface.mainWindow())
        actionSegS.triggered.connect(self.runSegS)

        actionSegW = QAction(
            QIcon(os.path.join(os.path.join(cmd_folder, 'icons\W.png'))),
            u"Watershed algorithm", self.iface.mainWindow())
        actionSegW.triggered.connect(self.runSegW)

        self.actions = [actionSegF,actionSegQ,actionSegS,actionSegW]
        for action in self.actions:
            self.iface.addPluginToMenu(u"&Terminus", action)
            self.iface.addToolBarIcon(action)


    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)

        #code to the unload method, to remove these elements when plugin is removed

        for action in self.actions:
            self.iface.removePluginMenu(u"&Terminus", action)
            self.iface.removeToolBarIcon(action)
            del action

    #a method that uses the helper method execAlgorithmDialog to launch the processing algorithm
    def runSegF(self):
        processing.execAlgorithmDialog("Terminus:segmentationfelzenszwalb")
    def runSegQ(self):
        processing.execAlgorithmDialog("Terminus:segmentationquickshift")
    def runSegS(self):
        processing.execAlgorithmDialog("Terminus:segmentationslic")
    def runSegW(self):
        processing.execAlgorithmDialog("Terminus:segmentationwatershed")
