from qgis.core import QgsProcessingProvider

from .fetchtengun import fetchtengun
from .listtengungrid import listtengungrid


class tengungun_provider(QgsProcessingProvider):

    def __init__(self):        
        QgsProcessingProvider.__init__(self)

    def unload(self):
        pass

    def loadAlgorithms(self):
        self.addAlgorithm(fetchtengun())
        self.addAlgorithm(listtengungrid())

    def id(self):
        return 'tengungun'

    def name(self):
        return self.tr('TENGUNGUN')

    def icon(self):
        return QgsProcessingProvider.icon(self)

    def longName(self):
        return self.name()
