# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TempoSalvoTools
                                 A QGIS plugin
 Este Plugin automatiza e cria diversos processos 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-10-09
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Leonardo Gomes
        email                : leogomes21@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtWidgets import QAction, QMenu
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt import sip

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .tempo_salvo_tools_dialog import TempoSalvoToolsDialog

from .codigos.GradeManagerGeoUTM import GradeManager

from .codigos.LinhaManagerPoligono import LinhaManager

from .codigos.ExportarManagerFotos import FotosManager

from .codigos.GerarCurvasNiveis import CurvasManager

from .codigos.GerarSetasRaster import SetasManager

from .codigos.ExtrairCotasMDT import CotasManager

from .codigos.PoligonoManagerLinha import PoligonoManager

from .codigos.CriarPlatoManager import PlatoManager

from .codigos.CalcularVolume import VolumeManager

from .codigos.GraficoTaludeManager2D import GraficoManager

from .codigos.GraficoPerfilManager import PerfilManager

from .codigos.GraficoEstruturasManager import EstruturasManager

from .codigos.CriarMalhaManager import MalhaManager

from .codigos.ConverterMalhaManager import MalhaConverteManager

from .codigos.RasterizarMalhaManager import RasterizarManager

from .codigos.OperacoesLinhasManager import LinhasManager

from .codigos.LinhaDentroPoligono import DentroManager

from .codigos.ExportarManagerImagens import ImagensManager

from .codigos.AdicionarCamadaManager import CamadaManager

from .codigos.CriarMatrizesVetores import MatrizManager

from .codigos.GeoprocessamentoPoligonos import GeoPoligonosManager

from .codigos.DimensionarVetoresManager import DimensionarVetores

from .codigos.NotasMecanicasManager import NotaMecanicas

from .codigos.CriarRedesDrenagem import RedesDrenagem

from .codigos.UiManager import UiManager  # Importa a classe UiManager
from .codigos.UiManagerP import UiManagerP  # Importa a classe UiManagerP
from .codigos.UiManagerT import UiManagerT  # Importa a classe UiManagerT
from .codigos.UiManagerR import UiManagerR  # Importa a classe UiManagerR
from .codigos.UiManagerM import UiManagerM  # Importa a classe UiManagerM
from .codigos.ToolbarManager import ToolbarManager
import os.path

class TempoSalvoTools:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.dlg = TempoSalvoToolsDialog(self.iface.mainWindow())  # Definindo a janela principal do QGIS como parent
        self.ui_manager = UiManager(iface, self.dlg)  # Instancia UiManager

        # Inicializa o ToolbarManager
        self.toolbar_manager = ToolbarManager(iface, self.dlg)

        self.ui_manager_p = UiManagerP(iface, self.dlg)  # Instancia UiManagerP
        self.ui_manager_T = UiManagerT(iface, self.dlg)  # Instancia UiManagerT
        self.ui_manager_R = UiManagerR(iface, self.dlg)  # Instancia UiManagerR
        self.ui_manager_M = UiManagerM(iface, self.dlg)  # Instancia UiManagerM

        # Inicializa as variáveis de instância para os diálogos
        self.setasraster_dlg = None
        self.curvas_dlg = None
        self.fotos_kmz_dlg = None
        self.linha_poligono_dlg = None
        self.grade_utm_geo_dlg = None
        self.cotasraster_dlg = None
        self.poligono_linha_dlg = None
        self.plato_mdt_dlg = None
        self.volume_mdt_dlg = None
        self.grafico_PyQt_dlg = None
        self.grafico_perfil_dlg = None
        self.grafico_estruturas_dlg = None
        self.malha_dlg = None
        self.malhaconverte_dlg = None
        self.rasterizarmalha_dlg = None
        self.operacoeslinhas_dlg = None
        self.dentrolinhas_dlg = None
        self.imagens_kmz_dlg = None
        self.camada_pontos_xls_dlg = None
        self.matrizes_vetores_dlg = None
        self.geoprocessar_poligonos_dlg = None
        self.dimensionar_vetores_dlg = None
        self.notas_dlg = None
        self.redes_drenagem_dlg = None

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'TempoSalvoTools_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Tempo Salvo Tools')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None
    
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('TempoSalvoTools', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        def create_submenu(menu, title, icon_path):
            """Auxiliary function to create a submenu if it does not exist."""
            for action in menu.actions():
                if isinstance(action, QAction) and action.text() == title:
                    return action.menu()  # Retorna o submenu existente
            # Cria um novo submenu porque ele não existe
            new_submenu = QMenu(self.iface.mainWindow())
            new_submenu.setTitle(self.tr(title))
            new_submenu.setIcon(QIcon(icon_path))
            menu.addMenu(new_submenu)
            return new_submenu

        # Verifique se o menu personalizado "Tempo Salvo Tools" já existe e reutilize-o se sim
        menu_bar = self.iface.mainWindow().menuBar()
        self.custom_menu = next((action.menu() for action in menu_bar.actions() if action.text() == self.tr(u'Tempo Salvo Tools')), None)

        # Se o menu personalizado "Tempo Salvo Tools" não existir, crie-o
        if self.custom_menu is None:
            self.custom_menu = QMenu(self.tr(u'Tempo Salvo Tools'), self.iface.mainWindow())
            # Insere o menu antes do último item da barra de menus
            menu_bar.insertMenu(menu_bar.actions()[-1], self.custom_menu)

        # Caminho para o novo ícone na subpasta 'icones'
        new_icon_path = os.path.join(self.plugin_dir, 'icones', 'camada.png') 

        # Caminho para os ícones dos submenus
        icon_path_camadas = os.path.join(self.plugin_dir, 'icones', 'camadas.png')
        icon_path_vetorial = os.path.join(self.plugin_dir, 'icones', 'criacaovetorial.png')
        icon_path_vetor_raster = os.path.join(self.plugin_dir, 'icones', 'rastervetor.png')
        icon_path_rasters = os.path.join(self.plugin_dir, 'icones', 'rasters.png')
        icon_path_projetos = os.path.join(self.plugin_dir, 'icones', 'projetos.png')

        # Cria ou recupera os submenus "Criação de Camadas" e "Criação Vetorial"
        self.vector_creation_submenu = create_submenu(self.custom_menu, u'Criação de Camadas', icon_path_camadas)

        self.vectorial_creation_submenu = create_submenu(self.custom_menu, u'Criação Vetorial', icon_path_vetorial)

        self.malha_creation_submenu = create_submenu(self.custom_menu, u'Criação de Malhas', icon_path_rasters)

        self.raster_vetor_creation_submenu = create_submenu(self.custom_menu, u'Raster para Vetor', icon_path_vetor_raster)
        
        self.projetos_creation_submenu = create_submenu(self.custom_menu, u'Projetos', icon_path_projetos)

        # Cria a ação "Gerenciar Camadas"
        self.plugin_action = self.add_action(
            new_icon_path,  # Usa o novo ícone da aplicação
            text=self.tr(u'Gerenciar Camadas'),
            callback=self.run,
            add_to_menu=False,  # Não adiciona ao menu de complementos
            add_to_toolbar=True,  # Não adiciona à barra de ferramentas
            parent=self.iface.mainWindow())

        # GRADE UTM/GEO
        icon_path_gradeutmgeo = os.path.join(self.plugin_dir, 'icones', 'gradeutmgeo.png')

        # Cria a ação "Grade UTM/GEO"
        self.grade_utm_geo_action = self.add_action(
            icon_path_gradeutmgeo,
            text=self.tr(u'Grade UTM/GEO'),
            callback=self.run_grade_utm_geo,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_grade_utm_geo'),
            parent=self.iface.mainWindow())
        self.grade_utm_geo_action.setObjectName('grade_utm_geo_action')  # Define um nome para a ação

        # Adiciona a ação "Grade UTM/GEO" ao submenu "Criação de Camadas"
        self.vector_creation_submenu.addAction(self.grade_utm_geo_action)

        # LINHAS PARA POLÍGONOS
        icon_path_linha_poligono = os.path.join(self.plugin_dir, 'icones', 'linhapoligono.png')

        # Cria a ação "Linha para Polígono"
        self.linha_poligono_action = self.add_action(
            icon_path_linha_poligono,
            text=self.tr(u'Linhas para Polígonos'),
            callback=self.run_linha_poligono,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_linha_poligono'),
            parent=self.iface.mainWindow())
        self.linha_poligono_action.setObjectName('linha_poligono_action')  # Define um nome para a ação

        # Adiciona a ação "Grade UTM/GEO" ao submenu "Criação de Camadas"
        self.vectorial_creation_submenu.addAction(self.linha_poligono_action)

        # FOTOS PARA KMZ
        icon_path_fotos = os.path.join(self.plugin_dir, 'icones', 'fotos.png')

        self.fotos_action = self.add_action(
            icon_path_fotos,
            text=self.tr(u'Fotos para KMZ'),
            callback=self.run_fotos_kmz,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_fotos_kmz'),
            parent=self.iface.mainWindow())
        self.fotos_action.setObjectName('fotos_action')  # Define um nome para a açã

        # Adiciona a ação "Fotos para KMZ" ao submenu "Criação de Camadas"
        self.vector_creation_submenu.addAction(self.fotos_action)

        # CURVAS 3D
        icon_path_curvas = os.path.join(self.plugin_dir, 'icones', 'curvasmdt.png')

        # Cria a ação "Gerar Curvas 3D"
        self.curvas_action = self.add_action(
            icon_path_curvas,
            text=self.tr(u'Gerar Curvas 3D'),
            callback=self.run_curvas,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_curvas'),
            parent=self.iface.mainWindow())
        self.curvas_action.setObjectName('curvas_action')  # Define um nome para a ação

        # Adiciona a ação "Gerar Curvas 3D" ao submenu "Criação de Camadas"
        self.raster_vetor_creation_submenu.addAction(self.curvas_action)

        # SETASRASTER
        icon_path_setasraster = os.path.join(self.plugin_dir, 'icones', 'setasraster.png')

        # Cria a ação "Gerar Setas sobre um MDT"
        self.setasraster_action = self.add_action(
            icon_path_setasraster,
            text=self.tr(u'Gerar Setas sobre o MDT'),
            callback=self.run_setasraster,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_setasraster'),
            parent=self.iface.mainWindow())
        self.setasraster_action.setObjectName('setasraster_action')  # Define um nome para a ação

        # Adiciona a ação "GERAR SETAS SOBRE O MDT" ao submenu "Criação de Camadas"
        self.raster_vetor_creation_submenu.addAction(self.setasraster_action)

        # COTASRASTER
        icon_path_cotasraster = os.path.join(self.plugin_dir, 'icones', 'cotasmdt.png')

        # Cria a ação "Gerar Setas sobre um MDT"
        self.cotasraster_action = self.add_action(
            icon_path_cotasraster,
            text=self.tr(u'Extrair Cotas de MDT'),
            callback=self.run_cotasraster,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_cotasraster'),
            parent=self.iface.mainWindow())
        self.cotasraster_action.setObjectName('cotasraster_action')  # Define um nome para a ação

        # Adiciona a ação "GERAR COTAS A PARTIR DE MDT" ao submenu "Criação de Camadas"
        self.raster_vetor_creation_submenu.addAction(self.cotasraster_action)

        # POLÍGONOS PARA LINHAS
        icon_path_poligono_linha = os.path.join(self.plugin_dir, 'icones', 'poligonolinha.png')

        # Cria a ação "Polígono para Linhas"
        self.poligono_linha_action = self.add_action(
            icon_path_poligono_linha,
            text=self.tr(u'Polígonos para Linhas'),
            callback=self.run_poligono_linha,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_poligono_linha'),
            parent=self.iface.mainWindow())
        self.poligono_linha_action.setObjectName('poligono_linha_action')  # Define um nome para a ação

        # Adiciona a ação "Polígonos para Linha" ao submenu "Criação Vetorial"
        self.vectorial_creation_submenu.addAction(self.poligono_linha_action)

        # PLATÔ
        icon_path_plato_mdt = os.path.join(self.plugin_dir, 'icones', 'plat.png')

        # Cria a ação "Polígono para Linhas"
        self.plato_mdt_action = self.add_action(
            icon_path_plato_mdt,
            text=self.tr(u'Criar Platô sobre o MDT'),
            callback=self.run_plato_mdt,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_plato_mdt'),
            parent=self.iface.mainWindow())
        self.plato_mdt_action.setObjectName('plato_mdt_action')  # Define um nome para a ação

        # Adiciona a ação "Polígonos para Linha" ao submenu "Projetos"
        self.projetos_creation_submenu.addAction(self.plato_mdt_action)

        # VOLUME
        icon_path_volume_mdt = os.path.join(self.plugin_dir, 'icones', 'volume_dif.png')

        # Cria a ação "Cálculos de Volumes"
        self.volume_mdt_action = self.add_action(
            icon_path_volume_mdt,
            text=self.tr(u'Cálculos de Volume'),
            callback=self.run_volume_mdt,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_volume_mdt'),
            parent=self.iface.mainWindow())
        self.volume_mdt_action.setObjectName('volume_mdt_action')  # Define um nome para a ação

        # Adiciona a ação "Cálculos de Volume" ao submenu "Projetos"
        self.projetos_creation_submenu.addAction(self.volume_mdt_action)

        # GRÁFICOTALUDE
        icon_path_grafico_PyQt = os.path.join(self.plugin_dir, 'icones', 'talude.png')

        # Cria a ação "Gerar Gráficos 2D com Taludes"
        self.grafico_PyQt_action = self.add_action(
            icon_path_grafico_PyQt,
            text=self.tr(u'Gerar Gráficos com Taludes'),
            callback=self.run_grafico_PyQt,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_grafico_PyQt'),
            parent=self.iface.mainWindow())
        self.grafico_PyQt_action.setObjectName('grafico_PyQt_action')  # Define um nome para a ação

        # Adiciona a ação "Gerar Gráficos 2D com Taludes" ao submenu "Projetos"
        self.projetos_creation_submenu.addAction(self.grafico_PyQt_action)

        # GRÁFICOPERFIL
        icon_path_grafico_perfil = os.path.join(self.plugin_dir, 'icones', 'perfil.png')

        # Cria a ação "Gerar Gráficos 2D com Taludes"
        self.grafico_perfil_action = self.add_action(
            icon_path_grafico_perfil,
            text=self.tr(u'Gerar Gráficos de Perfis'),
            callback=self.run_grafico_perfil,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_grafico_perfil'),
            parent=self.iface.mainWindow())
        self.grafico_perfil_action.setObjectName('grafico_perfil_action')  # Define um nome para a ação

        # Adiciona a ação "Gerar Gráficos 2D com Taludes" ao submenu "Projetos"
        self.projetos_creation_submenu.addAction(self.grafico_perfil_action)

        # GRÁFICOESTRUTURAS
        icon_path_grafico_estruturas = os.path.join(self.plugin_dir, 'icones', 'estruturasolar.png')

        # Cria a ação "Gerar Gráficos 2D com Taludes"
        self.grafico_estruturas_action = self.add_action(
            icon_path_grafico_estruturas,
            text=self.tr(u'Gerar Gráficos de Estruturas'),
            callback=self.run_grafico_estruturas,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_grafico_estruturas'),
            parent=self.iface.mainWindow())
        self.grafico_estruturas_action.setObjectName('grafico_estruturas_action')  # Define um nome para a ação

        # Adiciona a ação "Gerar Gráficos 2D com Taludes" ao submenu "Projetos"
        self.projetos_creation_submenu.addAction(self.grafico_estruturas_action)

        # CRIAR MALHAS
        icon_path_malha = os.path.join(self.plugin_dir, 'icones', 'criarmalha.png')

        # Cria a ação "Gerar Malhas"
        self.malha_action = self.add_action(
            icon_path_malha,
            text=self.tr(u'Gerar Malhas'),
            callback=self.run_malha,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_malha'),
            parent=self.iface.mainWindow())
        self.malha_action.setObjectName('malha_action')  # Define um nome para a ação

        # Adiciona a ação "Gerar Gráficos 2D com Taludes" ao submenu "Projetos"
        self.malha_creation_submenu.addAction(self.malha_action)

        # MALHA CONVERTE
        icon_path_malhaconverte = os.path.join(self.plugin_dir, 'icones', 'convertemalha.png')

        # Cria a ação "Converter Malhas"
        self.malhaconverte_action = self.add_action(
            icon_path_malhaconverte,
            text=self.tr(u'Converte para Malha'),
            callback=self.run_malhaconverte,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_converte_malha'),
            parent=self.iface.mainWindow())
        self.malhaconverte_action.setObjectName('malhaconverte_action')  # Define um nome para a ação

        # Adiciona a ação "Gerar Gráficos 2D com Taludes" ao submenu "Projetos"
        self.malha_creation_submenu.addAction(self.malhaconverte_action)

        # Rasterizar Malha
        icon_path_rasterizarmalha = os.path.join(self.plugin_dir, 'icones', 'rasterizar.png')

        # Cria a ação "Rasterizar Malhas"
        self.rasterizarmalha_action = self.add_action(
            icon_path_rasterizarmalha,
            text=self.tr(u'Rasterizar Malha'),
            callback=self.run_rasterizarmalha,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_rasterizar_malha'),
            parent=self.iface.mainWindow())
        self.rasterizarmalha_action.setObjectName('rasterizarmalha_action')  # Define um nome para a ação

        # Adiciona a ação "Gerar Gráficos 2D com Taludes" ao submenu "Projetos"
        self.malha_creation_submenu.addAction(self.rasterizarmalha_action)

        # OPERAÇÕES COM LINHAS
        icon_path_operacoeslinhas = os.path.join(self.plugin_dir, 'icones', 'linhasop.png')

        # Cria a ação "Polígono para Linhas"
        self.operacoeslinhas_action = self.add_action(
            icon_path_operacoeslinhas,
            text=self.tr(u'Operações Sobre Linhas'),
            callback=self.run_operacoeslinhas,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_operacoeslinhas'),
            parent=self.iface.mainWindow())
        self.operacoeslinhas_action.setObjectName('operacoeslinhas_action')  # Define um nome para a ação

        # Adiciona a ação "Polígonos para Linha" ao submenu "Criação Vetorial"
        self.vectorial_creation_submenu.addAction(self.operacoeslinhas_action)

        # LINHAS DENTRO DE POLÍGONOS
        icon_path_dentrolinhas = os.path.join(self.plugin_dir, 'icones', 'dentrolinhas.png')

        # Cria a ação "Polígono para Linhas"
        self.dentrolinhas_action = self.add_action(
            icon_path_dentrolinhas,
            text=self.tr(u'Linhas Dentro de Polígonos'),
            callback=self.run_dentrolinhas,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_dentrolinhas'),
            parent=self.iface.mainWindow())
        self.dentrolinhas_action.setObjectName('dentrolinhas_action')  # Define um nome para a ação

        # Adiciona a ação "Polígonos para Linha" ao submenu "Criação Vetorial"
        self.vectorial_creation_submenu.addAction(self.dentrolinhas_action)

       # IMAGENS PARA KMZ
        icon_path_imagens = os.path.join(self.plugin_dir, 'icones', 'imgkmz.png')

        self.imagens_action = self.add_action(
            icon_path_imagens,
            text=self.tr(u'Imagens para KMZ'),
            callback=self.run_imagens_kmz,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_imagens_kmz'),
            parent=self.iface.mainWindow())
        self.imagens_action.setObjectName('imagens_action')  # Define um nome para a ação

        # Adiciona a ação "Imagens para KMZ" ao submenu "Criação de Camadas"
        self.vector_creation_submenu.addAction(self.imagens_action)

       # Carregar Camadas de Pontos XLS
        icon_path_pontos_xls = os.path.join(self.plugin_dir, 'icones', 'xlsods.png')

        self.pontos_xls_action = self.add_action(
            icon_path_pontos_xls,
            text=self.tr(u'Adicionar Camada de Pontos Excel'),
            callback=self.run_pontos_xls,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_pontos_xls'),
            parent=self.iface.mainWindow())
        self.pontos_xls_action.setObjectName('pontos_xls_action')  # Define um nome para a ação

        # Adiciona a ação "Imagens para KMZ" ao submenu "Criação de Camadas"
        self.vector_creation_submenu.addAction(self.pontos_xls_action)

       # Criar Camadas de Matrizes de vetores
        icon_path_matrizes = os.path.join(self.plugin_dir, 'icones', 'matrizes.png')

        self.matrizes_action = self.add_action(
            icon_path_matrizes,
            text=self.tr(u'Gerar Matrizes Vetoriais'),
            callback=self.run_matrizes,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_matrizes'),
            parent=self.iface.mainWindow())
        self.matrizes_action.setObjectName('matrizes_action')  # Define um nome para a ação

        # Adiciona a ação "Imagens para KMZ" ao submenu "Criação Vetorial"
        self.vectorial_creation_submenu.addAction(self.matrizes_action)

       # Criar Camadas de Geoprocessar Polígonos
        icon_path_geoprocessar_poligonos = os.path.join(self.plugin_dir, 'icones', 'geopoligono.png')

        self.geoprocessar_poligonos_action = self.add_action(
            icon_path_geoprocessar_poligonos,
            text=self.tr(u'Geoprocessamento de Polígonos'),
            callback=self.run_geoprocessar_poligonos,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_geoprocessar_poligonos'),
            parent=self.iface.mainWindow())
        self.geoprocessar_poligonos_action.setObjectName('geoprocessar_poligonos_action')  # Define um nome para a ação

        # Adiciona a ação "Imagens para KMZ" ao submenu "Criação Vetorial"
        self.vectorial_creation_submenu.addAction(self.geoprocessar_poligonos_action)

       # Criar Camadas para dimensionar vetores
        icon_path_dimensionar = os.path.join(self.plugin_dir, 'icones', 'dim.png')

        self.dimensionar_action = self.add_action(
            icon_path_dimensionar,
            text=self.tr(u'Dimensionamento de Vetores'),
            callback=self.run_dimensionar,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_dimensionar'),
            parent=self.iface.mainWindow())
        self.dimensionar_action.setObjectName('dimensionar_action')  # Define um nome para a ação

        # Adiciona a ação "Dimensionar Vetores" ao submenu "Criação Vetorial"
        self.vectorial_creation_submenu.addAction(self.dimensionar_action)

       # Criar Camadas de Notas
        icon_path_notas = os.path.join(self.plugin_dir, 'icones', 'notas.png')

        self.notas_action = self.add_action(
            icon_path_notas,
            text=self.tr(u'Gerar Notas Mecânicas'),
            callback=self.run_notas,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_notas'),
            parent=self.iface.mainWindow())
        self.notas_action.setObjectName('notas_action')  # Define um nome para a ação

        # Adiciona a ação "Dimensionar Vetores" ao submenu "Criação Vetorial"
        self.vectorial_creation_submenu.addAction(self.notas_action)

        # REDES DE DRENAGEM
        icon_path_redes_drenagem = os.path.join(self.plugin_dir, 'icones', 'drenagem.png')

        # Cria a ação "Gerar Redes de Drenagem"
        self.redes_drenagem_action = self.add_action(
            icon_path_redes_drenagem,
            text=self.tr(u'Gerar Redes de Drenagem'),
            callback=self.run_redes_drenagem,
            add_to_menu=False,
            add_to_toolbar=self.toolbar_manager.should_add_to_toolbar('add_to_toolbar_redes_drenagem'),
            parent=self.iface.mainWindow())
        self.redes_drenagem_action.setObjectName('redes_drenagem_action')  # Define um nome para a ação

        # Adiciona a ação "Gerar Gráficos 2D com Taludes" ao submenu "Projetos"
        self.projetos_creation_submenu.addAction(self.redes_drenagem_action)

        # Adiciona a ação "Gerenciar Camadas" no topo do menu 'Tempo Salvo Tools'
        self.custom_menu.insertAction(self.custom_menu.actions()[0] if self.custom_menu.actions() else None, self.plugin_action)

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item, icon from QGIS GUI, and cleans up the toolbar."""

        # 0) REMOVER DOCKS CRIADOS PELO PLUGIN (evita ficar registrado no painel)

        # se você criou um dock e guardou nele:
        dock = getattr(self, "gsDockWidget", None)
        if dock is not None:
            try:
                self.iface.removeDockWidget(dock)
            except Exception:
                # às vezes o QGIS já removeu
                pass
            dock.deleteLater()
            self.gsDockWidget = None

        # 1) SUAS AÇÕES (igual você já tinha)

        # Remove a ação 'Gerenciar Camadas' do menu 'Tempo Salvo Tools'
        if self.plugin_action:
            self.custom_menu.removeAction(self.plugin_action)
            # Remove a ação da barra de ferramentas
            self.iface.removeToolBarIcon(self.plugin_action)
            self.plugin_action = None

        # Remove a ação 'Grade UTM/GEO' do submenu 'Criação de Camadas'
        if self.grade_utm_geo_action:
            self.vector_creation_submenu.removeAction(self.grade_utm_geo_action)
            self.iface.removeToolBarIcon(self.grade_utm_geo_action)
            self.grade_utm_geo_action = None

        # Remove a ação 'Linha Poligonos' do submenu 'Criação Vetorial'
        if self.linha_poligono_action:
            self.vectorial_creation_submenu.removeAction(self.linha_poligono_action)
            self.iface.removeToolBarIcon(self.linha_poligono_action)
            self.linha_poligono_action = None

        # Remove a ação 'Fotos para KMZ' do submenu 'Criação de Camadas'
        if self.fotos_action:
            self.vector_creation_submenu.removeAction(self.fotos_action)
            self.iface.removeToolBarIcon(self.fotos_action)
            self.fotos_action = None

        # Remove a ação 'Gerar Curvas' do submenu 'Criação de Camadas'
        if self.curvas_action:
            self.raster_vetor_creation_submenu.removeAction(self.curvas_action)
            self.iface.removeToolBarIcon(self.curvas_action)
            self.curvas_action = None

        # Remove a ação 'Gerar setas sobre o MDT' do submenu 'Criação de Camadas'
        if self.setasraster_action:
            self.raster_vetor_creation_submenu.removeAction(self.setasraster_action)
            self.iface.removeToolBarIcon(self.setasraster_action)
            self.setasraster_action = None

        # Remove a ação 'Extrair Cotas de Raster' do submenu 'Criação de Camadas'
        if self.cotasraster_action:
            self.raster_vetor_creation_submenu.removeAction(self.cotasraster_action)
            self.iface.removeToolBarIcon(self.cotasraster_action)
            self.cotasraster_action = None

        # Remove a ação 'Poligono Linhas' do submenu 'Criação Vetorial'
        if self.poligono_linha_action:
            self.vectorial_creation_submenu.removeAction(self.poligono_linha_action)
            self.iface.removeToolBarIcon(self.poligono_linha_action)
            self.poligono_linha_action = None

        # Remove a ação 'Platô mdt' do submenu 'Projetos'
        if  self.plato_mdt_action:
            self.projetos_creation_submenu.removeAction(self.plato_mdt_action)
            self.iface.removeToolBarIcon(self.plato_mdt_action)
            self.plato_mdt_action = None

        # Remove a ação 'Calcular volume' do submenu 'Projetos'
        if self.volume_mdt_action:
            self.projetos_creation_submenu.removeAction(self.volume_mdt_action)
            self.iface.removeToolBarIcon(self.volume_mdt_action)
            self.volume_mdt_action = None

        # Remove a ação 'Criar Gráfico com Taludes' do submenu 'Projetos'
        if self.grafico_PyQt_action:
            self.projetos_creation_submenu.removeAction(self.grafico_PyQt_action)
            self.iface.removeToolBarIcon(self.grafico_PyQt_action)
            self.grafico_PyQt_action = None

        # Remove a ação 'Criar Gráfico Perfil' do submenu 'Projetos'
        if self.grafico_perfil_action:
            self.projetos_creation_submenu.removeAction(self.grafico_perfil_action)
            self.iface.removeToolBarIcon(self.grafico_perfil_action)
            self.grafico_perfil_action = None

        # Remove a ação 'Criar Gráfico Estruturas' do submenu 'Projetos'
        if self.grafico_estruturas_action:
            self.projetos_creation_submenu.removeAction(self.grafico_estruturas_action)
            self.iface.removeToolBarIcon(self.grafico_estruturas_action)
            self.grafico_estruturas_action = None

        # Remove a ação 'Criar Malha' do submenu 'Malhas'
        if self.malha_action:
            self.malha_creation_submenu.removeAction(self.malha_action)
            self.iface.removeToolBarIcon(self.malha_action)
            self.malha_action = None

        # Remove a ação 'Converter para Malha' do submenu 'Malhas'
        if self.malhaconverte_action:
            self.malha_creation_submenu.removeAction(self.malhaconverte_action)
            self.iface.removeToolBarIcon(self.malhaconverte_action)
            self.malhaconverte_action = None

        # Remove a ação 'Rasterizar Malha' do submenu 'Malhas'
        if self.rasterizarmalha_action:
            self.malha_creation_submenu.removeAction(self.rasterizarmalha_action)
            self.iface.removeToolBarIcon(self.rasterizarmalha_action)
            self.rasterizarmalha_action = None

        # Remove a ação 'Operações com Linhas' do submenu 'Criação Vetorial'
        if self.operacoeslinhas_action:
            self.vectorial_creation_submenu.removeAction(self.operacoeslinhas_action)
            self.iface.removeToolBarIcon(self.operacoeslinhas_action)
            self.operacoeslinhas_action = None

        # Remove a ação 'Gera Linhas dentro de Polígonos' do submenu 'Criação Vetorial
        if self.dentrolinhas_action:
            self.vectorial_creation_submenu.removeAction(self.dentrolinhas_action)
            self.iface.removeToolBarIcon(self.dentrolinhas_action)
            self.dentrolinhas_action = None

        # Remove a ação 'Imagens para KMZ' do submenu 'Criação de Camadas'
        if self.imagens_action:
            self.vector_creation_submenu.removeAction(self.imagens_action)
            self.iface.removeToolBarIcon(self.imagens_action)
            self.imagens_action = None

        # Remove a ação 'Pontos de XLS' do submenu 'Criação de Camadas'
        if self.pontos_xls_action:
            self.vector_creation_submenu.removeAction(self.pontos_xls_action)
            self.iface.removeToolBarIcon(self.pontos_xls_action)
            self.pontos_xls_action = None

        # Remove a ação 'Matrizes de Vetores' do submenu 'Criação Vetorial'
        if self.matrizes_action:
            self.vectorial_creation_submenu.removeAction(self.matrizes_action)
            self.iface.removeToolBarIcon(self.matrizes_action)
            self.matrizes_action = None

        # Remove a ação 'Geoprocessar Polígonos' do submenu 'Criação Vetorial'
        if self.geoprocessar_poligonos_action:
            self.vectorial_creation_submenu.removeAction(self.geoprocessar_poligonos_action)
            self.iface.removeToolBarIcon(self.geoprocessar_poligonos_action)
            self.geoprocessar_poligonos_action = None

        # Remove a ação 'Dimensionar Vetore' do submenu 'Criação Vetorial'
        if self.dimensionar_action:
            self.vectorial_creation_submenu.removeAction(self.dimensionar_action)
            self.iface.removeToolBarIcon(self.dimensionar_action)
            self.dimensionar_action = None

        # Remove a ação 'Gerar Notas' do submenu 'Criação Vetorial'
        if self.notas_action:
            self.vectorial_creation_submenu.removeAction(self.notas_action)
            self.iface.removeToolBarIcon(self.notas_action)
            self.notas_action = None

        # Remove a ação 'Gerar Redes de Drenagem' do submenu 'Projetos'
        if self.redes_drenagem_action:
            self.vectorial_creation_submenu.removeAction(self.redes_drenagem_action)
            self.iface.removeToolBarIcon(self.redes_drenagem_action)
            self.redes_drenagem_action = None

        # Remove as ações dos submenus e os próprios submenus do menu personalizado 'Tempo Salvo Tools'
        if self.custom_menu:
            submenus_to_remove = [
                self.vector_creation_submenu,
                self.vectorial_creation_submenu,
                self.malha_creation_submenu,
                self.raster_vetor_creation_submenu,
                self.projetos_creation_submenu]

            for submenu in submenus_to_remove:
                if submenu:
                    for action in submenu.actions():
                        submenu.removeAction(action)
                    self.custom_menu.removeAction(submenu.menuAction())

            if not self.custom_menu.actions():
                self.iface.mainWindow().menuBar().removeAction(self.custom_menu.menuAction())

        # Limpa as referências para evitar referências pendentes
        self.vector_creation_submenu = None
        self.vectorial_creation_submenu = None
        self.malha_creation_submenu = None
        self.raster_vetor_creation_submenu = None
        self.projetos_creation_submenu = None

        # Remove todas as ações adicionadas à barra de ferramentas
        for action in self.actions:
            self.iface.removeToolBarIcon(action)
            action.deleteLater()

        # Limpa a lista de ações
        self.actions = []

    def run_grade_utm_geo(self):
        """Executa a ação de abrir o diálogo Grade UTM/GEO."""
        if (not hasattr(self, "grade_utm_geo_dlg")
            or self.grade_utm_geo_dlg is None
            or sip.isdeleted(self.grade_utm_geo_dlg)):

            self.grade_utm_geo_dlg = GradeManager(self.iface.mainWindow())

        self.grade_utm_geo_dlg.show()
        self.grade_utm_geo_dlg.raise_()
        self.grade_utm_geo_dlg.activateWindow()

    def run_linha_poligono(self):
        """Executa a ação de abrir o diálogo Linha para Polígono."""
        if self.linha_poligono_dlg is None:
            self.linha_poligono_dlg = LinhaManager(self.iface, self.iface.mainWindow())
        if not self.linha_poligono_dlg.isVisible():
            self.linha_poligono_dlg.show()
        else:
            self.linha_poligono_dlg.raise_()
            self.linha_poligono_dlg.activateWindow()

    def run_fotos_kmz(self):
        """Executa a ação de abrir o diálogo Fotos para KMZ."""
        if self.fotos_kmz_dlg is None:
            self.fotos_kmz_dlg = FotosManager(self.iface.mainWindow())
        if not self.fotos_kmz_dlg.isVisible():
            self.fotos_kmz_dlg.show()
        else:
            self.fotos_kmz_dlg.raise_()
            self.fotos_kmz_dlg.activateWindow()

    def run_curvas(self):
        """Executa a ação de abrir o diálogo Gerar Curvas 3D."""
        if self.curvas_dlg is None:
            self.curvas_dlg = CurvasManager(self.iface.mainWindow())
        if not self.curvas_dlg.isVisible():
            self.curvas_dlg.show()
        else:
            self.curvas_dlg.raise_()
            self.curvas_dlg.activateWindow()

    def run_setasraster(self):
        """Executa a ação de abrir o diálogo Setas sobre o MDT."""
        if self.setasraster_dlg is None:
            self.setasraster_dlg = SetasManager(self.iface.mainWindow())
        if not self.setasraster_dlg.isVisible():
            self.setasraster_dlg.show()
        else:
            self.setasraster_dlg.raise_()
            self.setasraster_dlg.activateWindow()

    def run_cotasraster(self):
        """Executa a ação de abrir o diálogo Cotas sobre o MDT."""
        if self.cotasraster_dlg is None:
            self.cotasraster_dlg = CotasManager(self.iface.mainWindow())
        if not self.cotasraster_dlg.isVisible():
            self.cotasraster_dlg.show()
        else:
            self.cotasraster_dlg.raise_()
            self.cotasraster_dlg.activateWindow()

    def run_poligono_linha(self):
        """Executa a ação de abrir o diálogo converter polígnos para linhas"""
        if self.poligono_linha_dlg is None:
            self.poligono_linha_dlg = PoligonoManager(self.iface, self.iface.mainWindow())
        if not self.poligono_linha_dlg.isVisible():
            self.poligono_linha_dlg.show()
        else:
            self.poligono_linha_dlg.raise_()
            self.poligono_linha_dlg.activateWindow()

    def run_plato_mdt(self):
        """Executa a ação de abrir o diálogo do Platô."""
        if self.plato_mdt_dlg is None:
            self.plato_mdt_dlg = PlatoManager(self.iface.mainWindow())
        if not self.plato_mdt_dlg.isVisible():
            self.plato_mdt_dlg.show()
        else:
            self.plato_mdt_dlg.raise_()
            self.plato_mdt_dlg.activateWindow()

    def run_volume_mdt(self):
        """Executa a ação de abrir o diálogo para calcular volumes entre MDTs."""
        if self.volume_mdt_dlg is None:
            self.volume_mdt_dlg = VolumeManager(self.iface.mainWindow())
        if not self.volume_mdt_dlg.isVisible():
            self.volume_mdt_dlg.show()
        else:
            self.volume_mdt_dlg.raise_()
            self.volume_mdt_dlg.activateWindow()

    def run_grafico_PyQt(self):
        """Executa a ação de abrir o diálogo Gráfico com taludes."""
        if self.grafico_PyQt_dlg is None:
            self.grafico_PyQt_dlg = GraficoManager(self.iface.mainWindow())
        if not self.grafico_PyQt_dlg.isVisible():
            self.grafico_PyQt_dlg.show()
        else:
            self.grafico_PyQt_dlg.raise_()
            self.grafico_PyQt_dlg.activateWindow()

    def run_grafico_perfil(self):
        """Executa a ação de abrir o diálogo de gráfico de perfis."""
        if self.grafico_perfil_dlg is None:
            self.grafico_perfil_dlg = PerfilManager(self.iface.mainWindow())
        if not self.grafico_perfil_dlg.isVisible():
            self.grafico_perfil_dlg.show()
        else:
            self.grafico_perfil_dlg.raise_()
            self.grafico_perfil_dlg.activateWindow()

    def run_grafico_estruturas(self):
        """Executa a ação de abrir o diálogo do de cálculo de estruturas."""
        if self.grafico_estruturas_dlg is None:
            self.grafico_estruturas_dlg = EstruturasManager(self.iface.mainWindow())
        if not self.grafico_estruturas_dlg.isVisible():
            self.grafico_estruturas_dlg.show()
        else:
            self.grafico_estruturas_dlg.raise_()
            self.grafico_estruturas_dlg.activateWindow()

    def run_malha(self):
        """Executa a ação de abrir o diálogo de Malha"""
        if self.malha_dlg is None:
            # Passe a referência "self" (plugin) e iface para o MalhaManager
            self.malha_dlg = MalhaManager(self.iface, self, self.iface.mainWindow())
        if not self.malha_dlg.isVisible():
            self.malha_dlg.show()
        else:
            self.malha_dlg.raise_()
            self.malha_dlg.activateWindow()

    def run_malhaconverte(self):
        """Executa a ação de abrir o diálogo de converter Malha"""
        if self.malhaconverte_dlg is None:
            self.malhaconverte_dlg = MalhaConverteManager(self.iface.mainWindow())
        if not self.malhaconverte_dlg.isVisible():
            self.malhaconverte_dlg.show()
        else:
            self.malhaconverte_dlg.raise_()
            self.malhaconverte_dlg.activateWindow()

    def run_rasterizarmalha(self):
        """Executa a ação de abrir o diálogo de rasterizar Malha"""
        if self.rasterizarmalha_dlg is None:
            self.rasterizarmalha_dlg = RasterizarManager(self.iface.mainWindow())
        if not self.rasterizarmalha_dlg.isVisible():
            self.rasterizarmalha_dlg.show()
        else:
            self.rasterizarmalha_dlg.raise_()
            self.rasterizarmalha_dlg.activateWindow()

    def run_operacoeslinhas(self):
        """Executa a ação de abrir o diálogo para realiazar operações sobre linhas."""
        if self.operacoeslinhas_dlg is None:
            self.operacoeslinhas_dlg = LinhasManager(self.iface.mainWindow())
        if not self.operacoeslinhas_dlg.isVisible():
            self.operacoeslinhas_dlg.show()
        else:
            self.operacoeslinhas_dlg.raise_()
            self.operacoeslinhas_dlg.activateWindow()

    def run_dentrolinhas(self):
        """Executa a ação de abrir o diálogo para gerar linhas dentro de polígonos."""
        if self.dentrolinhas_dlg is None:
            self.dentrolinhas_dlg = DentroManager(self.iface.mainWindow())
        if not self.dentrolinhas_dlg.isVisible():
            self.dentrolinhas_dlg.show()
        else:
            self.dentrolinhas_dlg.raise_()
            self.dentrolinhas_dlg.activateWindow()

    def run_imagens_kmz(self):
        """Executa a ação de abrir o diálogo Imagens para KMZ."""
        if self.imagens_kmz_dlg is None:
            self.imagens_kmz_dlg = ImagensManager(self.iface.mainWindow())
        if not self.imagens_kmz_dlg.isVisible():
            self.imagens_kmz_dlg.show()
        else:
            self.imagens_kmz_dlg.raise_()
            self.imagens_kmz_dlg.activateWindow()

    def run_pontos_xls(self):
        """Executa a ação de abrir o diálogo Adicionar Camada Excel."""
        if self.camada_pontos_xls_dlg is None:
            self.camada_pontos_xls_dlg = CamadaManager(self.iface.mainWindow())
        if not self.camada_pontos_xls_dlg.isVisible():
            self.camada_pontos_xls_dlg.show()
        else:
            self.camada_pontos_xls_dlg.raise_()
            self.camada_pontos_xls_dlg.activateWindow()

    def run_matrizes(self):
        """Executa a ação de abrir o diálogo Gerar Matrizes de Vetores."""
        if self.matrizes_vetores_dlg is None:
            self.matrizes_vetores_dlg = MatrizManager(self.iface.mainWindow(), self.iface)
        if not self.matrizes_vetores_dlg.isVisible():
            self.matrizes_vetores_dlg.show()
        else:
            self.matrizes_vetores_dlg.raise_()
            self.matrizes_vetores_dlg.activateWindow()

    def run_geoprocessar_poligonos(self):
        """Executa a ação de abrir o diálogo Gerar Geoprocessar Polígonos."""
        if self.geoprocessar_poligonos_dlg is None:
            self.geoprocessar_poligonos_dlg = GeoPoligonosManager(self.iface.mainWindow())
        if not self.geoprocessar_poligonos_dlg.isVisible():
            self.geoprocessar_poligonos_dlg.show()
        else:
            self.geoprocessar_poligonos_dlg.raise_()
            self.geoprocessar_poligonos_dlg.activateWindow()

    def run_dimensionar(self):
        """Executa a ação de abrir o diálogo Dimensionar Vetores."""
        if self.dimensionar_vetores_dlg is None:
            self.dimensionar_vetores_dlg = DimensionarVetores(self.iface.mainWindow())
        if not self.dimensionar_vetores_dlg.isVisible():
            self.dimensionar_vetores_dlg.show()
        else:
            self.dimensionar_vetores_dlg.raise_()
            self.dimensionar_vetores_dlg.activateWindow()

    def run_notas(self):
        """Executa a ação de abrir o diálogo Gerar Notas."""
        if self.notas_dlg is None:
            self.notas_dlg = NotaMecanicas(self.iface, self.iface.mainWindow())
        if not self.notas_dlg.isVisible():
            self.notas_dlg.show()
        else:
            self.notas_dlg.raise_()
            self.notas_dlg.activateWindow()

    def run_redes_drenagem(self):
        """Executa a ação de abrir o diálogo do de cálculo de estruturas."""
        if self.redes_drenagem_dlg is None:
            self.redes_drenagem_dlg = RedesDrenagem(self.iface.mainWindow())
        if not self.redes_drenagem_dlg.isVisible():
            self.redes_drenagem_dlg.show()
        else:
            self.redes_drenagem_dlg.raise_()
            self.redes_drenagem_dlg.activateWindow()

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start:
            self.first_start = False

        # Configura a janela do diálogo com botão de minimizar
        self.dlg.setWindowFlags(self.dlg.windowFlags() | Qt.Window | Qt.WindowMinimizeButtonHint)

        # Show the dialog non-modally
        self.dlg.show()
        self.dlg.raise_()
        self.dlg.activateWindow()