# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TellaeServicesDialog
                                 A QGIS plugin
 Access Tellae services from QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-04-02
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Tellae
        email                : contact@tellae.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import traceback

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtGui import QIcon, QPixmap
from qgis.core import Qgis

from tellae.tellae_store import TELLAE_STORE

from tellae.panels import LayersPanel, FlowsPanel, NetworkPanel, ConfigPanel, AboutPanel
from tellae.utils.utils import log

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), "main_window.ui"))


class TellaeServicesDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(TellaeServicesDialog, self).__init__(parent)

        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.set_menu_icons()

        self.layers_panel = LayersPanel(self)
        self.flows_panel = FlowsPanel(self)
        self.network_panel = NetworkPanel(self)
        self.config_panel = ConfigPanel(self)
        self.about_panel = AboutPanel(self)

        self.progress_count = 0

        self.set_menu_icons()

    # dialog setup

    def setup(self):

        # progress bar starts hidden with no message
        self._set_progress_bar(False)
        self.progress_text.setText("")

        # tabs management
        self.menu_widget.setCurrentRow(0)
        self.stacked_panels_widget.setCurrentIndex(0)
        self.menu_widget.currentRowChanged["int"].connect(TELLAE_STORE.set_tab)

        # panels setup
        self.layers_panel.setup()
        self.flows_panel.setup()
        self.network_panel.setup()
        self.config_panel.setup()
        self.about_panel.setup()

    def set_menu_icons(self):
        item = self.menu_widget.item(0)
        path = TELLAE_STORE.plugin_dir + "/icons/layers_40dp_000000.svg"
        icon = QIcon(path)
        item.setIcon(icon)

        item = self.menu_widget.item(1)
        path = TELLAE_STORE.plugin_dir + "/icons/sync_alt_40dp_000000.svg"
        icon = QIcon(path)
        item.setIcon(icon)

        item = self.menu_widget.item(2)
        path = TELLAE_STORE.plugin_dir + "/icons/directions_bus_40dp_000000.svg"
        icon = QIcon(path)
        item.setIcon(icon)

        item = self.menu_widget.item(3)
        path = TELLAE_STORE.plugin_dir + "/icons/settings_40dp_000000.svg"
        icon = QIcon(path)
        item.setIcon(icon)

        item = self.menu_widget.item(4)
        path = TELLAE_STORE.plugin_dir + "/icons/info_40dp_000000.svg"
        icon = QIcon(path)
        item.setIcon(icon)

    # primitives

    def message_bar_from_exception(self, exc):
        """
        Display snackbar and logs from the given exception.

        :param exc: Exception subclass
        """

        # display exception message in snackbar
        self.display_message_bar(str(exc), level=Qgis.MessageLevel.Critical)

        # log exception message
        log(str(exc), Qgis.MessageLevel.Critical)

        # log exception trace
        log(str(traceback.format_exc()), Qgis.MessageLevel.Critical)

    def display_message_bar(
        self,
        title: str,
        message: str = None,
        level: Qgis.MessageLevel = Qgis.MessageLevel.Info,
        duration: int = 5,
        # more_details: str = None,
        # open_logs: bool = False
    ):
        """Display a message.

        :param title: Title of the message.
        :type title: basestring

        :param message: The message.
        :type message: basestring

        :param level: A QGIS error level.

        :param duration: Duration in second.
        :type duration: int

        :param open_logs: If we need to add a button for the log panel.
        :type open_logs: bool

        :param more_details: The message to display in the "More button".
        :type more_details: basestring
        """
        widget = self.message_bar.createMessage(title, message)

        # if more_details or open_logs:
        #     # Adding the button
        #     button = QtWidgets.QPushButton(widget)
        #     widget.layout().addWidget(button)
        #
        #     if open_logs:
        #         button.setText('Open log panel')
        #         # noinspection PyUnresolvedReferences
        #         button.pressed.connect(
        #             lambda: open_log_panel())
        #     else:
        #         button.setText(tr('More details'))
        #         # noinspection PyUnresolvedReferences
        #         button.pressed.connect(
        #             lambda: QMessageBox.information(None, title, more_details))

        self.message_bar.pushWidget(widget, level, duration)

    def start_progress(self, message):
        """
        Start a progress display with the given message.

        :param message: message to display on top of the progress bar
        """
        # update count
        self.progress_count += 1

        # activate progress bar
        self._set_progress_bar(True)

        # set progress text
        self.progress_text.setText(message)

    def end_progress(self):
        """
        End a progress and update progress bar.
        """
        # update count
        self.progress_count -= 1

        if self.progress_count == 0:

            # deactivate progress bar
            self._set_progress_bar(False)

            # set progress text
            self.progress_text.setText("")

    def _set_progress_bar(self, visible: bool):
        """
        Direct management of the progress bar.

        :param visible: progress bar boolean
        """
        if visible:
            self.progress_bar.setRange(0, -0)
            self.progress_bar.setValue(-1)
        else:
            self.progress_bar.setRange(0, 100)
            self.progress_bar.setValue(0)
