# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TellaeServicesDialog
                                 A QGIS plugin
 Access Tellae services from QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-04-02
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Tellae
        email                : contact@tellae.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import traceback

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.PyQt.QtWidgets import QTableWidget, QTableWidgetItem, QPushButton
from qgis.PyQt.QtCore import Qt

from tellae.tellae_store import TELLAE_STORE
from tellae.models.layers import create_layer
from tellae.utils import *

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "tellae_services_dialog_base.ui")
)


class TellaeServicesDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(TellaeServicesDialog, self).__init__(parent)

        self.selected_theme = "Tous"
        self.layers = []

        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # progress bar starts hidden
        self.progressBar.hide()

    def set_auth_button_text(self, user):
        if user is None:
            text = "Login"
        else:
            text = f'{user["firstName"]} {user["lastName"]}'

        self.authButton.setText(text)

    def display_message(self, message: str):
        self.message.setText(message)

    def set_progress_bar(self, visible: bool):
        if visible:
            self.progressBar.show()
        else:
            self.progressBar.hide()

    def create_theme_selector(self):
        # set list of layers
        self.themeSelector.addItems(["Tous"] + TELLAE_STORE.themes)

        # set default selection to "all"
        self.themeSelector.setCurrentText("Tous")

        # add listener on update event
        self.themeSelector.currentTextChanged.connect(self.update_theme)

    def update_theme(self, new_theme):
        # update selected theme
        self.selected_theme = new_theme

        # update layers table
        self.set_layers_table()

    def set_layers_table(self):
        # get table widget
        table = self.tableWidget

        # get list of layers to display
        self.layers = TELLAE_STORE.get_filtered_layer_summary(self.selected_theme)
        table.setRowCount(len(self.layers))

        # setup table headers
        # total table length is 721, scroll bar is 16 => header width must total to 705
        headers = [
            {"text": "Nom", "value": lambda x: x["name"]["fr"], "width": 285},
            {
                "text": "Date",
                "value": lambda x: TELLAE_STORE.datasets_summary[x["main_dataset"]].get("date", ""),
                "width": 80,
                "align": Qt.AlignCenter,
            },
            {
                "text": "Source",
                "value": lambda x: TELLAE_STORE.datasets_summary[x["main_dataset"]][
                    "provider_name"
                ],
                "width": 280,
            },
            {"text": "Actions", "value": "actions", "width": 60},
        ]
        table.setColumnCount(len(headers))
        table.setHorizontalHeaderLabels([header["text"] for header in headers])
        for col, header in enumerate(headers):
            if "width" in header:
                table.setColumnWidth(col, header["width"])

        # populate table cells
        for row, layer in enumerate(self.layers):
            for col, header in enumerate(headers):
                # create a table cell
                cell = QTableWidgetItem()

                # evaluate its content depending on the row and column
                if callable(header["value"]):
                    text = header["value"](layer)
                elif header["value"] == "actions":
                    btn = QPushButton(table)
                    btn.setText("Add")
                    btn.clicked.connect(lambda state, x=row: self.add_layer(x))
                    table.setCellWidget(row, col, btn)
                    continue
                else:
                    text = layer[header["value"]]

                # set cell text and tooltip
                cell.setText(text)
                cell.setToolTip(text)

                # set text alignment
                if "align" in header:
                    cell.setTextAlignment(header["align"])

                # put the cell in the table
                table.setItem(row, col, cell)

        # disable table edition
        table.setEditTriggers(QTableWidget.NoEditTriggers)

    def add_layer(self, index):
        layer_item = self.layers[index]
        layer_name = layer_item.get("name", dict()).get("fr", "Unnamed")

        try:
            qgs_kite_layer = create_layer(layer_item)
            qgs_kite_layer.add_to_qgis()

        except Exception as e:
            self.signal_end_of_layer_add(layer_name, e)

    def start_layer_download(self, layer_name):
        self.display_message(
            f"Téléchargement de la couche '{layer_name}'..."
        )
        self.set_progress_bar(True)

    def signal_end_of_layer_add(self, layer_name, exception=None):
        # display result message
        if exception is None:
            message = f"La couche '{layer_name}' a été ajoutée avec succès !"
        else:
            log(f"An error occured during layer add: {exception.__repr__()}")
            # log(str(traceback.format_exc()))
            # evaluate message depending on exception type
            try:
                raise exception
            # min zoom not respected
            except MinZoomException:
                message = f"Vous devez zoomer pour charger la couche '{layer_name}'"
            # network error message
            except RequestsException as e:
                message = f"Erreur lors du téléchargement de la couche '{layer_name}'"
            except NotImplementedError:
                message = f"La couche '{layer_name}' nécessite des fonctionalités non implémentées pour le moment"
            # generic error message
            except Exception:
                message = f"Erreur lors de l'ajout de la couche '{layer_name}'"
        self.display_message(message)

        # remove loader
        self.set_progress_bar(False)


