import cmath
import math

def qlrps(fmhz, zsys, en0, ipol, eps, sgm):
    """
    General preparatory subroutine as in Section 41 by Hufford (see references/itm.pdf).
    Parameters
    ----------
    fmhz : Carrier frequency.
    en0 : Surface refractivity reduced to sea level.
    zsysz : General system elevation.
    eps : Polarization.
    sgm : Ground constants.
    wn : Wave number
    ens : Surface refractivity.
    gme : Effective earth curvature.
    zgnd : Surface impedance.
    """
    gma = 1.567461259557405171406214141948e-7 #1/GeoCoord.R
    wn = fmhz / 47.7
    ens = en0
    if zsys != 0: ens = ens * math.exp(-zsys / 9460.)
    gme = gma * (1 - 0.04665 * math.exp(ens / 179.3))
    zq = complex(eps, 376.62 * sgm / wn)
    zgnd = cmath.sqrt(zq - 1)
    if ipol != 0: zgnd = zgnd / zq
    return wn, gme, ens, zgnd
