# -*- coding: utf-8 -*-
import os,csv
class Setup(object):
    def __init__(self,newFilename):
        self.Filename=""
        self.Keys=[]
        if os.path.exists(newFilename):
            self.Filename=newFilename
            with open(self.Filename,newline="",encoding="cp1250") as csvfile:
                for row in csv.DictReader(csvfile,["key","value"],dialect="excel-tab"):
                    self.Keys.append(dict(row))
    def findKey(self,thisKey):
        for k in self.Keys:
            if k["key"]==thisKey:
                return k
        return None    
    def GetValue(self,Key,Create,DefaultValue):
        s=self.findKey(Key)
        if s==None:
            if Create==True:
                self.SetValue(Key,DefaultValue,Create)
            return DefaultValue
        return s["value"]
    def SetValue(self,Key,newValue,Create):
        s=self.findKey(Key)
        if s==None:
            if Create==True:
                self.Keys.append({"key":Key,"value":newValue})
                return newValue
        return s["value"]
    def Save(self):
        with open(self.Filename,"w",newline="",encoding="cp1250") as csvfile:
            sw=csv.DictWriter(csvfile,["key","value"],dialect="excel-tab")
            sw.writerows(self.Keys)
#setup=Setup("c:/Users/Lakatos Tamás/AppData/Roaming/QGIS/QGIS3/profiles/default/python/plugins/teledeluxe/TeleDeLuxe.ini")
#print(setup.GetValue("Sztár",False,"Én"))
#print(setup.GetValue("Sztár1",True,"Én"))
#setup.Save()
