# -*- coding: utf-8 -*-
import codecs
from TeleDeLuxe.Fejlec import Fejlec
import TeleDeLuxe.GeoCoord
import os
from TeleDeLuxe.LAA import LAA
import numpy as np
import math
class LBA(object):
    """LBA rádió mérési eredményfájl"""
    class LBAMeres(object):
        """LBA record"""
        class BVS(object):
            EMonoStereo=["Mono","Stereo"]
            def __init__(self):
                self.BVS=[LAA.LAAMeres.BVS(),LAA.LAAMeres.BVS()]        
        def __init__(self):
            self.Polarizacio = ""   #A mérés antennapolarizációja
            self.Ofszet = np.nan    #Frekvencia ofszet
            self.E = np.nan         #Térerősség
            self.Irany = np.nan     #Az mérés iránya É-hoz képest
            self.Szubjektiv = ""    #Szubjektív minőség
            self.Nemzetiseg = ""    #Az adóállomás nemzetisége
            self.Telephely = ""     #Az adóállomás telephelye
            self.Musor = ""         #Az adóállomás műsora
            self.Megjegyzes = ""
            self.Frekvencia = np.nan
            self.Mono = False       #True=Monó adás, False= sztereó adás
            self.Loket = np.nan     #Frekvencialöket
            self.Savszelesseg = np.nan    #Mért sávszélesség
            self.RDS = ""           #PI kód
            self.LBABVS=self.BVS()       #0.=Monó, 1.=Sztereó BVS
        def Ch(self):
            return (self.Frekvencia - 87.5) * 10
    class _Intermodulacio(object):
        def __init__(self, newf1, newf2, newTermek):
            self.f1 = newf1
            self.f2 = newf2
            self.Termek = newTermek
    def __init__(self, newPath, newFejlec = None):
        if newFejlec is None:
            self.Fejlec = Fejlec()
        else:
            self.Fejlec = newFejlec
        self.LBAMeres = []
        self._Path = newPath
        self.Nagyvaros=False
        self.Varos=False
        if self.Fejlec!=None:
            self.Nagyvaros = (self.Fejlec.Falunev == "Budapest")
            self.Varos = (self.Fejlec.Beepitettseg == 1)
    def Save(self,OverWrite, CreateBAK = False):
        """
        Az eredményfájl mentése.
        'Path Az eredményfájl útvonala. "\" a végére nem kell!
        'EditMode Javítás üzemmódkapcsoló. Az adott koordinátához tartozó nevű fájl kezelése más:
        '   True = .BAK kiterjesztésűre átnevezi. False = felülírja
        'return A mentett eredményfájl neve.
        'A fájl elnevezési szabálya: EOVx majd EOVy első négy karaktere xxxxyyyy.LB?
        """
        kit = ".LB"
        if os.path.exists(self._Path):
            a = ""
            if (self.Filename == "") or not OverWrite:
                a = self.Fejlec.FileName()
                fis = [l for l in os.listdir(self._Path) if (l[:11] == a + kit) and (len(l) == 12)]
                if len(fis) == 0:
                   self.Filename = a + kit + "A"
                else:
                    self.Filename = a + kit + chr(ord(fis[-1][-1]) + 1)
            a = os.path.join(self._Path,self.Filename)
            if CreateBAK and os.path.exists(a):
                import shutil
                shutil.copy(a, a + ".BAK")
            try:
                with codecs.open(a,'w',encoding='cp1250') as sw:
                    self.Fejlec.SaveToStream(sw)
                    for mer in self.LBAMeres:
                        q = "{0:6.2f}".format(mer.Frekvencia)
                        q += mer.Polarizacio
                        if np.isnan(mer.Ofszet): q+="     "
                        else: q += "{0:5.0f}".format(mer.Ofszet)
                        q += "{0:5.1f}".format(mer.E)
                        if np.isnan(mer.Loket): q+="   "
                        else: q += "{0:3.0f}".format(mer.Loket)
                        q += "{0:3}".format(mer.Irany)
                        if mer.Mono: q+="M"
                        else: q+="S"
                        if np.isnan(mer.Savszelesseg): q+="     "
                        else: q += "{0:5.1f}".format(mer.Savszelesseg)
                        q += "{0:3}".format(mer.Szubjektiv)
                        q += "{0:4}".format(mer.RDS) + "     "
                        q += "{0:3}".format(mer.Nemzetiseg)
                        q += mer.Telephely[:20].ljust(20)
                        q += mer.Musor[:10].ljust(10)
                        q += mer.Megjegyzes
                        if q != "": sw.write(q + '\r\n')
            finally:
                pass
    def azonosva(self, frkul, interindex):
        ava = [[28., 12., 6., -7., -20.], [37., 25., 7., -7., -20.]]
        return ava[interindex][int(math.fabs(frkul * 10.))]
    def jarved(self, irkul, polh, polz):
        if polh == polz:
            ik = math.fabs(irkul)
            if irkul > 180.: ik = 360. - ik
            if (ik>=0.) and (ik<27.):
                return 0
            elif (ik>=27.) and (ik<60.):
                return -0.36 * ik + 9.6
            else: return -12.
        return -10.
    def Emin(self, Sztereo):
        """
        Minimális térerősség számítása.
        Sztereo üzemmód beállítása.
        return A minimális térerősség dBuV/m-ben.
        Figyelembe veszi a Nagyvárosi és Városi beépítettséget.
        """
        if self.Nagyvaros:
            if Sztereo: return 74.
            else: return 70.
        if self.Varos:
            if Sztereo: return 66.
            else: return 60.
        if Sztereo: return 54.
        else: return 48.
    def Intermodulacio(self):
        """
        _Intermodulacio listát ad vissza
        """
        imer=[]
        for merlev in self.LBAMeres:
            if merlev.E>=80:
                for mertel in self.LBAMeres:
                    if (merlev.Telephely==mertel.Telephely) and (merlev.Frekvencia!=mertel.Frekvencia):
                        termek=2.*merlev.Frekvencia-mertel.Frekvencia
                        for mer in self.LBAMeres:
                            if mer.Frekvencia==termek:
                                imer.append(self._Intermodulacio(merlev,mertel,mer))

        #Dim merlevel = From mer In LBAMeres Where mer.E >= 80 Group By mer.Telephely Into Group, Count()
        #For Each mertel In merlevel
        #    If mertel.Count > 1 Then
        #        Dim qmer = From mer In LBAMeres Where mer.Telephely = mertel.Telephely
        #        For fi1 = 0 To qmer.Count - 1
        #            For fi2 = fi1 + 1 To qmer.Count - 1
        #                For Each termek In LBAMeres
        #                    If 2 * qmer(fi1).Frekvencia - qmer(fi2).Frekvencia = termek.Frekvencia Then imer.Add(New Class_Intermodulacio(qmer(fi1), qmer(fi2), termek))
        #                Next
        #            Next
        #        Next
        #    End If
        #Next
        return imer
    def BVSszamitas(self):
        """
        BVS ellátottsági értékelés.
        A BVS objektumot frissíti, az értékelést minden csatornára elvégzi.
        """
        for keresendo in range(0,len(self.LBAMeres)):
            frh = self.LBAMeres[keresendo].Frekvencia
            polh = self.LBAMeres[keresendo].Polarizacio
            eh = self.LBAMeres[keresendo].E
            irh = self.LBAMeres[keresendo].Irany
            S = self.LBAMeres[keresendo].Szubjektiv[0]
            for j in range(0,2):
                va = 999.
                for i in range(0,len(self.LBAMeres)):
                    frz = self.LBAMeres[i].Frekvencia
                    if (math.fabs(frh - frz) <= 0.4) and (i != keresendo):
                        pva = 999.
                        polz = self.LBAMeres[i].Polarizacio
                        ez = self.LBAMeres[i].E
                        irz = self.LBAMeres[i].Irany
                        pva = self.azonosva(frh - frz, j)
                        if pva < 999:
                            pv = eh - ez - pva - self.jarved(irh - irz, polh, polz)
                            if pv < va: va = pv
                B = eh - self.Emin(j)
                self.LBAMeres[keresendo].LBABVS.BVS[j].B = B
                if va == 999: self.LBAMeres[keresendo].LBABVS.BVS[j].V = None
                else: self.LBAMeres[keresendo].LBABVS.BVS[j].V = va
                self.LBAMeres[keresendo].LBABVS.BVS[j].S = S
                self.LBAMeres[keresendo].LBABVS.BVS[j].Ellatott = (B >= 0) and (va >= 0) and (S >= 2)
    def set_Filename(self,Value):
        """
        Az eredményfájl neve.
        Value A beolvasandó eredményfájl neve útvonallal együtt.
        Nem létező vagy hibás fájl esetén a LBAMeresCount = 0.
        """
        if Value != "":
            self.Filename = Value
            s = os.path.join(self._Path,self.Filename)
            if os.path.exists(s):
                self.LBAMeres = []
                try:
                    with codecs.open(s,encoding='cp1250') as sr:
                        self.Fejlec.LoadFromStream(sr)
                        for s in sr:
                            if s != "":
                                qlbmeres = LBA.LBAMeres()
                                qlbmeres.Frekvencia = float(s[0:6])
                                qlbmeres.Polarizacio = s[6:7]
                                if s[7:12]!=u"     ": qlbmeres.Ofszet = float(s[7:12].strip())
                                qlbmeres.E = float(s[12:17].strip())
                                if s[17:20]!=u"   ": qlbmeres.Loket = float(s[17:20].strip())
                                qlbmeres.Irany = int(s[20:23].strip())
                                qlbmeres.Mono = s[23:24] == "M"
                                if s[24:29]!=u"     ": qlbmeres.Savszelesseg = float(s[24:29].strip())
                                qlbmeres.Szubjektiv = s[29:32].strip()
                                qlbmeres.RDS = s[32:36]
                                qlbmeres.Nemzetiseg = s[41:44].upper()
                                qlbmeres.Telephely = s[44:64].strip()
                                qlbmeres.Musor = s[64:74].strip()
                                qlbmeres.Megjegyzes = s[75:].strip().replace(",",".")
                                self.LBAMeres.append(qlbmeres)
                    self.BVSszamitas()
                finally:
                    pass
    def CreateMeres(self):
        qm = LBAMeres()
        self.LBAMeres.append(qm)
        return qm
    def LoadLast(self):
        kit = ".LB"
        if self.Filename == "":
            a = self.Fejlec.FileName
        #    Dim fis As New System.Collections.ObjectModel.ReadOnlyCollection(Of String)(My.Computer.FileSystem.GetFiles(Path, FileIO.SearchOption.SearchTopLevelOnly, {a + kit + "?"}))
        #    If fis.Count = 0 Then Filename = a + kit + "A" Else Filename = a + kit + Chr(Asc(Strings.Right(fis.Last, 1)))
        #Else
        #    Filename = pFilename
        #End If
