import numpy as np
class SG3DB:
    def __init__(self):
        # sg3db : structure containing
        #  - data from ITU-R SG3 databank file
        #  - data used for P1546Compute and P1812
        self.MeasurementFolder=""
        self.MeasurementFileName=""
        self.first_point_transmitter=1
        self.coveragecode=np.array([])
        self.h_ground_cover=np.array([])
        self.radio_met_code=np.array([])
        self.TxRxDistance=[]
        self.TxSiteName=""
        self.TxLAT=[]
        self.TxLON=[]
        self.RxLAT=[]
        self.RxLON=[]
        self.N0=[]
        self.DN=[]
        self.RxSiteName=""
        self.TxCountry=""
        self.x=np.array([])
        self.h_gamsl=np.array([])
        self.frequency=np.array([])
        self.hTx=np.array([])
        self.hTxeff=np.array([])
        self.hRx=np.array([])
        self.polHVC=np.array([])
        self.TxdBm=np.array([])
        self.MaxLb=np.array([])
        self.Txgn=np.array([])
        self.Rxgn=np.array([])
        self.RxAntDO=np.array([])
        self.ERPMaxHoriz=np.array([])
        self.ERPMaxVertical=np.array([])
        self.ERPMaxTotal=np.array([])
        self.HRPred=np.array([])
        self.TimePercent=np.array([])
        self.LwrFS=np.array([])
        self.MeasuredFieldStrength=np.array([])
        self.BasicTransmissionLoss=np.array([])
        self.RxHeightGainGroup=np.array([])
        self.IsTopHeightInGroup=np.array([])
        self.RxHeightGainGroup=np.array([])
        self.IsTopHeightInGroup=np.array([])

        self.debug=0
        self.pathinfo=0
        self.fid_log=0
        self.TransmittedPower=np.array([])
        self.LandPath=0
        self.SeaPath=0
        self.ClutterCode=[]
        self.userChoiceInt=[]
        self.RxClutterCodeP1546=""
        self.RxClutterHeight=[]
        self.TxClutterHeight=[]
        self.PredictedFieldStrength=[]
        self.q=50
        self.heff=[]
        self.Ndata=[]
        self.eff1=[]
        self.tca=[]
    def __str__(self):
        userChoiceInt=self.userChoiceInt
        out="The following input data is defined:"+"\n"
        out=out+" PTx           ="+str(self.TransmittedPower[userChoiceInt])+"\n"
        out=out+" f             ="+str(self.frequency[userChoiceInt])+"\n"
        out=out+" t             ="+str(self.TimePercent[userChoiceInt])+"\n"
        out=out+" q             ="+str(self.q)+"\n"
        out=out+" heff          ="+str(self.heff)+"\n"
        out=out+" area          ="+str(self.RxClutterCodeP1546)+"\n"
        out=out+" pathinfo      ="+str(self.pathinfo)+"\n"
        out=out+" h2            ="+str(self.hRx[userChoiceInt])+"\n"
        out=out+" ha            ="+str(self.hTx[userChoiceInt])+"\n"
        out=out+" htter         ="+str(self.h_gamsl[0])+"\n"
        out=out+" hrter         ="+str(self.h_gamsl[-1])+"\n"
        out=out+" R1            ="+str(self.TxClutterHeight)+"\n"
        out=out+" R2            ="+str(self.RxClutterHeight)+"\n"
        out=out+" eff1          ="+str(self.eff1)+"\n"
        out=out+" eff2          ="+str(self.tca)+"\n"
        out=out+" debug         ="+str(self.debug)+"\n"
        # out=out+" fid_log       ="+str(self.fid_log           )+"\n"
        out=out+" Predicted Field Strength       ="+str(self.PredictedFieldStrength)+"\n"
        return out
    def update(self, other):
        self.MeasurementFolder=other.MeasurementFolder
        self.MeasurementFileName=other.MeasurementFileName
        self.first_point_transmitter=other.first_point_transmitter
        self.coveragecode=other.coveragecode
        self.h_ground_cover=other.h_ground_cover
        self.radio_met_code=other.radio_met_code
        self.TxRxDistance=other.TxRxDistance
        self.TxLAT=other.TxLAT
        self.TxLON=other.TxLON
        self.RxLAT=other.RxLAT
        self.RxLON=other.RxLON
        self.N0=other.N0
        self.DN=other.DN
        self.TxSiteName=other.TxSiteName
        self.RxSiteName=other.RxSiteName
        self.TxCountry=other.TxCountry
        self.coveragecode=other.coveragecode
        self.h_ground_cover=other.h_ground_cover
        self.radio_met_code=other.radio_met_code
        self.x=other.x
        self.h_gamsl=other.h_gamsl
        self.frequency=other.frequency
        self.hTx=other.hTx
        self.hTxeff=other.hTxeff
        self.hRx=other.hRx
        self.polHVC=other.polHVC
        self.TxdBm=other.TxdBm
        self.MaxLb=other.MaxLb
        self.Txgn=other.Txgn
        self.Rxgn=other.Rxgn
        self.RxAntDO=other.RxAntDO
        self.ERPMaxHoriz=other.ERPMaxHoriz
        self.ERPMaxVertical=other.ERPMaxVertical
        self.ERPMaxTotal=other.ERPMaxTotal
        self.HRPred=other.HRPred
        self.TimePercent=other.TimePercent
        self.LwrFS=other.LwrFS
        self.MeasuredFieldStrength=other.MeasuredFieldStrength
        self.BasicTransmissionLoss=other.BasicTransmissionLoss
        self.RxHeightGainGroup=other.RxHeightGainGroup
        self.IsTopHeightInGroup=other.IsTopHeightInGroup
        self.RxHeightGainGroup=other.RxHeightGainGroup
        self.IsTopHeightInGroup=other.IsTopHeightInGroup

        self.debug=other.debug
        self.pathinfo=other.pathinfo
        self.fid_log=other.fid_log
        self.TransmittedPower=other.TransmittedPower
        self.LandPath=other.LandPath
        self.SeaPath=other.SeaPath
        self.ClutterCode=other.ClutterCode
        self.userChoiceInt=other.userChoiceInt
        self.RxClutterCodeP1546=other.RxClutterCodeP1546
        self.RxClutterHeight=other.RxClutterHeight
        self.TxClutterHeight=other.TxClutterHeight
        self.PredictedFieldStrength=other.PredictedFieldStrength
        self.q=other.q
        self.heff=other.heff
        self.Ndata=other.Ndata
def read_sg3_measurements2(filename, fileformat):
    """
    sg3db=read_sg3_measurements2(filename,fileformat)
    This function reads the file <filename> from the ITU-R SG3 databank
    written using the format <fileformat> and returns output variables in the
    cell structure vargout.
    <filename> is a string defining the file in which the data is stored
    <fileformat> is the format with which the data is written in the file:
                   ='fryderyk_cvs' (implemented)
                   ='cvs'          (tbi)
                   ='xml'          (tbi)
    Output variable is a struct sg3db containing the following fields
    d              -distance between Tx and Rx
    Ef             -measured field strength at distance d
    f_GHz          -frequency in GHz
    Tx_AHaG_m      -Tx antenna height above ground in m
    RX_AHaG_m      -Rx antenna height above ground in m
    etc
    Author: Ivica Stevanovic, Federal Office of Communications, Switzerland
    Revision History:
    Date            Revision
    23MAY2016       Initial python version
    06SEP2013       Introduced corrections in order to read different
                    versions of .csv file (netherlands data, RCRCU databank and kholod data)
    22JUL2013       Initial version (IS)"""
    filename1=filename
    sg3db=SG3DB()
    #  read the file
    try:
        fid=open(filename1, "r")
    except:
        raise IOError("P1812: File cannot be opened: "+filename1)
    if fid == -1:
        return sg3db
    #    [measurementFolder, measurementFileName, ext]=fileparts(filename1)
    measurementFolder, measurementFileName=os.path.split(filename1)
    sg3db.MeasurementFolder=measurementFolder
    sg3db.MeasurementFileName=measurementFileName
    #
    if fileformat.find("Fryderyk_csv")!=-1:
        # case 'Fryderyk_csv'
        sg3db.first_point_transmitter=1
        sg3db.coveragecode=np.array([])
        sg3db.h_ground_cover=np.array([])
        sg3db.radio_met_code=np.array([])
        # read all the lines of the file
        lines=fid.readlines()
        fid.close()
        # strip all new line characters
        lines=[line.rstrip("\n") for line in lines]
        count=0
        while True:
            if count>=len(lines):
                break
            line=lines[count]
            dummy=line.split(",")
            if strcmp(dummy[0], "Tx LAT"):
                Tx_LAT_deg=float(dummy[1])
                sg3db.TxLAT=Tx_LAT_deg
            if strcmp(dummy[0], "Tx LON"):
                Tx_LON_deg=float(dummy[1])
                sg3db.TxLON=Tx_LON_deg
            if strcmp(dummy[0], "Rx LAT"):
                Rx_LAT_deg=float(dummy[1])
                sg3db.RxLAT=Rx_LAT_deg
            if strcmp(dummy[0], "Rx LON"):
                Rx_LON_deg=float(dummy[1])
                sg3db.RxLON=Rx_LON_deg
            if strcmp(dummy[0], "First Point Tx or Rx"):
                # if dummy[1].find('T')!=-1:
                if strcmp(dummy[1], "T"):
                    sg3db.first_point_transmitter=1
                else:
                    sg3db.first_point_transmitter=0
            if dummy[0].find("Tot. Path Length(km):")!=-1:
                TxRxDistance_km=float(dummy[1])
                sg3db.TxRxDistance=TxRxDistance_km
            if strcmp(dummy[0], "Tx site name:"):
                TxSiteName=dummy[1]
                sg3db.TxSiteName=TxSiteName
            if strcmp(dummy[0], "Rx site name:"):
                RxSiteName=dummy[1]
                sg3db.RxSiteName=RxSiteName
            if strcmp(dummy[0], "Tx Country:"):
                TxCountry=dummy[1]
                sg3db.TxCountry=TxCountry
            if strcmp(dummy[0], "Average annual values DN (N-units/km):"):
                DN=float(dummy[1])
                sg3db.DN=DN
            if strcmp(dummy[0], "Average annual sea-level surface refractivity No (N-units):"):
                N0=float(dummy[1])
                sg3db.N0=N0
            ## read the height profile
            if strcmp(dummy[0], "Number of Points:"):
                Npoints=int(dummy[1])
                sg3db.x=np.zeros((Npoints))
                sg3db.h_gamsl=np.zeros((Npoints))
                for i in range(0, Npoints):
                    count=count+1
                    readLine=lines[count]
                    dummy=readLine.split(",")
                    sg3db.x[i]=float(dummy[0])
                    sg3db.h_gamsl[i]=float(dummy[1])
                    if len(dummy)>2:
                        value=np.nan
                        if dummy[2]!="":
                            value=float(dummy[2])
                        sg3db.coveragecode=np.append(sg3db.coveragecode, value)
                        if (len(dummy))>3:
                            value=np.nan
                            if dummy[3]!="":
                                value=float(dummy[3])
                            sg3db.h_ground_cover=np.append(sg3db.h_ground_cover, value)
                            if (len(dummy))>4:
                                # Land=4, Coast=3, Sea=1
                                value=np.nan
                                if dummy[4]!="":
                                    value=float(dummy[4])
                                sg3db.radio_met_code=np.append(sg3db.radio_met_code, value)
            ## read the field strength
            if strcmp(dummy[0], "Frequency"):
                # read the next line that defines the units
                count=count+1
                readLine=lines[count]
                # the next line should be {Begin Measurements} and the one
                # after that the number of measurement records. However, in
                # the Dutch implementation, those two lines are missing.
                # and in the implementations of csv files from RCRU, {Begin
                # Mof Measurements} is there, but the number of
                # measurements (line after) may be missing
                # This is the reason we are checking for these two lines in
                # the following code
                f=np.array([])
                dutchflag=True
                count=count+1
                readLine=lines[count]
                if strcmp(readLine, "{Begin of Measurements"):
                    # check if the line after that contains only one number
                    # or the data
                    count=count+1
                    readLine=lines[count]  # the line with the number of records or not
                    dummy=readLine.split(",")
                    if len(dummy)>2:
                        # if isempty([dummy{2:end}])
                        if dummy[1:-1] == "":
                            # this is the number of data-the info we do
                            # not use, read another line
                            count=count+1
                            readLine=lines[count]
                            dutchflag=False
                        else:
                            dutchflag=True
                    else:
                        dutchflag=False
                        count=count+1
                        readLine=lines[count]
                # read all the lines until the {End of Measurements} tag
                kindex=0
                while True:
                    if kindex == 0:
                        # do not read the new line, but use the one read in
                        # the previous step
                        kindex=0
                    else:
                        count=count+1
                        readLine=lines[count]
                    if count>=len(lines):
                        break
                    if strcmp(readLine, "{End of Measurements}"):
                        break
                    dummy=readLine.split(",")
                    f=np.append(f, float(dummy[0]))
                    sg3db.frequency=np.append(sg3db.frequency, float(dummy[0]))
                    col=1
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.hTx=np.append(sg3db.hTx, value)
                    col=2
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.hTxeff=np.append(sg3db.hTxeff, value)
                    col=3
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.hRx=np.append(sg3db.hRx, value)
                    col=4
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.polHVC=np.append(sg3db.polHVC, value)
                    col=5
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.TxdBm=np.append(sg3db.TxdBm, value)
                    col=6
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.MaxLb=np.append(sg3db.MaxLb, value)
                    col=7
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.Txgn=np.append(sg3db.Txgn, value)
                    col=8
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.Rxgn=np.append(sg3db.Rxgn, value)
                    col=9
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.RxAntDO=np.append(sg3db.RxAntDO, value)
                    col=10
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.ERPMaxHoriz=np.append(sg3db.ERPMaxHoriz, value)
                    col=11
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.ERPMaxVertical=np.append(sg3db.ERPMaxVertical, value)
                    col=12
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.ERPMaxTotal=np.append(sg3db.ERPMaxTotal, value)
                    col=13
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.HRPred=np.append(sg3db.HRPred, value)
                    col=14
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    if np.isnan(value):
                        #Time percentage not defined. Default value 50% assumed.
                        value=50
                    sg3db.TimePercent=np.append(sg3db.TimePercent, value)
                    col=15
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.LwrFS=np.append(sg3db.LwrFS, value)
                    col=16
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.MeasuredFieldStrength=np.append(sg3db.MeasuredFieldStrength, value)
                    #
                    col=17
                    value=np.nan
                    if dummy[col]!="":
                        value=float(dummy[col])
                    sg3db.BasicTransmissionLoss=np.append(sg3db.BasicTransmissionLoss, value)
                    #
                    if len(dummy)>18:
                        col=18
                        value=np.nan
                        if dummy[col]!="":
                            value=float(dummy[col])
                        sg3db.RxHeightGainGroup=np.append(sg3db.RxHeightGainGroup, value)
                        col=19
                        value=np.nan
                        if dummy[col]!="":
                            value=float(dummy[col])
                        sg3db.IsTopHeightInGroup=np.append(sg3db.IsTopHeightInGroup, value)
                    else:
                        sg3db.RxHeightGainGroup=np.append(sg3db.RxHeightGainGroup, np.nan)
                        sg3db.IsTopHeightInGroup=np.append(sg3db.IsTopHeightInGroup, np.nan)
                    kindex=kindex+1
                # Number of different measured data sets
                Ndata=kindex
                sg3db.Ndata=Ndata
            count=count+1
    elif fileformat.find("csv")!=-1:
        print("csv format not yet implemented.")
    elif fileformat.find("xml")!=-1:
        print("xml format not yet implemented.")
    return sg3db
def strcmp(str1,str2):
    """
    This function compares two strings (by previously removing any white
    spaces and open/close brackets from the strings, and changing them to
    lower case).
    Author: Ivica Stevanovic, Federal Office of Communications, Switzerland
    Revision History:
    Date            Revision
    23MAY2016       Initial python version (IS)
    22JUL2013       Initial version (IS)
    """
    str1=str1.replace(" ", "")
    str2=str2.replace(" ", "")
    str1=str1.replace("(", "")
    str2=str2.replace("(", "")
    str1=str1.replace(")", "")
    str2=str2.replace(")", "")
    str1=str1.lower()
    str2=str2.lower()
    if str1.find(str2) == -1:
        return False
    else:
        return True
def clutter(i,ClutterCodeType):
    """
    ClutterClass, P1546ClutterClass, R=clutter(i, ClutterCode)
    This function maps the value i of a given clutter code type into
    the corresponding clutter class description, P1546 clutter class description
    and clutter height R.
    The implemented ClutterCodeTypes are:
    'OFCOM' (as defined in the SG3DB database on SUI data from 2012
    'TDB'   (as defined in the RCRU database and UK data) http://www.rcru.rl.ac.uk/njt/linkdatabase/linkdatabase.php
    'NLCD'  (as defined in the National Land Cover Dataset) http://www.mrlc.gov/nlcd06_leg.php
    'LULC'  (as defined in Land Use and Land Clutter database) http://transition.fcc.gov/Bureaus/Engineering_Technology/Documents/bulletins/oet72/oet72.pdf
    'GlobCover' (as defined in ESA's GlobCover land cover maps) http://due.esrin.esa.int/globcover/
    'DNR1812' (as defined in the implementation tests for DNR P.1812)
    'default' (land paths, rural area, R=10 m)
    Rev   Date        Author                          Description
    -------------------------------------------------------------------------------
    v3    24MAY16     Ivica St3vanovic, OFCOM         Initial python version
    v2    29Apr15     Ivica Stevanovic, OFCOM         Introduced 'default' option for ClutterCodeTypes
    v1    26SEP13     Ivica Stevanovic, OFCOM         Introduced it as a function
    """
    if strcmp(ClutterCodeType, "OFCOM"):
        if i == 0:
            RxClutterCode="Unknown"
        elif i == 1:
            RxClutterCode="Water (salt)"
        elif i == 2:
            RxClutterCode="Water (fresh)"
        elif i == 3:
            RxClutterCode="Road/Freeway"
        elif i == 4:
            RxClutterCode="Bare land"
        elif i == 5:
            RxClutterCode="Bare land/rock"
        elif i == 6:
            RxClutterCode="Cultivated land"
        elif i == 7:
            RxClutterCode="Scrub"
        elif i == 8:
            RxClutterCode="Forest"
        elif i == 9:
            RxClutterCode="Low dens. suburban"
        elif i == 10:
            RxClutterCode="Suburban"
        elif i == 11:
            RxClutterCode="Low dens. urban"
        elif i == 12:
            RxClutterCode="Urban"
        elif i == 13:
            RxClutterCode="Dens. urban"
        elif i == 14:
            RxClutterCode="High dens. urban"
        elif i == 15:
            RxClutterCode="High rise industry"
        elif i == 16:
            RxClutterCode="Skyscraper"
        else:
            RxClutterCode="Unknown data"
        if i == 8 or i == 12:
            RxP1546Clutter="Urban"
            R2external=15
        elif i == 1 or i == 2:
            RxP1546Clutter="Sea"
            R2external=10
        elif i<8 and i>2:
            RxP1546Clutter="Rural"
            R2external=10
        elif i<=11 and i>8:
            RxP1546Clutter="Suburban"
            R2external=10
        elif i<=16 and i>11:
            RxP1546Clutter="Dense Urban"
            R2external=20
        else:
            RxP1546Clutter=""
            R2external=[]
    elif strcmp(ClutterCodeType, "TDB"):
        if i == 0:
            RxClutterCode="No data"
            RxP1546Clutter=""
            R2external=[]
        elif i == 1:
            RxClutterCode="Fields"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 2:
            RxClutterCode="Road"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 3:
            RxClutterCode="BUILDINGS"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 4:
            RxClutterCode="URBAN"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 5:
            RxClutterCode="SUBURBAN"
            RxP1546Clutter="Suburban"
            R2external=10
        elif i == 6:
            RxClutterCode="VILLAGE"
            RxP1546Clutter="Suburban"
            R2external=10
        elif i == 7:
            RxClutterCode="SEA"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        elif i == 8:
            RxClutterCode="LAKE"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        elif i == 9:
            RxClutterCode="RIVER"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 10:
            RxClutterCode="CONIFER"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 11:
            RxClutterCode="NON_CONIFER"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 12:
            RxClutterCode="MUD"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 13:
            RxClutterCode="ORCHARD"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 14:
            RxClutterCode="MIXED_TREES"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 15:
            RxClutterCode="DENSE_URBAN"
            RxP1546Clutter="Dense Urban"
            R2external=30
        else:
            RxClutterCode="Unknown data"
            RxP1546Clutter=""
            R2external=[]
    elif strcmp(ClutterCodeType, "NLCD"):
        if i == 11:
            RxClutterCode="Open Water"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        elif i == 12:
            RxClutterCode="Perennial Ice/Snow"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 21:
            RxClutterCode="Developed, Open Space"
            RxP1546Clutter="Suburban"
            R2external=10
        elif i == 22:
            RxClutterCode="Developed, Low Intensity"
            RxP1546Clutter="Suburban"
            R2external=10
        elif i == 23:
            RxClutterCode="Developed, Medium Intensity"
            RxP1546Clutter="Suburban"
            R2external=10
        elif i == 24:
            RxClutterCode="Developed High Intensity"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 31:
            RxClutterCode="Barren Land (Rock/Sand/Clay)"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 41:
            RxClutterCode="Deciduous Forest"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 42:
            RxClutterCode="Evergreen Forest"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 43:
            RxClutterCode="Mixed Forest"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 51:
            RxClutterCode="Dwarf Scrub"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 52:
            RxClutterCode="Shrub/Scrub"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 71:
            RxClutterCode="Grassland/Herbaceous"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 72:
            RxClutterCode="Sedge/Herbaceous"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 73:
            RxClutterCode="Lichens-Alaska only"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 74:
            RxClutterCode="Moss-Alaska only"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 81:
            RxClutterCode="Pasture/Hay"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 82:
            RxClutterCode="Cultivated Crops"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 90:
            RxClutterCode="Woody Wetlands"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        elif i == 95:
            RxClutterCode="Emergent Herbaceous Wetlands"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        else:
            RxClutterCode="Unknown data"
            RxP1546Clutter=""
            R2external=[]
    elif strcmp(ClutterCodeType, "LULC"):
        if i == 11:
            RxClutterCode="Residential"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 12:
            RxClutterCode="Commercial services"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 13:
            RxClutterCode="Industrial"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 14:
            RxClutterCode="Transportation, communications, utilities"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 15:
            RxClutterCode="Industrial and commercial complexes"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 16:
            RxClutterCode="Mixed urban and built-up lands"
            RxP1546Clutter="Suburban"
            R2external=10
        elif i == 17:
            RxClutterCode="Other urban and built-up land"
            RxP1546Clutter="Suburban"
            R2external=10
        elif i == 21:
            RxClutterCode="Cropland and pasture"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 22:
            RxClutterCode="Orchards, groves, vineyards, nurseries, and horticultural"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 23:
            RxClutterCode="Confined feeding operations"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 24:
            RxClutterCode="Other agricultural land"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 31:
            RxClutterCode="Herbaceous rangeland"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 32:
            RxClutterCode="Shrub and brush rangeland"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 33:
            RxClutterCode="Mixed rangeland"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 41:
            RxClutterCode="Deciduous forest land"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 42:
            RxClutterCode="Evergreen forest land"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 43:
            RxClutterCode="Mixed forest land"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 51:
            RxClutterCode="Streams and canals"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        elif i == 52:
            RxClutterCode="Lakes"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        elif i == 53:
            RxClutterCode="Reservoirs"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        elif i == 54:
            RxClutterCode="Bays and estuaries"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        elif i == 61:
            RxClutterCode="Forested wetland"
            RxP1546Clutter="Urban"
            R2external=20
        elif i == 62:
            RxClutterCode="Non-forest wetland"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        elif i == 71:
            RxClutterCode="Dry salt flats"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 72:
            RxClutterCode="Beaches"
            RxP1546Clutter="Adjacent to Sea"
            R2external=10
        elif i == 73:
            RxClutterCode="Sandy areas other than beaches"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 74:
            RxClutterCode="Bare exposed rock"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 75:
            RxClutterCode="Strip mines, quarries, and gravel pits"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 76:
            RxClutterCode="Transitional areas"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 77:
            RxClutterCode="Mixed barren land"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 81:
            RxClutterCode="Shrub and brush tundra"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 82:
            RxClutterCode="Herbaceous tundra"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 83:
            RxClutterCode="Bare ground"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 84:
            RxClutterCode="Wet tundra"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 85:
            RxClutterCode="Mixed tundra"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 91:
            RxClutterCode="Perennial snowfields"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 92:
            RxClutterCode="Glaciers"
            RxP1546Clutter="Rural"
            R2external=10
        else:
            RxClutterCode="Unknown data"
            RxP1546Clutter=""
            R2external=[]
    elif strcmp(ClutterCodeType, "GlobCover"):
        if i == 1:
            RxClutterCode="Water/Sea"
            RxP1546Clutter="Sea"
            R2external=10
        elif i == 2:
            RxClutterCode="Open/Rural"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 3:
            RxClutterCode="Suburban"
            RxP1546Clutter="Suburban"
            R2external=10
        elif i == 4:
            RxClutterCode="Urban/trees/forest"
            RxP1546Clutter="Urban"
            R2external=15
        elif i == 5:
            RxClutterCode="Dense Urban"
            RxP1546Clutter="Dense Urban"
            R2external=20
        else:
            RxClutterCode="Unknown data"
            RxP1546Clutter=""
            R2external=[]
    elif strcmp(ClutterCodeType, "P1546"):
        if i == 1:
            RxClutterCode="Water/Sea"
            RxP1546Clutter="Sea"
            R2external=10
        elif i == 2:
            RxClutterCode="Open/Rural"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 3:
            RxClutterCode="Suburban"
            RxP1546Clutter="Suburban"
            R2external=10
        elif i == 4:
            RxClutterCode="Urban/trees/forest"
            RxP1546Clutter="Urban"
            R2external=15
        elif i == 5:
            RxClutterCode="Dense Urban"
            RxP1546Clutter="Dense Urban"
            R2external=20
        else:
            RxClutterCode="Unknown"
            RxP1546Clutter="Suburban"
            R2external=0
    elif strcmp(ClutterCodeType, "DNR1812"):
        if i == 0:
            RxClutterCode="Inland"
            RxP1546Clutter="Rural"
            R2external=10
        elif i == 1:
            RxClutterCode="Coastal"
            RxP1546Clutter="Sea"
            R2external=10
        elif i == 2:
            RxClutterCode="Sea"
            RxP1546Clutter="Sea"
            R2external=10
        else:
            RxClutterCode="Unknown data"
            RxP1546Clutter=""
            R2external=[]
    elif strcmp(ClutterCodeType, "default"):
        RxClutterCode="default"
        RxP1546Clutter="Rural"
        R2external=10
    else:
        RxClutterCode=""
        RxP1546Clutter=""
        R2external=[]
    return RxClutterCode, RxP1546Clutter, R2external
