# -*- coding: utf-8 -*-
import codecs
import matplotlib.pyplot as plt
import matplotlib.image as mpimg
from TeleDeLuxe.Fejlec import Fejlec
import TeleDeLuxe.GeoCoord
import os
import numpy as np
import math
import TeleDeLuxe.Math
class DVB(object):
    """LDA DVBt/t2 mérési eredményfájl"""
    class DVBMeres(object):
        """LDA record"""
        class Modulation:
            global Modulaciok
            Modulaciok = ["Unknown", "QPSK", "16QAM", "64QAM", "256QAM"]
            def __init__(self, newModulation = "Unknown"):
                self.__pModulation = 0
                self.set_asString(newModulation)
            def get_asString(self):
                return Modulaciok[self.__pModulation]
            def set_asString(self,value):
                self.__pModulation = Modulaciok.index(value)
            def get_Value(self):
                return self.__pModulation
            def set_Value(self,value):
                self.__pModulation = value
        def __init__(self):
            self.Recno = 0        #Rekord sorszáma
            self.T2 = False       #DVB-T2 üzemmód: DVB-T-nél false; DVB-T2-nél true
            self.Telephely = ""   #Az adóállomás telephelye
            self.Nemzetiseg = ""  #Az adóállomás nemzetisége
            self.MUX = ""         #Az adóállomás műsormultiplex jelölése
            self.Irany = 999      #A mérés iránya É-hoz képest
            self.Megjegyzes = ""

            self.HierAlpha = ""       #pl.: None csak T-nél
            self.CellId = ""          #Cella ID, csak T-nél
            self.CodeRateHP = ""      #pl.: 2/3, csak T-nél
            self.CodeRateLP = ""      #pl.: 2/3, csak T-nél
            self.PilotPattern = ""    #csak T2-nél: 1..8
            self.GraphCMER = ""       #Carrier MER Graph Data
            self.GraphFRes = ""       #Frequency Response Graph Data
            self.GraphIRes = ""       #Impulse Response Graph Data
            self.GraphSpectrum = ""   #+-1 Channel Spektrum képe

            self.berSigSync = ""      #BER mérés: Signal Syncron
            self.berStatus = ""       #BER mérés: Status BER mérésnél

            self.Pol = ""             #A mérés antennapolarizációja
            self.CP = np.NaN          #Channel Power dBm
            self.ACP = np.NAN         #Adjecent Channel Power dBm
            self.CNR = np.NAN         #Carrer Noise Ratio dB
            self.SNR = np.NAN         #Signal Noise Ratio dB
            self.BW = np.NAN          #Bandwidth MHz
            self.FE = np.NAN          #Frequency Error Hz
            self.NP = np.NAN          #Noise Power dBm
            self.Konstellacio = ""    #Konstellációs ábra fileneve
            self.MER = np.NAN         #Modulation Error Rate dB, T2 = MER L1 rms
            self.MERP = np.NAN        #csak T2 = MER PLP rms
            self.EVM = np.NAN         #Error Vector Magnitude dB
            self.CIR = ""             #Channel Impulse Response válasz képének fileneve
            self.BER = np.NAN         #BER Viterbi előtt, T2 = BERbLDPC
            self.E = np.NAN           #Térerősség
            self.E70 = np.NAN         #70%-os ellátottsághoz tartozó térerősség
            self.E95 = np.NAN         #95%-os ellátottsághoz tartozó térerősség
            self.Quality = 0          #Objektív minőség
            self.Szubjektiv = ""      #Szubjektív minőség

            self.Ch = 999             #Channel
            self.VBER = np.NaN        #BER Viterbi után = RS előtt, T2 - BERbBCH
            self.modeGI = ""         #pl.: 8K, 1/32
            self.Modulation = self.Modulation() #pl.: 64QAM
            self.CodeRate = ""      #pl.: 2/3, T2-nél PLP0 CodeRate
        def EminSzamol(self):
            if self.Modulation == 0: return
            if self.CodeRate == "": return
            if self.T2 and self.PilotPattern == "": return
            if self.T2:
                #1.QPSK,16QAM,64QAM,256QAM
                #2.1/2,3/5,2/3,3/4,4/5,5/6
                CNTabla = np.array([[1, 2.2, 3.1, 4.1, 4.7, 5.2],
                         [6.2, 7.6, 8.9, 10, 10.8, 11.3],
                         [10.5, 12.3, 13.6, 15.1, 16.1, 16.7],
                         [14.4, 16.7, 18.1, 20, 21.3, 22]])
                dRice = np.array([[0.2, 0.2, 0.3, 0.3, 0.3, 0.4],
                       [0.2, 0.2, 0.2, 0.4, 0.4, 0.4],
                       [0.3, 0.3, 0.3, 0.3, 0.5, 0.4],
                       [0.4, 0.2, 0.3, 0.3, 0.4, 0.4]])
                PPTabla = np.array([2.5, 2.5, 2.1, 2.1, 1.6, 1.6, 1.4, 1.5])
                CNdegrad = np.array([0.07, 0.09, 0.11, 0.14, 0.18, 0.22, 0.28, 0.36, 0.46, 0.58, 0.75, 0.97, 1.26, 1.65, 2.2, 3.02, 4.33, 6.87])
                Echodegrad = np.array([1, 1.2, 1.4, 1.6, 1.8, 2])
                qcr = 2
                qmo = min(self.Modulation.get_Value(),4) - 1
                qcr = ["1/2","3/5","2/3","3/4","4/5","5/6"].index(self.CodeRate)
                qpp = min(max(self.PilotPattern,1),8) - 1
                CN15 = CNTabla[qmo,qcr] + PPTabla[qpp] + dRice[qmo,qcr] - 15
                CNindex = max(int(CN15),0)
                CNindex1 = min(int(CN15) + 1,17)
                
                self.E95 = round(CN15 + 15 + TeleDeLuxe.Math.LinReg(CNindex,CNdegrad[CNindex],CNindex1,CNdegrad[CNindex1],CN15) - 22.0518 + 20 * math.log10(self.Frekvencia()),1) #+ Echodegrad(qcr)
            else:
                #1.QPSK,16QAM,64QAM
                #2.1/2,2/3,3/4,5/6,7/8
                EmTabla = np.array([[34.9, 36.9, 38.1, 39.3, 40.3],
                         [40.6, 43.1, 44.7, 45.9, 46.5],
                         [46.2, 48.5, 50.2, 51.7, 52.7]])
                f = self.Frekvencia()
                qmo = min(self.Modulation.get_Value(),3) - 1
                qcr = 2
                qcr = ["1/2","2/3","3/4","5/6","7/8"].index(self.CodeRate)
                fr = 200.
                if self.Ch > 20: fr = 500.
                self.E95 = round(EmTabla[qmo,qcr] + 20 * math.log10(f / fr),1)
                if self.Ch > 20: self.E95 = self.E95 + 4
            self.E70 = round(self.E95 - 6.1,1)
        def set_Ch(self,value):
            self.Ch = value
            self.EminSzamol()
        def set_VBER(self,value):    #Viterbi utáni bithibaarány
            self.VBER = value
            self.EminSzamol()
            if np.isnan(self.E) or np.isnan(self.E70) or np.isnan(self.E95) or np.isnan(self.BER):
                self.Quality = 0
            else:
                if np.isnan(self.VBER):
                    self.Quality = 0
                else:
                    if self.VBER > 0.0064: self.Quality = 1
                    if (self.VBER > 0.0002) and (self.VBER <= 0.0064): self.Quality = 2
                    if self.VBER <= 0.0002:   #Table 1
                        self.Quality = 2
                        if self.E >= self.E95:
                            CBERratio = 1000. #Viterbi előtti és CBERmin aránya
                            if self.BER > 0:
                                cBERmin = 0.0002
                                if self.CodeRate == "2/3": cBERmin = 0.0004
                                CBERratio = cBERmin / self.BER
                            if CBERratio <= 10: self.Quality = 3
                            if (CBERratio > 10) and (CBERratio <= 100): self.Quality = 4
                            if CBERratio > 100: self.Quality = 5
                    if (self.Modulation.get_asString() != "QPSK") and (self.VBER >= 0.00000000005): #Table 3
                        self.Quality = 2
                        if self.E >= self.E95:
                            Q4curve = 0.00001 * math.exp(-6000.0 * self.BER)
                            Q5curve = 0.0000005 * math.exp(-40000.0 * self.BER)
                            if (self.VBER <= 0.0002) and (self.VBER > Q4curve): self.Quality = 3
                            if (self.VBER <= Q4curve) and (self.VBER > Q5curve): self.Quality = 4
                            if (self.VBER <= Q5curve): self.Quality = 5
        def set_modeGI(self,value):
            self.modeGI = value
            self.EminSzamol()
        def set_Modulation(self,value):
            self.Modulation.set_asString(value)
            self.EminSzamol()
        def set_CodeRate(self,value):
            self.CodeRate = value
            self.EminSzamol()
        def GrKonstellacio(self,Path,ax):
            pa = os.path.join(Path,self.Konstellacio)
            if os.path.exists(pa):
                img = mpimg.imread(pa)
                ax.imshow(img)
            ax.set_title = str(self.Ch)
            ax.axis("off")
        def GrSpectrum(self,ax):
            x = np.linspace(-12,12,501)
            y = np.array(self.GraphSpectrum.split(","),dtype=np.float)
            ax.plot(x,y)
            for xx in [-2.75,2.75,3.75]:
                ax.axvline(xx,color="0.6",linestyle=":")
            ax.set_ylabel("Spectrum [dBm]")
            ax.set_xlim(-12,12)
            ax.grid(True)
        def GrCMER(self,ax):
            fs = self.CarrierCount() / self.Tu()
            x = np.linspace(0,fs,501)
            y = np.array(self.GraphCMER.split(","),dtype=np.float)
            ax.plot(x,y)
            for xx in [fs / 2. - 2.75,fs / 2. + 2.75,fs / 2. + 3.75]:
                ax.axvline(xx,color="0.6",linestyle=":")
            ax.set_ylabel("Carrier MER [dB]")
            ax.set_xlabel("MHz",fontsize=8)
            ax.set_xlim(0,fs)
            ax.grid(True)
        def GrIRES(self,ax):
            y = np.array(self.GraphIRes.split(","),dtype=np.float)
            darab = y.size
            startus = 0
            if self.T2:
                for i in range(darab - 1):
                    if y[i] >= 49.8: 
                        startus = i
                        break
                for i in range(darab - 1,startus + 1,-1):
                    if y[i] >= 49.8:
                        darab = i - startus + 1
                        break
            if darab > 3999: darab = 3999
            x = np.arange(startus,startus + darab,1)
            ax.plot(x,y[startus:startus + darab])
            ax.set_ylabel("Impulse Response [dB]")
            ax.set_xlabel("us",fontsize=8)
            #ax.set_xlim(-12,12)
            ax.grid(True)
        #Public Sub GrCMERToClipboard()
        #    If GraphCMER <> "" Then GraphToClipboard(GraphCMER, 0) Else
        #    My.Computer.Clipboard.Clear()
        #End Sub
        #Public Sub GrFResToClipboard()
        #    If GraphFRes <> "" Then GraphToClipboard(GraphFRes, 2) Else
        #    My.Computer.Clipboard.Clear()
        #End Sub
        #Public Sub GrIResToClipboard()
        #    If GraphIRes <> "" Then GraphToClipboard(GraphIRes, 1) Else
        #    My.Computer.Clipboard.Clear()
        #End Sub
        #Public Sub GrSpectrumToClipboard()
        #    If GraphSpectrum <> "" Then GraphToClipboard(GraphSpectrum, 3)
        #    Else My.Computer.Clipboard.Clear()
        #End Sub
        def ToString(self,value):
            #if IsNothing(value) Then Return String.Empty
            if type(value) == int and value == 999: return ""
            if type(value) == float and np.isnan(value): return ""
            if type(value) == str: return ""
            return str(value)
        #Protected Function SpektrumIndex(MHzCount As Integer, MHz As Double)
        #As Integer
        #    Return MHzCount * (MHz + 12) / 24
        #End Function
        #Public Function isDVBt(ByRef HatarMHz As Double, ByRef CP As Double)
        #As Enum_isDVBt
        #    Dim isd As Enum_isDVBt = Enum_isDVBt.No
        #    If GraphSpectrum <> "" Then
        #        Dim spe() As Double = Class_Meres.GrItem(GraphSpectrum)
        #        Dim aveN As Double = 0
        #        Dim aveT As Double = 0
        #        Dim aveT2 As Double = 0
        #        Dim aliT2 As Integer = SpektrumIndex(spe.Length, -3.885) '169
        #        Dim aliT As Integer = SpektrumIndex(spe.Length, -3.805) '171
        #        Dim fliT As Integer = SpektrumIndex(spe.Length, 3.805) '329
        #        Dim fliT2 As Integer = SpektrumIndex(spe.Length, 3.885) '331
        #        For i = 1 To 10
        #            aveN += spe(aliT2 - i) + spe(fliT2 + i)
        #            aveT += spe(aliT + i) + spe(fliT - i)
        #        Next
        #        aveN /= 20
        #        aveT /= 20
        #        Dim dbT2 As Double = 0
        #        For i = aliT2 To aliT - 1
        #            aveT2 += spe(i)
        #            dbT2 += 1
        #        Next
        #        For i = fliT + 1 To fliT2
        #            aveT2 += spe(i)
        #            dbT2 += 1
        #        Next
        #        aveT2 /= dbT2
        #        HatarMHz = 12
        #        If aveT - aveN > 3 Then
        #            isd = Enum_isDVBt.DVBt
        #            HatarMHz = 3.805
        #            If math.Abs(aveT - aveT2) < 3 Then isd = Enum_isDVBt.DVBt2
        #            : HatarMHz = 3.885
        #        End If
        #        CP = 0
        #        For i = SpektrumIndex(UBound(spe), -HatarMHz) To
        #        SpektrumIndex(UBound(spe), HatarMHz) '170 To 330
        #            CP += 10 ^ (spe(i) / 10)
        #        Next
        #        If spe.Length > 501 Then CP /= 3 'Anritsu 30 kHz ResBW
        #        CP = 10 * math.Log10(CP * 2400 / (spe.Length - 1)) 'ETL 10 kHz
        #        ResBW
        #    End If
        #    Return isd
        #End Function
        def DVBMHz(self,Csatorna):
            MHz = (Csatorna - 21) * 8 + 474
            return MHz
        def Frekvencia(self):
            return (self.Ch - 21) * 8 + 474
        def CarrierCount(self): #Vivők száma
            s = self.modeGI.split(",")
            return {"1K":853,"2K":1705,"4K":3409,"8K":6817,"8E":6913,
                    "16K":13633,"16E":13921,"32K":27265,"32E":27841}.get(s[0])
        def Tu(self):           #Szimbólumidő us-ban
            s = self.modeGI.split(",")
            us = 0.
            if len(s) > 1:
                us = (7. / 64.) * math.pow(2,(10 + math.log(float(s[0][:-1]),2)))
            return us
        def Guardus(self):
            s = self.modeGI.split(",")
            us = 0.
            if len(s) > 1:
                us = eval(s[1].strip().replace("/","./")) * self.Tu()
            return us
    def __init__(self,newPath,newFejlec = None):
        if newFejlec is None:
            self.Fejlec = Fejlec()
        else:
            self.Fejlec = newFejlec
        self.DVBMeres = []
        self.Filename = ""
        self._Path = newPath
    def LetValue(self,Token,Value):
        if type(Value) == None: return ""
        if type(Value) == unicode: return Token + "=" + Value + ";"
        if type(Value) == str:
           if Value == "": return ""
           else: return Token + "={0}".format(Value) + ";"
        if type(Value) == bool:
           if Value: return Token + "=Y;"
           else: return Token + "=N;"
        if type(Value) == int:
           if Value == 999: return ""
           else: return Token + "={0}".format(Value) + ";"
        if type(Value) == float:
           if np.isnan(Value): return ""
           else: return Token + "=" + str(Value) + ";"
    def Save(self,OverWrite,CreateBAK = False):
        """
		Az eredményfájl mentése.
    
		Path Az eredményfájl útvonala. "\" a végére nem kell!
		OverWrite Javítás üzemmódkapcsoló. Az adott koordinátához tartozó nevű fájl kezelése más:
		True = .BAK kiterjesztésűre átnevezi. False = felülírja
		A mentett eredményfájl neve.
		A fájl elnevezési szabálya: EOVx majd EOVy első négy karaktere xxxxyyyy.LD?
		"""
        kit = ".LD"
        if os.path.exists(self._Path):
            a = ""
            if (self.Filename == "") or not OverWrite:
                a = self.Fejlec.FileName()
                fis = [l for l in os.listdir(self._Path) if (l[:11] == a + kit) and (len(l) == 12)]
                if len(fis) == 0:
                   self.Filename = a + kit + "A"
                else:
                    self.Filename = a + kit + chr(ord(fis[-1][-1]) + 1)
            a = os.path.join(self._Path,self.Filename)
            if CreateBAK and os.path.exists(a):
                import shutil
                shutil.copy(a, a + ".BAK")
            try:
                with codecs.open(a,'w',encoding='cp1250') as sw:
                    self.Fejlec.SaveToStream(sw)
                    for mer in self.DVBMeres:
                        q = self.LetValue("Rec",mer.Recno)
                        q+=self.LetValue("T2",mer.T2)
                        q+=self.LetValue("Ch",mer.Ch)
                        q+=self.LetValue("Pol",mer.Pol)
                        q+=self.LetValue("Nem",mer.Nemzetiseg)
                        q+=self.LetValue("Tel",mer.Telephely)
                        q+=self.LetValue("MUX",mer.MUX)
                        q+=self.LetValue("mGI",mer.modeGI)
                        q+=self.LetValue("Mod",mer.Modulation.get_asString())
                        q+=self.LetValue("HAlp",mer.HierAlpha)
                        q+=self.LetValue("CID",mer.CellId)
                        q+=self.LetValue("CRat",mer.CodeRate)
                        q+=self.LetValue("CRHP",mer.CodeRateHP)
                        q+=self.LetValue("CRLP",mer.CodeRateLP)
                        q+=self.LetValue("PP",mer.PilotPattern)
                        q+=self.LetValue("bSS",mer.berSigSync)
                        q+=self.LetValue("bSt",mer.berStatus)
                        q+=self.LetValue("Ir",mer.Irany)
                        q+=self.LetValue("E",mer.E)
                        q+=self.LetValue("E70",mer.E70)
                        q+=self.LetValue("E95",mer.E95)
                        q+=self.LetValue("CP",mer.CP)
                        q+=self.LetValue("ACP",mer.ACP)
                        q+=self.LetValue("CNR",mer.CNR)
                        q+=self.LetValue("SNR",mer.SNR)
                        q+=self.LetValue("BW",mer.BW)
                        q+=self.LetValue("FE",mer.FE)
                        q+=self.LetValue("NP",mer.NP)
                        q+=self.LetValue("MER",mer.MER)
                        q+=self.LetValue("MERP",mer.MERP)
                        q+=self.LetValue("EVM",mer.EVM)
                        if not np.isnan(mer.BER): q+="BER={0:.1E}".format(mer.BER) + ";"
                        if not np.isnan(mer.VBER): q+="VBER={0:.1E}".format(mer.VBER) + ";"
                        q+=self.LetValue("Qual",mer.Quality)
                        q+=self.LetValue("Szub",mer.Szubjektiv)
                        q+=self.LetValue("Kons",mer.Konstellacio)
                        q+=self.LetValue("CIR",mer.CIR)

                        q+=self.LetValue("Megj",mer.Megjegyzes)

                        q+=self.LetValue("grC",mer.GraphCMER)
                        q+=self.LetValue("grF",mer.GraphFRes)
                        q+=self.LetValue("grI",mer.GraphIRes)
                        q+=self.LetValue("grS",mer.GraphSpectrum)
                        if q != "": sw.write(q + '\r\n')
            finally:
                pass
    def set_Filename(self,value):
        """
        Az eredményfájl neve.
        value: A beolvasandó eredményfájl neve útvonallal együtt.
        Nem létező vagy hibás fájl esetén a DVBMeresCount = 0.
        """
        if value != "":
            self.Filename = value
            s = os.path.join(self._Path,self.Filename)
            if os.path.exists(s):
                self.DVBMeres = []
                try:
                    with codecs.open(s,encoding='cp1250') as sr:
                        self.Fejlec.LoadFromStream(sr)
                        for s in sr:
                            if s != "":
                                ss = s.split(";")
                                qdvbmeres = DVB.DVBMeres()
                                for mezo in ss:
                                    ada = mezo.split("=")
                                    if len(ada) == 2:
                                        if ada[0] == "Rec": qdvbmeres.Recno = int(ada[1])
                                        if ada[0] == "Ch": qdvbmeres.Ch = int(ada[1])
                                        if ada[0] == "T2": qdvbmeres.T2 = ada[1] == "Y"
                                        if ada[0] == "Pol": qdvbmeres.Pol = ada[1]
                                        if ada[0] == "Nem": qdvbmeres.Nemzetiseg = ada[1]
                                        if ada[0] == "Tel": qdvbmeres.Telephely = ada[1]
                                        if ada[0] == "MUX": qdvbmeres.MUX = ada[1]
                                        if ada[0] == "mGI": qdvbmeres.modeGI = ada[1]
                                        if ada[0] == "Mod": qdvbmeres.Modulation.set_asString(ada[1])
                                        if ada[0] == "HAlp": qdvbmeres.HierAlpha = ada[1]
                                        if ada[0] == "CID": qdvbmeres.CellId = ada[1]
                                        if ada[0] == "CRat": qdvbmeres.CodeRate = ada[1]
                                        if ada[0] == "CRHP": qdvbmeres.CodeRateHP = ada[1]
                                        if ada[0] == "CRLP": qdvbmeres.CodeRateLP = ada[1]
                                        if ada[0] == "PP": qdvbmeres.PilotPattern = ada[1]
                                        if ada[0] == "bSS": qdvbmeres.berSigSync = ada[1]
                                        if ada[0] == "bSt": qdvbmeres.berStatus = ada[1]
                                        if ada[0] == "Ir": qdvbmeres.Irany = int(ada[1])
                                        if ada[0] == "E": qdvbmeres.E = ada[1]
                                        #Class_Meres.GetValue(.E70, s, "E70")
                                        #Class_Meres.GetValue(.E95, s, "E95")
                                        if ada[0] == "CP": qdvbmeres.CP = float(ada[1])
                                        if ada[0] == "ACP": qdvbmeres.ACP = float(ada[1])
                                        if ada[0] == "CNR": qdvbmeres.CNR = float(ada[1])
                                        if ada[0] == "SNR": qdvbmeres.SNR = float(ada[1])
                                        if ada[0] == "BW": qdvbmeres.BW = float(ada[1])
                                        if ada[0] == "FE": qdvbmeres.FE = float(ada[1])
                                        if ada[0] == "NP": qdvbmeres.NP = float(ada[1])
                                        if ada[0] == "MER": qdvbmeres.MER = float(ada[1])
                                        if ada[0] == "MERP": qdvbmeres.MERP = float(ada[1])
                                        if ada[0] == "EVM": qdvbmeres.EVM = float(ada[1])
                                        if ada[0] == "BER": qdvbmeres.BER = float(ada[1])
                                        if ada[0] == "VBER": qdvbmeres.VBER = float(ada[1])
                                        #Class_Meres.GetValue(.Quality, s,"Qual")
                                        if ada[0] == "Szub": qdvbmeres.Szubjektiv = ada[1]
                                        if ada[0] == "Kons": qdvbmeres.Konstellacio = ada[1]
                                        if ada[0] == "CIR": qdvbmeres.CIR = ada[1]
                                        if ada[0] == "Megj": qdvbmeres.Megjegyzes = ada[1]
                                        if ada[0] == "grC": qdvbmeres.GraphCMER = ada[1]
                                        if ada[0] == "grF": qdvbmeres.GraphFRes = ada[1]
                                        if ada[0] == "grI": qdvbmeres.GraphIRes = ada[1]
                                        if ada[0] == "grS": qdvbmeres.GraphSpectrum = ada[1]
                                qdvbmeres.EminSzamol()
                                self.DVBMeres.append(qdvbmeres)
                finally:
                    pass
    def ShowDiagrams(self,meresIndex):
        fig,ax = plt.subplots(2,2,figsize=(12,6))
        self.DVBMeres[meresIndex].GrSpectrum(ax[0][0])
        self.DVBMeres[meresIndex].GrKonstellacio(self._Path, ax[0][1])
        self.DVBMeres[meresIndex].GrCMER(ax[1][0])
        self.DVBMeres[meresIndex].GrIRES(ax[1][1])
        plt.text(0,60,str(self.DVBMeres[meresIndex].Ch) + " " + self.DVBMeres[meresIndex].Telephely + " " + self.DVBMeres[meresIndex].MUX)
        plt.tight_layout()
        plt.show()

    #Public Function CreateMeres() As Class_LBAMeres
    #    Dim qm As New Class_LBAMeres
    #    LBAMeres.Add(qm)
    #    Return qm
    #End Function
    #Public Sub LoadLast()
    #    Dim kit As String = ".LB"
    #    Dim a As String
    #    If pFilename = "" Then
    #        a = Fejlec.FileName
    #        Dim fis As New System.Collections.ObjectModel.ReadOnlyCollection(Of String)(My.Computer.FileSystem.GetFiles(Path, FileIO.SearchOption.SearchTopLevelOnly, {a + kit + "?"}))
    #        If fis.Count = 0 Then Filename = a + kit + "A" Else Filename = a + kit + Chr(Asc(Strings.Right(fis.Last, 1)))
    #    Else
    #        Filename = pFilename
    #    End If
    #End Sub
