# -*- coding: utf-8 -*-
import codecs
from TeleDeLuxe.Fejlec import Fejlec
import TeleDeLuxe.GeoCoord
import os
import numpy as np
import math
class LAA(object):
    """LAA TV mérési eredményfájl"""
    class LAAMeres(object):
        class BVS(object):
            def __init__(self):
                self.B = np.nan
                self.V = np.nan
                self.S = np.nan
                self.Ellatott = False
        def __init__(self):
            self.Azonosito=""
            self.Csatorna = 999
            self.Polarizacio = ""
            self.Ofszet = np.nan
            self.Ekep = np.nan
            self.Ehang = np.nan
            self.Irany = 999
            self.Szubjektiv = ""
            self.Nemzetiseg =""
            self.Telephely =""
            self.Musor =""
            self.Megjegyzes =""
            self.BVS = BVS()
    def Frekvencia(self):
        return TVfrekvencia(self.Azonosito, self.Csatorna)
    def __init__(self, newPath, newFejlec = None):
        if newFejlec is None:
            self.Fejlec = Fejlec()
        else:
            self.Fejlec = newFejlec
        self.LAAMeres = []
        self.Filename = ""
        self._Path = newPath
        self.Nagyvaros=False
        self.Varos=False
        if self.Fejlec!=None:
            self.Nagyvaros = (self.Fejlec.Falunev == "Budapest")
            self.Varos = (self.Fejlec.Beepitettseg == 1)
    def Save(self, OverWrite, CreateBAK = False):
        """Az eredményfájl mentése.
        Path Az eredményfájl útvonala. "\" a végére nem kell!
        OverWrite Javítás üzemmódkapcsoló. Az adott koordinátához tartozó nevű fájl kezelése más:
		True = .BAK kiterjesztésűre átnevezi. False = felülírja
		A mentett eredményfájl neve.
		A fájl elnevezési szabálya: EOVx majd EOVy első négy karaktere xxxxyyyy.LA?
    """
        kit = ".LA"
        if os.path.exists(self._Path):
            a = ""
            if (self.Filename == "") or not OverWrite:
                a = self.Fejlec.FileName()
                fis = [l for l in os.listdir(self._Path) if (l[:11] == a + kit) and (len(l) == 12)]
                if len(fis) == 0:
                   self.Filename = a + kit + "A"
                else:
                    self.Filename = a + kit + chr(ord(fis[-1][-1]) + 1)
            a = os.path.join(self._Path,self.Filename)
            if CreateBAK and os.path.exists(a):
                import shutil
                shutil.copy(a, a + ".BAK")
            try:
                with codecs.open(a,'w',encoding='cp1250') as sw:
                    self.Fejlec.SaveToStream(sw)
                    for mer in self.LAAMeres:
                        q = self.LAAMeres(i).Azonosito
                        q += "{0:2}".format(mer.Csatorna)
                        q += mer.Polarizacio
                        q += "{0:6.2f}".format(self.TVfrekvencia(mer.Azonosito, mer.Csatorna))
                        q += "{0:>+5.1f}".format(mer.Ofszet)
                        q += "{0:5.1f}".format(mer.Ekep)
                        q += "{0:>+5.1f}".format(mer.Ofszet)
                        q += "{0:5.1f}".format(mer.Ehang)
                        q += "{0:3}".format(mer.Irany)
                        q += "{0:4}".format(mer.Szubjektiv)
                        q += "{0:3}".format(mer.Nemzetiseg)
                        q += mer.Telephely[:15].ljust(15)
                        q += mer.Polarizacio
                        q += mer.Musor[:8].ljust(8)
                        q += mer.Megjegyzes
                        if q != "": sw.write(q + '\r\n')
            finally:
                pass
    def atlapolova(self, ofkul):
        if (ofkul>-2.5) and (ofkul<=0.25):
            atl = 17. * ofkul + 42.7
        elif (ofkul>0.25) and (ofkul<=1.):
            atl = 47.
        elif (ofkul>1.) and (ofkul<=5.):
            atl = -8. * ofkul + 55.
        elif (ofkul>5.) and (ofkul<=6.25):
            atl = 15.
        elif (ofkul>6.25) and (ofkul<=6.5):
            atl = 60. * ofkul - 360.
        elif (ofkul>6.5) and (ofkul<=7):
            atl = -40. * ofkul + 290.
        elif (ofkul>7) and (ofkul<=8):
            atl = -6. * ofkul + 52.
        return atl
    def azonosva(self, ofkul):
        return 9. * math.cos(ofkul / 2.4868) + 36.
    def jarved(self, Index, irkul, polh, polz):
        jar = -16.
        if polh == polz:
            ik = math.fabs(irkul)
            if irkul > 180.: ik = 360. - ik
            if (self.LAAMeres(Index).Csatorna>1) and (self.LAAMeres(Index).Csatorna<=5):
                if (ik>0) and (ik<=50):
                    jar = 0.
                elif (ik>50) and (ik<=50):
                    jar = -0.35 * ik + 17.5
                elif (ik>70):
                    jar = -7.
            elif (self.LAAMeres(Index).Csatorna>6) and (self.LAAMeres(Index).Csatorna<=12):
                if (ik>0) and (ik<=27):
                    jar = 0.
                elif (ik>27) and (ik<=60):
                    jar = -0.36 * ik + 9.6
                elif (ik>60):
                    jar = -12.
            elif self.LAAMeres(Index).Csatorna > 20:
                if (ik>0) and (ik<=20):
                    jar = 0.
                elif (ik>20) and (ik<=60):
                    jar = -0.4 * ik + 8.
                elif (ik>60):
                    jar = -16.
        return jar
    def Emin(self, Index):
        em = 74.
        if not self.Nagyvaros:
            if (self.LAAMeres(Index).Csatorna>1) and (self.LAAMeres(Index).Csatorna<=5):
                em = 46.
            elif (self.LAAMeres(Index).Csatorna>6) and (self.LAAMeres(Index).Csatorna<=12):
                em = 49.
            elif (self.LAAMeres(Index).Csatorna>=21) and (self.LAAMeres(Index).Csatorna<=34):
                em = 58.
            elif self.LAAMeres(Index).Csatorna > 34:
                em = 64.
            return em
    def BVSszamitas(self):
        """BVS ellátottsági értékelés.
        A BVS objektumot frissíti, az értékelést minden csatornára elvégzi.
        """
        #Dim keresendo As Integer, i As Integer
        #Dim va As Double, pva As Double, pv As Double
        #Dim szakasz As Integer, ofindex As Integer, frkul As Double
        #Dim azh As String, azz As String
        #Védelmi arány táblázat m
        Vtm = [[28., 30.66667, 29.33333, 28, 26.66667, 26.66667, 26.66667, 26.66667, 26.66667, 28., 29.33333, 30.66667, 28.],
               [6., 6., 6., 4., 4., 4., 4., 4., 4., 4., 6., 6., 6.],
               [6., 6., 6., 6., 6., 4., 4., 4., 6., 6., 6., 6., 6.],
               [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
               [-6., -7., -6., -4., -3., -2., -2., -2., -3., -4., -6., -7., -6.],
               [-8., -8., -7., -6., -5., -5., -5., -5., -5., -6., -7., -8., -8.],
               [-1.66667, 8.33333, 16.66667, 26.66667, 25., 25.33333, 18.33333, 16.66667, 20., 21.66667, 11.66667, 1.66667, -1.66667],
               [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.],
               [-34., -38., -40., -40., -40., -38., -34., -34., -38., -40., -38., -34., -34.],
               [0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.]]
        #Védelmi arány táblázat b
        Vtb = [[58., 58.33333, 53.66667, 48., 43.33333, 41.33333, 40.33333, 41.33333, 43.33333, 48., 53.66667, 58.33333, 58.],
               [47., 46., 42., 36., 32., 30., 29., 30., 32., 36., 42., 46., 47.],
               [47., 46., 42., 36., 32., 30., 29., 30., 32., 36., 42., 46., 47.],
               [50., 49., 45., 39., 35., 32., 31., 32., 35., 39., 45., 49., 50.],
               [56., 56., 51., 43., 38., 34., 33., 34., 38., 43., 51., 56., 56.],
               [60., 58., 53., 47., 42., 40., 39., 40., 42., 47., 53., 58., 60.],
               [41., 9., -18., -51., -48., -45., -31., -25., -33., -36., -3., 29., 41.],
               [35., 39., 42., 45., 42., 39., 35., 35., 39., 42., 39., 35., 35.],
               [198.2, 221.4, 234, 237, 234, 221.4, 198.2, 198.2, 221.4, 234, 221.4, 198.2, 198.2],
               [18., 20., 22., 25., 22., 20., 18., 18., 20., 22., 20., 18., 18.]]
        for keresendo in range(0,len(self.LAAMeres)):
            azh = self.LAAMeres(keresendo).Azonosito
            frh = self.TVfrekvencia(azh, self.LAAMeres(keresendo).Csatorna)
            polh = self.LAAMeres(keresendo).Polarizacio
            oh = self.LAAMeres(keresendo).Ofszet
            eh = self.LAAMeres(keresendo).Ekep
            irh = self.LAAMeres(keresendo).Irany
            S = int(LAAMeres(keresendo).Szubjektiv[0])
            va = 999.
            for i in range(0,len(self.LaAMeres)):
                azz = self.LAAMeres(i).Azonosito
                frz = self.TVfrekvencia(azz, self.LAAMeres(i).Csatorna)
                frkul = frz - frh
                if i != keresendo:
                    pva = 999.
                    polz = self.LAAMeres(i).Polarizacio
                    oz = self.LAAMeres(i).Ofszet
                    ez = self.LAAMeres(i).Ekep
                    irz = self.LAAMeres(i).Irany
                    ofindex = (math.abs(oh - oz) / 1.302) % 12
                    if (frkul>-8) and (frkul<=-1.25):
                        pva = -9
                    elif (frkul>-1.25) and (frkul<=-6):
                        if (frkul>-1.25) and (frkul<=-0.5):
                            szakasz = 0
                        elif (frkul>-0.5) and (frkul<=0):
                            szakasz = 1
                        elif (frkul>0) and (frkul<=0.5):
                            szakasz = 2
                        elif (frkul>0.5) and (frkul<=1):
                            szakasz = 3
                        elif (frkul>1) and (frkul<=2):
                            szakasz = 4
                        elif (frkul>2) and (frkul<=3):
                            szakasz = 5
                        elif (frkul>3) and (frkul<=3.6):
                            szakasz = 6
                        elif (frkul>3.6) and (frkul<=4.8):
                            szakasz = 7
                        elif (frkul>4.8) and (frkul<=5.3):
                            szakasz = 8
                        elif (frkul>5.3) and (frkul<=6):
                            szakasz = 9
                        pva = Vtm[szakasz, ofindex] * frkul + Vtb[szakasz, ofindex]
                    elif (frkul>6) and (frkul<=8):
                        if (azh == "O") or (azh == "K"): pva = -6.
                        else: pva = -12.
                    elif frkul==64: #n+8
                        if (azh == "O") or (azh == "K"): 
                            if (azz == "O") or (azz == "K"): pva = -10.
                            else: pva = -1.
                    elif frkul==72: #n+9
                            if (azh == "O") or (azh == "K"): pva = 11.
                    else:
                        if (azz == "O") or (azz == "K"): pva = 6.
                    if pva < 999.:
                        pv = eh - ez - pva - jarved(keresendo, irh - irz)
                        if pv < va: va = pv
            B = eh - self.Emin(keresendo)
            self.LAAMeres(keresendo).BVS.B = B
            if va == 999.: self.LAAMeres(keresendo).BVS.V = np.nan
            else: self.LAAMeres(keresendo).BVS.V = va
            self.LAAMeres(keresendo).BVS.S = S
            self.LAAMeres(keresendo).BVS.Ellatott = (B >= 0) and (va >= 0) and (S >= 4)
    def OfszetJel(self, kHz):
        """
        TV ofszetjelzést számít a kHz-ben megadott ofszetértékből.
        kHz Az ofszet kHz-ben.
        P0M stílusú ofszetjelzés.
        pl.: OfszetJel(10.4) visszaadott értéke 8P.
        """
        szam = int(kHz / 1.302 + 0.5)
        if szam < 0: a = "M"
        elif szam > 0: a = "P"
        else: a=""
        return str(math.fabs(szam)) + a
    def OfszetkHz(self,Jel):
        """
        TV ofszetkHz-et számít ofszetjelzésben megadott ofszetértékből.
        jel P0M stílusú ofszetjelzés.
        return Az ofszet kHz-ben.
        """
        if Jel[:-1]=="": return 0
        return -float(Jel[-1]=="M")* float(Jel[:-1])*1.302
    def TVcsatorna(self, Frekvencia, KepHang55):
        """
        TV csatorna MHz-ből.
        Frekvencia A névleges TV képvivő frekvencia MHz-ben.
        return Azonosító+Csatorna formában kifejezve.
        """
        if Frekvencia == 48.25: return "E2 "
        elif Frekvencia == 49.75: return "O1 "
        elif Frekvencia == 55.25: return "E3 "
        elif Frekvencia == 59.25: return "O2 "
        elif Frekvencia == 62.25: return "E4 "
        elif Frekvencia == 77.25: return "O3 "
        elif Frekvencia == 85.25: return "O4 "
        elif Frekvencia == 93.25: return "O5 "
        elif Frekvencia == 175.25:
            if KepHang55: return "E5 "
            else: return "O6 "
        elif Frekvencia == 182.25: return "E6 "
        elif Frekvencia == 183.25: return "O7 "
        elif Frekvencia == 189.25: return "E7 "
        elif Frekvencia == 191.25: return "O8 "
        elif Frekvencia == 196.25: return "E8 "
        elif Frekvencia == 199.25: return "O9 "
        elif Frekvencia == 203.25: return "E9 "
        elif Frekvencia == 207.25: return "O10"
        elif Frekvencia == 210.25: return "E10"
        elif Frekvencia == 215.25: return "O11"
        elif Frekvencia == 217.25: return "E11"
        elif Frekvencia == 223.25: return "O12"
        elif Frekvencia == 224.25: return "E12"
        else:
            azon="K"
            if KepHang55: azon="G"
            return azon + str((Frekvencia - 471.25) / 8. + 21.)
    def TVfrekvencia(self,Azonosito, Csatorna):
        """TV frekvencia.
        Azonosito A csatorna azonosítója.
        Csatorna A csatorna sorszáma.
        return A névleges TV képvivő frekvencia MHz-ben.
        Nem értelmezhető TV csatorna esetén hibás frekvenciát ad!
        """
        cs = Azonosito + str(Csatorna)
        if cs=="E2": return 48.25
        if cs=="O1": return 49.75
        if cs=="E3": return 55.25
        if cs=="O2": return 59.25
        if cs=="E4": return 62.25
        if cs=="O3": return 77.25
        if cs=="O4": return 85.25
        if cs=="O5": return 93.25
        if cs=="E5": return 175.25
        if cs=="O6": return 175.25
        if cs=="E6": return 182.25
        if cs=="O7": return 183.25
        if cs=="E7": return 189.25
        if cs=="O8": return 191.25
        if cs=="E8": return 196.25
        if cs=="O9": return 199.25
        if cs=="E9": return 203.25
        if cs=="O10": return 207.25
        if cs=="E10": return 210.25
        if cs=="O11": return 215.25
        if cs=="E11": return 217.25
        if cs=="O12": return 223.25
        if cs=="E12": return 224.25
        return (Csatorna - 21.) * 8. + 471.25
    def set_Filename(self, Value):
        """
        Az eredményfájl neve.
        Value A beolvasandó eredményfájl neve útvonallal együtt.
        Nem létező vagy hibás fájl esetén a LAAMeresCount = 0.
        """
        if Value != "":
            self.Filename = Value
            s = os.path.join(self._Path,self.Filename)
            if os.path.exists(s):
                self.LAAMeres = []
                try:
                    with codecs.open(s,encoding='cp1250') as sr:
                        self.Fejlec.LoadFromStream(sr)
                        for s in sr:
                            if s != "":
                                qlameres = LAA.LAAMeres()
                                qlameres.Azonosito = s[0:1]
                                qlameres.Csatorna = int(s[1:3])
                                qlameres.Polarizacio = s[3:4]
                                qlameres.Ofszet = float(s[10:15])
                                qlameres.Ekep = float(s[15:20])
                                qlameres.Ehang = float(s[25:30])
                                qlameres.Irany = int(s[30:33])
                                qlameres.Szubjektiv = s[33:37].strip()
                                qlameres.Nemzetiseg = s[37:40].upper()
                                qlameres.Telephely = s[40:55].strip()
                                qlameres.Musor = s[56,64].strip()
                                qlameres.Megjegyzes = s[65:].strip().replace(",",".")
                                self.LAAMeres.append(qlaameres)
                    self.BVSszamitas()
                finally:
                    pass
    def CreateMeres(self):
        qm =LAAMeres()
        self.LAAMeres.append(qm)
        return qm
    #Public Sub LoadLast()
    #    Dim kit As String = ".LA"
    #    Dim a As String
    #    If pFilename = "" Then
    #        a = Fejlec.FileName
    #        Dim fis As New System.Collections.ObjectModel.ReadOnlyCollection(Of String)(My.Computer.FileSystem.GetFiles(Path, FileIO.SearchOption.SearchTopLevelOnly, {a + kit + "?"}))
    #        If fis.Count = 0 Then Filename = a + kit + "A" Else Filename = a + kit + Chr(Asc(Strings.Right(fis.Last, 1)))
    #    Else
    #        Filename = pFilename
    #    End If
    #End Sub
