# -*- coding: utf-8 -*-
import datetime
import TeleDeLuxe.GeoCoord as GeoCoord
class Fejlec(object):
    EIdojaras = ["ismeretlen",u"erősen felhős",u"felhős",u"részben felhős",u"derült"]
    EBeepitettseg = ["ismeretlen",u"nagyvárosi","falusias",u"erdős",u"nyílt terület"]
    ETerep = ["ismeretlen",u"sík","dombos","hegyes"]
    def __init__(self):
        self.Datum = datetime.datetime.now()
        self.Ido = datetime.datetime.now()
        self.Merte = ""
        self.Muszer = ""
        self.Antenna = ""
        self.Falunev = ""
        self.Cim = ""
        self.Homerseklet = -999
        self.Tanyanev = ""
        self.Kerulet = 0
        self.WGS = GeoCoord.WGS()
        self.EOV = GeoCoord.EOV()
        self.Beepitettseg = 0    #EBeepitettseg
        self.Idojaras = 0        #EIdojaras
        self.Terep = 0           #ETerep
    def set_WGS(self,LonString,LatString):
        self.WGS.Lon.set_asString(LonString)
        self.WGS.Lat.set_asString(LatString)
        if (self.EOV.x == 0) and (self.EOV.y == 0): self.EOV = self.WGS.toEOV()
    def set_EOV(self,value):
        self.EOV = value
        if (self.WGS.Lat.Degree == 0) and (self.WGS.Lon.Degree == 0): self.WGS = self.EOV.toWGS()
    def set_Beepitettseg(self,value):
        if (value > 0) and (value <= len(EBeepitettseg)):
            self.Beepitettseg = value
        else:
            self.Beepitettseg = 4
    def set_Idojaras(self,value):
        if (value > 0) and (value <= len(EBeepitettseg)):
            self.Idojaras = value
        else:
            self.Idojaras = 4
    def set_Terep(self,value):
        if (value > 0) and (value <= len(EBeepitettseg)):
            self.Terep = value
        else:
            self.Terep = 1
    def IdojarasString(self):
        return self.EIdojaras[self.Idojaras]
    def BeepitettsegString(self):
        return self.EBeepitettseg[self.Beepitettseg]
    def TerepString(self):
        return self.TerepString[self.Terep]
    def UserCode(self):
        if "Koronczay Gyula" in self.Merte: return 7
        elif u"Borköles Zoltán" in self.Merte: return 6
        elif u"Kohl András" in self.Merte: return 5
        elif u"Kiszely György" in self.Merte: return 4
        else: return 0
    def __eq__(self,Fejlec):
        return (self.WGS == Fejlec.WGS) and (self.Falunev == Fejlec.Falunev) and (self.Cim == Fejlec.Cim) and (self.Merte == Fejlec.Merte) and (self.Datum == Fejlec.Datum) and (self.Antenna == Fejlec.Antenna) and (self.Muszer == Fejlec.Muszer)
    def LoadFromStream(self,sr):
        s = sr.readline().strip().split("-")
        if len(s[2])<4:
            if int(s[2])<20: s[2] = "20"+s[2]
            else: s[2] = "19"+s[2]
        self.Datum = datetime.date(int(s[2]),int(s[0]),int(s[1]))
        s = sr.readline().split(":")
        self.Ido = datetime.time(int(s[0]),int(s[1]),int(s[2][:2]))
        s = s[2].split("(")
        if len(s) > 1:
            s = s[1].split("C")
            self.Homerseklet = int(s[0])
            self.Idojaras = int(s[1][0])
        else:
            self.Homerseklet = 999
            self.Idojaras = 0
        s = sr.readline().split("(")
        if len(s) > 1:
            self.Muszer = s[0].strip()
            self.Terep = int(s[1][1])
            self.Beepitettseg = int(s[1][3])
        else:
            self.Muszer = s[0].strip()
            self.Terep = 0
            self.Beepitettseg = 0
        self.Antenna = sr.readline().strip()
        self.Merte = sr.readline().strip()
        s = sr.readline().replace(",",".")
        if s.find(" ") < 2:
            self.Falunev = ""
            self.Cim = s.strip()
        else:
            s = s.split(" ",1)
            self.Falunev = s[0].strip()
            self.Cim = s[1].strip()
        s = sr.readline().strip().split(" ")
        self.EOV.x = int(s[0])
        self.EOV.y = int(s[1])
        s = sr.readline().strip()
        if s == "":
            self.WGS = self.EOV.toWGS()
        else:
            s = s.split(";")
            self.set_WGS(s[1][3:],s[0][3:])
        sr.readline()
    def SaveToStream(self,sw):
        telepulesi = False
        sw.write('{0:%m-%d-%Y}'.format(self.Datum) + "\r\n")
        sw.write('{0:%H:%M:%S}'.format(self.Ido))
        if self.Homerseklet > -999: sw.write(" (" + '{0:0>2}'.format(self.Homerseklet) + "C" + '{0:0>1}'.format(self.Idojaras) + ")")
        sw.write("\r\n")
        sw.write(self.Muszer)
        if self.Terep == 0:
            sw.write("\r\n")
            telepulesi = True
        else:
            sw.write(" (T" + '{0:0>1}'.format(self.Terep) + "B" + '{0:0>1}'.format(self.Beepitettseg) + ")\r\n")
            telepulesi = bool(self.Beepitettseg < 3)
        sw.write(self.Antenna + "\r\n")
        sw.write(self.Merte + "\r\n")
        if telepulesi == True:
            if self.Kerulet > 0:
                sw.write(self.Falunev + " " + self.Kerulet + ". ker. " + self.Cim + "\r\n")
            else:
                sw.write(self.Falunev + " " + self.Cim + "\r\n")
        else:
            sw.write(" " + self.Cim + "\r\n")
        sw.write('{0:0>6}'.format(self.EOV.x) + " " + '{0:0>6}'.format(self.EOV.y) + "\r\n")
        sw.write("LAT" + self.WGS.Lat.get_asString() + ";LON" + self.WGS.Lon.get_asString() + ";\r\n")
        sw.write("\r\n")
    def FileName(self):
        return '{0:0>6}'.format(self.EOV.x)[:4] + '{0:0>6}'.format(self.EOV.y)[:4]
