# -*- coding: utf-8 -*-
import os
from pandas import ExcelFile
from pandas import read_excel
from pandas import set_option
import TeleDeLuxe.GeoCoord
class Adoxls(object):
    """
    Adó adatbázis olvasása Ado.xls-ből
    """
    def __init__(self, xlsPath):
        pa = os.path.join(xlsPath, "Ado.xls")
        if os.path.exists(pa):
            self.xlsPath = xlsPath
            #self.wsDVBt = read_excel(adoxls,"DVBt")
            #self.wsMUX = read_excel(adoxls,"MUX")
            #self.wsTel = read_excel(adoxls,"Telephelyek")
            def vag10(mit):
                return unicode(mit)[:10]
            def vag20(mit):
                return unicode(mit)[:20]
            def invDMS(mit):
                deg = TeleDeLuxe.GeoCoord.WGS.Degree()
                deg.set_asString(mit)
                return deg.get_asFloat()
            def heff(mit):
                if mit=="": return 30
                else: return int(mit)
            def erp(mit):
                if mit=="": return 0.
                else:
                    try:
                        return float(mit)
                    except:
                        return 0
            with ExcelFile(pa) as xls:
                self.wsRadio = read_excel(xls, sheet_name=3, usecols="A,B,D,E,F,G,H,L,M", names=["MHz","tel","nemz","mus","pol","Lat","Lon","ERP","heffmax"], converters={"mus": vag10, "tel": vag20, "Lat": invDMS, "Lon": invDMS, "ERP": erp, "heffmax": heff}, encoding="cp1250",keep_default_na=False)
            set_option('display.encoding','cp852')
    def findRadio(self, f, nemzetiseg = None, telephely = None, musor = None):
        a = self.wsRadio.loc[self.wsRadio["MHz"] == f,:]
        if nemzetiseg != None: a = a.query("nemz == u'" + nemzetiseg + "'")
        if telephely != None: a = a.query("tel == u'" + telephely + "'")
        if (musor != None): a = a.query("mus == u'" + musor + "'")
        return a