# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TC_TLAG
                                 A QGIS plugin
 Calculate the Time of Concentration and Lag Time
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-04-10
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Jorge Andrés Herrera Maldonado
        email                : joaherrerama@unal.edu.co
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
#import pandas as pd


from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication
from PyQt5.QtCore import  *
from PyQt5.QtGui import QIcon, QColor, QFont
from PyQt5.QtWidgets import QAction
from PyQt5.QtWidgets import QMessageBox

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Tc_Tlag_dialog import TC_TLAGDialog
import os.path

from qgis.core import *
import random 


class TC_TLAG:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface

        """

        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'TC_TLAG_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)
        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Time of Concentration and Lag Time')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.toolbar = self.iface.addToolBar(u'Tc Tlag')

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('TC_TLAG', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Tc_Tlag/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'main'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Time of Concentration and Lag Time'),
                action)
            self.iface.removeToolBarIcon(action)

        # remove the toolbar
        del self.toolbar


    def select_layer_fields(self, vlayer):

        self.dlg.cb_lp.setLayer(vlayer)
        self.dlg.cb_area.setLayer(vlayer)
        self.dlg.cb_slope.setLayer(vlayer)
        self.dlg.cb_max_height.setLayer(vlayer)
        self.dlg.cb_min_height.setLayer(vlayer)
        self.dlg.cb_cn.setLayer(vlayer)
        self.dlg.cb_perm.setLayer(vlayer)

        field = self.dlg.cb_lp.setLayer(vlayer)

    def check_box_able(self):

        L = self.dlg.cb_lp.currentField()
        S =self.dlg.cb_slope.currentField()
        A= self.dlg.cb_area.currentField()
        CN = self.dlg.cb_cn.currentField()
        C_MAX = self.dlg.cb_max_height.currentField()
        C_MIN = self.dlg.cb_min_height.currentField()
        PERM = self.dlg.cb_perm.currentField()

        arr = [L,S,A,CN,C_MAX,C_MIN,PERM]
        arreglo = []

        while arreglo != arr:

            arreglo = arr

            if C_MAX != "":
                self.dlg.cb_min_height.setEnabled(True)

            else:
                self.dlg.cb_min_height.setEnabled(False)

            if L== "" and CN == "" and PERM == "" and C_MAX== "" and C_MIN== "" and A== "" and S== "":

                self.dlg.chb_tc_williams.setEnabled(False)
                self.dlg.chb_tc_kirpich.setEnabled(False)            
                self.dlg.chb_tc_temez.setEnabled(False)
                self.dlg.chb_tc_ventura_heras.setEnabled(False)
                self.dlg.chb_tc_bransby_willi.setEnabled(False)
                self.dlg.chb_tc_clark.setEnabled(False)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(False)
                self.dlg.chb_tc_pilgrim.setEnabled(False)
                self.dlg.chb_tc_scs_ranser.setEnabled(False)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(False)
                self.dlg.chb_tl_snyder.setEnabled(False)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)


                self.dlg.chb_tc_williams.setChecked(False)
                self.dlg.chb_tc_kirpich.setChecked(False)            
                self.dlg.chb_tc_temez.setChecked(False)
                self.dlg.chb_tc_ventura_heras.setChecked(False)
                self.dlg.chb_tc_bransby_willi.setChecked(False)
                self.dlg.chb_tc_clark.setChecked(False)
                self.dlg.chb_tc_valencua_zuluaga.setChecked(False)
                self.dlg.chb_tc_pilgrim.setChecked(False)
                self.dlg.chb_tc_scs_ranser.setChecked(False)
                self.dlg.chb_tc_ccp.setChecked(False)
                self.dlg.chb_tc_guiadotti.setChecked(False)
                self.dlg.chb_tc_scs.setChecked(False)

                self.dlg.chb_tl_eagleson.setChecked(False)
                self.dlg.chb_tl_chow.setChecked(False)
                self.dlg.chb_tl_snyder.setChecked(False)
                self.dlg.chb_tl_putman.setChecked(False)
                self.dlg.chb_tl_scs.setChecked(False)

            elif L!= "" and CN != "" and PERM != "" and C_MAX!= "" and C_MIN!= "" and A!= "" and S!= "":


                self.dlg.chb_tc_williams.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(True)            
                self.dlg.chb_tc_temez.setEnabled(True)
                self.dlg.chb_tc_ventura_heras.setEnabled(True)
                self.dlg.chb_tc_bransby_willi.setEnabled(True)
                self.dlg.chb_tc_clark.setEnabled(True)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(True)
                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_scs_ranser.setEnabled(True)
                self.dlg.chb_tc_ccp.setEnabled(True)
                self.dlg.chb_tc_guiadotti.setEnabled(True)
                self.dlg.chb_tc_scs.setEnabled(True)

                self.dlg.chb_tl_eagleson.setEnabled(True)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_snyder.setEnabled(True)
                self.dlg.chb_tl_putman.setEnabled(True)
                self.dlg.chb_tl_scs.setEnabled(True)

                self.dlg.chb_tc_williams.setChecked(True)
                self.dlg.chb_tc_kirpich.setChecked(True)            
                self.dlg.chb_tc_temez.setChecked(True)
                self.dlg.chb_tc_ventura_heras.setChecked(True)
                self.dlg.chb_tc_bransby_willi.setChecked(True)
                self.dlg.chb_tc_clark.setChecked(True)
                self.dlg.chb_tc_valencua_zuluaga.setChecked(True)
                self.dlg.chb_tc_pilgrim.setChecked(True)
                self.dlg.chb_tc_scs_ranser.setChecked(True)
                self.dlg.chb_tc_ccp.setChecked(True)
                self.dlg.chb_tc_guiadotti.setChecked(True)
                self.dlg.chb_tc_scs.setChecked(True)

                self.dlg.chb_tl_eagleson.setChecked(True)
                self.dlg.chb_tl_chow.setChecked(True)
                self.dlg.chb_tl_snyder.setChecked(True)
                self.dlg.chb_tl_putman.setChecked(True)
                self.dlg.chb_tl_scs.setChecked(True)


            elif L!= "" and PERM != "" and C_MAX!= "" and C_MIN!= "" and A!= "" and S!= "":
                self.dlg.chb_tc_williams.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(True)            
                self.dlg.chb_tc_temez.setEnabled(True)
                self.dlg.chb_tc_ventura_heras.setEnabled(True)
                self.dlg.chb_tc_bransby_willi.setEnabled(True)
                self.dlg.chb_tc_clark.setEnabled(True)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(True)
                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_scs_ranser.setEnabled(True)
                self.dlg.chb_tc_ccp.setEnabled(True)
                self.dlg.chb_tc_guiadotti.setEnabled(True)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(True)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_snyder.setEnabled(True)
                self.dlg.chb_tl_putman.setEnabled(True)
                self.dlg.chb_tl_scs.setEnabled(False)

                self.dlg.chb_tc_williams.setChecked(True)
                self.dlg.chb_tc_kirpich.setChecked(True)            
                self.dlg.chb_tc_temez.setChecked(True)
                self.dlg.chb_tc_ventura_heras.setChecked(True)
                self.dlg.chb_tc_bransby_willi.setChecked(True)
                self.dlg.chb_tc_clark.setChecked(True)
                self.dlg.chb_tc_valencua_zuluaga.setChecked(True)
                self.dlg.chb_tc_pilgrim.setChecked(True)
                self.dlg.chb_tc_scs_ranser.setChecked(True)
                self.dlg.chb_tc_ccp.setChecked(True)
                self.dlg.chb_tc_guiadotti.setChecked(True)

                self.dlg.chb_tl_eagleson.setChecked(True)
                self.dlg.chb_tl_chow.setChecked(True)
                self.dlg.chb_tl_snyder.setChecked(True)
                self.dlg.chb_tl_putman.setChecked(True)

            elif L!= "" and CN != "" and C_MAX!= "" and C_MIN!= "" and A!= "" and S!= "":

                self.dlg.chb_tc_williams.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(True)            
                self.dlg.chb_tc_temez.setEnabled(True)
                self.dlg.chb_tc_ventura_heras.setEnabled(True)
                self.dlg.chb_tc_bransby_willi.setEnabled(True)
                self.dlg.chb_tc_clark.setEnabled(True)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(True)
                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_scs_ranser.setEnabled(True)
                self.dlg.chb_tc_ccp.setEnabled(True)
                self.dlg.chb_tc_guiadotti.setEnabled(True)
                self.dlg.chb_tc_scs.setEnabled(True)

                self.dlg.chb_tl_eagleson.setEnabled(True)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_snyder.setEnabled(True)
                self.dlg.chb_tl_scs.setEnabled(True)
                self.dlg.chb_tl_putman.setEnabled(False)

                self.dlg.chb_tc_williams.setChecked(True)
                self.dlg.chb_tc_kirpich.setChecked(True)            
                self.dlg.chb_tc_temez.setChecked(True)
                self.dlg.chb_tc_ventura_heras.setChecked(True)
                self.dlg.chb_tc_bransby_willi.setChecked(True)
                self.dlg.chb_tc_clark.setChecked(True)
                self.dlg.chb_tc_valencua_zuluaga.setChecked(True)
                self.dlg.chb_tc_pilgrim.setChecked(True)
                self.dlg.chb_tc_scs_ranser.setChecked(True)
                self.dlg.chb_tc_ccp.setChecked(True)
                self.dlg.chb_tc_guiadotti.setChecked(True)
                self.dlg.chb_tc_scs.setChecked(True)

                self.dlg.chb_tl_eagleson.setChecked(True)
                self.dlg.chb_tl_chow.setChecked(True)
                self.dlg.chb_tl_snyder.setChecked(True)
                self.dlg.chb_tl_scs.setChecked(True)

            elif L!= "" and C_MAX!= "" and C_MIN!= "" and A!= "" and S!= "":

                self.dlg.chb_tc_williams.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(True)            
                self.dlg.chb_tc_temez.setEnabled(True)
                self.dlg.chb_tc_ventura_heras.setEnabled(True)
                self.dlg.chb_tc_bransby_willi.setEnabled(True)
                self.dlg.chb_tc_clark.setEnabled(True)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(True)
                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_scs_ranser.setEnabled(True)
                self.dlg.chb_tc_ccp.setEnabled(True)
                self.dlg.chb_tc_guiadotti.setEnabled(True)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(True)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_snyder.setEnabled(True)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)

                self.dlg.chb_tc_williams.setChecked(True)
                self.dlg.chb_tc_kirpich.setChecked(True)            
                self.dlg.chb_tc_temez.setChecked(True)
                self.dlg.chb_tc_ventura_heras.setChecked(True)
                self.dlg.chb_tc_bransby_willi.setChecked(True)
                self.dlg.chb_tc_clark.setChecked(True)
                self.dlg.chb_tc_valencua_zuluaga.setChecked(True)
                self.dlg.chb_tc_pilgrim.setChecked(True)
                self.dlg.chb_tc_scs_ranser.setChecked(True)
                self.dlg.chb_tc_ccp.setChecked(True)
                self.dlg.chb_tc_guiadotti.setChecked(True)
                self.dlg.chb_tl_eagleson.setChecked(True)
                self.dlg.chb_tl_chow.setChecked(True)
                self.dlg.chb_tl_snyder.setChecked(True)

            elif L!= "" and PERM!= "" and S!= "" and A!= "":

                self.dlg.chb_tc_williams.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(True)            
                self.dlg.chb_tc_temez.setEnabled(True)
                self.dlg.chb_tc_ventura_heras.setEnabled(True)
                self.dlg.chb_tc_bransby_willi.setEnabled(True)
                self.dlg.chb_tc_clark.setEnabled(True)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(True)
                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_scs_ranser.setEnabled(False)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_snyder.setEnabled(True)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)

                self.dlg.chb_tc_williams.setChecked(True)
                self.dlg.chb_tc_kirpich.setChecked(True)            
                self.dlg.chb_tc_temez.setChecked(True)
                self.dlg.chb_tc_ventura_heras.setChecked(True)
                self.dlg.chb_tc_bransby_willi.setChecked(True)
                self.dlg.chb_tc_clark.setChecked(True)
                self.dlg.chb_tc_valencua_zuluaga.setChecked(True)
                self.dlg.chb_tc_pilgrim.setChecked(True)

                self.dlg.chb_tl_chow.setChecked(True)
                self.dlg.chb_tl_snyder.setChecked(True)

            elif L!= "" and C_MAX!= "" and C_MIN!= "" and A!= "":


                self.dlg.chb_tc_williams.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(False)            
                self.dlg.chb_tc_temez.setEnabled(False)
                self.dlg.chb_tc_ventura_heras.setEnabled(False)
                self.dlg.chb_tc_bransby_willi.setEnabled(False)
                self.dlg.chb_tc_clark.setEnabled(False)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(False)
                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_scs_ranser.setEnabled(True)
                self.dlg.chb_tc_ccp.setEnabled(True)
                self.dlg.chb_tc_guiadotti.setEnabled(True)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_snyder.setEnabled(True)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_eagleson.setEnabled(True)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)      

                self.dlg.chb_tc_williams.setChecked(True)
                self.dlg.chb_tc_pilgrim.setChecked(True)
                self.dlg.chb_tc_scs_ranser.setChecked(True)
                self.dlg.chb_tc_ccp.setChecked(True)
                self.dlg.chb_tc_guiadotti.setChecked(True)
                self.dlg.chb_tl_eagle.setChecked(True)
                self.dlg.chb_tl_snyder.setChecked(True)
                self.dlg.chb_tl_chow.setChecked(True)          

            elif L!= "" and CN!= "" and S != "" and A!= "":

                self.dlg.chb_tc_williams.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(True)            
                self.dlg.chb_tc_temez.setEnabled(True)
                self.dlg.chb_tc_ventura_heras.setEnabled(True)
                self.dlg.chb_tc_bransby_willi.setEnabled(True)
                self.dlg.chb_tc_clark.setEnabled(True)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(True)
                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_scs_ranser.setEnabled(True)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(True)

                self.dlg.chb_tl_eagleson.setEnabled(True)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_snyder.setEnabled(True)
                self.dlg.chb_tl_scs.setEnabled(True)
                self.dlg.chb_tl_putman.setEnabled(False)

                self.dlg.chb_tc_williams.setChecked(True)
                self.dlg.chb_tc_kirpich.setChecked(True)            
                self.dlg.chb_tc_temez.setChecked(True)
                self.dlg.chb_tc_ventura_heras.setChecked(True)
                self.dlg.chb_tc_bransby_willi.setChecked(True)
                self.dlg.chb_tc_clark.setChecked(True)
                self.dlg.chb_tc_valencua_zuluaga.setChecked(True)
                self.dlg.chb_tc_pilgrim.setChecked(True)
                self.dlg.chb_tc_scs_ranser.setChecked(True)

                self.dlg.chb_tl_chow.setChecked(True)
                self.dlg.chb_tl_snyder.setChecked(True)
                self.dlg.chb_tl_scs.setChecked(True)

            elif L!= "" and CN!= "" and S!= "":

                self.dlg.chb_tc_scs.setEnabled(True)
                self.dlg.chb_tc_temez.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(True)  
                self.dlg.chb_tc_williams.setEnabled(False)            
                self.dlg.chb_tc_ventura_heras.setEnabled(False)
                self.dlg.chb_tc_bransby_willi.setEnabled(False)
                self.dlg.chb_tc_clark.setEnabled(False)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(False)
                self.dlg.chb_tc_pilgrim.setEnabled(False)
                self.dlg.chb_tc_scs_ranser.setEnabled(False)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)


                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_snyder.setEnabled(False)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(True)

                self.dlg.chb_tc_scs.setChecked(True)
                self.dlg.chb_tc_temez.setChecked(True)
                self.dlg.chb_tc_kirpich.setChecked(True)
                self.dlg.chb_tl_chow.setChecked(True)
                self.dlg.chb_tl_scs.setChecked(True)

            elif L!= "" and PERM!= "" and S!= "":

                self.dlg.chb_tc_temez.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(True)  
                self.dlg.chb_tc_williams.setEnabled(False)
                self.dlg.chb_tc_ventura_heras.setEnabled(False)
                self.dlg.chb_tc_bransby_willi.setEnabled(False)
                self.dlg.chb_tc_clark.setEnabled(False)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(False)
                self.dlg.chb_tc_pilgrim.setEnabled(False)
                self.dlg.chb_tc_scs_ranser.setEnabled(False)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_snyder.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)
                self.dlg.chb_tl_putman.setEnabled(False)

                self.dlg.chb_tc_temez.setChecked(True)
                self.dlg.chb_tc_kirpich.setChecked(True)  
                self.dlg.chb_tl_chow.setChecked(True)

            elif L!= "" and A!= "" and S!= "" :

                self.dlg.chb_tc_williams.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(True)            
                self.dlg.chb_tc_temez.setEnabled(True)
                self.dlg.chb_tc_ventura_heras.setEnabled(True)
                self.dlg.chb_tc_bransby_willi.setEnabled(True)
                self.dlg.chb_tc_clark.setEnabled(True)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(True)
                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_scs_ranser.setEnabled(False)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_snyder.setEnabled(True)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)

                self.dlg.chb_tc_williams.setChecked(True)
                self.dlg.chb_tc_kirpich.setChecked(True)            
                self.dlg.chb_tc_temez.setChecked(True)
                self.dlg.chb_tc_ventura_heras.setChecked(True)
                self.dlg.chb_tc_bransby_willi.setChecked(True)
                self.dlg.chb_tc_clark.setChecked(True)
                self.dlg.chb_tc_valencua_zuluaga.setChecked(True)
                self.dlg.chb_tc_pilgrim.setChecked(True)
                self.dlg.chb_tl_chow.setChecked(True)
                self.dlg.chb_tl_snyder.setChecked(True)

            elif L!= "" and C_MAX!= "" and C_MIN!= "" :
                
                self.dlg.chb_tc_scs_ranser.setEnabled(True)
                self.dlg.chb_tc_ccp.setEnabled(True)
                self.dlg.chb_tc_williams.setEnabled(False)
                self.dlg.chb_tc_kirpich.setEnabled(False)            
                self.dlg.chb_tc_temez.setEnabled(False)
                self.dlg.chb_tc_ventura_heras.setEnabled(False)
                self.dlg.chb_tc_bransby_willi.setEnabled(False)
                self.dlg.chb_tc_clark.setEnabled(False)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(False)
                self.dlg.chb_tc_pilgrim.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_snyder.setEnabled(False)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)

                self.dlg.chb_tc_scs_ranser.setChecked(True)
                self.dlg.chb_tc_ccp.setChecked(True)
                self.dlg.chb_tl_chow.setChecked(True)

            elif A!= "" and C_MAX!= "" and C_MIN!= "":

                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_guiadotti.setEnabled(True)
                self.dlg.chb_tc_williams.setEnabled(False)
                self.dlg.chb_tc_kirpich.setEnabled(False)            
                self.dlg.chb_tc_temez.setEnabled(False)
                self.dlg.chb_tc_ventura_heras.setEnabled(False)
                self.dlg.chb_tc_bransby_willi.setEnabled(False)
                self.dlg.chb_tc_clark.setEnabled(False)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(False)
                self.dlg.chb_tc_scs_ranser.setEnabled(False)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_snyder.setEnabled(False)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(True)

                self.dlg.chb_tc_pilgrim.setChecked(True)
                self.dlg.chb_tc_guiadotti.setChecked(True)
                self.dlg.chb_tl_chow.setChecked(True)

            elif A!= "" and L!= "" :
                self.dlg.chb_tc_williams.setEnabled(False)
                self.dlg.chb_tc_kirpich.setEnabled(False)            
                self.dlg.chb_tc_temez.setEnabled(False)
                self.dlg.chb_tc_ventura_heras.setEnabled(False)
                self.dlg.chb_tc_bransby_willi.setEnabled(False)
                self.dlg.chb_tc_clark.setEnabled(False)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(False)
                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_scs_ranser.setEnabled(False)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(True)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)
                self.dlg.chb_tl_snyder.setEnabled(False)

                self.dlg.chb_tc_pilgrim.setChecked(False)
                self.dlg.chb_tl_chow.setChecked(True)

            elif  A!= "" and S!= "" :

                self.dlg.chb_tc_pilgrim.setEnabled(True)
                self.dlg.chb_tc_clark.setEnabled(True)
                self.dlg.chb_tc_williams.setEnabled(False)
                self.dlg.chb_tc_kirpich.setEnabled(False)            
                self.dlg.chb_tc_temez.setEnabled(False)
                self.dlg.chb_tc_ventura_heras.setEnabled(False)
                self.dlg.chb_tc_bransby_willi.setEnabled(False)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(False)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(False)
                self.dlg.chb_tc_scs_ranser.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_snyder.setEnabled(False)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(True)

                self.dlg.chb_tc_pilgrim.setChecked(True)
                self.dlg.chb_tc_clark.setChecked(True)  
                self.dlg.chb_tl_chow.setChecked(True)

            elif L!= "" and S!= "" :

                self.dlg.chb_tc_temez.setEnabled(True)
                self.dlg.chb_tc_kirpich.setEnabled(True)
                self.dlg.chb_tc_williams.setEnabled(False)
                self.dlg.chb_tc_ventura_heras.setEnabled(False)
                self.dlg.chb_tc_bransby_willi.setEnabled(False)
                self.dlg.chb_tc_clark.setEnabled(False)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(False)
                self.dlg.chb_tc_pilgrim.setEnabled(False)
                self.dlg.chb_tc_scs_ranser.setEnabled(False)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(False)

                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(False)
                self.dlg.chb_tl_snyder.setEnabled(False)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)

                self.dlg.chb_tc_temez.setChecked(True)
                self.dlg.chb_tc_kirpich.setChecked(True)

            elif  A!= "" :
                self.dlg.chb_tc_williams.setEnabled(False)
                self.dlg.chb_tc_kirpich.setEnabled(False)            
                self.dlg.chb_tc_temez.setEnabled(False)
                self.dlg.chb_tc_ventura_heras.setEnabled(False)
                self.dlg.chb_tc_bransby_willi.setEnabled(False)
                self.dlg.chb_tc_clark.setEnabled(False)
                self.dlg.chb_tc_valencua_zuluaga.setEnabled(False)
                self.dlg.chb_tc_scs_ranser.setEnabled(False)
                self.dlg.chb_tc_ccp.setEnabled(False)
                self.dlg.chb_tc_guiadotti.setEnabled(False)
                self.dlg.chb_tc_scs.setEnabled(False)
                self.dlg.chb_tc_pilgrim.setEnabled(True)

                self.dlg.chb_tl_eagleson.setEnabled(False)
                self.dlg.chb_tl_snyder.setEnabled(False)
                self.dlg.chb_tl_putman.setEnabled(False)
                self.dlg.chb_tl_scs.setEnabled(False)
                self.dlg.chb_tl_chow.setEnabled(True)

                self.dlg.chb_tc_pilgrim.setChecked(True)
                self.dlg.chb_tl_chow.setChecked(True)

            pass        

    def sql_funtion(self):
        vlayer = self.dlg.cb_invector.currentLayer()
        field = self.dlg.cb_lp.currentText()

    def process(self,vlayer):

            try:
                import pip
            except:
                execfile(os.path.join(self.plugin_dir, get_pip.py))
                import pip
                # just in case the included version is old
                pip.main(['install','--upgrade','pip'])

            try:
                import math
            except:
                pip.main(['install', 'math'])

            try:
                import numpy
            except:
                pip.main(['install', 'numpy'])


            #print(self.dlg.output.filePath())

            if self.dlg.output.filePath() != '' and self.dlg.cb_invector.currentLayer():

                import os
                if os.path.exists(self.dlg.output.filePath()):

                    shape = self.dlg.cb_invector.currentLayer()
                    ruta = self.dlg.output.filePath()
                    options = QgsVectorFileWriter.SaveVectorOptions()
                    options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteFile
                    options.actionOnExistingFile = QgsVectorFileWriter.CreateOrOverwriteLayer
                    options.actionOnExistingFile = QgsVectorFileWriter.AppendToLayerNoNewFields  
                    options.shape = "_".join(shape.name().split(' '))
                    writer = QgsVectorFileWriter.writeAsVectorFormat(shape,ruta,options)
                    layer = QgsVectorLayer(ruta, os.path.basename(ruta), "ogr")
                    provider = layer.dataProvider()
                
                else:

                    shape = self.dlg.cb_invector.currentLayer()
                    ruta = self.dlg.output.filePath()
                    writer = QgsVectorFileWriter.writeAsVectorFormat(shape,ruta,"UTF-8",shape.crs(),driverName="ESRI Shapefile")
                    layer = QgsVectorLayer(ruta, os.path.basename(ruta), "ogr")
                    provider = layer.dataProvider()
                
                #print(ruta)
                #print(layer) 
                
                #Parameters index

                L = self.dlg.cb_lp.currentField()
                S =self.dlg.cb_slope.currentField()
                A= self.dlg.cb_area.currentField()
                A= self.dlg.cb_area.currentField()
                CN = self.dlg.cb_cn.currentField()
                C_MAX = self.dlg.cb_max_height.currentField()
                C_MIN = self.dlg.cb_min_height.currentField()
                PERM = self.dlg.cb_perm.currentField()

                arr = [L,S,A,CN,C_MAX,C_MIN,PERM]

                narr = []
                q1 = []
                na =[]
                contador=0
                if self.dlg.chb_tc_williams.isEnabled() and self.dlg.chb_tc_williams.isChecked():
                    name = "williams"
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:
                            feat.setAttribute(feat.fieldNameIndex(name),((((feat[L]*0.621371))*((feat[A]*0.386102))**0.4)/((math.sqrt(4*feat[A]/math.pi)*0.621371)*((math.atan(feat[S])*(180/math.pi)))**0.25))*60)
                            layer.updateFeature(feat)
                    narr.append(name)
                if self.dlg.chb_tc_kirpich.isEnabled() and self.dlg.chb_tc_kirpich.isChecked(): 
                    name= 'kirpich'
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:

                            feat.setAttribute(feat.fieldNameIndex(name),0.06628*(((feat[L])/math.sqrt(feat[S]))**0.77)*60)
                            layer.updateFeature(feat)
                    narr.append(name)
                if self.dlg.chb_tc_temez.isEnabled() and self.dlg.chb_tc_temez.isChecked(): 
                    name= 'temez' 
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:

                            feat.setAttribute(feat.fieldNameIndex(name),(0.3*(feat[L]/((math.atan(feat[S])*(180/math.pi)))**(0.25))**0.75)*60)
                            layer.updateFeature(feat)
                    narr.append(name)
                if self.dlg.chb_tc_ventura_heras.isEnabled() and self.dlg.chb_tc_ventura_heras.isChecked():
                    name= 'vent_heras' 
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:

                            feat.setAttribute(feat.fieldNameIndex(name),((feat[L]/math.sqrt(feat[A]))*((feat[A]**0.5)/(math.atan(feat[S])*(180/math.pi))))*60)
                            layer.updateFeature(feat)
                    narr.append(name)
                if self.dlg.chb_tc_bransby_willi.isEnabled() and self.dlg.chb_tc_bransby_willi.isChecked():
                    name= 'bran_willi' 
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:

                            feat.setAttribute(feat.fieldNameIndex(name),(21.3*(feat[L]*0.621371) *(1/((feat[A]*0.386102)**0.1)*(feat[S]**0.2))))
                            layer.updateFeature(feat)
                    narr.append(name)
                if self.dlg.chb_tc_clark.isEnabled() and self.dlg.chb_tc_clark.isChecked():
                    name= 'clark' 
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:

                            feat.setAttribute(feat.fieldNameIndex(name),(0.335*(feat[A]*(feat[S]**0.5))**0.593)*60)
                            layer.updateFeature(feat)
                    narr.append(name)
                if self.dlg.chb_tc_valencua_zuluaga.isEnabled() and self.dlg.chb_tc_valencua_zuluaga.isChecked():
                    name= 'valen_zulu' 
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:

                            feat.setAttribute(feat.fieldNameIndex(name),(1.7694*(feat[A]**0.325)*(feat[L]**(-0.096))*((math.atan(feat[S])*(180/math.pi))**(-0.290)))*60)
                            layer.updateFeature(feat)
                    narr.append(name)
                if self.dlg.chb_tc_pilgrim.isEnabled() and self.dlg.chb_tc_pilgrim.isChecked():
                    name= 'pilgrim' 
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:

                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)
                    else:
                        pass

                    it = layer.getFeatures(QgsFeatureRequest())    
                    with edit(layer):
                        for feat in it:
                            feat.setAttribute(feat.fieldNameIndex(name),0.76*(feat[A]**0.38)*60)
                            layer.updateFeature(feat)
                    narr.append(name)
                if self.dlg.chb_tc_scs_ranser.isEnabled() and self.dlg.chb_tc_scs_ranser.isChecked():
                    name= 'scs_ranser' 
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:

                            feat.setAttribute(feat.fieldNameIndex(name),(0.97*(feat[L]**3/(feat[C_MAX]-feat[C_MIN]))**0.385)*60)
                            layer.updateFeature(feat)
                    narr.append(name)
                if self.dlg.chb_tc_ccp.isEnabled() and self.dlg.chb_tc_ccp.isChecked():
                    name= 'ccp' 
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:

                            feat.setAttribute(feat.fieldNameIndex(name),60*(11.9*((feat[L]*0.621371)**3)/((feat[C_MAX]-feat[C_MIN])*3.28084)))
                            layer.updateFeature(feat)
                    narr.append(name)
                if self.dlg.chb_tc_guiadotti.isEnabled() and self.dlg.chb_tc_guiadotti.isChecked():
                    name= 'guiadotti' 
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:

                            feat.setAttribute(feat.fieldNameIndex(name),(((4*math.sqrt(feat[A]))+(1.5*feat[L]))/(0.8*math.sqrt((feat[C_MAX]-feat[C_MIN]))))*60)
                            layer.updateFeature(feat)
                if self.dlg.chb_tc_scs.isEnabled() and self.dlg.chb_tc_scs.isChecked(): 
                    name= 'scs' 
                    contador +=1
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:
                            feat.setAttribute(feat.fieldNameIndex(name),(((0.0136*(feat[L]*1000)**0.8))*(((1000/feat[CN])-9)**0.7))/(feat[S]**0.5))
                            layer.updateFeature(feat)
                    narr.append(name)

                self.dlg.progressBar.setValue(25)
                ##### Calculation the Average of time of contentration ###########################
                #print(narr)
                prom_tc = 'Mean_Tc' 
                if layer.dataProvider().fieldNameIndex(prom_tc) == -1:
                    provider.addAttributes([QgsField(prom_tc, QVariant.Double)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(prom_tc)
                    #print(idx)                        
                else:
                    pass              
                it = layer.getFeatures(QgsFeatureRequest())

                with edit(layer):
                    for feat in it:
                        meanarr=[]
                        for i in narr:
                            meanarr.append(feat[i])
                        prom = numpy.mean(meanarr)
                        #print(prom)
                        feat.setAttribute(feat.fieldNameIndex(prom_tc), float(prom))
                        layer.updateFeature(feat)                
                ##### Calculation the Standar Desviation of time of contentration ###########################
                sta_tc = 'Std_Tc' 
                if layer.dataProvider().fieldNameIndex(sta_tc) == -1:
                    provider.addAttributes([QgsField(sta_tc, QVariant.Double)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(sta_tc)
                    #print(idx)                        
                else:
                    pass                
                it = layer.getFeatures(QgsFeatureRequest())

                with edit(layer):
                    for feat in it:
                        meanarr=[]
                        for i in narr:
                            meanarr.append(feat[i])
                        std = numpy.std(meanarr)
                        #print(prom)
                        feat.setAttribute(feat.fieldNameIndex(sta_tc), float(std))
                        layer.updateFeature(feat)   

            ##### First quantil #########################################################

                q1tc = "Q2_Tc"
                if layer.dataProvider().fieldNameIndex(q1tc) == -1:
                    provider.addAttributes([QgsField(q1tc, QVariant.Double)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(q1tc)
                    #print(idx)                        
                else:
                    pass

                it = layer.getFeatures(QgsFeatureRequest())
                with edit(layer):
                    for feat in it:
                        meanarr=[]
                        for i in narr:
                            meanarr.append(feat[i])
                            #print(meanarr)
                        q1 = numpy.percentile(meanarr, 50)

                        feat.setAttribute(feat.fieldNameIndex(q1tc), float(q1))
                        layer.updateFeature(feat)

            ##### Dates in First quantil #########################################################

                dq1tc = "N_Q2_Tc"
                if layer.dataProvider().fieldNameIndex(dq1tc) == -1:
                    provider.addAttributes([QgsField(dq1tc, QVariant.Int)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(dq1tc)
                    #print(idx)                        
                else:
                    pass

                it = layer.getFeatures(QgsFeatureRequest())
                with edit(layer):
                    for feat in it:
                        meanarr=[]
                        for i in narr:
                            if feat[i] <= feat[q1tc]:
                                meanarr.append(feat[i])
                            #print(meanarr)
                        q = len(meanarr)

                        feat.setAttribute(feat.fieldNameIndex(dq1tc), int(q))
                        layer.updateFeature(feat)

                ##### Calculation the Timmed mean of time of contentration ###########################

                trimmed_tc = 'Trimean_Tc' 
                if layer.dataProvider().fieldNameIndex(trimmed_tc) == -1:
                    provider.addAttributes([QgsField(trimmed_tc, QVariant.Double)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(trimmed_tc)
                    #print(idx)                        
                else:
                    pass                
                it = layer.getFeatures(QgsFeatureRequest())

                if contador > 3:
                    with edit(layer):
                        for feat in it:
                            meanarr=[]
                            for i in narr:
                                max = feat[prom_tc] + feat[sta_tc]
                                min = feat[prom_tc] - feat[sta_tc]

                                if feat[dq1tc]/contador < 0.5:
                                    if feat[i] <= max and feat[i]>= min:
                                        meanarr.append(feat[i])
                                else:
                                    if feat[i] <= max:
                                        meanarr.append(feat[i])

                            #print(meanarr)
                            trim = numpy.mean(meanarr)
                            #print(prom)
                            feat.setAttribute(feat.fieldNameIndex(trimmed_tc), float(trim))
                            layer.updateFeature(feat) 
                else:

                    with edit(layer):
                        for feat in it:
                            meanarr=[]
                            for i in narr:
                                max = feat[prom_tc] + feat[sta_tc]
                                min = feat[prom_tc] - feat[sta_tc]

                                if feat[i] <= max :
                                    meanarr.append(feat[i])
                            #print(meanarr)
                            trim = numpy.mean(meanarr)
                            #print(prom)
                            feat.setAttribute(feat.fieldNameIndex(trimmed_tc), float(trim))
                            layer.updateFeature(feat) 

                print(contador)

                symb_tc = 'symb_Tc' 

                if layer.dataProvider().fieldNameIndex(symb_tc) == -1:
                    provider.addAttributes([QgsField(symb_tc, QVariant.Double,len=7, prec=4)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(symb_tc)
                    #print(idx)                        
                else:
                    pass    

                it = layer.getFeatures(QgsFeatureRequest())            

                with edit(layer):
                    for feat in it:
                            feat.setAttribute(feat.fieldNameIndex(symb_tc),feat[trimmed_tc])
                            layer.updateFeature(feat)

                ##### Selecction of time of contentration ###########################

                tc = 'Tc' 
                if layer.dataProvider().fieldNameIndex(tc) == -1:
                    provider.addAttributes([QgsField(tc, QVariant.String)])
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(tc)
                    #print(idx)                
                else:
                    pass

                it = layer.getFeatures(QgsFeatureRequest())

                with edit(layer):
                    for feat in it:
                        aproxc=10000000000
                        for i in narr:
                            aprox= numpy.absolute(feat[trimmed_tc]-feat[i])
                            if aprox < aproxc:
                                aproxc=aprox 
                                aproxi= i
                                #print(aproxi)

                        meanarr=aproxi
                        #print(meanarr)

                        if meanarr=="williams":
                            self.sel_tc="WILLIAMS"
                        elif meanarr=="kirpich  ":
                            self.sel_tc="KIRPICH"  
                        elif meanarr=="temez":
                            self.sel_tc="TEMEZ"
                        elif meanarr=="vent_heras":
                            self.sel_tc="VENTURA-HERAS"
                        elif meanarr=="bran_willi":
                            self.sel_tc="BRANSBY-WILLIAMS"
                        elif meanarr=="clark":
                            self.sel_tc="CLARK"
                        elif meanarr=="valen_zulu":
                            self.sel_tc="VALENCUA-ZULUAGA"
                        elif meanarr=="pilgrim":
                            self.sel_tc="PILGRIM"
                        elif meanarr=="scs_ranser":
                            self.sel_tc="SCS-RANSER"
                        elif meanarr=="ccp":
                            self.sel_tc="CALIFORNIA CULVERT PRACTICE"
                        elif meanarr=="guiadotti":
                            self.sel_tc="GUIADOTTI"
                        elif meanarr=="scs":
                            self.sel_tc="SCS"
                        else:
                            self.sel_tc='None'

                        feat.setAttribute(feat.fieldNameIndex(tc),self.sel_tc)
                        layer.updateFeature(feat)

                self.dlg.progressBar.setValue(50)
        ######################################### LAG TIME #################################################################
                narrtl=[]
                cont = 0

                if self.dlg.chb_tl_eagleson.isEnabled() and self.dlg.chb_tl_eagleson.isChecked():
                    name= 'eagleson' 
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:
                            feat.setAttribute(feat.fieldNameIndex(name),float(0.32*(((feat[L]*0.621371)*(0.54*(numpy.mean([(1.4*(feat[A]**0.568))*0.386102,((1.7*((feat[A]*0.386102)**0.58))),(((1.64*((feat[A]*0.386102)**0.55)))),(((1.6*((feat[A]*0.386102)**0.55))))]))**0.58)/(numpy.sqrt((((feat[C_MAX] - feat[C_MIN])*3.28084)/ feat[L]*0.621371)))**0.39))*60))
                            layer.updateFeature(feat)
                    narrtl.append(name)
                    cont +=1
                if self.dlg.chb_tl_chow.isEnabled() and self.dlg.chb_tl_chow.isChecked():
                    name= 'chow' 
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)

                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:
                            feat.setAttribute(feat.fieldNameIndex(name),(feat[trimmed_tc]*0.6))
                            layer.updateFeature(feat)
                    narrtl.append(name)
                    cont +=1
                if self.dlg.chb_tl_snyder.isEnabled() and self.dlg.chb_tl_snyder.isChecked():
                    name= 'snyder' 
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:
                            feat.setAttribute(feat.fieldNameIndex(name),float(0.32*((((0.54*(numpy.mean([(1.4*(feat[A]**0.568))*0.386102,((1.7*((feat[A]*0.386102)**0.58))),(((1.64*((feat[A]*0.386102)**0.55)))),(((1.6*((feat[A]*0.386102)**0.55))))]))**0.58)*(feat[L]*0.621371)/feat[S]**0.5)**1.42))))
                            layer.updateFeature(feat)
                    narrtl.append(name)
                    cont +=1
                if self.dlg.chb_tl_putman.isEnabled() and self.dlg.chb_tl_putman.isChecked():
                    name= 'putman' 
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:
                            feat.setAttribute(feat.fieldNameIndex(name),(0.49*(math.sqrt((feat[L]*0.621371))/(math.sqrt((((feat[C_MAX] - feat[C_MIN])*3.28084)/ feat[L]*0.621371))*(feat[PERM]**-0.57)))*60))
                            layer.updateFeature(feat)
                            #print('updated')
                    narrtl.append(name)
                    cont +=1
                if self.dlg.chb_tl_scs.isEnabled() and self.dlg.chb_tl_scs.isChecked():
                    name= 'tl_scs' 
                    if layer.dataProvider().fieldNameIndex(name) == -1:
                        provider.addAttributes([QgsField(name, QVariant.Double)]) 
                        layer.updateFields() 
                        idx = layer.fields().indexFromName(name)
                        #print(idx)                        
                    else:
                        pass
                    it = layer.getFeatures(QgsFeatureRequest())
                    with edit(layer):
                        for feat in it:
                            feat.setAttribute(feat.fieldNameIndex(name),((feat[L]**0.8)*((((1000/feat[CN])-9)**0.7)/((1900*((math.atan(feat[S])*180/math.pi)))**0.5)))*60)
                            layer.updateFeature(feat)
                    narrtl.append(name)
                    cont +=1

                self.dlg.progressBar.setValue(75)

                ##### Calculation the Average of time of contentration ###########################
                prom_tl = 'Mean_Lt' 
                if layer.dataProvider().fieldNameIndex(prom_tl) == -1:
                    provider.addAttributes([QgsField(prom_tl, QVariant.Double)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(prom_tl)
                    #print(idx)                        
                else:
                    pass            
                it = layer.getFeatures(QgsFeatureRequest())

                with edit(layer):
                    for feat in it:
                        meanarr=[]
                        for i in narrtl:
                            meanarr.append(feat[i])
                        prom = numpy.mean(meanarr)
                        #print(prom)
                        feat.setAttribute(feat.fieldNameIndex(prom_tl), float(prom))
                        layer.updateFeature(feat)                
                ##### Calculation the Standar Desviation of time of contentration ###########################

                sta_tl = 'Std_Lt' 
                if layer.dataProvider().fieldNameIndex(sta_tl) == -1:
                    provider.addAttributes([QgsField(sta_tl, QVariant.Double)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(sta_tl)
                    #print(idx)                        
                else:
                    pass     

                it = layer.getFeatures(QgsFeatureRequest())
                with edit(layer):
                    for feat in it:
                        meanarr=[]
                        for i in narrtl:
                            meanarr.append(feat[i])
                        std_tl = numpy.std(meanarr)
                        feat.setAttribute(feat.fieldNameIndex(sta_tl), float(std_tl))
                        layer.updateFeature(feat)   

            ##### First quantil #########################################################

                q1tl = "Q2_Lt"
                if layer.dataProvider().fieldNameIndex(q1tl) == -1:
                    provider.addAttributes([QgsField(q1tl, QVariant.Double)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(q1tl)
                    #print(idx)                        
                else:
                    pass

                it = layer.getFeatures(QgsFeatureRequest())
                with edit(layer):
                    for feat in it:
                        meanarr=[]
                        for i in narrtl:
                            meanarr.append(feat[i])
                            #print(meanarr)
                        q1 = numpy.percentile(meanarr, 50)

                        feat.setAttribute(feat.fieldNameIndex(q1tl), float(q1))
                        layer.updateFeature(feat)

            ##### Dates in First quantil #########################################################

                dq1tl = "N_Q2_Lt"
                if layer.dataProvider().fieldNameIndex(dq1tl) == -1:
                    provider.addAttributes([QgsField(dq1tl, QVariant.Int)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(dq1tl)
                    #print(idx)                        
                else:
                    pass

                it = layer.getFeatures(QgsFeatureRequest())
                with edit(layer):
                    for feat in it:
                        meanarr=[]
                        for i in narrtl:
                            if feat[i] <= feat[q1tl]:
                                meanarr.append(feat[i])
                            #print(meanarr)
                        q = len(meanarr)

                        feat.setAttribute(feat.fieldNameIndex(dq1tl), int(q))
                        layer.updateFeature(feat)



            ##### Calculation the Timmed mean of time of contentration ###########################

                trimmed_tl = 'Trimean_Lt' 
                if layer.dataProvider().fieldNameIndex(trimmed_tl) == -1:
                    provider.addAttributes([QgsField(trimmed_tl, QVariant.Double)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(trimmed_tl)
                    #print(idx)                        
                else:
                    pass           
                it = layer.getFeatures(QgsFeatureRequest())

                if cont > 3:
                    with edit(layer):
                        for feat in it:
                            meanarr=[]
                            for i in narrtl:
                                max = feat[prom_tl] + feat[sta_tl]
                                min = feat[prom_tl] - feat[sta_tl]

                                if feat[dq1tl]/cont < 0.5:
                                    if feat[i] <= max and feat[i]>= min:
                                        meanarr.append(feat[i])
                                else:
                                    if feat[i] <= max:
                                        meanarr.append(feat[i])

                            #print(meanarr)
                            trim = numpy.mean(meanarr)
                            #print(prom)
                            feat.setAttribute(feat.fieldNameIndex(trimmed_tl), float(trim_tl))
                            layer.updateFeature(feat) 

                else:
                    with edit(layer):
                        for feat in it:
                            meanarr=[]
                            for i in narrtl:
                                max = feat[prom_tl] + feat[sta_tl]
                                min = feat[prom_tl] - feat[sta_tl]

                                if feat[i] <= max:
                                    meanarr.append(feat[i])
                            #print(meanarr)
                            trim_tl = numpy.mean(meanarr)
                            feat.setAttribute(feat.fieldNameIndex(trimmed_tl), float(trim_tl))
                            layer.updateFeature(feat) 

                symb_tl = 'symb_Lt' 
                if layer.dataProvider().fieldNameIndex(symb_tl) == -1:
                    provider.addAttributes([QgsField(symb_tl, QVariant.Double,len=7,prec=4)]) 
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(symb_tl)
                    #print(idx)                        
                else:
                    pass           
                it = layer.getFeatures(QgsFeatureRequest())

                with edit(layer):
                    for feat in it:
                            feat.setAttribute(feat.fieldNameIndex(symb_tl),feat[trimmed_tl])
                            layer.updateFeature(feat)

                ##### Selecction of time of contentration ###########################

                tl = 'Lt' 
                if layer.dataProvider().fieldNameIndex(tl) == -1:
                    provider.addAttributes([QgsField(tl, QVariant.String)])                     
                    layer.updateFields() 
                    idx = layer.fields().indexFromName(tl)
                    #print(idx)   
                else:
                    pass

                it = layer.getFeatures(QgsFeatureRequest())
                with edit(layer):
                    for feat in it:
                        aproxc=10000000000
                        meanarr=""
                        for i in narrtl:
                            aprox= numpy.absolute(feat[trimmed_tl]-feat[i])
                            if aprox < aproxc:
                                aproxc=aprox
                                aproxi= i

                        meanarr=aproxi  
                        #print(meanarr)

                        if meanarr=="eagleson":
                            self.sel_tl="EAGLESON"
                        elif meanarr=="chow":
                            self.sel_tl="CHOW"  
                        elif meanarr=="snyder":
                            self.sel_tl="SNYDER"
                        elif meanarr=="putman":
                            self.sel_tl="PUTMAN"
                        elif meanarr=="tl_scs":
                            self.sel_tl="SCS"
                        
                        feat.setAttribute(feat.fieldNameIndex(tl), self.sel_tl)
                        layer.updateFeature(feat)

                self.dlg.progressBar.setValue(100)           


                fieldName = 'symb_Tc'
                provider = layer.dataProvider()
                numberOfClasses = 5
                color1 = QColor('#f7fbff')  
                color2 = QColor('#1f78b4')
                  
                ramp =  QgsGradientColorRamp(color1, color2)

                rend = QgsGraduatedSymbolRenderer.createRenderer(layer, 
                                                                       fieldName, 
                                                                       numberOfClasses, 
                                                                       QgsGraduatedSymbolRenderer.Jenks, 
                                                                       QgsSymbol.defaultSymbol(layer.geometryType()), 
                                                                       ramp,
                                                                       legendFormat = QgsRendererRangeLabelFormat('%1 - %2',precision = 12,trimTrailingZeroes = False ))

                fieldName1 = 'symb_Lt'
                provider1 = layer.dataProvider()
                numberOfClasses1 = 5
                color11 = QColor('#ffffff')  
                color21 = QColor('#3e0000')
                  
                ramp1 =  QgsGradientColorRamp(color11, color21)

                rend1 = QgsGraduatedSymbolRenderer.createRenderer(layer, 
                                                                  fieldName1, 
                                                                  numberOfClasses1, 
                                                                  QgsGraduatedSymbolRenderer.Jenks, 
                                                                  QgsSymbol.defaultSymbol(layer.geometryType()), 
                                                                  ramp1,
                                                                  legendFormat = QgsRendererRangeLabelFormat('%1 - %2',precision = 12,trimTrailingZeroes = False))
                
                r1= QgsRuleBasedRenderer.Rule(None, 0, 0, label='Time of Concentration (Min)')
                r2= QgsRuleBasedRenderer.Rule(None, 0, 0, label='Lag Time (Min)')

                ref1=QgsRuleBasedRenderer.refineRuleRanges(r1, rend)
                ref2=QgsRuleBasedRenderer.refineRuleRanges(r2, rend1)


                rootrule = QgsRuleBasedRenderer.Rule(None)
                rootrule.appendChild(r1)
                rootrule.appendChild(r2)

                # assign the created renderer to the layer
                if rootrule is not None:
                    layer.setRenderer(QgsRuleBasedRenderer(rootrule))

                layer.triggerRepaint()

                layer_settings  = QgsPalLayerSettings()
                text_format = QgsTextFormat()

                text_format.setFont(QFont("Arial", 8))
                text_format.setSize(8)

                buffer_settings = QgsTextBufferSettings()
                buffer_settings.setEnabled(True)
                buffer_settings.setSize(1)
                buffer_settings.setColor(QColor("white"))

                text_format.setBuffer(buffer_settings)
                layer_settings.setFormat(text_format)

                layer_settings.fieldName = "'TC:' ||'  '||Tc||'\n'|| 'LAG TIME:' ||'  '||Lt"
                layer_settings.placement = 4

                layer_settings.enabled = True
                layer_settings.isExpression = True
                layer_settings.drawLabels = True

                layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
                layer.setLabelsEnabled(True)
                layer.setLabeling(layer_settings)
                layer.triggerRepaint()
                QgsProject.instance().addMapLayer(layer)

                ret = QMessageBox.question(self.iface.pluginMenu(),'', "Do you want to log out?", QMessageBox.Yes | QMessageBox.No)

                if ret == QMessageBox.Yes:
                    self.cancel()
                else:
                    self.dlg.progressBar.setValue(0)   
            else:
                QMessageBox.information(self.iface.pluginMenu(), "Output file", 'There is not output file')

    def cancel(self):

        self.dlg.destroy()

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            #self.first_start = False
            self.dlg = TC_TLAGDialog()

       
        self.dlg.cb_invector.setFilters(QgsMapLayerProxyModel.PolygonLayer)
        vlayer = self.dlg.cb_invector.currentLayer()
        #print (vlayer)

        self.dlg.output.setStorageMode(self.dlg.output.SaveFile)
        self.dlg.output.setConfirmOverwrite(True)
        self.dlg.output.setFilter(self.tr("ESRI Shapefile (*.shp *.SHP)"))

        self.dlg.cb_lp.setLayer(vlayer)
        self.dlg.cb_area.setLayer(vlayer)
        self.dlg.cb_slope.setLayer(vlayer)
        self.dlg.cb_max_height.setLayer(vlayer)
        self.dlg.cb_min_height.setLayer(vlayer)
        self.dlg.cb_cn.setLayer(vlayer)  
        self.dlg.cb_perm.setLayer(vlayer)
            
        self.dlg.cb_invector.layerChanged.connect(self.select_layer_fields)
        self.dlg.cb_lp.fieldChanged.connect(self.check_box_able)
        self.dlg.cb_area.fieldChanged.connect(self.check_box_able)
        self.dlg.cb_slope.fieldChanged.connect(self.check_box_able)
        self.dlg.cb_max_height.fieldChanged.connect(self.check_box_able)
        self.dlg.cb_min_height.fieldChanged.connect(self.check_box_able)
        self.dlg.cb_cn.fieldChanged.connect(self.check_box_able)  
        self.dlg.cb_perm.fieldChanged.connect(self.check_box_able)  

         # show the dialog
        self.dlg.show()

        self.dlg.pushButtoncancel.clicked.connect(self.cancel)
        self.dlg.pushButtonok.clicked.connect(self.process)

        result = self.dlg.exec_()
        # See if OK was pressed
        if result:

            pass




       


