#! python3  # noqa: E265

"""
Wikidata Tab dialog.
"""

# PyQGIS
from qgis.gui import QgsFieldComboBox

# Import PyQt libs
from qgis.PyQt.QtWidgets import (
    QButtonGroup,
    QCheckBox,
    QLabel,
    QStackedWidget,
    QVBoxLayout,
    QWidget,
)


class WikidataTab(QWidget):
    """ """

    def __init__(self, parent):
        super().__init__()

        wikidata_layout = QVBoxLayout()
        wikidata_check_group = QButtonGroup(self)
        wikidata_check_group.setExclusive(True)

        # Wikidata GBIF Taxon id Checkbox
        self.wikidata_gbif_checkbox = QCheckBox()
        self.wikidata_gbif_checkbox.setText(
            self.tr("Use GBIF taxon id as reference to get TAXREF id:")
        )
        self.wikidata_gbif_checkbox.setChecked(True)
        wikidata_check_group.addButton(self.wikidata_gbif_checkbox, 0)
        wikidata_layout.addWidget(self.wikidata_gbif_checkbox)

        # Wikidata iNaturalist Taxon id Checkbox
        self.wikidata_inaturalist_checkbox = QCheckBox()
        self.wikidata_inaturalist_checkbox.setText(
            self.tr("Use iNaturalist taxon id as reference to get TAXREF id:")
        )
        self.wikidata_inaturalist_checkbox.setChecked(False)
        wikidata_check_group.addButton(self.wikidata_inaturalist_checkbox, 1)
        wikidata_layout.addWidget(self.wikidata_inaturalist_checkbox)

        # Wikidata Stack
        self.wikidata_stack = QStackedWidget()
        # Wikidata GBIF Stack
        wikidata_gbif_page = QWidget()
        wikidata_gbif_layout = QVBoxLayout()
        select_field_wikidata_gbif_label = QLabel(self)
        select_field_wikidata_gbif_label.setText(
            self.tr("Select a field containing GBIF taxon id")
        )
        wikidata_gbif_layout.addWidget(select_field_wikidata_gbif_label)
        self.select_field_wikidata_gbif_combo_box = QgsFieldComboBox(self)
        self.select_field_wikidata_gbif_combo_box.setAllowEmptyFieldName(False)
        if parent.select_layer_combo_box.currentLayer():
            self.select_field_wikidata_gbif_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        parent.select_layer_combo_box.layerChanged.connect(
            lambda: self.select_field_wikidata_gbif_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        )
        wikidata_gbif_layout.addWidget(self.select_field_wikidata_gbif_combo_box)
        wikidata_gbif_page.setLayout(wikidata_gbif_layout)
        self.wikidata_stack.addWidget(wikidata_gbif_page)

        # Wikidata iNaturalist Stack
        wikidata_inaturalist_page = QWidget()
        wikidata_inaturalist_layout = QVBoxLayout()
        select_field_wikidata_inaturalist_label = QLabel(self)
        select_field_wikidata_inaturalist_label.setText(
            self.tr("Select a field containing iNaturalist taxon id")
        )
        wikidata_inaturalist_layout.addWidget(select_field_wikidata_inaturalist_label)
        self.select_field_wikidata_inaturalist_combo_box = QgsFieldComboBox(self)
        self.select_field_wikidata_inaturalist_combo_box.setAllowEmptyFieldName(False)
        if parent.select_layer_combo_box.currentLayer():
            self.select_field_wikidata_inaturalist_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        parent.select_layer_combo_box.layerChanged.connect(
            lambda: self.select_field_wikidata_inaturalist_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        )
        wikidata_inaturalist_layout.addWidget(
            self.select_field_wikidata_inaturalist_combo_box
        )
        wikidata_inaturalist_page.setLayout(wikidata_inaturalist_layout)
        self.wikidata_stack.addWidget(wikidata_inaturalist_page)

        # Add Layout
        wikidata_layout.addWidget(self.wikidata_stack)
        self.setLayout(wikidata_layout)

        # Ui signals
        wikidata_check_group.buttonClicked.connect(
            lambda: self.wikidata_stack.setCurrentIndex(
                wikidata_check_group.checkedId()
            )
        )

    def append_organiser(self, organiser, tab_index):
        organiser[tab_index] = {
            "stack": self.wikidata_stack,
            0: {"field": self.select_field_wikidata_gbif_combo_box},
            1: {"field": self.select_field_wikidata_inaturalist_combo_box},
        }
        return organiser
