#! python3  # noqa: E265

"""
GBIF Tab dialog.
"""

# PyQGIS
from qgis.gui import QgsFieldComboBox

# Import PyQt libs
from qgis.PyQt.QtWidgets import (
    QButtonGroup,
    QCheckBox,
    QLabel,
    QStackedWidget,
    QVBoxLayout,
    QWidget,
)


class GbifTab(QWidget):
    """ """

    def __init__(self, parent):
        super().__init__()
        gbif_layout = QVBoxLayout()

        gbif_check_group = QButtonGroup(self)
        gbif_check_group.setExclusive(True)

        # GBIF taxon id checkbox
        self.gbif_taxon_id_checkbox = QCheckBox()
        self.gbif_taxon_id_checkbox.setText(
            self.tr("Use GBIF taxon id as reference to get TAXREF id (not available):")
        )
        self.gbif_taxon_id_checkbox.setEnabled(False)
        gbif_check_group.addButton(self.gbif_taxon_id_checkbox, 0)
        gbif_layout.addWidget(self.gbif_taxon_id_checkbox)
        # GBIF taxon id checkbox
        self.gbif_sci_name_checkbox = QCheckBox()
        self.gbif_sci_name_checkbox.setText(
            self.tr("Use Scientific Name as reference to get TAXREF id :")
        )
        self.gbif_sci_name_checkbox.setChecked(True)
        gbif_check_group.addButton(self.gbif_sci_name_checkbox, 1)
        gbif_layout.addWidget(self.gbif_sci_name_checkbox)

        # GBIF Stack
        self.gbif_stack = QStackedWidget()
        # GBIF Taxon ID stack
        gbif_id_page = QWidget()
        gbif_id_layout = QVBoxLayout()
        select_field_gbif_label = QLabel(self)
        select_field_gbif_label.setText(
            self.tr("Select a field containing GBIF taxon id")
        )
        gbif_id_layout.addWidget(select_field_gbif_label)
        self.select_field_gbif_combo_box = QgsFieldComboBox(self)
        self.select_field_gbif_combo_box.setAllowEmptyFieldName(False)
        if parent.select_layer_combo_box.currentLayer():
            self.select_field_gbif_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        parent.select_layer_combo_box.layerChanged.connect(
            lambda: self.select_field_gbif_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        )
        gbif_id_layout.addWidget(self.select_field_gbif_combo_box)
        gbif_id_page.setLayout(gbif_id_layout)
        self.gbif_stack.addWidget(gbif_id_page)

        # GBIF Scientific Name stack
        gbif_sci_name_page = QWidget()
        gbif_sci_name_layout = QVBoxLayout()
        select_field_sci_name_label = QLabel(self)
        select_field_sci_name_label.setText(
            self.tr("Select a field containing Scientific Name")
        )
        gbif_sci_name_layout.addWidget(select_field_sci_name_label)
        self.select_field_scientific_name_combo_box = QgsFieldComboBox(self)
        self.select_field_scientific_name_combo_box.setAllowEmptyFieldName(False)
        if parent.select_layer_combo_box.currentLayer():
            self.select_field_scientific_name_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        parent.select_layer_combo_box.layerChanged.connect(
            lambda: self.select_field_scientific_name_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        )
        gbif_sci_name_layout.addWidget(self.select_field_scientific_name_combo_box)
        gbif_sci_name_page.setLayout(gbif_sci_name_layout)
        self.gbif_stack.addWidget(gbif_sci_name_page)
        self.gbif_stack.setCurrentIndex(1)

        # Add Layout
        gbif_layout.addWidget(self.gbif_stack)
        self.setLayout(gbif_layout)

        # Ui signals
        gbif_check_group.buttonClicked.connect(
            lambda: self.gbif_stack.setCurrentIndex(gbif_check_group.checkedId())
        )

    def append_organiser(self, organiser, tab_index):
        organiser[tab_index] = {
            "stack": self.gbif_stack,
            0: {"field": self.select_field_gbif_combo_box},
            1: {"field": self.select_field_scientific_name_combo_box},
        }
        return organiser
