#! python3  # noqa: E265

"""
INPN Tab dialog.
"""

# PyQGIS
from qgis.gui import QgsFieldComboBox

# Import PyQt libs
from qgis.PyQt.QtWidgets import (
    QButtonGroup,
    QCheckBox,
    QLabel,
    QStackedWidget,
    QVBoxLayout,
    QWidget,
)


class InpnTab(QWidget):
    """ """

    def __init__(self, parent):
        super().__init__()
        inpn_layout = QVBoxLayout()

        inpn_check_group = QButtonGroup(self)
        inpn_check_group.setExclusive(True)

        # Inpn Scientific Name checkbox
        self.inpn_sci_name_checkbox = QCheckBox()
        self.inpn_sci_name_checkbox.setText(
            self.tr("Use scientific name as reference to get TAXREF id:")
        )
        self.inpn_sci_name_checkbox.setChecked(True)
        inpn_check_group.addButton(self.inpn_sci_name_checkbox, 0)
        inpn_layout.addWidget(self.inpn_sci_name_checkbox)
        # Probably other roads to add

        # INPN Stack
        self.inpn_stack = QStackedWidget()

        # INPN Scientific Name Stack
        inpn_sci_name_page = QWidget()
        inpn_sci_name_page_layout = QVBoxLayout()
        select_field_inpn_sci_name_label = QLabel(self)
        select_field_inpn_sci_name_label.setText(
            self.tr("Select a field containing species name")
        )
        inpn_sci_name_page_layout.addWidget(select_field_inpn_sci_name_label)
        self.select_field_inpn_sci_name_combo_box = QgsFieldComboBox(self)
        self.select_field_inpn_sci_name_combo_box.setAllowEmptyFieldName(False)
        if parent.select_layer_combo_box.currentLayer():
            self.select_field_inpn_sci_name_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        parent.select_layer_combo_box.layerChanged.connect(
            lambda: self.select_field_inpn_sci_name_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        )
        inpn_sci_name_page_layout.addWidget(self.select_field_inpn_sci_name_combo_box)
        select_field_inpn_rank_label = QLabel(self)
        select_field_inpn_rank_label.setText(
            self.tr("Select a field containing rank of observation (optionnal)")
        )
        inpn_sci_name_page_layout.addWidget(select_field_inpn_rank_label)
        self.select_field_inpn_rank_combo_box = QgsFieldComboBox(self)
        self.select_field_inpn_rank_combo_box.setAllowEmptyFieldName(True)
        if parent.select_layer_combo_box.currentLayer():
            self.select_field_inpn_rank_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        parent.select_layer_combo_box.layerChanged.connect(
            lambda: self.select_field_inpn_rank_combo_box.setLayer(
                parent.select_layer_combo_box.currentLayer()
            )
        )
        inpn_sci_name_page_layout.addWidget(self.select_field_inpn_rank_combo_box)
        inpn_sci_name_page.setLayout(inpn_sci_name_page_layout)
        self.inpn_stack.addWidget(inpn_sci_name_page)

        # Add INPN Tab
        inpn_layout.addWidget(self.inpn_stack)
        self.setLayout(inpn_layout)

        # Ui signals
        inpn_check_group.buttonClicked.connect(
            lambda: self.inpn_stack.setCurrentIndex(inpn_check_group.checkedId())
        )

    def append_organiser(self, organiser, tab_index):
        organiser[tab_index] = {
            "stack": self.inpn_stack,
            0: {
                "field": self.select_field_inpn_sci_name_combo_box,
                "optional": self.select_field_inpn_rank_combo_box,
            },
        }
        return organiser
