# -*- coding: utf-8 -*-
"""
/***************************************************************************
 TanakaContours
                                 A QGIS plugin
 Generates Tanaka contours from DEM
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-06-10
        copyright            : (C) 2022 by Richard Moritz
        email                : richi.moritz.rm@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""



#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ Imports ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
from fileinput import filename
from xml.etree.ElementInclude import include
import re
from math import floor, ceil

from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *
from qgis.PyQt.QtWidgets import *
from qgis.core import *
import processing
from qgis.utils import iface
from qgis.core.additions.edit import edit

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .tanaka_contours_dialog import TanakaContoursDialog
import os.path
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~






# --------------- Class beginning ------------------------------
"""QGIS Plugin Implementation."""

class TanakaContours:

    def __init__(self, iface):
    # save reference to the QGIS interface
        self.iface = iface

    def initGui(self):
    # create action that will start plugin configuration
        self.action = QAction(QIcon(':/plugins/tanaka_contours/icon.png'), "TanakaContours", self.iface.mainWindow())
        self.action.triggered.connect(self.run)

    # add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.first_start = True

    def unload(self):
    # remove the plugin menu item and icon
        self.iface.removePluginMenu("&Test plugins", self.action)
        self.iface.removeToolBarIcon(self.action)

    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def getNoDataValue(self):
        self.rasterName = self.dlg.comboBox_input.currentText()
        self.raster_path = self.input_rasterLayer[self.rasterName].source()

        raster_path = self.input_rasterLayer[self.rasterName].source()
        rlayer = QgsRasterLayer(raster_path, "Raster Layer")
        extent = rlayer.extent()

        provider = rlayer.dataProvider()
        rows = rlayer.rasterUnitsPerPixelY()
        cols = rlayer.rasterUnitsPerPixelX()

        block = provider.block(1, extent, rows, cols)
        self.stats = rlayer.dataProvider().bandStatistics(1, QgsRasterBandStats.All)
        self.min = self.stats.minimumValue
        self.max = self.stats.maximumValue

        self.dlg.label_max.setText(str(round(self.stats.maximumValue,2)))
        self.dlg.label_min.setText(str(round(self.stats.minimumValue,2)))
        self.dlg.lineEdit_input_nodata.setText(str(block.noDataValue()))
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def selectOutput(self):
        self.dlg.lineEdit_output.setText("")
        self.OutputDir = QFileDialog.getExistingDirectory(None, 'Open working directory', "", QFileDialog.ShowDirsOnly)
        self.dlg.lineEdit_output.setText(self.OutputDir)
        self.dlg.button_box.setEnabled(True)
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def getLayers(self):
        self.dlg.comboBox_input.clear()
        self.dlg.comboBox_input.addItems(self.input_rasterLayer.keys())
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def save_outputParameters(self):
        self.outputfolder = self.dlg.lineEdit_output.text()
        self.outputname = self.dlg.lineEdit_output_name.text()
        self.format_output = 'GPKG' if self.dlg.radioButton_output1.isChecked() else 'ESRI Shapefile'
        self.outputpath = os.path.join(str(self.outputfolder),str(self.outputname))
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def getValues(self):
            # ---- Input
            self.program_interval = self.dlg.lineEdit_input_interval.text()
            self.program_nodata = self.dlg.lineEdit_input_nodata.text()
            # ---- Smoothing
            if self.dlg.checkBox_smoothing.isChecked():                            # Default Value / No contour line will be deleted
                self.smooth_None = True
                self.program_offset = self.dlg.lineEdit_smoothing_offset.setText("0")
                self.program_max = self.dlg.lineEdit_smoothing_max.setText("0")
                self.program_iteration = self.dlg.lineEdit_smoothing_iteration.setText("1")
            else:
                self.smooth_None = False
                self.program_offset = self.dlg.lineEdit_smoothing_offset.text()
                self.program_max = self.dlg.lineEdit_smoothing_max.text()
                self.program_iteration = self.dlg.lineEdit_smoothing_iteration.text()
            # ---- Extraction
            if self.dlg.checkBox_extraction.isChecked():                            # Default Value / No contour line will be deleted
                self.extract_None = True
                self.program_extration = self.dlg.lineEdit_extration.setText("0")
            else:
                self.extract_None = False
                self.program_extration = self.dlg.lineEdit_extration.text()
            # --- Styling ---
            if self.dlg.checkBox_scaleWidth.isChecked():
                self.scaleWidth = True
            else:
                self.scaleWidth = False

            # --- Color Ramp ---
            self.applyColor = True if self.dlg.checkBox_apply.isChecked() else False
            self.colorRamp = self.dlg.ColorRamp_input.colorRamp()
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def changeRasterStyle(self):

        rasterInput = QgsProject.instance().mapLayersByName(self.rasterName)[0]
        shader_function = QgsColorRampShader()
        shader_function.setSourceColorRamp(self.colorRamp)
        shader_function.setColorRampType(QgsColorRampShader.Interpolated)
        
        shader_function.setClassificationMode(QgsColorRampShader.EqualInterval)
        classes = 1 + abs(float(self.program_interval)*ceil(float(self.max)/float(self.program_interval)) - float(self.program_interval)*floor(float(self.min)/float(self.program_interval)))/ float(self.program_interval)

        shader_function.classifyColorRamp(classes)
        raster_shader = QgsRasterShader()
        raster_shader.setRasterShaderFunction(shader_function)
        renderer = QgsSingleBandPseudoColorRenderer(rasterInput.dataProvider(),1,raster_shader)
        renderer.setClassificationMax(float(self.program_interval)*ceil(float(self.max)/float(self.program_interval)))
        renderer.setClassificationMin(float(self.program_interval)*floor(float(self.min)/float(self.program_interval)))
        rasterInput.setRenderer(renderer)
        rasterInput.triggerRepaint()
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    # --- Step 1 ------------------ Generating Contour 
    def createContour(self, input_raster, interval, nodata):
        alg_params = {
            'BAND': 1,
            'CREATE_3D': False,
            'EXTRA': '',
            'FIELD_NAME': 'ELEV',
            'IGNORE_NODATA': False,
            'INPUT': input_raster,
            'INTERVAL': interval,
            'NODATA': nodata,
            'OFFSET': 0,                                                                # Enter an Offset                 
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        return processing.run('gdal:contour', alg_params)['OUTPUT']
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    # --- Step 2 ------------------ Calculating Length
    def calcLength(self, input_Contour):
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'length',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,                                                # 0-Float, 1-Integer, 2-String, 3-Date
            'FORMULA': '$length',
            'INPUT': input_Contour,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        return processing.run('native:fieldcalculator', alg_params)['OUTPUT']
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    # --- Step 3 ------------------ Extract by Length
    def extractByLength(self, inputLength, ext_length):
        alg_params = {
            'FIELD': 'length',
            'INPUT': inputLength,
            'OPERATOR': 3,                                                  # > bigger than
            'VALUE': ext_length,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT #'C:/Users/richi/Desktop/Bachelorarbeit/xxx/extract.gpkg'
        }
        return processing.run('native:extractbyattribute', alg_params)['OUTPUT']
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    # --- Step 4 ------------------ Smoothing the Layer
    def smoothing(self, inputLayer, iteration, maxAngle, offset):
        alg_params = {
            'INPUT': inputLayer,
            'ITERATIONS': iteration,                      
            'MAX_ANGLE': maxAngle,                       
            'OFFSET': offset,                        
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT #'C:/Users/richi/Desktop/Bachelorarbeit/xxx/smooth.gpkg'
        }
        return processing.run('native:smoothgeometry', alg_params)['OUTPUT']
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    # --- Step 5 ------------------ Explode the Layer
    def explode(self, inputLayer):
        alg_params = {
            'INPUT': inputLayer,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        return processing.run('native:explodelines', alg_params)['OUTPUT']
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    # --- Step 6 ------------------ Calculate Azimuth
    def calcAzimuth(self, inputLayer):
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'azimuth',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,  # Integer
            'FORMULA': 'degrees(\r\n\tazimuth(\r\n\tstart_point($geometry),\r\n\tend_point($geometry))\r\n\t)',
            'INPUT': inputLayer,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        return processing.run('native:fieldcalculator', alg_params)['OUTPUT']
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    def updateFID(self, inputLayer):
        alg_params = {
            'FIELD_LENGTH': 0,
            'FIELD_NAME': 'fid',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,  # Integer
            'FORMULA': '@row_number+1',
            'INPUT': inputLayer,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        fid_new = processing.run('native:fieldcalculator', alg_params)['OUTPUT']
        alg_params = {
            'COLUMN': 'ID',
            'INPUT': fid_new,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        return processing.run('native:deletecolumn', alg_params)['OUTPUT']
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    # All the processes are listed here, they use the functions above

    def processTanaka(self, input_raster, scaleWidth, interval, extractionLength, iteration, maxAngle, nodata, offset, smooth_None, extract_None, outputpath, output_format):

        contourLayer = self.createContour(input_raster, interval, nodata)
        further_processing_layer = contourLayer

        if extract_None == False and smooth_None == False:                          # execute both "extract" and "smooth" function
            lengthLayer = self.calcLength(further_processing_layer)
            extractLayer = self.extractByLength(lengthLayer, extractionLength)
            further_processing_layer = self.smoothing(extractLayer, iteration, maxAngle, offset)
        elif extract_None == False and smooth_None == True:                         # execute "extract" function
            lengthLayer = self.calcLength(further_processing_layer)
            further_processing_layer = self.extractByLength(lengthLayer, extractionLength)
        elif extract_None == True and smooth_None == False:                         # execute "smooth" function
            further_processing_layer = self.smoothing(further_processing_layer, iteration, maxAngle, offset)
        
        explodeLayer = self.explode(further_processing_layer)
        azimuthLayer = self.calcAzimuth(explodeLayer)
        updated_layer = self.updateFID(azimuthLayer)

        # --- Tanaka styling formula ---
        tanaka_color = 'color_hsl( 0,0, scale_linear( abs(( CASE WHEN "azimuth"-45 < 0 THEN "azimuth"-45+360 ELSE "azimuth"-45 END )-180), 0, 180, 0, 100))'
        tanaka_width = 'scale_linear(abs( abs(( CASE WHEN "azimuth"-45 < 0 THEN "azimuth"-45+360 ELSE "azimuth"-45 END )-180) -90),0, 90, 0.2, 1)'
        
        # --- Assigning Tanaka styling to Layer ---
        renderer = updated_layer.renderer().clone()
        renderer.symbol().symbolLayer(0).setDataDefinedProperty(QgsSymbolLayer.PropertyStrokeColor, QgsProperty.fromExpression(tanaka_color))
        if scaleWidth == True:
            renderer.symbol().symbolLayer(0).setDataDefinedProperty(QgsSymbolLayer.PropertyStrokeWidth, QgsProperty.fromExpression(tanaka_width))
        updated_layer.setBlendMode(QPainter.CompositionMode_Overlay)
        updated_layer.setRenderer(renderer)
        updated_layer.triggerRepaint()

        
        # -------- Output Layer, will be loaded in active QGIS Project -------------
        if self.outputname is '':
            basename = 'Tanaka contours'
        else:
            basename = self.outputname
        updated_layer.setName(basename)
        QgsProject.instance().addMapLayer(updated_layer)
        # --------------------------------------------------------------------------

        # -------- Temporaray Layer will be save as Vector File --------------------
        QgsVectorFileWriter.writeAsVectorFormat(updated_layer,outputpath,'utf-8',driverName=output_format)
        # --------------------------------------------------------------------------
    #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~





    """ ---------------------- Run method that performs all the real work -------------------"""
    def run(self):
        
        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        
        # ~~~~~~~~~~~~~~~~~~~~ What happens, when starting the Plugin ~~~~~~~~~~~~~~~~~~~~~~~~~
        if self.first_start == True:
            self.dlg = TanakaContoursDialog()
            self.input_rasterLayer = {layer.name():layer for layer in QgsProject.instance().mapLayers().values() if layer.type()== 1}  # Only choose raster files
            self.getLayers()


            self.dlg.pushButton_output.clicked.connect(self.selectOutput)
            self.dlg.pushButton_noData.clicked.connect(self.getNoDataValue)
            
        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~




        # ~~~~~~~~~~~~~~~~~~~~ What happens, when pressing OK ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if result:
            
            self.rasterName = self.dlg.comboBox_input.currentText()
            self.raster_path = self.input_rasterLayer[self.rasterName].source()
    
            # --- Getting all Inputs
            self.save_outputParameters()
            self.getValues()
            self.getNoDataValue()

            self.processTanaka(self.raster_path, self.scaleWidth, self.program_interval, self.program_extration, self.program_iteration, self.program_max, self.program_nodata, self.program_offset, self.smooth_None, self.extract_None, self.outputpath, self.format_output)
            if self.applyColor == True:
                self.changeRasterStyle()
        #~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~