"""
/***************************************************************************
 SwissGeoDownloader
                                 A QGIS plugin
 This plugin lets you comfortably download swiss geo data.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-03-14
        copyright            : (C) 2025 by Patricia Moll
        email                : pimoll.dev@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os

from qgis.PyQt.QtCore import (QCoreApplication, QSettings, QTranslator, Qt)
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from swissgeodownloader import PLUGIN_DIR
# Import the code for the DockWidget
from swissgeodownloader.ui.sgd_dockwidget import SwissGeoDownloaderDockWidget


class SwissGeoDownloader:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface

        # Initialize locale
        self.locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(PLUGIN_DIR, 'i18n', '{}.qm'.format(self.locale))

        if not os.path.exists(locale_path):
            self.locale = 'en'
            locale_path = os.path.join(PLUGIN_DIR, 'i18n', self.locale + '.qm')
        
        self.translator = QTranslator()
        self.translator.load(locale_path)
        QCoreApplication.installTranslator(self.translator)

        self.action = None
        self.pluginIsActive = False
        self.dockwidget = None

    def tr(self, message):
        return QCoreApplication.translate(type(self).__name__, message)

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        icon = QIcon(str(os.path.join(PLUGIN_DIR, 'resources', 'icon.png')))
        self.action = QAction(icon, 'Swiss Geo Downloader', self.iface.mainWindow())
        self.action.triggered.connect(self.run)
        self.action.setEnabled(True)
        self.action.setStatusTip(self.tr('Swiss Geo Downloader allows you to download '
                                         'geodata of Switzerland in an easy and '
                                         'convenient way.'))
        self.action.setWhatsThis(self.tr('Swiss Geo Downloader is a plugin to to '
                                         'download swiss geodata.'))
        # Adds plugin icon to Plugins toolbar
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu('Swiss Geo Downloader', self.action)

    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""
        if self.dockwidget:
            self.dockwidget.cleanCanvas()
            # disconnect
            self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)
        self.dockwidget = None
        self.pluginIsActive = False

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        self.onClosePlugin()
        self.iface.removePluginWebMenu('Swiss Geo Downloader', self.action)
        self.iface.removeToolBarIcon(self.action)

    def run(self):
        """Run method that loads and starts the plugin"""
        if not self.pluginIsActive:
            self.pluginIsActive = True
            if self.dockwidget is None:
                # Create the dockwidget and keep reference
                self.dockwidget = SwissGeoDownloaderDockWidget(self.iface, self.locale)

            # Connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # Show the dockwidget
            self.iface.addDockWidget(Qt.DockWidgetArea.RightDockWidgetArea, self.dockwidget)
            self.dockwidget.show()
