# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SurveyHelplinePro
                                 A QGIS plugin
 Toolset for Survey team related to GIS works
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-11-29
        git sha              : $Format:%H$
        copyright            : (C) 2025 by Batchu Pramod Kumar
        email                : bpramod29@gmail.com
 ***************************************************************************/

# -*- coding: utf-8 -*-

/***************************************************************************
Survey Helpline Pro
Copyright (C) 2025 Batchu Pramod Kumar

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .survey_helpline_pro_dialog import SurveyHelplineProDialog
import os.path
from .dialogs.reprocess_dialog_base import ReprocessDialog
from .dialogs.ppm_generation_dialog import PPMGenerationDialog


class SurveyHelplinePro:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale

        # locale = QSettings().value('locale/userLocale')[0:2]

        locale_value = QSettings().value("locale/userLocale", "en_US")
        if isinstance(locale_value, str):
            locale = locale_value[0:2]
        else:
            locale = "en"

        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SurveyHelplinePro_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Survey Helpline Pro')

        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SurveyHelplinePro', message)

    def initGui(self):

        self.menu = self.iface.mainWindow().menuBar().addMenu("Survey Helpline Pro")

        self.sslr_menu = self.menu.addMenu("SS&LR")
        self.svamitva_menu = self.menu.addMenu("SVAMITVA")

        icon_path = ':/plugins/survey_helpline_pro/icon.png'
        icon_Reprocess =':/plugins/survey_helpline_pro/Reprocess_icon.png'

        # Reprocess Shapefile
        self.action_reprocess = QAction(QIcon(icon_Reprocess), "Reprocess Shapefile (Merged Shapefile)", self.iface.mainWindow())
        self.action_reprocess.triggered.connect(self.open_reprocess_dialog)
        self.svamitva_menu.addAction(self.action_reprocess)

        # PPM Generation
        self.action_ppm_generation = QAction(QIcon(icon_path), "PPM Generation", self.iface.mainWindow())
        self.action_ppm_generation.triggered.connect(self.open_ppm_generation_dialog)
        self.svamitva_menu.addAction(self.action_ppm_generation)

        print("Survey Helpline Pro menu loaded successfully")


    def unload(self):

        """Cleanup menus when plugin is disabled."""

        if self.menu is not None:
            self.menu.deleteLater()
            
    def open_reprocess_dialog(self):
        """Open Reprocess Shapefile dialog"""
        dlg = ReprocessDialog()
        dlg.exec_()


    def open_ppm_generation_dialog(self):
        """Open PPM Generation dialog"""
        dlg = PPMGenerationDialog(self.iface)
        dlg.exec_()

    def run(self):
        # Not used anymore
        pass
