# -*- coding: utf-8 -*-

"""
/***************************************************************************
 SurfaceWaterStorage
                                 A QGIS plugin
 This plugin calculates the area flooded by water volume, height, elevation 
 or area, and the Area-Elevation-Volume graph
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-11-13
        copyright            : (C) 2024 by João Vitor Pimenta
        email                : jvpjoaopimenta@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'João Vitor Pimenta'
__date__ = '2024-07-13'
__copyright__ = '(C) 2024 by João Vitor Pimenta'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import QgsProcessingException

def verifyVerticalSpacingInput (verticalSpacingInput):
    '''
    Checks if the vertical spacing is less than 0
    '''
    if verticalSpacingInput <=0:
        raise QgsProcessingException(
            'Vertical spacing must be greather than 0'
            )
def verifyNumberOfFeaturesAreaInput (areaInput):
    '''
    Checks whether the number of features in the area layer is only one
    '''
    featuresCount = sum(1 for _ in areaInput.getFeatures())
    if featuresCount > 1:
        raise QgsProcessingException(
            'The layer has more than one feature!'
        )
def verifyDEMInputDataValues (demLayer, areaInput):
    '''
    Checks about the elevation data values in the area
    '''
    demPr = demLayer.dataProvider()
    demArray = []
    feature = next(areaInput.getFeatures())
    fGeometry = feature.geometry()
    fBBox = fGeometry.boundingBox()
    demBlock = demPr.block(1,fBBox,demLayer.width(),demLayer.height())
    demNoDataValue = demBlock.noDataValue()

    for j in range(demLayer.height()):
        for k in range(demLayer.width()):
            demArray.append((demBlock).value(j,k))

    if all(x == demNoDataValue for x in demArray):
        raise QgsProcessingException(
            'The feature is only in NODATA values'
            )

    if fGeometry.intersects(demLayer.extent()) is False:
        raise QgsProcessingException(
            "The feature don't intersects the DEM extent"
        )

    demCellX = demLayer.rasterUnitsPerPixelX()
    demCellY = demLayer.rasterUnitsPerPixelY()

    if (fBBox.width() < demCellX) and (fBBox.height() < demCellY):
        raise QgsProcessingException(
            'The feature is smaller than raster pixel size'
        )
