# TODO: This script is still not working

import pathlib
import sys
import subprocess
import os
import win32com.client

plugin_dir = pathlib.Path(__file__).parent

def install_with_pip(packages):
    try:
        import pip
    except ImportError:
        print("pip is not installed. Please install pip manually and rerun the script.")
        return

    for package in packages:
        try:
            __import__(package['module'])
        except ImportError:
            print(f"{package['module']} not available, installing {package['name']}")
            subprocess.check_call([sys.executable, '-m', 'pip', 'install', package['name']])

def find_osgeo4w_shell():
    start_menu_path = pathlib.Path("C:/ProgramData/Microsoft/Windows/Start Menu/Programs/")
    for path in start_menu_path.rglob("OSGeo4W Shell.lnk"):
        return path
    return None

def get_target_from_shortcut(shortcut_path):
    shell = win32com.client.Dispatch("WScript.Shell")
    shortcut = shell.CreateShortCut(str(shortcut_path))
    return shortcut.TargetPath

def install_with_osgeo4w(packages):
    osgeo4w_shell_path = find_osgeo4w_shell()
    if not osgeo4w_shell_path:
        raise FileNotFoundError("OSGeo4W Shell.lnk not found. Please ensure OSGeo4W is installed and the shortcut is available in the Start Menu.")
    
    osgeo4w_bat_path = get_target_from_shortcut(osgeo4w_shell_path)
    if not os.path.exists(osgeo4w_bat_path):
        raise FileNotFoundError(f"OSGeo4W.bat not found at {osgeo4w_bat_path}. Please update the path.")
    
    for package in packages:
        try:
            __import__(package['module'])
        except ImportError:
            print(f"{package['module']} not available, installing via OSGeo4W")
            subprocess.run([osgeo4w_bat_path, 'py3_env', 'python', '-m', 'pip', 'install', package['name']], shell=True, check=True)

def main():
    required_packages = [
        {'name': 'numpy', 'module': 'numpy'},
        {'name': 'scipy', 'module': 'scipy'},
        {'name': 'scikit-learn', 'module': 'sklearn'}
    ]
    if os.name == 'nt':  # Check if the OS is Windows
        install_with_osgeo4w(required_packages)
    else:
        install_with_pip(required_packages)

if __name__ == '__main__':
    main()
