# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SuperficialWaterExtend
                                 A QGIS plugin
 Calcular el area y la variacion temporal de las aguas superficiales
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-10-26
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Manuel Guerra Jardines
        email                : gmanuelj4147@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .superficial_water_extend_dialog import SuperficialWaterExtendDialog
import os.path
import datetime
import processing
from qgis.utils import iface 


from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.gui  import QgsMessageBar

from qgis.core import *
from qgis.utils import *
from qgis.gui import *
from qgis.analysis import *
from qgis.core import QgsProject

from PyQt5.QtWidgets import QMessageBox
from PyQt5.QtWidgets import QAction, QFileDialog
from PyQt5 import *
from PyQt5.QtCore import QSettings, QTranslator, qVersion, QCoreApplication, QVariant


from osgeo import gdal
import numpy as np 
import math
import tempfile
import matplotlib.pyplot as plt
from osgeo import ogr

class SuperficialWaterExtend:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SuperficialWaterExtend_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Superficial Water Extend')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SuperficialWaterExtend', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/superficial_water_extend/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Superficial_Water_Extend'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Superficial Water Extend'),
                action)
            self.iface.removeToolBarIcon(action)
    
    # funciones para cargar los inputs
    def select_input_file(self):
        inputfile, _filter=QFileDialog.getOpenFileName(self.dlg,"Select input file","","All Files (*);;Text Files (*.txt)")
        self.dlg.lineEdit.setText(str(inputfile))
    
    def select_input_file2(self):
        inputfile2, _filter=QFileDialog.getOpenFileName(self.dlg,"Select input file","","All Files (*);;Text Files (*.txt)")
        self.dlg.lineEdit_2.setText(str(inputfile2))
    
    def select_input_file3(self):
        inputfile3, _filter=QFileDialog.getOpenFileName(self.dlg,"Select input file","","All Files (*);;Text Files (*.txt)")
        self.dlg.lineEdit_3.setText(str(inputfile3))
    
    def select_input_file4(self):
        inputfile4, _filter=QFileDialog.getOpenFileName(self.dlg,"Select input file","","All Files (*);;Text Files (*.txt)")
        self.dlg.lineEdit_4.setText(str(inputfile4))
    
    def select_input_file5(self):
        inputfile5, _filter=QFileDialog.getOpenFileName(self.dlg,"Select input file","","All Files (*);;Text Files (*.txt)")
        self.dlg.lineEdit_5.setText(str(inputfile5))
    
    #inputs other date
    def select_input_file6(self):
        inputfile6, _filter=QFileDialog.getOpenFileName(self.dlg,"Select input file","","All Files (*);;Text Files (*.txt)")
        self.dlg.lineEdit_8.setText(str(inputfile6))
    
    def select_input_file7(self):
        inputfile7, _filter=QFileDialog.getOpenFileName(self.dlg,"Select input file","","All Files (*);;Text Files (*.txt)")
        self.dlg.lineEdit_7.setText(str(inputfile7))
    
    def select_input_file8(self):
        inputfile8, _filter=QFileDialog.getOpenFileName(self.dlg,"Select input file","","All Files (*);;Text Files (*.txt)")
        self.dlg.lineEdit_6.setText(str(inputfile8))
    
    def select_input_file9(self):
        inputfile9, _filter=QFileDialog.getOpenFileName(self.dlg,"Select input file","","All Files (*);;Text Files (*.txt)")
        self.dlg.lineEdit_10.setText(str(inputfile9))
    
    def select_input_file10(self):
        inputfile10, _filter=QFileDialog.getOpenFileName(self.dlg,"Select input file","","All Files (*);;Text Files (*.txt)")
        self.dlg.lineEdit_9.setText(str(inputfile10))
    
    # output file
    def select_output_file(self,lineE):
        filename= QFileDialog.getExistingDirectory(self.dlg,"Select output file ")
        self.dlg.lineEdit_12.setText(filename)
        
    def createRasterFromTemplate(self,fn, ds, data,ndv=-32768,driverFmt="GTiff"):
        driver = gdal.GetDriverByName(driverFmt)
        outds = driver.Create(fn,ds.RasterXSize,ds.RasterYSize,1,gdal.GDT_Float32)
        outds.SetGeoTransform(ds.GetGeoTransform())
        outds.SetProjection(ds.GetProjection())
        outds.GetRasterBand(1).SetNoDataValue(ndv)
        outds.GetRasterBand(1).WriteArray(data)
        outds = None 
        ds = None
        return fn
    
    def cal_ind_MNDWI(self,green_in,SWIR_in,out):
        ds_green= gdal.Open(green_in)
        ds_SWIR= gdal.Open(SWIR_in)
        green= ds_green.ReadAsArray()
        swir= ds_SWIR.ReadAsArray()
        
        ndv = -32768
        MNDWI = (green-swir)/(green+swir)
        MNDWI[np.isnan(MNDWI)]= ndv
        

        
        #out_MNDWI = os.path.join(output3,'MNDWI.tif')
        #cerrar_MNDWI=self.temp_file('.TIF')
        out_MNDWI=self.createRasterFromTemplate(out, gdal.Open(green_in),MNDWI)
        return out_MNDWI
    
    def cal_ind_AWEI_sh(self,blue_in,green_in,NIR_in,SWIR_in,SWIR2_in,out):
        

        ds_blue= gdal.Open(blue_in)
        ds_green= gdal.Open(green_in)
        ds_NIR= gdal.Open(NIR_in)
        ds_SWIR= gdal.Open(SWIR_in)
        ds_SWIR2= gdal.Open(SWIR2_in)
        
        blue= ds_blue.ReadAsArray()
        green= ds_green.ReadAsArray()
        nir= ds_NIR.ReadAsArray()
        swir= ds_SWIR.ReadAsArray()
        swir2= ds_SWIR2.ReadAsArray()
        
        ndv = -32768
        AWEI_sh = blue + 2.5*green - 1.5*(nir+swir)-0.25*swir2
        AWEI_sh[np.isnan(AWEI_sh)]= ndv
        
        AWEI_nsh = 4*(green-swir) - (0.25*nir - 2.75* swir2)
        AWEI_nsh[np.isnan(AWEI_nsh)]= ndv
       
        out_AWEI_sh=self.createRasterFromTemplate(out, gdal.Open(green_in),AWEI_sh)
        out_AWEI_nsh = self.createRasterFromTemplate(out, gdal.Open(green_in),AWEI_nsh)
        
        
        return out, out_AWEI_nsh
    
    def sist_coord(self,raster_in):
        crs= gdal.Open(raster_in).GetProjection()
        return crs
    
    def agua_sup(self,entrada,out,out_shp,crs,ext):
          #all_polig:es el shape de todos los poligonos generados x la funcion to_shape
    
        #crs = iface.mapCanvas().mapSettings().destinationCrs().toWkt()
        Crs=crs
        Agua_per = QgsVectorLayer('Polygon?crs='+Crs,'Agua_per','memory')
        prov = Agua_per.dataProvider()
    
        fields = QgsFields()
        fields.append(QgsField('ID',QVariant.Int,'',10,0))
        fields.append(QgsField('Area_Km²',QVariant.Double,'',10,6))
        prov.addAttributes(fields)
    
        #area
        lyr = QgsVectorLayer(entrada,'Agua_total','ogr')
        it = lyr.getFeatures()
        lyr.startEditing()
        a = lyr.featureCount()
        #print(a)
    
        areas = []
        id_1=0
        h=0
        j=0
    
        for feature in it:
            dn= feature['DN']
            if dn == 1:
                h +=1
                area_m=(feature.geometry().area())
                areas.append(area_m)
            #condicion(solo toma valores mayores de esta area)
                if area_m > (ext*100**3):
                    feat = QgsFeature()
                    geom = feature.geometry()
                    feat.setGeometry(feature.geometry())
                    feat.setAttributes([id_1,(area_m/100**3)])
                    prov.addFeatures([feat])
                    id_1 +=1
                    
        Agua_per.updateFields()
        
        writer= QgsVectorFileWriter.writeAsVectorFormat(Agua_per,out, 'utf-8' , driverName='xlsx')
        writer1= QgsVectorFileWriter.writeAsVectorFormat(Agua_per,out_shp, 'utf-8' , driverName='ESRI Shapefile')
        #QgsProject.instance().addMapLayer(Agua_per)
        Total_Area= (sum(areas))/(100**3)
    
        return Total_Area
    
    def agua_estacionaria(self,all_polig,out,out_shp,crs,ext):
        Agua_stac = QgsVectorLayer('Polygon?crs='+crs,'Agua_stac','memory')
        prov = Agua_stac.dataProvider()
    
        fields = QgsFields()
        fields.append(QgsField('ID',QVariant.Int,'',10,0))
        fields.append(QgsField('Area_Km²',QVariant.Double,'',10,6))
        prov.addAttributes(fields)    
   
        #area
        lyr = QgsVectorLayer(all_polig,'Agua_total','ogr')
        iter = lyr.getFeatures()
        lyr.startEditing()
        a = lyr.featureCount()
        #print(a)
    
        areas = []
        id=0
        h=0
    
        for feature in iter:
            dn= feature['DN']
            if dn == 1:
                h +=1
                area_m=(feature.geometry().area())
                areas.append(area_m)
                #condicion(solo toma valores mayores de esta area)
                if area_m <= (ext*100**3):
                    feat = QgsFeature()
                    geom = feature.geometry()
                    feat.setGeometry(feature.geometry())
                    feat.setAttributes([id,(area_m/100**3)])
                    prov.addFeatures([feat])
                    id +=1
        Agua_stac.updateFields()
        
        writer= QgsVectorFileWriter.writeAsVectorFormat(Agua_stac,out_shp, 'utf-8' , 
                                                    driverName='ESRI Shapefile')
        writer1= QgsVectorFileWriter.writeAsVectorFormat(Agua_stac,out, 'utf-8' , driverName='xlsx')
        return writer
    
    
    def temp_file(self,extens):
        temp= tempfile.NamedTemporaryFile(suffix=extens)
        direc= temp.name
        return direc, temp
    
    def filtro_MNDWI(self,img,umbr,out):
        #binario= output+'\\'+ 'binario.tif'
        param={ 'BAND_A' : 1,'EXTRA' : '',
                'FORMULA' : 'A >=' + umbr,
                'INPUT_A' :img,'NO_DATA' : -32768,
                'OPTIONS' : '','OUTPUT' : out,
                'RTYPE' : 1}
        processing.run('gdal:rastercalculator',param)
        return out
    
    def filtro_AWEI(self,img,umbr,out):
        param={ 'BAND_A' : 1,'EXTRA' : '',
                'FORMULA' : 'A >='+ umbr,
                'INPUT_A' :img,'NO_DATA' : -32768,
                'OPTIONS' : '','OUTPUT' : out,
                'RTYPE' : 1}
        processing.run('gdal:rastercalculator',param)
        return out
    
    def to_shape(self,binario,dig):
        #digitalizado=output+'\\'+'digitalizado.shp'
        param={ 'BAND' : 1, 'EIGHT_CONNECTEDNESS' :False,
                'EXTRA' : '', 'FIELD' : 'DN', 
                'INPUT' : binario,'OUTPUT' : dig}
        processing.run('gdal:polygonize',param)
        return dig
    
    def percent_var(self, base_year, other_year, out_shp,crs):
        
        lyr1 = QgsVectorLayer(base_year,'base','ogr')
        lyr2 = QgsVectorLayer(other_year,'other','ogr')
        feats_lyr1=[feat for feat in lyr1.getFeatures()]
        feats_lyr2=[feat for feat in lyr2.getFeatures()]
        
        selected_feats =[]
        centr_pts=[]
        area_base=[]
        area_other=[]
        vari_percent=[]
        
        for i, feat1 in enumerate(feats_lyr1):
            for j, feat2 in enumerate(feats_lyr2):
                if feat1.geometry().intersects(feat2.geometry()):
                    area1= (feat1.geometry().area())/(100**3)
                    area2= (feat2.geometry().area())/(100**3)
                    var= ((area1-area2)/area1)*100
                    if abs(var) <100: 
                        print("area", area1, area2,var)
                        selected_feats.append(var)
                        centr_pts.append(feat1.geometry().centroid())
                        area_base.append(area1)
                        area_other.append(area2)
                        vari_percent.append(var)
        Var = QgsVectorLayer('Point?crs='+crs,'Variacion temporal','memory')
        prov = Var.dataProvider()

        fields = QgsFields()
        fields.append(QgsField('ID',QVariant.Int,'',10,0))
        fields.append(QgsField('Variacion',QVariant.Double,'',24,6))
        prov.addAttributes(fields)

        id = 0 
        iter = len(centr_pts)
        ID=[]
        for i in range(iter):
            var_percnt = selected_feats[i]
            ptos =centr_pts[i]
            entr_atrib = [id,round(var_percnt,4)]
            feat = QgsFeature()
            feat.setGeometry((ptos))
            feat.setAttributes(entr_atrib)
            prov.addFeatures([feat])
            ID.append(i)
            id += 1
            
        Var.updateFields()
        writer1= QgsVectorFileWriter.writeAsVectorFormat(Var,os.path.join(out_shp,"Agua_perm_Variacion.shp"), 'utf-8' , driverName='ESRI Shapefile')
        QgsProject.instance().addMapLayer(Var)
        
        return area_base, area_other, vari_percent,ID



    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = SuperficialWaterExtendDialog()
            
            #dar funcionalidad a los botones
            self.dlg.pushButton.clicked.connect(self.select_input_file)
            self.dlg.pushButton_2.clicked.connect(self.select_input_file2)
            self.dlg.pushButton_3.clicked.connect(self.select_input_file3)
            self.dlg.pushButton_4.clicked.connect(self.select_input_file4)
            self.dlg.pushButton_5.clicked.connect(self.select_input_file5)
            self.dlg.pushButton_7.clicked.connect(self.select_input_file6)
            self.dlg.pushButton_10.clicked.connect(self.select_input_file7)
            self.dlg.pushButton_9.clicked.connect(self.select_input_file8)
            self.dlg.pushButton_6.clicked.connect(self.select_input_file9)
            self.dlg.pushButton_8.clicked.connect(self.select_input_file10)
            self.dlg.pushButton_11.clicked.connect(self.select_output_file)
        
        #vaciar la caja de lineEdit donde se especifica el nombre del archivo    
        self.dlg.lineEdit.clear()
        self.dlg.lineEdit_2.clear()
        self.dlg.lineEdit_3.clear()
        self.dlg.lineEdit_4.clear()
        self.dlg.lineEdit_5.clear()
        self.dlg.lineEdit_6.clear()
        self.dlg.lineEdit_7.clear()
        self.dlg.lineEdit_8.clear()
        self.dlg.lineEdit_9.clear()
        self.dlg.lineEdit_10.clear()
        self.dlg.lineEdit_11.clear()
        self.dlg.lineEdit_12.clear()
        self.dlg.dateEdit.clear()
        self.dlg.dateEdit_2.clear()        

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            
            #base year
            blue1 = self.dlg.lineEdit.text()
            green1= self.dlg.lineEdit_2.text()
            nir1 = self.dlg.lineEdit_3.text()
            swir1=self.dlg.lineEdit_4.text()
            swir2_1 = self.dlg.lineEdit_5.text()
            date_base = self.dlg.dateEdit.date().toPyDate()
            
            #other date
            blue2 = self.dlg.lineEdit_8.text()
            green2= self.dlg.lineEdit_7.text()
            nir2 = self.dlg.lineEdit_6.text()
            swir2 =self.dlg.lineEdit_10.text()
            swir2_2 = self.dlg.lineEdit_9.text()
            oth_date = self.dlg.dateEdit_2.date().toPyDate()
            
            #out
            filename=self.dlg.lineEdit_12.text()
            
            #area minima
            min_area = self.dlg.lineEdit_11.text()
            if min_area=="":
                ext=0
            else:
                ext = min_area
            #valor umbral
            V_U =  self.dlg.lineEdit_13.text()
            if V_U =="":
                u_v= 0
            else:
                u_v= V_U
            
            with tempfile.TemporaryDirectory() as temp:
                
                if blue2 != "":
                    Crs = self.sist_coord(blue1)
                    if self.dlg.checkBox.isChecked():
                        MNDWI_1= self.cal_ind_MNDWI(green1,swir1,os.path.join(temp,'MNDWI_1.tif'))
                        MNDWI_2= self.cal_ind_MNDWI(green2,swir2,os.path.join(temp,'MNDWI_2.tif'))
                        print(os.path.join(temp,'MNDWI_1.tif'))
                    
                        filt_1= self.filtro_MNDWI(MNDWI_1,u_v,os.path.join(temp,'binario_1.tif'))
                        filt_2= self.filtro_MNDWI(MNDWI_2,u_v,os.path.join(temp,'binario_2.tif'))
                    
                        polig_1= self.to_shape(filt_1,os.path.join(temp,'digitalizado_1.shp'))
                        polig_2= self.to_shape(filt_2,os.path.join(temp,'digitalizado_2.shp'))
                        
                        area_1= self.agua_sup(polig_1,os.path.join(filename,'area_'+str(date_base)+'.xlsx'),os.path.join(filename,'area_'+str(date_base)+'.shp'),Crs,float(ext))
                        area_2= self.agua_sup(polig_2,os.path.join(filename,'area_'+str(oth_date)+'.xlsx'),os.path.join(filename,'area_'+str(oth_date)+'.shp'),Crs,float(ext))
                        
                        area_esta= self.agua_estacionaria(polig_1,os.path.join(filename,'area_esta'+str(date_base)+'.xlsx'),os.path.join(filename,'area_esta'+str(date_base)+'.shp'),Crs,float(ext))
                        area_esta= self.agua_estacionaria(polig_2,os.path.join(filename,'area_esta'+str(oth_date)+'.xlsx'),os.path.join(filename,'area_esta'+str(oth_date)+'.shp'),Crs,float(ext))
                        
                        iface.addVectorLayer(os.path.join(filename,'area_'+str(date_base)+'.shp'),'area_'+str(date_base),"ogr")
                        iface.addVectorLayer(os.path.join(filename,'area_'+str(oth_date)+'.shp'),'area_'+str(oth_date),"ogr")
                        if self.dlg.checkBox_4.isChecked():
                            lyr_1=os.path.join(filename,'area_'+str(date_base)+'.shp')
                            lyr_2=os.path.join(filename,'area_'+str(oth_date)+'.shp')
                            a_b, a_o, var_perc,co=self.percent_var(lyr_1,lyr_2,filename,Crs)
                            Area_perm_base = sum(a_b)
                            Area_perm_other=sum(a_o)
                            Area_esta_base = area_1 - Area_perm_base
                            Area_esta_other = area_2 - Area_perm_other
                    
                    if self.dlg.checkBox_2.isChecked():
                        AW_1 = self.cal_ind_AWEI_sh(blue1,green1,nir1,swir1,swir2_1, os.path.join(temp,'AWEI_1.tif'))
                        AW_2 = self.cal_ind_AWEI_sh(blue2,green2,nir2,swir2,swir2_2, os.path.join(temp,'AWEI_2.tif'))
                        
                        filt_1= self.filtro_AWEI(AW_1,u_v,os.path.join(temp,'binarioAW_1.tif'))
                        filt_2= self.filtro_AWEI(AW_2,u_v,os.path.join(temp,'binarioAW_2.tif'))
                    
                        polig_1= self.to_shape(filt_1,os.path.join(temp,'digitalizadoAW_1.shp'))
                        polig_2= self.to_shape(filt_2,os.path.join(temp,'digitalizadoAW_2.shp'))
                        
                        area_1= self.agua_sup(polig_1,os.path.join(filename,'area_AW'+str(date_base)+'.xlsx'),os.path.join(filename,'area_AW'+str(date_base)+'.shp'),Crs,float(ext))
                        area_2= self.agua_sup(polig_2,os.path.join(filename,'area_AW'+str(oth_date)+'.xlsx'),os.path.join(filename,'area_AW'+str(oth_date)+'.shp'),Crs,float(ext))
                        
                        area_esta= self.agua_estacionaria(polig_1,os.path.join(filename,'area_esta_AW'+str(date_base)+'.xlsx'),os.path.join(filename,'area_esta_AW'+str(date_base)+'.shp'),Crs,float(ext))
                        area_esta= self.agua_estacionaria(polig_2,os.path.join(filename,'area_esta_AW'+str(oth_date)+'.xlsx'),os.path.join(filename,'area_esta_AW'+str(oth_date)+'.shp'),Crs,float(ext))
                        
                        iface.addVectorLayer(os.path.join(filename,'area_AW'+str(date_base)+'.shp'),'area_AW'+str(date_base),"ogr")
                        iface.addVectorLayer(os.path.join(filename,'area_AW'+str(oth_date)+'.shp'),'area_AW'+str(oth_date),"ogr")
                        if self.dlg.checkBox_4.isChecked():
                            lyr_1=os.path.join(filename,'area_AW'+str(date_base)+'.shp')
                            lyr_2=os.path.join(filename,'area_AW'+str(oth_date)+'.shp')
                            a_b, a_o, var_perc,co=self.percent_var(lyr_1,lyr_2,filename,Crs)
                            Area_perm_base = sum(a_b)
                            Area_perm_other=sum(a_o)
                            Area_esta_base = area_1 - Area_perm_base
                            Area_esta_other = area_2 - Area_perm_other
                    
                else:
                    Crs = self.sist_coord(blue1)
                    if self.dlg.checkBox.isChecked():
                        MNDWI= self.cal_ind_MNDWI(green1,swir1,os.path.join(temp,'MNDWI_1.tif'))
                        filt= self.filtro_MNDWI(MNDWI,u_v,os.path.join(temp,'binario_1.tif'))
                        polig= self.to_shape(filt,os.path.join(temp,'digitalizado_1.shp'))
                        area= self.agua_sup(polig,os.path.join(filename,'area_'+str(date_base)+'.xlsx'),os.path.join(filename,'area_'+str(date_base)+'.shp'),Crs,float(ext))
                        
                        area_esta= self.agua_estacionaria(polig,os.path.join(filename,'area_esta'+str(date_base)+'.xlsx'),os.path.join(filename,'area_esta'+str(date_base)+'.shp'),Crs,float(ext))
                        
                        iface.addVectorLayer(os.path.join(filename,'area_'+str(date_base)+'.shp'),'area_'+str(date_base),"ogr")
                    
                    if self.dlg.checkBox_2.isChecked():
                        AW_1 = self.cal_ind_AWEI_sh(blue1,green1,nir1,swir1,swir2_1, os.path.join(temp,'AWEI_1.tif'))
                        filt_1= self.filtro_AWEI(AW_1,u_v,os.path.join(temp,'binarioAW_1.tif'))
                        polig_1= self.to_shape(filt_1,os.path.join(temp,'digitalizadoAW_1.shp'))
                        
                        area_1= self.agua_sup(polig_1,os.path.join(filename,'area_AW'+str(date_base)+'.xlsx'),os.path.join(filename,'area_AW'+str(date_base)+'.shp'),Crs,float(ext))
                        
                        area_esta= self.agua_estacionaria(polig_1,os.path.join(filename,'area_esta_AW'+str(date_base)+'.xlsx'),os.path.join(filename,'area_esta_AW'+str(date_base)+'.shp'),Crs,float(ext))
                        
                        iface.addVectorLayer(os.path.join(filename,'area_AW'+str(date_base)+'.shp'),'area_AW'+str(date_base),"ogr")
                    
                               
            pass
