# -*- coding: utf-8 -*-
"""
/***************************************************************************
 StyleExporter
                                 A QGIS plugin
 Plugin export styles of selected layers to individual file with name same as layers name.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-01
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Łukasz Świątek
        email                : lukasz.swiatek1996@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
from qgis.core import QgsProject, Qgis, QgsVectorFileWriter

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .style_exporter_dialog import StyleExporterDialog
import os.path


class StyleExporter:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'StyleExporter_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Style Exporter')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('StyleExporter', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/style_exporter/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Export layer styles'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Style Exporter'),
                action)
            self.iface.removeToolBarIcon(action)
    def select_output_file(self):
        filename = QFileDialog.getExistingDirectory (self.dlg, "Wybierz folder zapisu ", "")
        self.dlg.lineEdit.setText(filename)
        
    def load_table(self):
        
        itemLabels = [layer.name() for layer in self.iface.mapCanvas().layers()]
        self.dlg.listWidget.clear()
        
        for item in itemLabels:
            self.dlg.listWidget.addItem(item);
            
    def load_field_table(self):
        
        itemLabels = ['SLD', 'QML', 'SHP']  # , 'Typ pola']
        self.dlg.listWidget_2.clear()
        
        for item in itemLabels:
            self.dlg.listWidget_2.addItem(item);
            



    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = StyleExporterDialog()
            self.dlg.pushButton.clicked.connect(lambda: self.select_output_file())
            self.dlg.pushButton_2.clicked.connect(lambda: self.dlg.listWidget.selectAll())
            self.dlg.pushButton_3.clicked.connect(lambda: self.dlg.listWidget.clearSelection())
            self.dlg.pushButton_4.clicked.connect(lambda: self.dlg.listWidget.invertSelection())
            self.dlg.pushButton_5.clicked.connect(lambda: self.load_table())
            
        # [layer.name() for layer in self.iface.mapCanvas().layers()]
        # [layer.name() for layer in layers]
        
        self.load_table()
        self.load_field_table()
    

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            filename = self.dlg.lineEdit.text()
            prefix = self.dlg.lineEdit_2.text()
            sufix = self.dlg.lineEdit_3.text()

            lst = [field.text() for field in self.dlg.listWidget_2.selectedItems()]
                
            for item in self.dlg.listWidget.selectedItems():
                
                layers = QgsProject.instance().mapLayersByName(item.text())
                layer = layers[0]
                
                path = f"{filename}/{prefix}{item.text()}{sufix}"

                if 'SLD' in lst:
                    layer.saveSldStyle(f"{path}.sld")
                        
                if 'QML' in lst:
                    layer.saveNamedStyle(f"{path}.qml")
                    
                if 'SHP' in lst:
                    writer = QgsVectorFileWriter.writeAsVectorFormat(layer, f"{path}.shp",'utf-8',driverName='ESRI Shapefile')
  
            self.iface.messageBar().pushMessage(
            "Udało się!", "Zapisano wybrane style w " + filename,
            level=Qgis.Success, duration=10)

