# -*- coding: utf-8 -*-
"""
/***************************************************************************
 StreetFacingSideDialog
                                 A QGIS plugin
 Identifies the side of the polygon (e.g. parcels or building footprints) that is facing the street, river, or any other line vector file type. 
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-03-06
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Blair William Gerald Scriven
        email                : scrivenblair@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5.QtWidgets import QFileDialog, QMenu
from qgis import processing
from qgis.core import QgsMapLayerProxyModel, QgsVectorLayer, QgsRasterLayer

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'Street_Facing_Side_dialog_base.ui'))


class StreetFacingSideDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(StreetFacingSideDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        
        # Set appropriate function for each button when clicked 
        self.Process_Button.clicked.connect(self.create_streetface_layer)

        # Define the MapLayer_ComboBoxes 
        self.PolygonLayer_Combobox.setFilters(QgsMapLayerProxyModel.PolygonLayer)
        self.PolygonLayer_Combobox.setCurrentIndex(-1) #clear the selection
        self.LineLayer_Combobox.setFilters(QgsMapLayerProxyModel.LineLayer)
        self.LineLayer_Combobox.setCurrentIndex(-1) #clear the selection


    def create_streetface_layer(self):
      self.Pbar.setValue(0) # reset progress bar
      self.Error_Message_Label.setText("") # reset error message to blank

      # Set main function parameters
      PolyFileName = self.PolygonLayer_Combobox.currentLayer()
      LineFileName = self.LineLayer_Combobox.currentLayer()
      OutFold = self.qgsFileWidget.filePath()

      # Error Handling: Check for empty parameters
      if not OutFold:
         self.Error_Message_Label.resize(400, 20) # You have to resize label everytime you change the text
         self.Error_Message_Label.setText("WARNING: You have not selected an output file")
         return
      if type(PolyFileName) is not QgsVectorLayer:
         self.Error_Message_Label.resize(400, 20)
         self.Error_Message_Label.setText("WARNING: You have not selected a polygon file")
         return
      if type(LineFileName) is not QgsVectorLayer:
         self.Error_Message_Label.resize(400, 20) 
         self.Error_Message_Label.setText("WARNING: You have not selected a line file")
         return

      
      ### START THE PROCESSING CODE TO CREATE GW RASTER BUFFER ####################################

      self.Pbar.setValue(10)
      poly_to_lines = processing.run("native:polygonstolines", {'INPUT': PolyFileName,
                                                                'OUTPUT': 'memory:'})
      self.Pbar.setValue(25)
      Footprint_Centroids = processing.run("native:centroids", {'INPUT': PolyFileName,
                                                                'OUTPUT': 'memory:'})
      self.Pbar.setValue(45)
      Exploded_Lines = processing.run("native:explodelines", {'INPUT': poly_to_lines['OUTPUT'],
                                                              'OUTPUT': 'memory:'})
      self.Pbar.setValue(65)
      Centroids_w_nearRoad_points = processing.run("native:joinbynearest", {'INPUT': Footprint_Centroids['OUTPUT'],
                                                                            'INPUT_2': LineFileName,
                                                                            'DISCARD_NONMATCHING': True,
                                                                            'OUTPUT': 'memory:'})
      self.Pbar.setValue(85)
      Building_to_Road_Line = processing.run("native:geometrybyexpression", {'INPUT': Centroids_w_nearRoad_points['OUTPUT'],
                                                                             'OUTPUT_GEOMETRY':1,
                                                                             'EXPRESSION':'MAKE_LINE($geometry, MAKE_POINT("nearest_x", "nearest_y"))','OUTPUT': 'memory:'})
      self.Pbar.setValue(95)
      
      check = self.checkAdd2Map.isChecked()
      if check is True:
         processing.runAndLoadResults("native:extractbylocation", {'INPUT': Exploded_Lines['OUTPUT'],
                                                                   'PREDICATE': [0],  # intersect
                                                                   'INTERSECT': Building_to_Road_Line['OUTPUT'],
                                                                   'OUTPUT': OutFold})
      else:
         processing.run("native:extractbylocation", {'INPUT': Exploded_Lines['OUTPUT'],
                                                     'PREDICATE': [0],  # intersect
                                                     'INTERSECT': Building_to_Road_Line['OUTPUT'],
                                                     'OUTPUT': OutFold})

      ### END OF PROCESSING CODE ##################################################################
      
      self.Pbar.setValue(100)