# -*- coding: utf-8 -*-
"""
/***************************************************************************
Name                 : Change Log
Description          : Handles the display of change log HTML document.
Date                 : 20/April/2016
copyright            : (C) 2016 by UN-Habitat and implementing partners.
                       See the accompanying file CONTRIBUTORS.txt in the root
email                : stdm@unhabitat.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt import uic
from qgis.PyQt.QtCore import (
    QUrl,
    Qt
)
from qgis.PyQt.QtWidgets import (
    QDialog
)

from stdm.ui.gui_utils import GuiUtils
from stdm.utils.util import file_text

# from stdm.settings.registryconfig import (
#     RegistryConfig,
#     SHOW_LICENSE
# )
# from stdm.data.license_doc import LicenseDocument
#
# from notification import NotificationBar, ERROR

WIDGET, BASE = uic.loadUiType(
    GuiUtils.get_ui_file_path('ui_change_log.ui'))


class ChangeLog(WIDGET, BASE):
    def __init__(self, parent=None):
        """
        This class shows the change log.
        :param parent: The container of the dialog
        :type parent: QMainWindow or None
        :return: None
        :rtype: NoneType
        """
        QDialog.__init__(
            self, parent,
            Qt.WindowSystemMenuHint | Qt.WindowTitleHint
        )
        self.setupUi(self)
        self.buttonBox.accepted.connect(self.accept)
        # Add maximize buttons
        self.setWindowFlags(
            self.windowFlags() |
            Qt.WindowSystemMenuHint |
            Qt.WindowMaximizeButtonHint
        )

    def show_change_log(self, path):
        """
        Show STDM change log window if the user have never
        seen it before.
        :return: None
        :rtype: NoneType
        """
        change_log_file = '{}/html/change_log.htm'.format(path)
        change_log_url = QUrl.fromLocalFile(change_log_file)
        change_log_html = file_text(change_log_file)
        self.webView.setHtml( change_log_html, change_log_url)

        self.exec_()
