# -*- coding: utf-8 -*-
"""
/***************************************************************************
 StaraMaps
                                 A QGIS plugin
 Test
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-05
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Tarik
        email                : t@q
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import os.path

import requests
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis._core import QgsLayerTreeGroup
from qgis.core import QgsProject, QgsRasterLayer

from .StaraMaps_dialog import StaraMapsDialog

# Initialize Qt resources from file resources.py
# Import the code for the dialog


# pyrcc5 resources.qrc -o resources.py
'''
Verde: Hex: 00663b, RGB: 0; 102; 59
Laranja: Hex: f37435, RGB: 243; 116; 53
'''


class StaraMaps:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """

        # Save reference to the QGIS interface
        self.iface = iface
        self.project = QgsProject.instance()

        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'StaraMaps_{}.qm'.format(locale))

        self.translator = QTranslator()
        if os.path.exists(locale_path):
            self.translator.load(locale_path)

        else:
            locale_path = os.path.join(
                self.plugin_dir,
                'i18n',
                'StaraMaps_pt.qm')
            self.translator.load(locale_path)

        QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&StaraMaps')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        QgsProject.instance().legendLayersAdded.connect(self.enableFeatCountAndAlphaSlider)

    def enableFeatCountAndAlphaSlider(self, layers):
        pass

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of custom_message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('StaraMaps', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/StaraMaps/MicrosoftTeams-image.png'
        self.add_action(
            icon_path,
            text=self.tr(u''),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&StaraMaps'),
                action)
            self.iface.removeToolBarIcon(action)

    def listar_camadas_grupos_raiz(self, root):

        # Lista para armazenar as camadas encontradas
        camadas = []

        # Itera sobre os filhos da raiz
        for filho in root.children():
            # Verifica se o filho é um grupo raiz
            if isinstance(filho, QgsLayerTreeGroup):
                # Itera sobre as camadas dentro do grupo raiz
                for camada in filho.findLayers():
                    camadas.append(camada.layer())

        return camadas

    def show_terrain_layer(self, layer, checked):
        print(layer)

        root = self.project.layerTreeRoot()
        layers = self.listar_camadas_grupos_raiz(root)
        print(layers)
        canvas = self.iface.mapCanvas()
        service_uri = "type=xyz&zmin=0&zmax=20&url=https://" + requests.utils.quote(
            "mt1.google.com/vt/lyrs=s&x={x}&y={y}&z={z}")
        terrain_layer = QgsRasterLayer(service_uri, 'OSM', 'wms')

        if not terrain_layer.isValid():
            print("Erro ao carregar a camada de terreno XYZ.")
        else:
            canvas.setLayers(layers + [terrain_layer])
            terrain_layer.triggerRepaint()
            canvas.setDestinationCrs(self.iface.activeLayer().crs())

        canvas.setExtent(layers[-1].extent())
        canvas.refreshAllLayers()

    def init_plugin(self):

        root = self.project.layerTreeRoot()

        layers = self.listar_camadas_grupos_raiz(root)
        self.dlg = StaraMapsDialog(layers, self.iface, self.project)
        self.dlg.terrain_layer.connect(self.show_terrain_layer)

        # show the dialog
        self.dlg.show()

        # self.dlg.checkhavefiles()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def run(self):
        """Run method that performs all the real work"""

        QCoreApplication.installTranslator(self.translator)

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start:
            self.first_start = False
            from .install_window import InfoWindow
            self.info = InfoWindow()
            self.info.finished_signal.connect(lambda: (
                self.info.hide(),
                self.info.deleteLater(),
                self.init_plugin()
            ))
            self.info.show()
            # self.init_plugin()
        else:
            # show the dialog

            if self.dlg.isHidden():
                self.dlg.show()

            self.dlg.raise_()
            self.dlg.activateWindow()

            # self.dlg.checkhavefiles()
            # Run the dialog event loop
            result = self.dlg.exec_()
            # See if OK was pressed
            if result:
                # Do something useful here - delete the line containing pass and
                # substitute with your code.
                pass
