"""
/***************************************************************************
 srid_updater part of Coordinate Systems Updater
 A QGIS plugin for updating SRID's that need to be improved
 -------------------
 begin                : 2011-07-10
 copyright            : (C) 2011 by Diethard Jansen
 email                : Diethard.Jansen at Gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
# Initialize Qt resources from file resources.py
import qrc_resources
# Import the code for the dialog
from srid_updater_dialog import SRID_updater_dialog

class SRID_updater:

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/icon.png"), \
            "Coordinate Systems Updater", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("Coordinate Systems Updater", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("Coordinate Systems Updater",self.action)
        self.iface.removeToolBarIcon(self.action)

    # run method that performs all the real work
    def run(self):

        # create and show the dialog
        l_dialog = SRID_updater_dialog(self.iface)
        l_dialog.show()
        l_dialog.exec_()
