"""
/***************************************************************************
 SRID_updater_dialog
 Dialog part of Coordinate Systems Updater plugin
 -------------------
 begin                : 2011-06-13
 copyright            : (C) 2011 by Realworld Systems BV
 email                : Diethard.Jansen@ realworld-systems.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *
import qgis, os

from ui_srid_updater import Ui_SRID_updater
import srid

WIN = "startfile" in dir(os)
Ubuntu = os.environ.get('GNOME_DESKTOP_SESSION_ID') != None

def myDir():
    return os.path.abspath(os.path.dirname(__file__))

# create the dialog
class SRID_updater_dialog(QDialog):
    def __init__(self, iface):
        QDialog.__init__(self)
        # Set up the user interface from Designer.
        self.iface = iface
        self.ui = Ui_SRID_updater()
        self.ui.setupUi(self)
        # the list of coordinate systems should be loaded in sorted order.
        # the list widget would sort them alphabetically because they
        # are strings, however they should be sorted on srid.
        self.ui.SRID_listWidget.setSortingEnabled(False)
        # Fill the choicelist with 'All' and 'Selected'
        self.ui.comboBox.addItem(self.tr('All'))
        self.ui.comboBox.addItem(self.tr('Selected'))
        # create container holding all SRID references from file
        # that may need updating.
        self.cs_refs = srid.Cs_ref_container(self)
        # load all coordinate system references in Dialog
        self._initialLoad()

    def _initialLoad(self):
        """
        Load the list from references provided. Because a csv file is
        read during the load, this can fail so do it in a protected manner.
        """
        if self.cs_refs.authorised:
            try:
                self.cs_refs.load()
            except IOError, e:
                QMessageBox.warning(self, "CS_refs - Error",
                                    "Failed to load: %s" % e)
        self._populate_list()

    def _populate_list(self):
        """
        Clear and populate the list in dialog with coordinate system references
        """
        l_ui = self.ui
        l_list_widget = l_ui.SRID_listWidget
        l_list_widget.clear()
        for i_cs_ref in self.cs_refs.inOrder():
            l_s = "%i : %s : %s" %  (i_cs_ref.srid, i_cs_ref.description,
                                     i_cs_ref.parameters)
            l_item = QListWidgetItem(QString(l_s))
            l_item.setForeground(i_cs_ref.color())
            l_list_widget.addItem(l_item)
        
    @pyqtSignature("")
    def on_updateButton_clicked(self):
        """
        update all or selected items from list
        """
        if self.ui.comboBox.currentIndex() == 0:
            self._update_all()
        else:
            self._update_selected()
        self._populate_list()
        self._show_restart_msg()

    @pyqtSignature("")
    def on_restoreButton_clicked(self):
        """
        Restore all or selected items from list
        """
        if self.ui.comboBox.currentIndex() == 0:
            self._restore_all()
        else:
            self._restore_selected()
        self._populate_list()
        self._show_restart_msg()
        
    @pyqtSignature("")
    def on_helpButton_clicked(self):
        """opens the help manual"""
        self._helpHelp()

    @pyqtSignature("")
    def on_closeButton_clicked(self):
        """hides (closes) the window"""
        self.close()

    def _update_all(self):
        """
        Update all 'blue' items from list
        """
        self.cs_refs.update_all()

    def _update_selected(self):
        """
        Update selected 'blue' items from list
        """
        l_items = self.ui.SRID_listWidget.selectedItems()
        self.cs_refs.update_selected(l_items)

    def _restore_all(self):
        """
        Restore all 'dark-green' items from list
        """
        self.cs_refs.restore_all()

    def _restore_selected(self):
        """
        Restore selected 'dark-green' items from list
        """
        l_items = self.ui.SRID_listWidget.selectedItems()
        self.cs_refs.restore_selected(l_items)

    def _helpHelp(self):
        """
        starts the help manual which resides behind the help button
        """
        if 'showPluginHelp' in dir(qgis.utils):
            # for QGIS 1.5 and higher
            qgis.utils.showPluginHelp()
        else:
            # for all QGIS versions before 1.5
            l_file_name = str(self.tr("index.html"))
            l_help_file = os.path.join(myDir(), l_file_name)
            
            if WIN:
                # for windows
                os.startfile(l_help_file)
            elif Ubuntu:
                os.system('gnome-open %s' % l_help_file)
            else:
                os.system('open %s' % l_help_file)

    def _show_restart_msg(self):
        """
        Show message to reload QGIS project to make changes effective
        """
        l_msg = self.tr("Reload of QGIS project is neccesary for changes to take effect on map views!")
        QMessageBox.warning(self, "restart qgis", l_msg)
