#coding:utf-8
# author=Kai Moriguchi @Chichibu 2013.4~2014.3
# email:a09a215@gmail.com
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.utils import iface
from form import Ui_form
from ccbfuncform import ccbfuncform
from ccbplugintools import *
import traceback
import sys
import processing

class ccbtools_dlg(QtGui.QMainWindow, Ui_form):
    def __init__(self, parent=None):
        self.Tools = ccbfuncform()
        self.TypeParam =((".shp",'SHP (*.shp);;'),(".tif",'TIFF (*,tif);;'))
        self.ilayers = QgsMapLayerRegistry.instance()
        super(ccbtools_dlg, self).__init__(parent)
        self.setupUi(self)
        for t in self.Tools.p:
            self.analyzebox.addItem(unicode(t[1][0]))
        self.analyzebox.currentIndexChanged.connect(self.analyze_changed)
        self.runbutton.clicked.connect(self.run_clicked)
        self.outputbutton.clicked.connect(self.outputbutton_clicked)

    def Qtrans(self,str):
        return QtGui.QApplication.translate("fm",str,None, QtGui.QApplication.UnicodeUTF8)

    def analyze_changed(self):
        self.analyzeID = self.analyzebox.currentIndex()
        self.inputbox_1.clear()
        self.inputbox_2.clear()
        for (key, layer) in self.ilayers.mapLayers().iteritems():
            if layer.type()==self.Tools.p[self.analyzeID][2][0]:
                if self.Tools.p[self.analyzeID][2][0]==QgsMapLayer.VectorLayer:
                    if layer.geometryType()==self.Tools.p[self.analyzeID][2][1]:
                        self.inputbox_1.addItem(unicode(layer.name()), key)
                else:
                    self.inputbox_1.addItem(unicode(layer.name()), key)
            if layer.type()==self.Tools.p[self.analyzeID][3][0]:
                if self.Tools.p[self.analyzeID][3][0]==QgsMapLayer.VectorLayer:
                    if layer.geometryType()==self.Tools.p[self.analyzeID][3][1]:
                        self.inputbox_2.addItem(unicode(layer.name()), key)
                else:
                    self.inputbox_2.addItem(unicode(layer.name()), key)

        outname = self.outputbox.text()
        if(self.Tools.NoLayer!=self.Tools.p[self.analyzeID][2][0] and (os.path.basename(outname)==os.getenv('TEMP') or outname=="")):
            direc = os.path.dirname(self.ilayers.mapLayer(self.inputbox_1.itemData(self.inputbox_1.currentIndex())).source())
        else:
            direc = os.path.dirname(outname)
        if os.path.isdir(direc)==False:
            direc = os.getenv('TEMP')
        root = os.path.normpath(os.path.join(direc,"Result"))
        self.outputbox.setText(self.Qtrans(root+self.TypeParam[self.Tools.p[self.analyzeID][4][0]][0]))
        self.analyzebox.setToolTip(self.Qtrans(self.Tools.p[self.analyzeID][1][1]))
        self.inputbox_1.setToolTip(self.Qtrans(self.Tools.p[self.analyzeID][2][2]))
        self.inputbox_2.setToolTip(self.Qtrans( self.Tools.p[self.analyzeID][3][2]))
        self.outputbox.setToolTip(self.Qtrans(self.Tools.p[self.analyzeID][4][1]))
        paramtstr=""
        tipstr=""
        for p in self.Tools.p[self.analyzeID][5]:
            paramtstr = paramtstr+str(p[2])+";"
            tipstr = tipstr + p[3]+"; "
        self.parambox.setText(self.Qtrans(paramtstr.rstrip(";")))
        self.parambox.setToolTip(self.Qtrans( tipstr.rstrip("; ")))

    def outputbutton_clicked(self):
        self.inputlayer_1 = self.ilayers.mapLayer(self.inputbox_1.itemData(self.inputbox_1.currentIndex()))
        self.inputlayer_2 = self.ilayers.mapLayer(self.inputbox_2.itemData(self.inputbox_2.currentIndex()))
        if self.inputlayer_1 is not None:
            self.outdir = os.path.dirname(self.inputlayer_1.source())
        elif self.inputlayer_2 is not None:
            self.outdir = os.path.dirname(self.inputlayer_2.source())
        else:
            self.outdir = os.getenv('TEMP')
        self.outputbox.setText(
            QFileDialog.getSaveFileName(self,
                self.Qtrans('Select output file'),
                self.outdir, self.TypeParam[self.Tools.p[self.analyzeID][4][0]][1] + self.Qtrans('All files')
            )
        )

    def run_clicked(self):
        self.inputlayer_1 = self.ilayers.mapLayer(self.inputbox_1.itemData(self.inputbox_1.currentIndex()))
        self.inputlayer_2 = self.ilayers.mapLayer(self.inputbox_2.itemData(self.inputbox_2.currentIndex()))
        self.outfilename = unicode(self.outputbox.text())
        if self.inputlayer_1 is None and -1 < self.Tools.p[self.analyzeID][2][0]:
            msgbox("Input layer_1 is empty.")
            return
        if self.inputlayer_2 is None and -1 < self.Tools.p[self.analyzeID][3][0]:
            msgbox("Input layer_2 is empty.")
            return
        if self.outfilename == u'' and -1<self.Tools.p[self.analyzeID][4][0]:
            msgbox("Output file is empty.")
            return
        if self.parambox.text()=='' and 0<len(self.Tools.p[self.analyzeID][5]):
            msgbox("Parameter box is empty.")
            return
        self.Param = None
        if 0<len(self.Tools.p[self.analyzeID][5]):
            strParam = self.parambox.text().split(";")
            if len(strParam)!=len(self.Tools.p[self.analyzeID][5]):
                msgbox("Number of parameters is incorrect.")
                return
            isnum =(isinstance(self.Tools.p[self.analyzeID][5][0][0],basestring)==False)
            if isnum:
                self.Param = [float(p) for p in strParam]
            else:
                self.Param = [unicode(p) for p in strParam]
        if isnum:
            i=0
            for p in self.Param:
                min = self.Tools.p[self.analyzeID][5][i][0]
                max = self.Tools.p[self.analyzeID][5][i][1]
                if p<min or max<p:
                    msgbox("Min and Max of parameter No."+str(i+1)+" is "+str(min)+"~"+str(max))
                    return
                i=i+1
        self.setEnabled(False)
        self.setCursor(QCursor(Qt.WaitCursor))
        QCoreApplication.processEvents()
        try:
            Did = self.Tools.p[self.analyzeID][0]().run(self.inputlayer_1,self.inputlayer_2, self.outfilename,self.Param,self.progressbar)
            if Did and self.addcheck.isChecked() and os.path.isfile(self.outfilename):
                processing.load(self.outfilename,os.path.basename(os.path.splitext(self.outfilename)[0]))
        except:
            info = sys.exc_info()
            tbinfo = traceback.format_tb( info[2] )
            Emessage = ""
            for tbi in tbinfo:
               Emessage = Emessage + "\n" + tbi
            Emessage = Emessage + str( info[1] )
            msgbox(Emessage)

        self.setCursor(QCursor(Qt.ArrowCursor))
        self.setEnabled(True)

