#encoding:utf-8
# author=Kai Moriguchi @Chichibu 2013.4~2014.3
# email:a09a215@gmail.com

import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.utils import *
import processing
import math
from ccbplugintools import *
#processing.alglist("delaunay")
#processing.alghelp("qgis:delaunaytriangulation")

class svoronoi(object):
    def setname(self):
        self.DelName = "Delaunay"
        self.DelFileName = os.path.join(self.tempdir,self.DelName+".shp")
        self.TINCenName = "TINCenter"
        self.TINCenFileName = os.path.join(self.tempdir,self.TINCenName+".shp")
        self.CirName = "Circle"
        self.CirFileName = os.path.join(self.tempdir, self.CirName+".shp")
        self.CrossName = "Cross"
        self.CrossFileName = os.path.join(self.tempdir,self.CrossName+".shp")

        n=self.Point.dataProvider().featureCount()
        self.Id_Idx =[[0 for j in range(2)] for i in range(n)]

        i=0
        for p in self.Point.getFeatures():
            self.Id_Idx[i][0]=p.attributes()[self.ididx]
            self.Id_Idx[i][1]=p.geometry().asPoint()
            i=i+1

    def deleteFiles(self):
        deleteShapefile(self.tempdir,self.DelName)
        deleteShapefile(self.tempdir,self.TINCenName)
        deleteShapefile(self.tempdir,self.CirName)
        deleteShapefile(self.tempdir,self.CrossName)
        deleteShapefile(self.tempdir,self.VoronoiName)

    def getDelaunay(self):
        Del = processing.runalg("qgis:delaunaytriangulation", self.Point,self.DelFileName)
        self.Delaunay = processing.load(Del['OUTPUT'],self.DelName)
        self.Delaunay.startEditing()
        self.Delaunay.dataProvider().addAttributes([
            QgsField("idx0",QVariant.Int),QgsField("idx1",QVariant.Int),QgsField("idx2",QVariant.Int),
            QgsField("ID0",QVariant.String),QgsField("ID1",QVariant.String),QgsField("ID2",QVariant.String)]
            )
        self.Delaunay.updateFields()
        id=0
        for d in self.Delaunay.getFeatures():
            for i in range(3):
                idx = int(d.attributes()[i]+0.001)
                self.Delaunay.changeAttributeValue(id,i+3,idx)
                self.Delaunay.changeAttributeValue(id,i+6,self.Id_Idx[idx][0])
            id=id+1
        self.Delaunay.commitChanges()
    def getCenterOfDelaunay(self):
        fields = QgsFields()
        fields.append(QgsField("idx0",QVariant.Int))
        fields.append(QgsField("idx1",QVariant.Int))
        fields.append(QgsField("idx2",QVariant.Int))
        fields.append(QgsField("ID0",QVariant.String))
        fields.append(QgsField("ID1",QVariant.String))
        fields.append(QgsField("ID2",QVariant.String))
        fields.append(QgsField("R",QVariant.Double))
        fields.append(QgsField("Area1",QVariant.Double))
        fields.append(QgsField("Area2",QVariant.Double))
        provider = self.Plot.dataProvider()
        writer = QgsVectorFileWriter(self.TINCenFileName, provider.encoding(), fields,QGis.WKBPoint, provider.crs() )
        n = self.Point.dataProvider().featureCount()
        self.PointXY = [[0 for j in range(2)] for i in range(n)]
        i=0
        for p in self.Point.getFeatures():
            self.PointXY[i][0] = p.geometry().asPoint()
            self.PointXY[i][1] = p.attributes()[self.ididx]
            i=i+1
        fet = QgsFeature()
        for d in self.Delaunay.getFeatures():
            coor=[[0.,0.],[0.,0.],[0.,0.]]
            for i in range(3):
                coor[i]=self.PointXY[int(d.attributes()[i])][0]
            lineA2 = math.pow(coor[1][0]-coor[2][0],2)+math.pow(coor[1][1]-coor[2][1],2)
            lineB2 = math.pow(coor[2][0]-coor[0][0],2)+math.pow(coor[2][1]-coor[0][1],2)
            lineC2 = math.pow(coor[0][0]-coor[1][0],2)+math.pow(coor[0][1]-coor[1][1],2)
            lineA = math.sqrt(lineA2)
            lineB = math.sqrt(lineB2)
            lineC = math.sqrt(lineC2)
            s = (lineA+lineB+lineC)/2
            Area = math.sqrt(s*(s-lineA)*(s-lineB)*(s-lineC))
            R = lineA*lineB*lineC/(4*Area)
            c0 = lineA2*(lineB2+lineC2-lineA2)
            c1 = lineB2*(lineC2+lineA2-lineB2)
            c2 = lineC2*(lineA2+lineB2-lineC2)
            cs = c0+c1+c2
            centerX = (c0*coor[0][0]+c1*coor[1][0]+c2*coor[2][0])/cs
            centerY = (c0*coor[0][1]+c1*coor[1][1]+c2*coor[2][1])/cs
            fet.setGeometry(QgsGeometry.fromPoint(QgsPoint(centerX,centerY)))

            list1 = [int(d.attributes()[i]+0.001) for i in [0,1,2]]
            list2 = [self.Id_Idx[i][0] for i in list1]
            list1.extend(list2)
            list1.append(R)
            fet.setAttributes(list1)
            writer.addFeature(fet)
        del writer
        self.TINCenter = processing.load(self.TINCenFileName,self.TINCenName)

    def getjudgeCircle(self):
        Cir = processing.runalg("qgis:variabledistancebuffer", self.TINCenter,"R",24,False,self.CirFileName)
        self.Circle = processing.load(Cir['OUTPUT'],self.CirName)
        self.CirCentroid = [0]*self.Circle.dataProvider().featureCount()
        i=0
        for c in self.Circle.getFeatures():
            self.CirCentroid[i] = c.geometry().centroid().asPoint()
            i=i+1
        self.Circle.startEditing()
        idx = self.Circle.fieldNameIndex('Area1')
        i=0
        for c in self.Circle.getFeatures():
            self.Circle.changeAttributeValue(i, idx,c.geometry().area())
            i=i+1
        self.Circle.commitChanges()
        Cro = processing.runalg("qgis:intersection", self.Circle,self.Plot,self.CrossFileName)
        self.Cross=processing.load(Cro['OUTPUT'],self.CrossName)
        idx1 = self.Cross.fieldNameIndex('Area2')
        self.Cross.startEditing()
        i=0
        for c in self.Cross.getFeatures():
            self.Cross.changeAttributeValue(i, idx1,c.geometry().area())
            i=i+1
        self.Cross.commitChanges()

    def selectVoronoi(self):
        Vor = processing.runalg("qgis:voronoipolygons",self.Point,0,self.VoronoiFileName)
        self.Voronoi=processing.load(Vor['OUTPUT'],self.VoronoiName)
        self.Voronoi.startEditing()
        idx1 = self.Cross.fieldNameIndex('Area1')
        idx2 = self.Cross.fieldNameIndex('Area2')
        idx3 = self.Cross.fieldNameIndex("ID0")
        idx4 = self.Cross.fieldNameIndex("ID1")
        idx5 = self.Cross.fieldNameIndex("ID2")
        OutList =[""]
        i=0
        for c in self.Cross.getFeatures():
            if c.attributes()[idx2]<c.attributes()[idx1]*self.AllowError:
                OutList.append(c.attributes()[idx3])
                OutList.append(c.attributes()[idx4])
                OutList.append(c.attributes()[idx5])
        OutList.pop(0)
        OutList = list(set(OutList))
        OutIdx = [0]*len(OutList)
        for v in self.Voronoi.getFeatures():
            if v.attributes()[self.ididx] in OutList:
                OutIdx[i] = int(v.id())
                i=i+1
        OutIdx.sort()
        self.Voronoi.startEditing()
        self.Voronoi.dataProvider().deleteFeatures(OutIdx)
        self.Voronoi.commitChanges()

    def run(self,inlayer1,inlayer2,outname,Param,progbar):
        self.Point = inlayer1
        self.Plot = inlayer2
        self.VoronoiFileName = outname
        self.VoronoiName = os.path.splitext(os.path.split(self.VoronoiFileName)[1])[0]
        self.ididx = int(Param[0]+0.1)
        self.bVisible = 0.5<Param[1]
        self.AllowError = 1.-Param[2]/100.
        self.tempdir = os.path.dirname(outname)
        self.setname()
        self.deleteFiles()
        self.getDelaunay()
        self.getCenterOfDelaunay()
        self.getjudgeCircle()
        self.selectVoronoi()
        QgsMapLayerRegistry.instance().removeMapLayers([self.Voronoi.id()])
        if self.bVisible==False:
            QgsMapLayerRegistry.instance().removeMapLayers([self.Circle.id(),self.TINCenter.id(),self.Delaunay.id(),self.Cross.id()])
        return True

