#encoding:utf-8
# author=Kai Moriguchi @Chichibu 2013.4~2014.3
# email:a09a215@gmail.com

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from ccbplugintools import *
from qgis.core import *
from qgis.utils import *
import math
from subprocess import call
import _winreg

class estcoor(object):
    def f(self,V,args):
        X = args[0]; Y = args[1]; G = args[2]; H = args[3]; Ras = args[4];
        newx = G[0] + V[0]
        newy = G[1] + V[1]
        sine = math.sin(V[2])
        cosine = math.cos(V[2])
        e2=0
        for i in range(len(X)):
            x0 = X[i]-G[0]
            y0 = Y[i]-G[1]
            x = newx + cosine *x0 - sine   *y0
            y = newy + sine   *x0 + cosine *y0
            dchm = Ras.identify(QgsPoint(x,y),QgsRaster.IdentifyFormatValue).results()[1]
            e2 = e2 +(H[i]-dchm) * (H[i]-dchm)
        return e2

    def estimate(self):
        try:
            import numpy
        except:
            msgbox("Numpy is not installed yet. Click OK to install it from download page.",1)
            if r == QMessageBox.OK:
                call([DefaultBrowser,"http://sourceforge.net/projects/numpy/files/NumPy/"])
            return False
        try:
            from scipy.optimize import minimize,anneal
        except:
            msgbox("Scipy is not installed yet. Click OK to install it from download page.",1)
            if r == QMessageBox.OK:
                call([DefaultBrowser,"http://sourceforge.net/projects/scipy/files/scipy/"])
            return False

        numpy.random.seed()
        n = self.Point.dataProvider().featureCount()
        self.X = numpy.array([0.]*n)
        self.Y = numpy.array([0.]*n)
        self.H = numpy.array([0.]*n)
        self.G = numpy.array([0.,0.])
        i=0
        for p in self.Point.getFeatures():
            self.X[i],self.Y[i] = p.geometry().asPoint()
            self.G[0] = self.G[0]+self.X[i]
            self.G[1] = self.G[1]+self.Y[i]
            self.H[i] = p.attributes()[self.dataIdx]
            i+=1
        self.G[0]=self.G[0]/n
        self.G[1]=self.G[1]/n
        Raspvd = self.Raster.dataProvider()
        Args = [self.X,self.Y,self.G,self.H,Raspvd]
        P = numpy.array([0.]*3)
        PMin = numpy.array([-self.maxdL,-self.maxdL,-self.maxdD*math.pi/180.0])
        PMax = numpy.array([self.maxdL,self.maxdL,self.maxdD*math.pi/180.0])
        init_e = self.f(P,Args)
        best_e = 0+init_e
        for i in range(self.NumCycle):
            P = numpy.array([0.]*3)
            SARes = anneal(self.f, P,args=[Args],maxiter=self.SAMaxIter,lower=PMin,upper=PMax)
            NMRes = minimize(self.f, SARes[0], args=[Args],method='nelder-mead',options={'xtol': 1e-8, 'disp': False})
            e = self.f(NMRes.x,Args)
            self.progbar.setValue(int(100*(i+1)/self.NumCycle))
            if e<best_e:
                best_e = e
                self.BestRes=numpy.copy(NMRes.x)
        msgbox("Initial SquErr = " +str(init_e) + ";  Optim SquErr = " + str(best_e)+
               ";  (dx,dy,drad)=("+str(NMRes.x[0])+","+str(NMRes.x[1])+","+str(NMRes.x[2]*180.0/math.pi)+")")
        self.opt_gx = self.G[0] + NMRes.x[0]
        self.opt_gy = self.G[1] + NMRes.x[1]
        self.opt_sin = math.sin( NMRes.x[2])
        self.opt_cos = math.cos( NMRes.x[2])

    def createNewPoint(self):
        provider = self.Point.dataProvider()
        fields = QgsFields()
        fields.append(QgsField("ID",QVariant.String))
        fields.append(QgsField("H",QVariant.Double))
        writer = QgsVectorFileWriter(self.newPointFilename, provider.encoding(), fields,QGis.WKBPoint, provider.crs() )
        fet = QgsFeature()
        i=0
        for p in self.Point.getFeatures():
            x0 = self.X[i]-self.G[0]
            y0 = self.Y[i]-self.G[1]
            x = self.opt_gx + self.opt_cos   *x0 - self.opt_sin *y0
            y = self.opt_gy + self.opt_sin   *x0 + self.opt_cos *y0
            fet.setGeometry(QgsGeometry.fromPoint(QgsPoint(x,y)) )
            fet.setAttributes([p.attributes()[0],p.attributes()[1]])
            writer.addFeature(fet)
            i=i+1
        del writer

    def run(self,inlayer1,inlayer2,outname,Param,progbar):
        key = _winreg.OpenKey(_winreg.HKEY_CLASSES_ROOT,"http\\shell\\open\\command")
        DefaultBrowser = _winreg.QueryValueEx(key,"")[0]
        DefaultBrowser = DefaultBrowser[1:DefaultBrowser.find(r".exe")+4]
        self.Point = inlayer1
        self.Raster = inlayer2
        self.newPointFilename = outname
        self.dataIdx = int(Param[0]+0.000001)
        self.NumCycle = int(Param[1]+0.000001)
        self.SAMaxIter = int(Param[2]+0.000001)
        self.maxdL = Param[3]
        self.maxdD = Param[4]
        isInt = self.Point.dataProvider().fields().field(self.dataIdx).type() == QVariant.Int
        isDouble = self.Point.dataProvider().fields().field(self.dataIdx).type() == QVariant.Double
        if (isInt or isDouble)==False:
            msgbox("Incorrect index of data.")
            return False
        inNull=False
        for p in self.Point.getFeatures():
            inNull = inNull or (p.attributes()[self.dataIdx]==None)
        if inNull:
            msgbox("Null data is in the attribute.")
            return False
        self.progbar = progbar
        self.estimate()
        self.createNewPoint()
        return True
