# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SpuGeoMemorialDialog
                                 A QGIS plugin
 Generates descriptive memorials in the format of the SPU of the Federal Government of Brazil
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2018-11-14
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Guilherme Henrique
        email                : guilherme.henrique@planejamento.gov.br
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from __future__ import absolute_import

import os

#from PyQt5 import uic
#from PyQt5 import QtWidgets

from qgis.PyQt import uic
from qgis.PyQt.QtWidgets import QMessageBox, QDialog

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'spugeo_memorial_dialog_base.ui'))

# Import specific modules
from .kappaAndConvergence.calculateKappaAndConvergence import CalculateKappaAndConvergenceDialog
from .azimuthsAndDistances.azimuthsAndDistances import AzimuthsAndDistancesDialog

class SpuGeoMemorialDialog(QDialog, FORM_CLASS):
    """Contains Spu geomemorial dialog method
    """
    def __init__(self, iface):
        """Constructor.
        :param: iface
        :return
        """
        QDialog.__init__(self)
        #super(SpuGeoMemorialDialog, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        self.iface = iface

        # Connecting SIGNAL/SLOTS for the Output button
        self.kappaAndConvergenceButton.clicked.connect(self.calculateKappa)

        # Connecting SIGNAL/SLOTS for the Output button
        self.azimuthsAndDistancesButton.clicked.connect(self.calculateAzimuths)

    def calculateKappa(self):
        """Calculates Kappa
        :param:
        :return:
        """
        currentLayer = self.iface.mapCanvas().currentLayer()
        if currentLayer:
            d = CalculateKappaAndConvergenceDialog(self.iface)
            d.exec_()
        else:
            QMessageBox.warning(self.iface.mainWindow(), self.tr("Warning!"), self.tr("Please, open a layer and select a line or polygon feature."))

    def calculateAzimuths(self):
        """Calculates Azimuths
        :param:
        :return:
        """

        currentLayer = self.iface.mapCanvas().currentLayer()
        if currentLayer:
            selectedFeatures = len(currentLayer.selectedFeatures())
            if selectedFeatures == 1:
                selectedFeature = currentLayer.selectedFeatures()[0]
                d = AzimuthsAndDistancesDialog(self.iface, selectedFeature.geometry())
                d.exec_()
            else:
                QMessageBox.warning(self.iface.mainWindow(), self.tr("Warning!"), self.tr("One and only one feature must be selected to perform the calculations."))
        else:
            QMessageBox.warning(self.iface.mainWindow(), self.tr("Warning!"), self.tr("Please, open a layer and select a line or polygon feature."))
