# -*- coding: utf-8 -*-

"""
/***************************************************************************
 spectralmatch
                                 A QGIS plugin
 Performant Relative Radiometric Normalization toolkit with Pseudo-Invariant Features, seamlines, and other utilities for mosaics and time series
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-06-15
        copyright            : (C) 2025 by Kanoa Lindiwe LLC
        email                : cankanoa@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Kanoa Lindiwe LLC'
__date__ = '2025-06-15'
__copyright__ = '(C) 2025 by Kanoa Lindiwe LLC'
__revision__ = '$Format:%H$'

import subprocess
import os
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (
    QgsProcessing,
    QgsFeatureSink,
    QgsProcessingAlgorithm,
    QgsProcessingParameterFeatureSource,
    QgsProcessingParameterFeatureSink,
    QgsProcessingParameterString,
    QgsProcessingParameterFile,
    QgsProcessingException,
   )
from .utils import get_interpreter, normalize_cli_value, load_function_headers, _add_string_param, _add_folder_select_param, get_python_dependency_folder

def loadAlgorithms(self):
    for func in load_function_headers():
        algo_cls = make_algorithm_class(func["function"])
        self.addAlgorithm(algo_cls())


def make_algorithm_class(full_function_path: str):
    """
    Creates a QGIS ProcessingAlgorithm class for a given function path.

    Args:
        full_function_path (str): e.g. 'spectralmatch.match.global_regression.global_regression'
    """
    parts = full_function_path.split(".")
    class_attrs = {}
    function = parts[-1]
    class_name = function.replace("_", "").title() + "Algorithm"
    submodule = parts[-2]
    group_id = parts[-3] if len(parts) >= 4 else parts[-2]  # folder if present, else module

    def initAlgorithm(self, config):
        self.python_interpreter = get_interpreter()
        self.func_info = load_function_headers(full_function_path)
        python_dependencies = get_python_dependency_folder()
        self.env = os.environ.copy()
        self.env["PYTHONPATH"] = python_dependencies + os.pathsep + self.env.get("PYTHONPATH", "")

        for param in self.func_info.get("parameters", []):
            name = param["name"]
            display_name = param["display_name"]
            param_type = param.get("param_type", "string")
            default = param.get("default")

            if param_type == "exclude":
                continue
            elif param_type == "folder":
                _add_folder_select_param(self, name, display_name)
            elif param_type == "string":
                _add_string_param(self, name, display_name, default)

    def processAlgorithm(self, parameters, context, feedback):
        cmd = [self.python_interpreter, "-m", "spectralmatch", function]

        feedback.pushInfo("Processed parameters:")

        for param in self.func_info.get("parameters", []):
            name = param["name"]
            if name in parameters:
                value = self.parameterAsString(parameters, name, context)
                cli_value = normalize_cli_value(value)
                cmd.extend([f"--{name}", cli_value])
                feedback.pushInfo(f"{name} = {cli_value}")

        feedback.pushInfo("\nRunning: " + " ".join(cmd) + "\n")

        process = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True, bufsize=1, env=self.env)
        for line in process.stdout:
            feedback.pushInfo(line.rstrip())
        process.stdout.close()
        return_code = process.wait()

        if return_code != 0:
            raise Exception(f"Process failed with return code {return_code}")

        return {}

    def shortHelpString(self):
        doc = load_function_headers(full_function_path).get("docstring", "")
        return f"<pre>{doc}</pre>"

    def helpUrl(self):
        return "https://spectralmatch.github.io/spectralmatch/"

    def name(self):
        return function.replace("_", " ").capitalize()

    def displayName(self):
        return self.tr(self.name())

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):
        return group_id.capitalize()

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return cls()

    class_attrs.update(locals())
    cls = type(class_name, (QgsProcessingAlgorithm,), class_attrs)
    return cls