
from PyQt4.QtCore import *
from PyQt4.QtGui import *

import spatialite_utils

class MetadataBrowser(QTextBrowser):

	def __init__(self, parent=None):
		QTextBrowser.__init__(self, parent)

		self.simplifiedMode = False		
		self.db = None

	def setSimplifiedMode(self, value=True):
		self.simplifiedMode = value
		
	def setDatabase(self, db):
		""" called when connected / disconnected from db """
		self.db = db
		
	def showDbInfo(self, item=None):

		info = self.db.get_info()

		dbname = self.db.dbname if item == None else item.name
			
		html  = '<div style="background-color:#ccffcc"><h1>&nbsp;&nbsp;%s</h1></div>' % dbname
		
		html += '<h2>spatialite</h2>'
		if self.db.has_spatialite:
			gis_info = self.db.get_spatialite_info()
			html += '<table>'
			html += '<tr><td width="100">Library:<td>%s' % gis_info[0]
			html += '<tr><td>GEOS:<td>%s' % gis_info[1]
			html += '<tr><td>Proj:<td>%s' % gis_info[2]
			html += '</table>'
			if not self.db.has_geometry_columns:
				html += '<p><img src=":/icons/warning-20px.png"> &nbsp; ' \
								'geometry_columns table doesn\'t exist!<br>' \
								'This table is essential for many GIS applications for enumeration of tables.</p>'
		else:
			html += '<p><img src=":/icons/warning-20px.png"> &nbsp; spatialite support not enabled!</p>'
					
		html += '<h2>Server version</h2>' + info
				
		self.setHtml(html)
	
	
	
	def showDBInfo(self, item):
		
		if not item:
			self.setHtml('')
			return

		html  = '<div style="background-color:#ffcccc"><h1>&nbsp;&nbsp;%s</h1></div>' % item.name
		html += "<p> (schema)<p>Tables: %d" % (item.childCount())
		html += "<br><br>"

		self.setHtml(html)


	def showTableInfo(self, item):

		if not item:
			self.setHtml('')
			return
		
		if item.is_view:
			reltype = "View"
		else:
			reltype = "Table"
			
		table_name = item.name

		# if the estimation is less than 100 rows, try to count them - it shouldn't take long time
		if item.row_count_real == -1:
			try:
				item.row_count_real = self.db.get_table_rows(table_name)
			except spatialite_utils.DbError, e:
				pass
			
		html  = '<div style="background-color:#ccccff"><h1>&nbsp;&nbsp;%s</h1></div>' % table_name
		html += '<div style="margin-top:30px; margin-left:10px;"> <table>'
		html += '<tr><td width="150">Relation type:<td>%s' % reltype
		html += '<tr><td>Rows (counted):<td>'
		
		if item.row_count_real != -1:
			html += "%d" % item.row_count_real
		else:
			html += 'Unknown (<a href="action:rows">find out</a>)'

		html += '</table></div>'
		
		
		fields = self.db.get_table_fields(table_name)
		indexes = self.db.get_table_indexes(table_name)
		triggers = self.db.get_table_triggers(table_name)

		if not self.simplifiedMode and not item.is_view:
			has_pkey = False
			for f in fields:
				if f.primary_key:
					has_pkey = True

			if not has_pkey:
				html += '<div style="margin-top:10px; margin-left:10px;"><img src=":/icons/warning-20px.png"> &nbsp; No primary key defined for this table!</div>'
		
		html += '<div style="margin-top:30px; margin-left:10px;"><h2>Spatialite</h2>'
		if item.geom_type:
			html += '<table><tr><td width=150>Column:<td>%s<tr><td>Geometry:<td>%s' % (item.geom_column, item.geom_type)
			if item.geom_dim: # only if we have info from geometry_columns
				if item.geom_srid != -1:
					sr_info = self.db.sr_info_for_srid(item.geom_srid)
				else:
					sr_info = "Undefined"
				html += '<tr><td>Dimension:<td>%s<tr><td>Spatial ref:<td>%s (%d)' % (item.geom_dim, sr_info, item.geom_srid)

			if not self.simplifiedMode and not item.is_view:
				# estimated extent
				html += '<tr><td>Extent:<td>'
				try:
					extent = self.db.get_table_estimated_extent(item.geom_column, table_name)
					if extent[0] is not None:
						html += '%.5f, %.5f - %.5f, %.5f' % extent
					else:
						html += '(unknown)'
				except spatialite_utils.DbError, e:
					html += '(unknown)'
			html += '</table>'
			if item.geom_type == 'geometry':
				html += '<p><img src=":/icons/warning-20px.png"> &nbsp; There isn\'t entry in geometry_columns!</p>'
			# find out geometry's column number
			for fld in fields:
				if fld.name == item.geom_column:
					geom_col_num = fld.num

			if not self.simplifiedMode and not item.is_view:
				# find out whether it has spatial index on it
				has_spatial_index = False
				for idx in indexes:
					if geom_col_num in idx.columns:
						has_spatial_index = True
				if not has_spatial_index:
					html += '<p><img src=":/icons/warning-20px.png"> &nbsp; No spatial index defined.</p>'
		else:
			html += '<p>This is not a spatial table.</p>'
		html += '</div>'
		
		# fields
		html += '<div style="margin-top:30px; margin-left:10px"><h2>Fields</h2>'
		html += '<table><tr bgcolor="#dddddd">'
		html += '<th width="30"># <th width="180">Name <th width="100">Type <th width="50">Null <th>Default '
		for fld in fields:
			is_null_txt = "N" if fld.notnull else "Y"
			default = fld.default if fld.default else ""
			fldtype = fld.data_type
			
			# find out whether it's part of primary key
			pk_style = ' style="text-decoration:underline;"' if fld.primary_key else ''
			html += '<tr><td align="center">%s<td%s>%s<td>%s<td align="center">%s<td>%s' % (fld.num, pk_style, fld.name, fldtype, is_null_txt, default)
		html += "&nbsp;</table></div>"
				
		# indexes
		if len(indexes) != 0:
			html += '<div style="margin-top:30px; margin-left:10px"><h2>Indexes</h2>'
			html += '<table><tr bgcolor="#dddddd"><th width="180">Name<th width="180">Column(s)'
			for fld in indexes:
				keys = ""
				for key in fld.columns:
					if len(keys) != 0: keys += "<br>"
					keys += self._field_name_by_number(key, fields)
				html += "<tr><td>%s<td>%s" % (fld.name, keys)
			html += "&nbsp;</table></div>"
			
		# triggers
		if len(triggers) != 0:
			html += '<div style="margin-top:30px; margin-left:10px"><h2>Triggers</h2>'
			html += '<table><tr bgcolor="#dddddd"><th width="180">Name'
			for trig in triggers:
				html += '<tr><td>%s' % (trig.name)
			html += "&nbsp;</table></div>"
			
		if item.is_view:
			html += '<div style=" margin-top:30px; margin-left:10px"><h2>View definition</h2>'
			html += '<p>%s</p>' % self.db.get_view_definition(table_name)
			html += '</div>'
		
		self.setHtml(html)
		
		return True

	def _field_name_by_number(self, num, fields):
		""" return field specified by its number or None if doesn't exist """
		for fld in fields:
			if fld.num == num:
				return fld.name
		return "??? (#%d)" % num
		
		
